// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCifsServiceModifyCollectionParams creates a new CifsServiceModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCifsServiceModifyCollectionParams() *CifsServiceModifyCollectionParams {
	return &CifsServiceModifyCollectionParams{
		requestTimeout: cr.DefaultTimeout,
	}
}

// NewCifsServiceModifyCollectionParamsWithTimeout creates a new CifsServiceModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewCifsServiceModifyCollectionParamsWithTimeout(timeout time.Duration) *CifsServiceModifyCollectionParams {
	return &CifsServiceModifyCollectionParams{
		requestTimeout: timeout,
	}
}

// NewCifsServiceModifyCollectionParamsWithContext creates a new CifsServiceModifyCollectionParams object
// with the ability to set a context for a request.
func NewCifsServiceModifyCollectionParamsWithContext(ctx context.Context) *CifsServiceModifyCollectionParams {
	return &CifsServiceModifyCollectionParams{
		Context: ctx,
	}
}

// NewCifsServiceModifyCollectionParamsWithHTTPClient creates a new CifsServiceModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewCifsServiceModifyCollectionParamsWithHTTPClient(client *http.Client) *CifsServiceModifyCollectionParams {
	return &CifsServiceModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
CifsServiceModifyCollectionParams contains all the parameters to send to the API endpoint

	for the cifs service modify collection operation.

	Typically these are written to a http.Request.
*/
type CifsServiceModifyCollectionParams struct {

	/* AdDomainDefaultSite.

	   Filter by ad_domain.default_site
	*/
	AdDomainDefaultSite *string

	/* AdDomainFqdn.

	   Filter by ad_domain.fqdn
	*/
	AdDomainFqdn *string

	/* AdDomainOrganizationalUnit.

	   Filter by ad_domain.organizational_unit
	*/
	AdDomainOrganizationalUnit *string

	/* AuthStyle.

	   Filter by auth-style
	*/
	AuthStyle *string

	/* AuthUserType.

	   Filter by auth_user_type
	*/
	AuthUserType *string

	/* AuthenticationMethod.

	   Filter by authentication_method
	*/
	AuthenticationMethod *string

	/* ClientID.

	   Filter by client_id
	*/
	ClientID *string

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* DefaultUnixUser.

	   Filter by default_unix_user
	*/
	DefaultUnixUser *string

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Force.

	   If this is set and a machine account with the same name as specified in 'cifs-server name' exists in the Active Directory, existing machine account will be overwritten and reused. The default value for this field is false.
	*/
	Force *bool

	/* GroupPolicyObjectEnabled.

	   Filter by group_policy_object_enabled
	*/
	GroupPolicyObjectEnabled *bool

	/* Info.

	   Info specification
	*/
	Info CifsServiceModifyCollectionBody

	/* KeyVaultURI.

	   Filter by key_vault_uri
	*/
	KeyVaultURI *string

	/* MetricDuration.

	   Filter by metric.duration
	*/
	MetricDuration *string

	/* MetricIopsOther.

	   Filter by metric.iops.other
	*/
	MetricIopsOther *int64

	/* MetricIopsRead.

	   Filter by metric.iops.read
	*/
	MetricIopsRead *int64

	/* MetricIopsTotal.

	   Filter by metric.iops.total
	*/
	MetricIopsTotal *int64

	/* MetricIopsWrite.

	   Filter by metric.iops.write
	*/
	MetricIopsWrite *int64

	/* MetricLatencyOther.

	   Filter by metric.latency.other
	*/
	MetricLatencyOther *int64

	/* MetricLatencyRead.

	   Filter by metric.latency.read
	*/
	MetricLatencyRead *int64

	/* MetricLatencyTotal.

	   Filter by metric.latency.total
	*/
	MetricLatencyTotal *int64

	/* MetricLatencyWrite.

	   Filter by metric.latency.write
	*/
	MetricLatencyWrite *int64

	/* MetricStatus.

	   Filter by metric.status
	*/
	MetricStatus *string

	/* MetricThroughputRead.

	   Filter by metric.throughput.read
	*/
	MetricThroughputRead *int64

	/* MetricThroughputTotal.

	   Filter by metric.throughput.total
	*/
	MetricThroughputTotal *int64

	/* MetricThroughputWrite.

	   Filter by metric.throughput.write
	*/
	MetricThroughputWrite *int64

	/* MetricTimestamp.

	   Filter by metric.timestamp
	*/
	MetricTimestamp *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NetbiosAliases.

	   Filter by netbios.aliases
	*/
	NetbiosAliases *string

	/* NetbiosEnabled.

	   Filter by netbios.enabled
	*/
	NetbiosEnabled *bool

	/* NetbiosWinsServers.

	   Filter by netbios.wins_servers
	*/
	NetbiosWinsServers *string

	/* OauthHost.

	   Filter by oauth_host
	*/
	OauthHost *string

	/* OptionsAdminToRootMapping.

	   Filter by options.admin_to_root_mapping
	*/
	OptionsAdminToRootMapping *bool

	/* OptionsAdvancedSparseFile.

	   Filter by options.advanced_sparse_file
	*/
	OptionsAdvancedSparseFile *bool

	/* OptionsBackupSymlinkEnabled.

	   Filter by options.backup_symlink_enabled
	*/
	OptionsBackupSymlinkEnabled *bool

	/* OptionsClientDupDetectionEnabled.

	   Filter by options.client_dup_detection_enabled
	*/
	OptionsClientDupDetectionEnabled *bool

	/* OptionsClientVersionReportingEnabled.

	   Filter by options.client_version_reporting_enabled
	*/
	OptionsClientVersionReportingEnabled *bool

	/* OptionsCopyOffload.

	   Filter by options.copy_offload
	*/
	OptionsCopyOffload *bool

	/* OptionsDacEnabled.

	   Filter by options.dac_enabled
	*/
	OptionsDacEnabled *bool

	/* OptionsExportPolicyEnabled.

	   Filter by options.export_policy_enabled
	*/
	OptionsExportPolicyEnabled *bool

	/* OptionsFakeOpen.

	   Filter by options.fake_open
	*/
	OptionsFakeOpen *bool

	/* OptionsFsctlTrim.

	   Filter by options.fsctl_trim
	*/
	OptionsFsctlTrim *bool

	/* OptionsJunctionReparse.

	   Filter by options.junction_reparse
	*/
	OptionsJunctionReparse *bool

	/* OptionsLargeMtu.

	   Filter by options.large_mtu
	*/
	OptionsLargeMtu *bool

	/* OptionsMaxConnectionsPerSession.

	   Filter by options.max_connections_per_session
	*/
	OptionsMaxConnectionsPerSession *int64

	/* OptionsMaxLifsPerSession.

	   Filter by options.max_lifs_per_session
	*/
	OptionsMaxLifsPerSession *int64

	/* OptionsMaxOpensSameFilePerTree.

	   Filter by options.max_opens_same_file_per_tree
	*/
	OptionsMaxOpensSameFilePerTree *int64

	/* OptionsMaxSameTreeConnectPerSession.

	   Filter by options.max_same_tree_connect_per_session
	*/
	OptionsMaxSameTreeConnectPerSession *int64

	/* OptionsMaxSameUserSessionsPerConnection.

	   Filter by options.max_same_user_sessions_per_connection
	*/
	OptionsMaxSameUserSessionsPerConnection *int64

	/* OptionsMaxWatchesSetPerTree.

	   Filter by options.max_watches_set_per_tree
	*/
	OptionsMaxWatchesSetPerTree *int64

	/* OptionsMultichannel.

	   Filter by options.multichannel
	*/
	OptionsMultichannel *bool

	/* OptionsNullUserWindowsName.

	   Filter by options.null_user_windows_name
	*/
	OptionsNullUserWindowsName *string

	/* OptionsPathComponentCache.

	   Filter by options.path_component_cache
	*/
	OptionsPathComponentCache *bool

	/* OptionsReferral.

	   Filter by options.referral
	*/
	OptionsReferral *bool

	/* OptionsShadowcopy.

	   Filter by options.shadowcopy
	*/
	OptionsShadowcopy *bool

	/* OptionsShadowcopyDirDepth.

	   Filter by options.shadowcopy_dir_depth
	*/
	OptionsShadowcopyDirDepth *int64

	/* OptionsSmbCredits.

	   Filter by options.smb_credits
	*/
	OptionsSmbCredits *int64

	/* OptionsTrustedDomainEnumSearchEnabled.

	   Filter by options.trusted_domain_enum_search_enabled
	*/
	OptionsTrustedDomainEnumSearchEnabled *bool

	/* OptionsWidelinkReparseVersions.

	   Filter by options.widelink_reparse_versions
	*/
	OptionsWidelinkReparseVersions *string

	/* ProxyHost.

	   Filter by proxy_host
	*/
	ProxyHost *string

	/* ProxyPort.

	   Filter by proxy_port
	*/
	ProxyPort *int64

	/* ProxyType.

	   Filter by proxy_type
	*/
	ProxyType *string

	/* ProxyUsername.

	   Filter by proxy_username
	*/
	ProxyUsername *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SecurityAdvertisedKdcEncryptions.

	   Filter by security.advertised_kdc_encryptions
	*/
	SecurityAdvertisedKdcEncryptions *string

	/* SecurityAesNetlogonEnabled.

	   Filter by security.aes_netlogon_enabled
	*/
	SecurityAesNetlogonEnabled *bool

	/* SecurityEncryptDcConnection.

	   Filter by security.encrypt_dc_connection
	*/
	SecurityEncryptDcConnection *bool

	/* SecurityKdcEncryption.

	   Filter by security.kdc_encryption
	*/
	SecurityKdcEncryption *bool

	/* SecurityLdapReferralEnabled.

	   Filter by security.ldap_referral_enabled
	*/
	SecurityLdapReferralEnabled *bool

	/* SecurityLmCompatibilityLevel.

	   Filter by security.lm_compatibility_level
	*/
	SecurityLmCompatibilityLevel *string

	/* SecurityRestrictAnonymous.

	   Filter by security.restrict_anonymous
	*/
	SecurityRestrictAnonymous *string

	/* SecuritySessionSecurity.

	   Filter by security.session_security
	*/
	SecuritySessionSecurity *string

	/* SecuritySmbEncryption.

	   Filter by security.smb_encryption
	*/
	SecuritySmbEncryption *bool

	/* SecuritySmbSigning.

	   Filter by security.smb_signing
	*/
	SecuritySmbSigning *bool

	/* SecurityTryLdapChannelBinding.

	   Filter by security.try_ldap_channel_binding
	*/
	SecurityTryLdapChannelBinding *bool

	/* SecurityUseLdaps.

	   Filter by security.use_ldaps
	*/
	SecurityUseLdaps *bool

	/* SecurityUseStartTLS.

	   Filter by security.use_start_tls
	*/
	SecurityUseStartTLS *bool

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* StatisticsIopsRawOther.

	   Filter by statistics.iops_raw.other
	*/
	StatisticsIopsRawOther *int64

	/* StatisticsIopsRawRead.

	   Filter by statistics.iops_raw.read
	*/
	StatisticsIopsRawRead *int64

	/* StatisticsIopsRawTotal.

	   Filter by statistics.iops_raw.total
	*/
	StatisticsIopsRawTotal *int64

	/* StatisticsIopsRawWrite.

	   Filter by statistics.iops_raw.write
	*/
	StatisticsIopsRawWrite *int64

	/* StatisticsLatencyRawOther.

	   Filter by statistics.latency_raw.other
	*/
	StatisticsLatencyRawOther *int64

	/* StatisticsLatencyRawRead.

	   Filter by statistics.latency_raw.read
	*/
	StatisticsLatencyRawRead *int64

	/* StatisticsLatencyRawTotal.

	   Filter by statistics.latency_raw.total
	*/
	StatisticsLatencyRawTotal *int64

	/* StatisticsLatencyRawWrite.

	   Filter by statistics.latency_raw.write
	*/
	StatisticsLatencyRawWrite *int64

	/* StatisticsStatus.

	   Filter by statistics.status
	*/
	StatisticsStatus *string

	/* StatisticsThroughputRawRead.

	   Filter by statistics.throughput_raw.read
	*/
	StatisticsThroughputRawRead *int64

	/* StatisticsThroughputRawTotal.

	   Filter by statistics.throughput_raw.total
	*/
	StatisticsThroughputRawTotal *int64

	/* StatisticsThroughputRawWrite.

	   Filter by statistics.throughput_raw.write
	*/
	StatisticsThroughputRawWrite *int64

	/* StatisticsTimestamp.

	   Filter by statistics.timestamp
	*/
	StatisticsTimestamp *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* TenantID.

	   Filter by tenant_id
	*/
	TenantID *string

	/* Timeout.

	   Filter by timeout
	*/
	Timeout *int64

	/* VerifyHost.

	   Filter by verify_host
	*/
	VerifyHost *bool

	/* Workgroup.

	   Filter by workgroup
	*/
	Workgroup *string

	requestTimeout time.Duration
	Context        context.Context
	HTTPClient     *http.Client
}

// WithDefaults hydrates default values in the cifs service modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsServiceModifyCollectionParams) WithDefaults() *CifsServiceModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cifs service modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsServiceModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := CifsServiceModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.requestTimeout = o.requestTimeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithRequestTimeout adds the timeout to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithRequestTimeout(timeout time.Duration) *CifsServiceModifyCollectionParams {
	o.SetRequestTimeout(timeout)
	return o
}

// SetRequestTimeout adds the timeout to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetRequestTimeout(timeout time.Duration) {
	o.requestTimeout = timeout
}

// WithContext adds the context to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithContext(ctx context.Context) *CifsServiceModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithHTTPClient(client *http.Client) *CifsServiceModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAdDomainDefaultSite adds the adDomainDefaultSite to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithAdDomainDefaultSite(adDomainDefaultSite *string) *CifsServiceModifyCollectionParams {
	o.SetAdDomainDefaultSite(adDomainDefaultSite)
	return o
}

// SetAdDomainDefaultSite adds the adDomainDefaultSite to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetAdDomainDefaultSite(adDomainDefaultSite *string) {
	o.AdDomainDefaultSite = adDomainDefaultSite
}

// WithAdDomainFqdn adds the adDomainFqdn to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithAdDomainFqdn(adDomainFqdn *string) *CifsServiceModifyCollectionParams {
	o.SetAdDomainFqdn(adDomainFqdn)
	return o
}

// SetAdDomainFqdn adds the adDomainFqdn to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetAdDomainFqdn(adDomainFqdn *string) {
	o.AdDomainFqdn = adDomainFqdn
}

// WithAdDomainOrganizationalUnit adds the adDomainOrganizationalUnit to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithAdDomainOrganizationalUnit(adDomainOrganizationalUnit *string) *CifsServiceModifyCollectionParams {
	o.SetAdDomainOrganizationalUnit(adDomainOrganizationalUnit)
	return o
}

// SetAdDomainOrganizationalUnit adds the adDomainOrganizationalUnit to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetAdDomainOrganizationalUnit(adDomainOrganizationalUnit *string) {
	o.AdDomainOrganizationalUnit = adDomainOrganizationalUnit
}

// WithAuthStyle adds the authStyle to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithAuthStyle(authStyle *string) *CifsServiceModifyCollectionParams {
	o.SetAuthStyle(authStyle)
	return o
}

// SetAuthStyle adds the authStyle to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetAuthStyle(authStyle *string) {
	o.AuthStyle = authStyle
}

// WithAuthUserType adds the authUserType to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithAuthUserType(authUserType *string) *CifsServiceModifyCollectionParams {
	o.SetAuthUserType(authUserType)
	return o
}

// SetAuthUserType adds the authUserType to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetAuthUserType(authUserType *string) {
	o.AuthUserType = authUserType
}

// WithAuthenticationMethod adds the authenticationMethod to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithAuthenticationMethod(authenticationMethod *string) *CifsServiceModifyCollectionParams {
	o.SetAuthenticationMethod(authenticationMethod)
	return o
}

// SetAuthenticationMethod adds the authenticationMethod to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetAuthenticationMethod(authenticationMethod *string) {
	o.AuthenticationMethod = authenticationMethod
}

// WithClientID adds the clientID to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithClientID(clientID *string) *CifsServiceModifyCollectionParams {
	o.SetClientID(clientID)
	return o
}

// SetClientID adds the clientId to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetClientID(clientID *string) {
	o.ClientID = clientID
}

// WithComment adds the comment to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithComment(comment *string) *CifsServiceModifyCollectionParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithContinueOnFailure adds the continueOnFailure to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *CifsServiceModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDefaultUnixUser adds the defaultUnixUser to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithDefaultUnixUser(defaultUnixUser *string) *CifsServiceModifyCollectionParams {
	o.SetDefaultUnixUser(defaultUnixUser)
	return o
}

// SetDefaultUnixUser adds the defaultUnixUser to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetDefaultUnixUser(defaultUnixUser *string) {
	o.DefaultUnixUser = defaultUnixUser
}

// WithEnabled adds the enabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithEnabled(enabled *bool) *CifsServiceModifyCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithForce adds the force to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithForce(force *bool) *CifsServiceModifyCollectionParams {
	o.SetForce(force)
	return o
}

// SetForce adds the force to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetForce(force *bool) {
	o.Force = force
}

// WithGroupPolicyObjectEnabled adds the groupPolicyObjectEnabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithGroupPolicyObjectEnabled(groupPolicyObjectEnabled *bool) *CifsServiceModifyCollectionParams {
	o.SetGroupPolicyObjectEnabled(groupPolicyObjectEnabled)
	return o
}

// SetGroupPolicyObjectEnabled adds the groupPolicyObjectEnabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetGroupPolicyObjectEnabled(groupPolicyObjectEnabled *bool) {
	o.GroupPolicyObjectEnabled = groupPolicyObjectEnabled
}

// WithInfo adds the info to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithInfo(info CifsServiceModifyCollectionBody) *CifsServiceModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetInfo(info CifsServiceModifyCollectionBody) {
	o.Info = info
}

// WithKeyVaultURI adds the keyVaultURI to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithKeyVaultURI(keyVaultURI *string) *CifsServiceModifyCollectionParams {
	o.SetKeyVaultURI(keyVaultURI)
	return o
}

// SetKeyVaultURI adds the keyVaultUri to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetKeyVaultURI(keyVaultURI *string) {
	o.KeyVaultURI = keyVaultURI
}

// WithMetricDuration adds the metricDuration to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithMetricDuration(metricDuration *string) *CifsServiceModifyCollectionParams {
	o.SetMetricDuration(metricDuration)
	return o
}

// SetMetricDuration adds the metricDuration to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetMetricDuration(metricDuration *string) {
	o.MetricDuration = metricDuration
}

// WithMetricIopsOther adds the metricIopsOther to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithMetricIopsOther(metricIopsOther *int64) *CifsServiceModifyCollectionParams {
	o.SetMetricIopsOther(metricIopsOther)
	return o
}

// SetMetricIopsOther adds the metricIopsOther to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetMetricIopsOther(metricIopsOther *int64) {
	o.MetricIopsOther = metricIopsOther
}

// WithMetricIopsRead adds the metricIopsRead to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithMetricIopsRead(metricIopsRead *int64) *CifsServiceModifyCollectionParams {
	o.SetMetricIopsRead(metricIopsRead)
	return o
}

// SetMetricIopsRead adds the metricIopsRead to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetMetricIopsRead(metricIopsRead *int64) {
	o.MetricIopsRead = metricIopsRead
}

// WithMetricIopsTotal adds the metricIopsTotal to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithMetricIopsTotal(metricIopsTotal *int64) *CifsServiceModifyCollectionParams {
	o.SetMetricIopsTotal(metricIopsTotal)
	return o
}

// SetMetricIopsTotal adds the metricIopsTotal to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetMetricIopsTotal(metricIopsTotal *int64) {
	o.MetricIopsTotal = metricIopsTotal
}

// WithMetricIopsWrite adds the metricIopsWrite to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithMetricIopsWrite(metricIopsWrite *int64) *CifsServiceModifyCollectionParams {
	o.SetMetricIopsWrite(metricIopsWrite)
	return o
}

// SetMetricIopsWrite adds the metricIopsWrite to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetMetricIopsWrite(metricIopsWrite *int64) {
	o.MetricIopsWrite = metricIopsWrite
}

// WithMetricLatencyOther adds the metricLatencyOther to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithMetricLatencyOther(metricLatencyOther *int64) *CifsServiceModifyCollectionParams {
	o.SetMetricLatencyOther(metricLatencyOther)
	return o
}

// SetMetricLatencyOther adds the metricLatencyOther to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetMetricLatencyOther(metricLatencyOther *int64) {
	o.MetricLatencyOther = metricLatencyOther
}

// WithMetricLatencyRead adds the metricLatencyRead to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithMetricLatencyRead(metricLatencyRead *int64) *CifsServiceModifyCollectionParams {
	o.SetMetricLatencyRead(metricLatencyRead)
	return o
}

// SetMetricLatencyRead adds the metricLatencyRead to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetMetricLatencyRead(metricLatencyRead *int64) {
	o.MetricLatencyRead = metricLatencyRead
}

// WithMetricLatencyTotal adds the metricLatencyTotal to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithMetricLatencyTotal(metricLatencyTotal *int64) *CifsServiceModifyCollectionParams {
	o.SetMetricLatencyTotal(metricLatencyTotal)
	return o
}

// SetMetricLatencyTotal adds the metricLatencyTotal to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetMetricLatencyTotal(metricLatencyTotal *int64) {
	o.MetricLatencyTotal = metricLatencyTotal
}

// WithMetricLatencyWrite adds the metricLatencyWrite to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithMetricLatencyWrite(metricLatencyWrite *int64) *CifsServiceModifyCollectionParams {
	o.SetMetricLatencyWrite(metricLatencyWrite)
	return o
}

// SetMetricLatencyWrite adds the metricLatencyWrite to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetMetricLatencyWrite(metricLatencyWrite *int64) {
	o.MetricLatencyWrite = metricLatencyWrite
}

// WithMetricStatus adds the metricStatus to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithMetricStatus(metricStatus *string) *CifsServiceModifyCollectionParams {
	o.SetMetricStatus(metricStatus)
	return o
}

// SetMetricStatus adds the metricStatus to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetMetricStatus(metricStatus *string) {
	o.MetricStatus = metricStatus
}

// WithMetricThroughputRead adds the metricThroughputRead to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithMetricThroughputRead(metricThroughputRead *int64) *CifsServiceModifyCollectionParams {
	o.SetMetricThroughputRead(metricThroughputRead)
	return o
}

// SetMetricThroughputRead adds the metricThroughputRead to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetMetricThroughputRead(metricThroughputRead *int64) {
	o.MetricThroughputRead = metricThroughputRead
}

// WithMetricThroughputTotal adds the metricThroughputTotal to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithMetricThroughputTotal(metricThroughputTotal *int64) *CifsServiceModifyCollectionParams {
	o.SetMetricThroughputTotal(metricThroughputTotal)
	return o
}

// SetMetricThroughputTotal adds the metricThroughputTotal to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetMetricThroughputTotal(metricThroughputTotal *int64) {
	o.MetricThroughputTotal = metricThroughputTotal
}

// WithMetricThroughputWrite adds the metricThroughputWrite to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithMetricThroughputWrite(metricThroughputWrite *int64) *CifsServiceModifyCollectionParams {
	o.SetMetricThroughputWrite(metricThroughputWrite)
	return o
}

// SetMetricThroughputWrite adds the metricThroughputWrite to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetMetricThroughputWrite(metricThroughputWrite *int64) {
	o.MetricThroughputWrite = metricThroughputWrite
}

// WithMetricTimestamp adds the metricTimestamp to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithMetricTimestamp(metricTimestamp *string) *CifsServiceModifyCollectionParams {
	o.SetMetricTimestamp(metricTimestamp)
	return o
}

// SetMetricTimestamp adds the metricTimestamp to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetMetricTimestamp(metricTimestamp *string) {
	o.MetricTimestamp = metricTimestamp
}

// WithName adds the name to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithName(name *string) *CifsServiceModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithNetbiosAliases adds the netbiosAliases to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithNetbiosAliases(netbiosAliases *string) *CifsServiceModifyCollectionParams {
	o.SetNetbiosAliases(netbiosAliases)
	return o
}

// SetNetbiosAliases adds the netbiosAliases to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetNetbiosAliases(netbiosAliases *string) {
	o.NetbiosAliases = netbiosAliases
}

// WithNetbiosEnabled adds the netbiosEnabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithNetbiosEnabled(netbiosEnabled *bool) *CifsServiceModifyCollectionParams {
	o.SetNetbiosEnabled(netbiosEnabled)
	return o
}

// SetNetbiosEnabled adds the netbiosEnabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetNetbiosEnabled(netbiosEnabled *bool) {
	o.NetbiosEnabled = netbiosEnabled
}

// WithNetbiosWinsServers adds the netbiosWinsServers to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithNetbiosWinsServers(netbiosWinsServers *string) *CifsServiceModifyCollectionParams {
	o.SetNetbiosWinsServers(netbiosWinsServers)
	return o
}

// SetNetbiosWinsServers adds the netbiosWinsServers to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetNetbiosWinsServers(netbiosWinsServers *string) {
	o.NetbiosWinsServers = netbiosWinsServers
}

// WithOauthHost adds the oauthHost to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOauthHost(oauthHost *string) *CifsServiceModifyCollectionParams {
	o.SetOauthHost(oauthHost)
	return o
}

// SetOauthHost adds the oauthHost to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOauthHost(oauthHost *string) {
	o.OauthHost = oauthHost
}

// WithOptionsAdminToRootMapping adds the optionsAdminToRootMapping to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsAdminToRootMapping(optionsAdminToRootMapping *bool) *CifsServiceModifyCollectionParams {
	o.SetOptionsAdminToRootMapping(optionsAdminToRootMapping)
	return o
}

// SetOptionsAdminToRootMapping adds the optionsAdminToRootMapping to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsAdminToRootMapping(optionsAdminToRootMapping *bool) {
	o.OptionsAdminToRootMapping = optionsAdminToRootMapping
}

// WithOptionsAdvancedSparseFile adds the optionsAdvancedSparseFile to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsAdvancedSparseFile(optionsAdvancedSparseFile *bool) *CifsServiceModifyCollectionParams {
	o.SetOptionsAdvancedSparseFile(optionsAdvancedSparseFile)
	return o
}

// SetOptionsAdvancedSparseFile adds the optionsAdvancedSparseFile to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsAdvancedSparseFile(optionsAdvancedSparseFile *bool) {
	o.OptionsAdvancedSparseFile = optionsAdvancedSparseFile
}

// WithOptionsBackupSymlinkEnabled adds the optionsBackupSymlinkEnabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsBackupSymlinkEnabled(optionsBackupSymlinkEnabled *bool) *CifsServiceModifyCollectionParams {
	o.SetOptionsBackupSymlinkEnabled(optionsBackupSymlinkEnabled)
	return o
}

// SetOptionsBackupSymlinkEnabled adds the optionsBackupSymlinkEnabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsBackupSymlinkEnabled(optionsBackupSymlinkEnabled *bool) {
	o.OptionsBackupSymlinkEnabled = optionsBackupSymlinkEnabled
}

// WithOptionsClientDupDetectionEnabled adds the optionsClientDupDetectionEnabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsClientDupDetectionEnabled(optionsClientDupDetectionEnabled *bool) *CifsServiceModifyCollectionParams {
	o.SetOptionsClientDupDetectionEnabled(optionsClientDupDetectionEnabled)
	return o
}

// SetOptionsClientDupDetectionEnabled adds the optionsClientDupDetectionEnabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsClientDupDetectionEnabled(optionsClientDupDetectionEnabled *bool) {
	o.OptionsClientDupDetectionEnabled = optionsClientDupDetectionEnabled
}

// WithOptionsClientVersionReportingEnabled adds the optionsClientVersionReportingEnabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsClientVersionReportingEnabled(optionsClientVersionReportingEnabled *bool) *CifsServiceModifyCollectionParams {
	o.SetOptionsClientVersionReportingEnabled(optionsClientVersionReportingEnabled)
	return o
}

// SetOptionsClientVersionReportingEnabled adds the optionsClientVersionReportingEnabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsClientVersionReportingEnabled(optionsClientVersionReportingEnabled *bool) {
	o.OptionsClientVersionReportingEnabled = optionsClientVersionReportingEnabled
}

// WithOptionsCopyOffload adds the optionsCopyOffload to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsCopyOffload(optionsCopyOffload *bool) *CifsServiceModifyCollectionParams {
	o.SetOptionsCopyOffload(optionsCopyOffload)
	return o
}

// SetOptionsCopyOffload adds the optionsCopyOffload to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsCopyOffload(optionsCopyOffload *bool) {
	o.OptionsCopyOffload = optionsCopyOffload
}

// WithOptionsDacEnabled adds the optionsDacEnabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsDacEnabled(optionsDacEnabled *bool) *CifsServiceModifyCollectionParams {
	o.SetOptionsDacEnabled(optionsDacEnabled)
	return o
}

// SetOptionsDacEnabled adds the optionsDacEnabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsDacEnabled(optionsDacEnabled *bool) {
	o.OptionsDacEnabled = optionsDacEnabled
}

// WithOptionsExportPolicyEnabled adds the optionsExportPolicyEnabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsExportPolicyEnabled(optionsExportPolicyEnabled *bool) *CifsServiceModifyCollectionParams {
	o.SetOptionsExportPolicyEnabled(optionsExportPolicyEnabled)
	return o
}

// SetOptionsExportPolicyEnabled adds the optionsExportPolicyEnabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsExportPolicyEnabled(optionsExportPolicyEnabled *bool) {
	o.OptionsExportPolicyEnabled = optionsExportPolicyEnabled
}

// WithOptionsFakeOpen adds the optionsFakeOpen to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsFakeOpen(optionsFakeOpen *bool) *CifsServiceModifyCollectionParams {
	o.SetOptionsFakeOpen(optionsFakeOpen)
	return o
}

// SetOptionsFakeOpen adds the optionsFakeOpen to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsFakeOpen(optionsFakeOpen *bool) {
	o.OptionsFakeOpen = optionsFakeOpen
}

// WithOptionsFsctlTrim adds the optionsFsctlTrim to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsFsctlTrim(optionsFsctlTrim *bool) *CifsServiceModifyCollectionParams {
	o.SetOptionsFsctlTrim(optionsFsctlTrim)
	return o
}

// SetOptionsFsctlTrim adds the optionsFsctlTrim to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsFsctlTrim(optionsFsctlTrim *bool) {
	o.OptionsFsctlTrim = optionsFsctlTrim
}

// WithOptionsJunctionReparse adds the optionsJunctionReparse to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsJunctionReparse(optionsJunctionReparse *bool) *CifsServiceModifyCollectionParams {
	o.SetOptionsJunctionReparse(optionsJunctionReparse)
	return o
}

// SetOptionsJunctionReparse adds the optionsJunctionReparse to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsJunctionReparse(optionsJunctionReparse *bool) {
	o.OptionsJunctionReparse = optionsJunctionReparse
}

// WithOptionsLargeMtu adds the optionsLargeMtu to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsLargeMtu(optionsLargeMtu *bool) *CifsServiceModifyCollectionParams {
	o.SetOptionsLargeMtu(optionsLargeMtu)
	return o
}

// SetOptionsLargeMtu adds the optionsLargeMtu to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsLargeMtu(optionsLargeMtu *bool) {
	o.OptionsLargeMtu = optionsLargeMtu
}

// WithOptionsMaxConnectionsPerSession adds the optionsMaxConnectionsPerSession to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsMaxConnectionsPerSession(optionsMaxConnectionsPerSession *int64) *CifsServiceModifyCollectionParams {
	o.SetOptionsMaxConnectionsPerSession(optionsMaxConnectionsPerSession)
	return o
}

// SetOptionsMaxConnectionsPerSession adds the optionsMaxConnectionsPerSession to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsMaxConnectionsPerSession(optionsMaxConnectionsPerSession *int64) {
	o.OptionsMaxConnectionsPerSession = optionsMaxConnectionsPerSession
}

// WithOptionsMaxLifsPerSession adds the optionsMaxLifsPerSession to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsMaxLifsPerSession(optionsMaxLifsPerSession *int64) *CifsServiceModifyCollectionParams {
	o.SetOptionsMaxLifsPerSession(optionsMaxLifsPerSession)
	return o
}

// SetOptionsMaxLifsPerSession adds the optionsMaxLifsPerSession to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsMaxLifsPerSession(optionsMaxLifsPerSession *int64) {
	o.OptionsMaxLifsPerSession = optionsMaxLifsPerSession
}

// WithOptionsMaxOpensSameFilePerTree adds the optionsMaxOpensSameFilePerTree to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsMaxOpensSameFilePerTree(optionsMaxOpensSameFilePerTree *int64) *CifsServiceModifyCollectionParams {
	o.SetOptionsMaxOpensSameFilePerTree(optionsMaxOpensSameFilePerTree)
	return o
}

// SetOptionsMaxOpensSameFilePerTree adds the optionsMaxOpensSameFilePerTree to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsMaxOpensSameFilePerTree(optionsMaxOpensSameFilePerTree *int64) {
	o.OptionsMaxOpensSameFilePerTree = optionsMaxOpensSameFilePerTree
}

// WithOptionsMaxSameTreeConnectPerSession adds the optionsMaxSameTreeConnectPerSession to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsMaxSameTreeConnectPerSession(optionsMaxSameTreeConnectPerSession *int64) *CifsServiceModifyCollectionParams {
	o.SetOptionsMaxSameTreeConnectPerSession(optionsMaxSameTreeConnectPerSession)
	return o
}

// SetOptionsMaxSameTreeConnectPerSession adds the optionsMaxSameTreeConnectPerSession to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsMaxSameTreeConnectPerSession(optionsMaxSameTreeConnectPerSession *int64) {
	o.OptionsMaxSameTreeConnectPerSession = optionsMaxSameTreeConnectPerSession
}

// WithOptionsMaxSameUserSessionsPerConnection adds the optionsMaxSameUserSessionsPerConnection to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsMaxSameUserSessionsPerConnection(optionsMaxSameUserSessionsPerConnection *int64) *CifsServiceModifyCollectionParams {
	o.SetOptionsMaxSameUserSessionsPerConnection(optionsMaxSameUserSessionsPerConnection)
	return o
}

// SetOptionsMaxSameUserSessionsPerConnection adds the optionsMaxSameUserSessionsPerConnection to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsMaxSameUserSessionsPerConnection(optionsMaxSameUserSessionsPerConnection *int64) {
	o.OptionsMaxSameUserSessionsPerConnection = optionsMaxSameUserSessionsPerConnection
}

// WithOptionsMaxWatchesSetPerTree adds the optionsMaxWatchesSetPerTree to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsMaxWatchesSetPerTree(optionsMaxWatchesSetPerTree *int64) *CifsServiceModifyCollectionParams {
	o.SetOptionsMaxWatchesSetPerTree(optionsMaxWatchesSetPerTree)
	return o
}

// SetOptionsMaxWatchesSetPerTree adds the optionsMaxWatchesSetPerTree to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsMaxWatchesSetPerTree(optionsMaxWatchesSetPerTree *int64) {
	o.OptionsMaxWatchesSetPerTree = optionsMaxWatchesSetPerTree
}

// WithOptionsMultichannel adds the optionsMultichannel to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsMultichannel(optionsMultichannel *bool) *CifsServiceModifyCollectionParams {
	o.SetOptionsMultichannel(optionsMultichannel)
	return o
}

// SetOptionsMultichannel adds the optionsMultichannel to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsMultichannel(optionsMultichannel *bool) {
	o.OptionsMultichannel = optionsMultichannel
}

// WithOptionsNullUserWindowsName adds the optionsNullUserWindowsName to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsNullUserWindowsName(optionsNullUserWindowsName *string) *CifsServiceModifyCollectionParams {
	o.SetOptionsNullUserWindowsName(optionsNullUserWindowsName)
	return o
}

// SetOptionsNullUserWindowsName adds the optionsNullUserWindowsName to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsNullUserWindowsName(optionsNullUserWindowsName *string) {
	o.OptionsNullUserWindowsName = optionsNullUserWindowsName
}

// WithOptionsPathComponentCache adds the optionsPathComponentCache to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsPathComponentCache(optionsPathComponentCache *bool) *CifsServiceModifyCollectionParams {
	o.SetOptionsPathComponentCache(optionsPathComponentCache)
	return o
}

// SetOptionsPathComponentCache adds the optionsPathComponentCache to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsPathComponentCache(optionsPathComponentCache *bool) {
	o.OptionsPathComponentCache = optionsPathComponentCache
}

// WithOptionsReferral adds the optionsReferral to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsReferral(optionsReferral *bool) *CifsServiceModifyCollectionParams {
	o.SetOptionsReferral(optionsReferral)
	return o
}

// SetOptionsReferral adds the optionsReferral to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsReferral(optionsReferral *bool) {
	o.OptionsReferral = optionsReferral
}

// WithOptionsShadowcopy adds the optionsShadowcopy to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsShadowcopy(optionsShadowcopy *bool) *CifsServiceModifyCollectionParams {
	o.SetOptionsShadowcopy(optionsShadowcopy)
	return o
}

// SetOptionsShadowcopy adds the optionsShadowcopy to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsShadowcopy(optionsShadowcopy *bool) {
	o.OptionsShadowcopy = optionsShadowcopy
}

// WithOptionsShadowcopyDirDepth adds the optionsShadowcopyDirDepth to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsShadowcopyDirDepth(optionsShadowcopyDirDepth *int64) *CifsServiceModifyCollectionParams {
	o.SetOptionsShadowcopyDirDepth(optionsShadowcopyDirDepth)
	return o
}

// SetOptionsShadowcopyDirDepth adds the optionsShadowcopyDirDepth to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsShadowcopyDirDepth(optionsShadowcopyDirDepth *int64) {
	o.OptionsShadowcopyDirDepth = optionsShadowcopyDirDepth
}

// WithOptionsSmbCredits adds the optionsSmbCredits to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsSmbCredits(optionsSmbCredits *int64) *CifsServiceModifyCollectionParams {
	o.SetOptionsSmbCredits(optionsSmbCredits)
	return o
}

// SetOptionsSmbCredits adds the optionsSmbCredits to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsSmbCredits(optionsSmbCredits *int64) {
	o.OptionsSmbCredits = optionsSmbCredits
}

// WithOptionsTrustedDomainEnumSearchEnabled adds the optionsTrustedDomainEnumSearchEnabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsTrustedDomainEnumSearchEnabled(optionsTrustedDomainEnumSearchEnabled *bool) *CifsServiceModifyCollectionParams {
	o.SetOptionsTrustedDomainEnumSearchEnabled(optionsTrustedDomainEnumSearchEnabled)
	return o
}

// SetOptionsTrustedDomainEnumSearchEnabled adds the optionsTrustedDomainEnumSearchEnabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsTrustedDomainEnumSearchEnabled(optionsTrustedDomainEnumSearchEnabled *bool) {
	o.OptionsTrustedDomainEnumSearchEnabled = optionsTrustedDomainEnumSearchEnabled
}

// WithOptionsWidelinkReparseVersions adds the optionsWidelinkReparseVersions to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithOptionsWidelinkReparseVersions(optionsWidelinkReparseVersions *string) *CifsServiceModifyCollectionParams {
	o.SetOptionsWidelinkReparseVersions(optionsWidelinkReparseVersions)
	return o
}

// SetOptionsWidelinkReparseVersions adds the optionsWidelinkReparseVersions to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetOptionsWidelinkReparseVersions(optionsWidelinkReparseVersions *string) {
	o.OptionsWidelinkReparseVersions = optionsWidelinkReparseVersions
}

// WithProxyHost adds the proxyHost to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithProxyHost(proxyHost *string) *CifsServiceModifyCollectionParams {
	o.SetProxyHost(proxyHost)
	return o
}

// SetProxyHost adds the proxyHost to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetProxyHost(proxyHost *string) {
	o.ProxyHost = proxyHost
}

// WithProxyPort adds the proxyPort to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithProxyPort(proxyPort *int64) *CifsServiceModifyCollectionParams {
	o.SetProxyPort(proxyPort)
	return o
}

// SetProxyPort adds the proxyPort to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetProxyPort(proxyPort *int64) {
	o.ProxyPort = proxyPort
}

// WithProxyType adds the proxyType to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithProxyType(proxyType *string) *CifsServiceModifyCollectionParams {
	o.SetProxyType(proxyType)
	return o
}

// SetProxyType adds the proxyType to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetProxyType(proxyType *string) {
	o.ProxyType = proxyType
}

// WithProxyUsername adds the proxyUsername to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithProxyUsername(proxyUsername *string) *CifsServiceModifyCollectionParams {
	o.SetProxyUsername(proxyUsername)
	return o
}

// SetProxyUsername adds the proxyUsername to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetProxyUsername(proxyUsername *string) {
	o.ProxyUsername = proxyUsername
}

// WithReturnRecords adds the returnRecords to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithReturnRecords(returnRecords *bool) *CifsServiceModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *CifsServiceModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSecurityAdvertisedKdcEncryptions adds the securityAdvertisedKdcEncryptions to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithSecurityAdvertisedKdcEncryptions(securityAdvertisedKdcEncryptions *string) *CifsServiceModifyCollectionParams {
	o.SetSecurityAdvertisedKdcEncryptions(securityAdvertisedKdcEncryptions)
	return o
}

// SetSecurityAdvertisedKdcEncryptions adds the securityAdvertisedKdcEncryptions to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetSecurityAdvertisedKdcEncryptions(securityAdvertisedKdcEncryptions *string) {
	o.SecurityAdvertisedKdcEncryptions = securityAdvertisedKdcEncryptions
}

// WithSecurityAesNetlogonEnabled adds the securityAesNetlogonEnabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithSecurityAesNetlogonEnabled(securityAesNetlogonEnabled *bool) *CifsServiceModifyCollectionParams {
	o.SetSecurityAesNetlogonEnabled(securityAesNetlogonEnabled)
	return o
}

// SetSecurityAesNetlogonEnabled adds the securityAesNetlogonEnabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetSecurityAesNetlogonEnabled(securityAesNetlogonEnabled *bool) {
	o.SecurityAesNetlogonEnabled = securityAesNetlogonEnabled
}

// WithSecurityEncryptDcConnection adds the securityEncryptDcConnection to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithSecurityEncryptDcConnection(securityEncryptDcConnection *bool) *CifsServiceModifyCollectionParams {
	o.SetSecurityEncryptDcConnection(securityEncryptDcConnection)
	return o
}

// SetSecurityEncryptDcConnection adds the securityEncryptDcConnection to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetSecurityEncryptDcConnection(securityEncryptDcConnection *bool) {
	o.SecurityEncryptDcConnection = securityEncryptDcConnection
}

// WithSecurityKdcEncryption adds the securityKdcEncryption to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithSecurityKdcEncryption(securityKdcEncryption *bool) *CifsServiceModifyCollectionParams {
	o.SetSecurityKdcEncryption(securityKdcEncryption)
	return o
}

// SetSecurityKdcEncryption adds the securityKdcEncryption to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetSecurityKdcEncryption(securityKdcEncryption *bool) {
	o.SecurityKdcEncryption = securityKdcEncryption
}

// WithSecurityLdapReferralEnabled adds the securityLdapReferralEnabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithSecurityLdapReferralEnabled(securityLdapReferralEnabled *bool) *CifsServiceModifyCollectionParams {
	o.SetSecurityLdapReferralEnabled(securityLdapReferralEnabled)
	return o
}

// SetSecurityLdapReferralEnabled adds the securityLdapReferralEnabled to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetSecurityLdapReferralEnabled(securityLdapReferralEnabled *bool) {
	o.SecurityLdapReferralEnabled = securityLdapReferralEnabled
}

// WithSecurityLmCompatibilityLevel adds the securityLmCompatibilityLevel to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithSecurityLmCompatibilityLevel(securityLmCompatibilityLevel *string) *CifsServiceModifyCollectionParams {
	o.SetSecurityLmCompatibilityLevel(securityLmCompatibilityLevel)
	return o
}

// SetSecurityLmCompatibilityLevel adds the securityLmCompatibilityLevel to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetSecurityLmCompatibilityLevel(securityLmCompatibilityLevel *string) {
	o.SecurityLmCompatibilityLevel = securityLmCompatibilityLevel
}

// WithSecurityRestrictAnonymous adds the securityRestrictAnonymous to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithSecurityRestrictAnonymous(securityRestrictAnonymous *string) *CifsServiceModifyCollectionParams {
	o.SetSecurityRestrictAnonymous(securityRestrictAnonymous)
	return o
}

// SetSecurityRestrictAnonymous adds the securityRestrictAnonymous to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetSecurityRestrictAnonymous(securityRestrictAnonymous *string) {
	o.SecurityRestrictAnonymous = securityRestrictAnonymous
}

// WithSecuritySessionSecurity adds the securitySessionSecurity to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithSecuritySessionSecurity(securitySessionSecurity *string) *CifsServiceModifyCollectionParams {
	o.SetSecuritySessionSecurity(securitySessionSecurity)
	return o
}

// SetSecuritySessionSecurity adds the securitySessionSecurity to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetSecuritySessionSecurity(securitySessionSecurity *string) {
	o.SecuritySessionSecurity = securitySessionSecurity
}

// WithSecuritySmbEncryption adds the securitySmbEncryption to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithSecuritySmbEncryption(securitySmbEncryption *bool) *CifsServiceModifyCollectionParams {
	o.SetSecuritySmbEncryption(securitySmbEncryption)
	return o
}

// SetSecuritySmbEncryption adds the securitySmbEncryption to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetSecuritySmbEncryption(securitySmbEncryption *bool) {
	o.SecuritySmbEncryption = securitySmbEncryption
}

// WithSecuritySmbSigning adds the securitySmbSigning to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithSecuritySmbSigning(securitySmbSigning *bool) *CifsServiceModifyCollectionParams {
	o.SetSecuritySmbSigning(securitySmbSigning)
	return o
}

// SetSecuritySmbSigning adds the securitySmbSigning to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetSecuritySmbSigning(securitySmbSigning *bool) {
	o.SecuritySmbSigning = securitySmbSigning
}

// WithSecurityTryLdapChannelBinding adds the securityTryLdapChannelBinding to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithSecurityTryLdapChannelBinding(securityTryLdapChannelBinding *bool) *CifsServiceModifyCollectionParams {
	o.SetSecurityTryLdapChannelBinding(securityTryLdapChannelBinding)
	return o
}

// SetSecurityTryLdapChannelBinding adds the securityTryLdapChannelBinding to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetSecurityTryLdapChannelBinding(securityTryLdapChannelBinding *bool) {
	o.SecurityTryLdapChannelBinding = securityTryLdapChannelBinding
}

// WithSecurityUseLdaps adds the securityUseLdaps to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithSecurityUseLdaps(securityUseLdaps *bool) *CifsServiceModifyCollectionParams {
	o.SetSecurityUseLdaps(securityUseLdaps)
	return o
}

// SetSecurityUseLdaps adds the securityUseLdaps to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetSecurityUseLdaps(securityUseLdaps *bool) {
	o.SecurityUseLdaps = securityUseLdaps
}

// WithSecurityUseStartTLS adds the securityUseStartTLS to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithSecurityUseStartTLS(securityUseStartTLS *bool) *CifsServiceModifyCollectionParams {
	o.SetSecurityUseStartTLS(securityUseStartTLS)
	return o
}

// SetSecurityUseStartTLS adds the securityUseStartTls to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetSecurityUseStartTLS(securityUseStartTLS *bool) {
	o.SecurityUseStartTLS = securityUseStartTLS
}

// WithSerialRecords adds the serialRecords to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithSerialRecords(serialRecords *bool) *CifsServiceModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithStatisticsIopsRawOther adds the statisticsIopsRawOther to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithStatisticsIopsRawOther(statisticsIopsRawOther *int64) *CifsServiceModifyCollectionParams {
	o.SetStatisticsIopsRawOther(statisticsIopsRawOther)
	return o
}

// SetStatisticsIopsRawOther adds the statisticsIopsRawOther to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetStatisticsIopsRawOther(statisticsIopsRawOther *int64) {
	o.StatisticsIopsRawOther = statisticsIopsRawOther
}

// WithStatisticsIopsRawRead adds the statisticsIopsRawRead to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithStatisticsIopsRawRead(statisticsIopsRawRead *int64) *CifsServiceModifyCollectionParams {
	o.SetStatisticsIopsRawRead(statisticsIopsRawRead)
	return o
}

// SetStatisticsIopsRawRead adds the statisticsIopsRawRead to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetStatisticsIopsRawRead(statisticsIopsRawRead *int64) {
	o.StatisticsIopsRawRead = statisticsIopsRawRead
}

// WithStatisticsIopsRawTotal adds the statisticsIopsRawTotal to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithStatisticsIopsRawTotal(statisticsIopsRawTotal *int64) *CifsServiceModifyCollectionParams {
	o.SetStatisticsIopsRawTotal(statisticsIopsRawTotal)
	return o
}

// SetStatisticsIopsRawTotal adds the statisticsIopsRawTotal to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetStatisticsIopsRawTotal(statisticsIopsRawTotal *int64) {
	o.StatisticsIopsRawTotal = statisticsIopsRawTotal
}

// WithStatisticsIopsRawWrite adds the statisticsIopsRawWrite to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithStatisticsIopsRawWrite(statisticsIopsRawWrite *int64) *CifsServiceModifyCollectionParams {
	o.SetStatisticsIopsRawWrite(statisticsIopsRawWrite)
	return o
}

// SetStatisticsIopsRawWrite adds the statisticsIopsRawWrite to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetStatisticsIopsRawWrite(statisticsIopsRawWrite *int64) {
	o.StatisticsIopsRawWrite = statisticsIopsRawWrite
}

// WithStatisticsLatencyRawOther adds the statisticsLatencyRawOther to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithStatisticsLatencyRawOther(statisticsLatencyRawOther *int64) *CifsServiceModifyCollectionParams {
	o.SetStatisticsLatencyRawOther(statisticsLatencyRawOther)
	return o
}

// SetStatisticsLatencyRawOther adds the statisticsLatencyRawOther to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetStatisticsLatencyRawOther(statisticsLatencyRawOther *int64) {
	o.StatisticsLatencyRawOther = statisticsLatencyRawOther
}

// WithStatisticsLatencyRawRead adds the statisticsLatencyRawRead to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithStatisticsLatencyRawRead(statisticsLatencyRawRead *int64) *CifsServiceModifyCollectionParams {
	o.SetStatisticsLatencyRawRead(statisticsLatencyRawRead)
	return o
}

// SetStatisticsLatencyRawRead adds the statisticsLatencyRawRead to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetStatisticsLatencyRawRead(statisticsLatencyRawRead *int64) {
	o.StatisticsLatencyRawRead = statisticsLatencyRawRead
}

// WithStatisticsLatencyRawTotal adds the statisticsLatencyRawTotal to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithStatisticsLatencyRawTotal(statisticsLatencyRawTotal *int64) *CifsServiceModifyCollectionParams {
	o.SetStatisticsLatencyRawTotal(statisticsLatencyRawTotal)
	return o
}

// SetStatisticsLatencyRawTotal adds the statisticsLatencyRawTotal to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetStatisticsLatencyRawTotal(statisticsLatencyRawTotal *int64) {
	o.StatisticsLatencyRawTotal = statisticsLatencyRawTotal
}

// WithStatisticsLatencyRawWrite adds the statisticsLatencyRawWrite to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithStatisticsLatencyRawWrite(statisticsLatencyRawWrite *int64) *CifsServiceModifyCollectionParams {
	o.SetStatisticsLatencyRawWrite(statisticsLatencyRawWrite)
	return o
}

// SetStatisticsLatencyRawWrite adds the statisticsLatencyRawWrite to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetStatisticsLatencyRawWrite(statisticsLatencyRawWrite *int64) {
	o.StatisticsLatencyRawWrite = statisticsLatencyRawWrite
}

// WithStatisticsStatus adds the statisticsStatus to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithStatisticsStatus(statisticsStatus *string) *CifsServiceModifyCollectionParams {
	o.SetStatisticsStatus(statisticsStatus)
	return o
}

// SetStatisticsStatus adds the statisticsStatus to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetStatisticsStatus(statisticsStatus *string) {
	o.StatisticsStatus = statisticsStatus
}

// WithStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) *CifsServiceModifyCollectionParams {
	o.SetStatisticsThroughputRawRead(statisticsThroughputRawRead)
	return o
}

// SetStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) {
	o.StatisticsThroughputRawRead = statisticsThroughputRawRead
}

// WithStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) *CifsServiceModifyCollectionParams {
	o.SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal)
	return o
}

// SetStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) {
	o.StatisticsThroughputRawTotal = statisticsThroughputRawTotal
}

// WithStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) *CifsServiceModifyCollectionParams {
	o.SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite)
	return o
}

// SetStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) {
	o.StatisticsThroughputRawWrite = statisticsThroughputRawWrite
}

// WithStatisticsTimestamp adds the statisticsTimestamp to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithStatisticsTimestamp(statisticsTimestamp *string) *CifsServiceModifyCollectionParams {
	o.SetStatisticsTimestamp(statisticsTimestamp)
	return o
}

// SetStatisticsTimestamp adds the statisticsTimestamp to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetStatisticsTimestamp(statisticsTimestamp *string) {
	o.StatisticsTimestamp = statisticsTimestamp
}

// WithSvmName adds the svmName to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithSvmName(svmName *string) *CifsServiceModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithSvmUUID(svmUUID *string) *CifsServiceModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTenantID adds the tenantID to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithTenantID(tenantID *string) *CifsServiceModifyCollectionParams {
	o.SetTenantID(tenantID)
	return o
}

// SetTenantID adds the tenantId to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetTenantID(tenantID *string) {
	o.TenantID = tenantID
}

// WithTimeout adds the timeout to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithTimeout(timeout *int64) *CifsServiceModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetTimeout(timeout *int64) {
	o.Timeout = timeout
}

// WithVerifyHost adds the verifyHost to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithVerifyHost(verifyHost *bool) *CifsServiceModifyCollectionParams {
	o.SetVerifyHost(verifyHost)
	return o
}

// SetVerifyHost adds the verifyHost to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetVerifyHost(verifyHost *bool) {
	o.VerifyHost = verifyHost
}

// WithWorkgroup adds the workgroup to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) WithWorkgroup(workgroup *string) *CifsServiceModifyCollectionParams {
	o.SetWorkgroup(workgroup)
	return o
}

// SetWorkgroup adds the workgroup to the cifs service modify collection params
func (o *CifsServiceModifyCollectionParams) SetWorkgroup(workgroup *string) {
	o.Workgroup = workgroup
}

// WriteToRequest writes these params to a swagger request
func (o *CifsServiceModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.requestTimeout); err != nil {
		return err
	}
	var res []error

	if o.AdDomainDefaultSite != nil {

		// query param ad_domain.default_site
		var qrAdDomainDefaultSite string

		if o.AdDomainDefaultSite != nil {
			qrAdDomainDefaultSite = *o.AdDomainDefaultSite
		}
		qAdDomainDefaultSite := qrAdDomainDefaultSite
		if qAdDomainDefaultSite != "" {

			if err := r.SetQueryParam("ad_domain.default_site", qAdDomainDefaultSite); err != nil {
				return err
			}
		}
	}

	if o.AdDomainFqdn != nil {

		// query param ad_domain.fqdn
		var qrAdDomainFqdn string

		if o.AdDomainFqdn != nil {
			qrAdDomainFqdn = *o.AdDomainFqdn
		}
		qAdDomainFqdn := qrAdDomainFqdn
		if qAdDomainFqdn != "" {

			if err := r.SetQueryParam("ad_domain.fqdn", qAdDomainFqdn); err != nil {
				return err
			}
		}
	}

	if o.AdDomainOrganizationalUnit != nil {

		// query param ad_domain.organizational_unit
		var qrAdDomainOrganizationalUnit string

		if o.AdDomainOrganizationalUnit != nil {
			qrAdDomainOrganizationalUnit = *o.AdDomainOrganizationalUnit
		}
		qAdDomainOrganizationalUnit := qrAdDomainOrganizationalUnit
		if qAdDomainOrganizationalUnit != "" {

			if err := r.SetQueryParam("ad_domain.organizational_unit", qAdDomainOrganizationalUnit); err != nil {
				return err
			}
		}
	}

	if o.AuthStyle != nil {

		// query param auth-style
		var qrAuthStyle string

		if o.AuthStyle != nil {
			qrAuthStyle = *o.AuthStyle
		}
		qAuthStyle := qrAuthStyle
		if qAuthStyle != "" {

			if err := r.SetQueryParam("auth-style", qAuthStyle); err != nil {
				return err
			}
		}
	}

	if o.AuthUserType != nil {

		// query param auth_user_type
		var qrAuthUserType string

		if o.AuthUserType != nil {
			qrAuthUserType = *o.AuthUserType
		}
		qAuthUserType := qrAuthUserType
		if qAuthUserType != "" {

			if err := r.SetQueryParam("auth_user_type", qAuthUserType); err != nil {
				return err
			}
		}
	}

	if o.AuthenticationMethod != nil {

		// query param authentication_method
		var qrAuthenticationMethod string

		if o.AuthenticationMethod != nil {
			qrAuthenticationMethod = *o.AuthenticationMethod
		}
		qAuthenticationMethod := qrAuthenticationMethod
		if qAuthenticationMethod != "" {

			if err := r.SetQueryParam("authentication_method", qAuthenticationMethod); err != nil {
				return err
			}
		}
	}

	if o.ClientID != nil {

		// query param client_id
		var qrClientID string

		if o.ClientID != nil {
			qrClientID = *o.ClientID
		}
		qClientID := qrClientID
		if qClientID != "" {

			if err := r.SetQueryParam("client_id", qClientID); err != nil {
				return err
			}
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.DefaultUnixUser != nil {

		// query param default_unix_user
		var qrDefaultUnixUser string

		if o.DefaultUnixUser != nil {
			qrDefaultUnixUser = *o.DefaultUnixUser
		}
		qDefaultUnixUser := qrDefaultUnixUser
		if qDefaultUnixUser != "" {

			if err := r.SetQueryParam("default_unix_user", qDefaultUnixUser); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.Force != nil {

		// query param force
		var qrForce bool

		if o.Force != nil {
			qrForce = *o.Force
		}
		qForce := swag.FormatBool(qrForce)
		if qForce != "" {

			if err := r.SetQueryParam("force", qForce); err != nil {
				return err
			}
		}
	}

	if o.GroupPolicyObjectEnabled != nil {

		// query param group_policy_object_enabled
		var qrGroupPolicyObjectEnabled bool

		if o.GroupPolicyObjectEnabled != nil {
			qrGroupPolicyObjectEnabled = *o.GroupPolicyObjectEnabled
		}
		qGroupPolicyObjectEnabled := swag.FormatBool(qrGroupPolicyObjectEnabled)
		if qGroupPolicyObjectEnabled != "" {

			if err := r.SetQueryParam("group_policy_object_enabled", qGroupPolicyObjectEnabled); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.KeyVaultURI != nil {

		// query param key_vault_uri
		var qrKeyVaultURI string

		if o.KeyVaultURI != nil {
			qrKeyVaultURI = *o.KeyVaultURI
		}
		qKeyVaultURI := qrKeyVaultURI
		if qKeyVaultURI != "" {

			if err := r.SetQueryParam("key_vault_uri", qKeyVaultURI); err != nil {
				return err
			}
		}
	}

	if o.MetricDuration != nil {

		// query param metric.duration
		var qrMetricDuration string

		if o.MetricDuration != nil {
			qrMetricDuration = *o.MetricDuration
		}
		qMetricDuration := qrMetricDuration
		if qMetricDuration != "" {

			if err := r.SetQueryParam("metric.duration", qMetricDuration); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsOther != nil {

		// query param metric.iops.other
		var qrMetricIopsOther int64

		if o.MetricIopsOther != nil {
			qrMetricIopsOther = *o.MetricIopsOther
		}
		qMetricIopsOther := swag.FormatInt64(qrMetricIopsOther)
		if qMetricIopsOther != "" {

			if err := r.SetQueryParam("metric.iops.other", qMetricIopsOther); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsRead != nil {

		// query param metric.iops.read
		var qrMetricIopsRead int64

		if o.MetricIopsRead != nil {
			qrMetricIopsRead = *o.MetricIopsRead
		}
		qMetricIopsRead := swag.FormatInt64(qrMetricIopsRead)
		if qMetricIopsRead != "" {

			if err := r.SetQueryParam("metric.iops.read", qMetricIopsRead); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsTotal != nil {

		// query param metric.iops.total
		var qrMetricIopsTotal int64

		if o.MetricIopsTotal != nil {
			qrMetricIopsTotal = *o.MetricIopsTotal
		}
		qMetricIopsTotal := swag.FormatInt64(qrMetricIopsTotal)
		if qMetricIopsTotal != "" {

			if err := r.SetQueryParam("metric.iops.total", qMetricIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsWrite != nil {

		// query param metric.iops.write
		var qrMetricIopsWrite int64

		if o.MetricIopsWrite != nil {
			qrMetricIopsWrite = *o.MetricIopsWrite
		}
		qMetricIopsWrite := swag.FormatInt64(qrMetricIopsWrite)
		if qMetricIopsWrite != "" {

			if err := r.SetQueryParam("metric.iops.write", qMetricIopsWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyOther != nil {

		// query param metric.latency.other
		var qrMetricLatencyOther int64

		if o.MetricLatencyOther != nil {
			qrMetricLatencyOther = *o.MetricLatencyOther
		}
		qMetricLatencyOther := swag.FormatInt64(qrMetricLatencyOther)
		if qMetricLatencyOther != "" {

			if err := r.SetQueryParam("metric.latency.other", qMetricLatencyOther); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyRead != nil {

		// query param metric.latency.read
		var qrMetricLatencyRead int64

		if o.MetricLatencyRead != nil {
			qrMetricLatencyRead = *o.MetricLatencyRead
		}
		qMetricLatencyRead := swag.FormatInt64(qrMetricLatencyRead)
		if qMetricLatencyRead != "" {

			if err := r.SetQueryParam("metric.latency.read", qMetricLatencyRead); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyTotal != nil {

		// query param metric.latency.total
		var qrMetricLatencyTotal int64

		if o.MetricLatencyTotal != nil {
			qrMetricLatencyTotal = *o.MetricLatencyTotal
		}
		qMetricLatencyTotal := swag.FormatInt64(qrMetricLatencyTotal)
		if qMetricLatencyTotal != "" {

			if err := r.SetQueryParam("metric.latency.total", qMetricLatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyWrite != nil {

		// query param metric.latency.write
		var qrMetricLatencyWrite int64

		if o.MetricLatencyWrite != nil {
			qrMetricLatencyWrite = *o.MetricLatencyWrite
		}
		qMetricLatencyWrite := swag.FormatInt64(qrMetricLatencyWrite)
		if qMetricLatencyWrite != "" {

			if err := r.SetQueryParam("metric.latency.write", qMetricLatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricStatus != nil {

		// query param metric.status
		var qrMetricStatus string

		if o.MetricStatus != nil {
			qrMetricStatus = *o.MetricStatus
		}
		qMetricStatus := qrMetricStatus
		if qMetricStatus != "" {

			if err := r.SetQueryParam("metric.status", qMetricStatus); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputRead != nil {

		// query param metric.throughput.read
		var qrMetricThroughputRead int64

		if o.MetricThroughputRead != nil {
			qrMetricThroughputRead = *o.MetricThroughputRead
		}
		qMetricThroughputRead := swag.FormatInt64(qrMetricThroughputRead)
		if qMetricThroughputRead != "" {

			if err := r.SetQueryParam("metric.throughput.read", qMetricThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputTotal != nil {

		// query param metric.throughput.total
		var qrMetricThroughputTotal int64

		if o.MetricThroughputTotal != nil {
			qrMetricThroughputTotal = *o.MetricThroughputTotal
		}
		qMetricThroughputTotal := swag.FormatInt64(qrMetricThroughputTotal)
		if qMetricThroughputTotal != "" {

			if err := r.SetQueryParam("metric.throughput.total", qMetricThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputWrite != nil {

		// query param metric.throughput.write
		var qrMetricThroughputWrite int64

		if o.MetricThroughputWrite != nil {
			qrMetricThroughputWrite = *o.MetricThroughputWrite
		}
		qMetricThroughputWrite := swag.FormatInt64(qrMetricThroughputWrite)
		if qMetricThroughputWrite != "" {

			if err := r.SetQueryParam("metric.throughput.write", qMetricThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricTimestamp != nil {

		// query param metric.timestamp
		var qrMetricTimestamp string

		if o.MetricTimestamp != nil {
			qrMetricTimestamp = *o.MetricTimestamp
		}
		qMetricTimestamp := qrMetricTimestamp
		if qMetricTimestamp != "" {

			if err := r.SetQueryParam("metric.timestamp", qMetricTimestamp); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NetbiosAliases != nil {

		// query param netbios.aliases
		var qrNetbiosAliases string

		if o.NetbiosAliases != nil {
			qrNetbiosAliases = *o.NetbiosAliases
		}
		qNetbiosAliases := qrNetbiosAliases
		if qNetbiosAliases != "" {

			if err := r.SetQueryParam("netbios.aliases", qNetbiosAliases); err != nil {
				return err
			}
		}
	}

	if o.NetbiosEnabled != nil {

		// query param netbios.enabled
		var qrNetbiosEnabled bool

		if o.NetbiosEnabled != nil {
			qrNetbiosEnabled = *o.NetbiosEnabled
		}
		qNetbiosEnabled := swag.FormatBool(qrNetbiosEnabled)
		if qNetbiosEnabled != "" {

			if err := r.SetQueryParam("netbios.enabled", qNetbiosEnabled); err != nil {
				return err
			}
		}
	}

	if o.NetbiosWinsServers != nil {

		// query param netbios.wins_servers
		var qrNetbiosWinsServers string

		if o.NetbiosWinsServers != nil {
			qrNetbiosWinsServers = *o.NetbiosWinsServers
		}
		qNetbiosWinsServers := qrNetbiosWinsServers
		if qNetbiosWinsServers != "" {

			if err := r.SetQueryParam("netbios.wins_servers", qNetbiosWinsServers); err != nil {
				return err
			}
		}
	}

	if o.OauthHost != nil {

		// query param oauth_host
		var qrOauthHost string

		if o.OauthHost != nil {
			qrOauthHost = *o.OauthHost
		}
		qOauthHost := qrOauthHost
		if qOauthHost != "" {

			if err := r.SetQueryParam("oauth_host", qOauthHost); err != nil {
				return err
			}
		}
	}

	if o.OptionsAdminToRootMapping != nil {

		// query param options.admin_to_root_mapping
		var qrOptionsAdminToRootMapping bool

		if o.OptionsAdminToRootMapping != nil {
			qrOptionsAdminToRootMapping = *o.OptionsAdminToRootMapping
		}
		qOptionsAdminToRootMapping := swag.FormatBool(qrOptionsAdminToRootMapping)
		if qOptionsAdminToRootMapping != "" {

			if err := r.SetQueryParam("options.admin_to_root_mapping", qOptionsAdminToRootMapping); err != nil {
				return err
			}
		}
	}

	if o.OptionsAdvancedSparseFile != nil {

		// query param options.advanced_sparse_file
		var qrOptionsAdvancedSparseFile bool

		if o.OptionsAdvancedSparseFile != nil {
			qrOptionsAdvancedSparseFile = *o.OptionsAdvancedSparseFile
		}
		qOptionsAdvancedSparseFile := swag.FormatBool(qrOptionsAdvancedSparseFile)
		if qOptionsAdvancedSparseFile != "" {

			if err := r.SetQueryParam("options.advanced_sparse_file", qOptionsAdvancedSparseFile); err != nil {
				return err
			}
		}
	}

	if o.OptionsBackupSymlinkEnabled != nil {

		// query param options.backup_symlink_enabled
		var qrOptionsBackupSymlinkEnabled bool

		if o.OptionsBackupSymlinkEnabled != nil {
			qrOptionsBackupSymlinkEnabled = *o.OptionsBackupSymlinkEnabled
		}
		qOptionsBackupSymlinkEnabled := swag.FormatBool(qrOptionsBackupSymlinkEnabled)
		if qOptionsBackupSymlinkEnabled != "" {

			if err := r.SetQueryParam("options.backup_symlink_enabled", qOptionsBackupSymlinkEnabled); err != nil {
				return err
			}
		}
	}

	if o.OptionsClientDupDetectionEnabled != nil {

		// query param options.client_dup_detection_enabled
		var qrOptionsClientDupDetectionEnabled bool

		if o.OptionsClientDupDetectionEnabled != nil {
			qrOptionsClientDupDetectionEnabled = *o.OptionsClientDupDetectionEnabled
		}
		qOptionsClientDupDetectionEnabled := swag.FormatBool(qrOptionsClientDupDetectionEnabled)
		if qOptionsClientDupDetectionEnabled != "" {

			if err := r.SetQueryParam("options.client_dup_detection_enabled", qOptionsClientDupDetectionEnabled); err != nil {
				return err
			}
		}
	}

	if o.OptionsClientVersionReportingEnabled != nil {

		// query param options.client_version_reporting_enabled
		var qrOptionsClientVersionReportingEnabled bool

		if o.OptionsClientVersionReportingEnabled != nil {
			qrOptionsClientVersionReportingEnabled = *o.OptionsClientVersionReportingEnabled
		}
		qOptionsClientVersionReportingEnabled := swag.FormatBool(qrOptionsClientVersionReportingEnabled)
		if qOptionsClientVersionReportingEnabled != "" {

			if err := r.SetQueryParam("options.client_version_reporting_enabled", qOptionsClientVersionReportingEnabled); err != nil {
				return err
			}
		}
	}

	if o.OptionsCopyOffload != nil {

		// query param options.copy_offload
		var qrOptionsCopyOffload bool

		if o.OptionsCopyOffload != nil {
			qrOptionsCopyOffload = *o.OptionsCopyOffload
		}
		qOptionsCopyOffload := swag.FormatBool(qrOptionsCopyOffload)
		if qOptionsCopyOffload != "" {

			if err := r.SetQueryParam("options.copy_offload", qOptionsCopyOffload); err != nil {
				return err
			}
		}
	}

	if o.OptionsDacEnabled != nil {

		// query param options.dac_enabled
		var qrOptionsDacEnabled bool

		if o.OptionsDacEnabled != nil {
			qrOptionsDacEnabled = *o.OptionsDacEnabled
		}
		qOptionsDacEnabled := swag.FormatBool(qrOptionsDacEnabled)
		if qOptionsDacEnabled != "" {

			if err := r.SetQueryParam("options.dac_enabled", qOptionsDacEnabled); err != nil {
				return err
			}
		}
	}

	if o.OptionsExportPolicyEnabled != nil {

		// query param options.export_policy_enabled
		var qrOptionsExportPolicyEnabled bool

		if o.OptionsExportPolicyEnabled != nil {
			qrOptionsExportPolicyEnabled = *o.OptionsExportPolicyEnabled
		}
		qOptionsExportPolicyEnabled := swag.FormatBool(qrOptionsExportPolicyEnabled)
		if qOptionsExportPolicyEnabled != "" {

			if err := r.SetQueryParam("options.export_policy_enabled", qOptionsExportPolicyEnabled); err != nil {
				return err
			}
		}
	}

	if o.OptionsFakeOpen != nil {

		// query param options.fake_open
		var qrOptionsFakeOpen bool

		if o.OptionsFakeOpen != nil {
			qrOptionsFakeOpen = *o.OptionsFakeOpen
		}
		qOptionsFakeOpen := swag.FormatBool(qrOptionsFakeOpen)
		if qOptionsFakeOpen != "" {

			if err := r.SetQueryParam("options.fake_open", qOptionsFakeOpen); err != nil {
				return err
			}
		}
	}

	if o.OptionsFsctlTrim != nil {

		// query param options.fsctl_trim
		var qrOptionsFsctlTrim bool

		if o.OptionsFsctlTrim != nil {
			qrOptionsFsctlTrim = *o.OptionsFsctlTrim
		}
		qOptionsFsctlTrim := swag.FormatBool(qrOptionsFsctlTrim)
		if qOptionsFsctlTrim != "" {

			if err := r.SetQueryParam("options.fsctl_trim", qOptionsFsctlTrim); err != nil {
				return err
			}
		}
	}

	if o.OptionsJunctionReparse != nil {

		// query param options.junction_reparse
		var qrOptionsJunctionReparse bool

		if o.OptionsJunctionReparse != nil {
			qrOptionsJunctionReparse = *o.OptionsJunctionReparse
		}
		qOptionsJunctionReparse := swag.FormatBool(qrOptionsJunctionReparse)
		if qOptionsJunctionReparse != "" {

			if err := r.SetQueryParam("options.junction_reparse", qOptionsJunctionReparse); err != nil {
				return err
			}
		}
	}

	if o.OptionsLargeMtu != nil {

		// query param options.large_mtu
		var qrOptionsLargeMtu bool

		if o.OptionsLargeMtu != nil {
			qrOptionsLargeMtu = *o.OptionsLargeMtu
		}
		qOptionsLargeMtu := swag.FormatBool(qrOptionsLargeMtu)
		if qOptionsLargeMtu != "" {

			if err := r.SetQueryParam("options.large_mtu", qOptionsLargeMtu); err != nil {
				return err
			}
		}
	}

	if o.OptionsMaxConnectionsPerSession != nil {

		// query param options.max_connections_per_session
		var qrOptionsMaxConnectionsPerSession int64

		if o.OptionsMaxConnectionsPerSession != nil {
			qrOptionsMaxConnectionsPerSession = *o.OptionsMaxConnectionsPerSession
		}
		qOptionsMaxConnectionsPerSession := swag.FormatInt64(qrOptionsMaxConnectionsPerSession)
		if qOptionsMaxConnectionsPerSession != "" {

			if err := r.SetQueryParam("options.max_connections_per_session", qOptionsMaxConnectionsPerSession); err != nil {
				return err
			}
		}
	}

	if o.OptionsMaxLifsPerSession != nil {

		// query param options.max_lifs_per_session
		var qrOptionsMaxLifsPerSession int64

		if o.OptionsMaxLifsPerSession != nil {
			qrOptionsMaxLifsPerSession = *o.OptionsMaxLifsPerSession
		}
		qOptionsMaxLifsPerSession := swag.FormatInt64(qrOptionsMaxLifsPerSession)
		if qOptionsMaxLifsPerSession != "" {

			if err := r.SetQueryParam("options.max_lifs_per_session", qOptionsMaxLifsPerSession); err != nil {
				return err
			}
		}
	}

	if o.OptionsMaxOpensSameFilePerTree != nil {

		// query param options.max_opens_same_file_per_tree
		var qrOptionsMaxOpensSameFilePerTree int64

		if o.OptionsMaxOpensSameFilePerTree != nil {
			qrOptionsMaxOpensSameFilePerTree = *o.OptionsMaxOpensSameFilePerTree
		}
		qOptionsMaxOpensSameFilePerTree := swag.FormatInt64(qrOptionsMaxOpensSameFilePerTree)
		if qOptionsMaxOpensSameFilePerTree != "" {

			if err := r.SetQueryParam("options.max_opens_same_file_per_tree", qOptionsMaxOpensSameFilePerTree); err != nil {
				return err
			}
		}
	}

	if o.OptionsMaxSameTreeConnectPerSession != nil {

		// query param options.max_same_tree_connect_per_session
		var qrOptionsMaxSameTreeConnectPerSession int64

		if o.OptionsMaxSameTreeConnectPerSession != nil {
			qrOptionsMaxSameTreeConnectPerSession = *o.OptionsMaxSameTreeConnectPerSession
		}
		qOptionsMaxSameTreeConnectPerSession := swag.FormatInt64(qrOptionsMaxSameTreeConnectPerSession)
		if qOptionsMaxSameTreeConnectPerSession != "" {

			if err := r.SetQueryParam("options.max_same_tree_connect_per_session", qOptionsMaxSameTreeConnectPerSession); err != nil {
				return err
			}
		}
	}

	if o.OptionsMaxSameUserSessionsPerConnection != nil {

		// query param options.max_same_user_sessions_per_connection
		var qrOptionsMaxSameUserSessionsPerConnection int64

		if o.OptionsMaxSameUserSessionsPerConnection != nil {
			qrOptionsMaxSameUserSessionsPerConnection = *o.OptionsMaxSameUserSessionsPerConnection
		}
		qOptionsMaxSameUserSessionsPerConnection := swag.FormatInt64(qrOptionsMaxSameUserSessionsPerConnection)
		if qOptionsMaxSameUserSessionsPerConnection != "" {

			if err := r.SetQueryParam("options.max_same_user_sessions_per_connection", qOptionsMaxSameUserSessionsPerConnection); err != nil {
				return err
			}
		}
	}

	if o.OptionsMaxWatchesSetPerTree != nil {

		// query param options.max_watches_set_per_tree
		var qrOptionsMaxWatchesSetPerTree int64

		if o.OptionsMaxWatchesSetPerTree != nil {
			qrOptionsMaxWatchesSetPerTree = *o.OptionsMaxWatchesSetPerTree
		}
		qOptionsMaxWatchesSetPerTree := swag.FormatInt64(qrOptionsMaxWatchesSetPerTree)
		if qOptionsMaxWatchesSetPerTree != "" {

			if err := r.SetQueryParam("options.max_watches_set_per_tree", qOptionsMaxWatchesSetPerTree); err != nil {
				return err
			}
		}
	}

	if o.OptionsMultichannel != nil {

		// query param options.multichannel
		var qrOptionsMultichannel bool

		if o.OptionsMultichannel != nil {
			qrOptionsMultichannel = *o.OptionsMultichannel
		}
		qOptionsMultichannel := swag.FormatBool(qrOptionsMultichannel)
		if qOptionsMultichannel != "" {

			if err := r.SetQueryParam("options.multichannel", qOptionsMultichannel); err != nil {
				return err
			}
		}
	}

	if o.OptionsNullUserWindowsName != nil {

		// query param options.null_user_windows_name
		var qrOptionsNullUserWindowsName string

		if o.OptionsNullUserWindowsName != nil {
			qrOptionsNullUserWindowsName = *o.OptionsNullUserWindowsName
		}
		qOptionsNullUserWindowsName := qrOptionsNullUserWindowsName
		if qOptionsNullUserWindowsName != "" {

			if err := r.SetQueryParam("options.null_user_windows_name", qOptionsNullUserWindowsName); err != nil {
				return err
			}
		}
	}

	if o.OptionsPathComponentCache != nil {

		// query param options.path_component_cache
		var qrOptionsPathComponentCache bool

		if o.OptionsPathComponentCache != nil {
			qrOptionsPathComponentCache = *o.OptionsPathComponentCache
		}
		qOptionsPathComponentCache := swag.FormatBool(qrOptionsPathComponentCache)
		if qOptionsPathComponentCache != "" {

			if err := r.SetQueryParam("options.path_component_cache", qOptionsPathComponentCache); err != nil {
				return err
			}
		}
	}

	if o.OptionsReferral != nil {

		// query param options.referral
		var qrOptionsReferral bool

		if o.OptionsReferral != nil {
			qrOptionsReferral = *o.OptionsReferral
		}
		qOptionsReferral := swag.FormatBool(qrOptionsReferral)
		if qOptionsReferral != "" {

			if err := r.SetQueryParam("options.referral", qOptionsReferral); err != nil {
				return err
			}
		}
	}

	if o.OptionsShadowcopy != nil {

		// query param options.shadowcopy
		var qrOptionsShadowcopy bool

		if o.OptionsShadowcopy != nil {
			qrOptionsShadowcopy = *o.OptionsShadowcopy
		}
		qOptionsShadowcopy := swag.FormatBool(qrOptionsShadowcopy)
		if qOptionsShadowcopy != "" {

			if err := r.SetQueryParam("options.shadowcopy", qOptionsShadowcopy); err != nil {
				return err
			}
		}
	}

	if o.OptionsShadowcopyDirDepth != nil {

		// query param options.shadowcopy_dir_depth
		var qrOptionsShadowcopyDirDepth int64

		if o.OptionsShadowcopyDirDepth != nil {
			qrOptionsShadowcopyDirDepth = *o.OptionsShadowcopyDirDepth
		}
		qOptionsShadowcopyDirDepth := swag.FormatInt64(qrOptionsShadowcopyDirDepth)
		if qOptionsShadowcopyDirDepth != "" {

			if err := r.SetQueryParam("options.shadowcopy_dir_depth", qOptionsShadowcopyDirDepth); err != nil {
				return err
			}
		}
	}

	if o.OptionsSmbCredits != nil {

		// query param options.smb_credits
		var qrOptionsSmbCredits int64

		if o.OptionsSmbCredits != nil {
			qrOptionsSmbCredits = *o.OptionsSmbCredits
		}
		qOptionsSmbCredits := swag.FormatInt64(qrOptionsSmbCredits)
		if qOptionsSmbCredits != "" {

			if err := r.SetQueryParam("options.smb_credits", qOptionsSmbCredits); err != nil {
				return err
			}
		}
	}

	if o.OptionsTrustedDomainEnumSearchEnabled != nil {

		// query param options.trusted_domain_enum_search_enabled
		var qrOptionsTrustedDomainEnumSearchEnabled bool

		if o.OptionsTrustedDomainEnumSearchEnabled != nil {
			qrOptionsTrustedDomainEnumSearchEnabled = *o.OptionsTrustedDomainEnumSearchEnabled
		}
		qOptionsTrustedDomainEnumSearchEnabled := swag.FormatBool(qrOptionsTrustedDomainEnumSearchEnabled)
		if qOptionsTrustedDomainEnumSearchEnabled != "" {

			if err := r.SetQueryParam("options.trusted_domain_enum_search_enabled", qOptionsTrustedDomainEnumSearchEnabled); err != nil {
				return err
			}
		}
	}

	if o.OptionsWidelinkReparseVersions != nil {

		// query param options.widelink_reparse_versions
		var qrOptionsWidelinkReparseVersions string

		if o.OptionsWidelinkReparseVersions != nil {
			qrOptionsWidelinkReparseVersions = *o.OptionsWidelinkReparseVersions
		}
		qOptionsWidelinkReparseVersions := qrOptionsWidelinkReparseVersions
		if qOptionsWidelinkReparseVersions != "" {

			if err := r.SetQueryParam("options.widelink_reparse_versions", qOptionsWidelinkReparseVersions); err != nil {
				return err
			}
		}
	}

	if o.ProxyHost != nil {

		// query param proxy_host
		var qrProxyHost string

		if o.ProxyHost != nil {
			qrProxyHost = *o.ProxyHost
		}
		qProxyHost := qrProxyHost
		if qProxyHost != "" {

			if err := r.SetQueryParam("proxy_host", qProxyHost); err != nil {
				return err
			}
		}
	}

	if o.ProxyPort != nil {

		// query param proxy_port
		var qrProxyPort int64

		if o.ProxyPort != nil {
			qrProxyPort = *o.ProxyPort
		}
		qProxyPort := swag.FormatInt64(qrProxyPort)
		if qProxyPort != "" {

			if err := r.SetQueryParam("proxy_port", qProxyPort); err != nil {
				return err
			}
		}
	}

	if o.ProxyType != nil {

		// query param proxy_type
		var qrProxyType string

		if o.ProxyType != nil {
			qrProxyType = *o.ProxyType
		}
		qProxyType := qrProxyType
		if qProxyType != "" {

			if err := r.SetQueryParam("proxy_type", qProxyType); err != nil {
				return err
			}
		}
	}

	if o.ProxyUsername != nil {

		// query param proxy_username
		var qrProxyUsername string

		if o.ProxyUsername != nil {
			qrProxyUsername = *o.ProxyUsername
		}
		qProxyUsername := qrProxyUsername
		if qProxyUsername != "" {

			if err := r.SetQueryParam("proxy_username", qProxyUsername); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SecurityAdvertisedKdcEncryptions != nil {

		// query param security.advertised_kdc_encryptions
		var qrSecurityAdvertisedKdcEncryptions string

		if o.SecurityAdvertisedKdcEncryptions != nil {
			qrSecurityAdvertisedKdcEncryptions = *o.SecurityAdvertisedKdcEncryptions
		}
		qSecurityAdvertisedKdcEncryptions := qrSecurityAdvertisedKdcEncryptions
		if qSecurityAdvertisedKdcEncryptions != "" {

			if err := r.SetQueryParam("security.advertised_kdc_encryptions", qSecurityAdvertisedKdcEncryptions); err != nil {
				return err
			}
		}
	}

	if o.SecurityAesNetlogonEnabled != nil {

		// query param security.aes_netlogon_enabled
		var qrSecurityAesNetlogonEnabled bool

		if o.SecurityAesNetlogonEnabled != nil {
			qrSecurityAesNetlogonEnabled = *o.SecurityAesNetlogonEnabled
		}
		qSecurityAesNetlogonEnabled := swag.FormatBool(qrSecurityAesNetlogonEnabled)
		if qSecurityAesNetlogonEnabled != "" {

			if err := r.SetQueryParam("security.aes_netlogon_enabled", qSecurityAesNetlogonEnabled); err != nil {
				return err
			}
		}
	}

	if o.SecurityEncryptDcConnection != nil {

		// query param security.encrypt_dc_connection
		var qrSecurityEncryptDcConnection bool

		if o.SecurityEncryptDcConnection != nil {
			qrSecurityEncryptDcConnection = *o.SecurityEncryptDcConnection
		}
		qSecurityEncryptDcConnection := swag.FormatBool(qrSecurityEncryptDcConnection)
		if qSecurityEncryptDcConnection != "" {

			if err := r.SetQueryParam("security.encrypt_dc_connection", qSecurityEncryptDcConnection); err != nil {
				return err
			}
		}
	}

	if o.SecurityKdcEncryption != nil {

		// query param security.kdc_encryption
		var qrSecurityKdcEncryption bool

		if o.SecurityKdcEncryption != nil {
			qrSecurityKdcEncryption = *o.SecurityKdcEncryption
		}
		qSecurityKdcEncryption := swag.FormatBool(qrSecurityKdcEncryption)
		if qSecurityKdcEncryption != "" {

			if err := r.SetQueryParam("security.kdc_encryption", qSecurityKdcEncryption); err != nil {
				return err
			}
		}
	}

	if o.SecurityLdapReferralEnabled != nil {

		// query param security.ldap_referral_enabled
		var qrSecurityLdapReferralEnabled bool

		if o.SecurityLdapReferralEnabled != nil {
			qrSecurityLdapReferralEnabled = *o.SecurityLdapReferralEnabled
		}
		qSecurityLdapReferralEnabled := swag.FormatBool(qrSecurityLdapReferralEnabled)
		if qSecurityLdapReferralEnabled != "" {

			if err := r.SetQueryParam("security.ldap_referral_enabled", qSecurityLdapReferralEnabled); err != nil {
				return err
			}
		}
	}

	if o.SecurityLmCompatibilityLevel != nil {

		// query param security.lm_compatibility_level
		var qrSecurityLmCompatibilityLevel string

		if o.SecurityLmCompatibilityLevel != nil {
			qrSecurityLmCompatibilityLevel = *o.SecurityLmCompatibilityLevel
		}
		qSecurityLmCompatibilityLevel := qrSecurityLmCompatibilityLevel
		if qSecurityLmCompatibilityLevel != "" {

			if err := r.SetQueryParam("security.lm_compatibility_level", qSecurityLmCompatibilityLevel); err != nil {
				return err
			}
		}
	}

	if o.SecurityRestrictAnonymous != nil {

		// query param security.restrict_anonymous
		var qrSecurityRestrictAnonymous string

		if o.SecurityRestrictAnonymous != nil {
			qrSecurityRestrictAnonymous = *o.SecurityRestrictAnonymous
		}
		qSecurityRestrictAnonymous := qrSecurityRestrictAnonymous
		if qSecurityRestrictAnonymous != "" {

			if err := r.SetQueryParam("security.restrict_anonymous", qSecurityRestrictAnonymous); err != nil {
				return err
			}
		}
	}

	if o.SecuritySessionSecurity != nil {

		// query param security.session_security
		var qrSecuritySessionSecurity string

		if o.SecuritySessionSecurity != nil {
			qrSecuritySessionSecurity = *o.SecuritySessionSecurity
		}
		qSecuritySessionSecurity := qrSecuritySessionSecurity
		if qSecuritySessionSecurity != "" {

			if err := r.SetQueryParam("security.session_security", qSecuritySessionSecurity); err != nil {
				return err
			}
		}
	}

	if o.SecuritySmbEncryption != nil {

		// query param security.smb_encryption
		var qrSecuritySmbEncryption bool

		if o.SecuritySmbEncryption != nil {
			qrSecuritySmbEncryption = *o.SecuritySmbEncryption
		}
		qSecuritySmbEncryption := swag.FormatBool(qrSecuritySmbEncryption)
		if qSecuritySmbEncryption != "" {

			if err := r.SetQueryParam("security.smb_encryption", qSecuritySmbEncryption); err != nil {
				return err
			}
		}
	}

	if o.SecuritySmbSigning != nil {

		// query param security.smb_signing
		var qrSecuritySmbSigning bool

		if o.SecuritySmbSigning != nil {
			qrSecuritySmbSigning = *o.SecuritySmbSigning
		}
		qSecuritySmbSigning := swag.FormatBool(qrSecuritySmbSigning)
		if qSecuritySmbSigning != "" {

			if err := r.SetQueryParam("security.smb_signing", qSecuritySmbSigning); err != nil {
				return err
			}
		}
	}

	if o.SecurityTryLdapChannelBinding != nil {

		// query param security.try_ldap_channel_binding
		var qrSecurityTryLdapChannelBinding bool

		if o.SecurityTryLdapChannelBinding != nil {
			qrSecurityTryLdapChannelBinding = *o.SecurityTryLdapChannelBinding
		}
		qSecurityTryLdapChannelBinding := swag.FormatBool(qrSecurityTryLdapChannelBinding)
		if qSecurityTryLdapChannelBinding != "" {

			if err := r.SetQueryParam("security.try_ldap_channel_binding", qSecurityTryLdapChannelBinding); err != nil {
				return err
			}
		}
	}

	if o.SecurityUseLdaps != nil {

		// query param security.use_ldaps
		var qrSecurityUseLdaps bool

		if o.SecurityUseLdaps != nil {
			qrSecurityUseLdaps = *o.SecurityUseLdaps
		}
		qSecurityUseLdaps := swag.FormatBool(qrSecurityUseLdaps)
		if qSecurityUseLdaps != "" {

			if err := r.SetQueryParam("security.use_ldaps", qSecurityUseLdaps); err != nil {
				return err
			}
		}
	}

	if o.SecurityUseStartTLS != nil {

		// query param security.use_start_tls
		var qrSecurityUseStartTLS bool

		if o.SecurityUseStartTLS != nil {
			qrSecurityUseStartTLS = *o.SecurityUseStartTLS
		}
		qSecurityUseStartTLS := swag.FormatBool(qrSecurityUseStartTLS)
		if qSecurityUseStartTLS != "" {

			if err := r.SetQueryParam("security.use_start_tls", qSecurityUseStartTLS); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawOther != nil {

		// query param statistics.iops_raw.other
		var qrStatisticsIopsRawOther int64

		if o.StatisticsIopsRawOther != nil {
			qrStatisticsIopsRawOther = *o.StatisticsIopsRawOther
		}
		qStatisticsIopsRawOther := swag.FormatInt64(qrStatisticsIopsRawOther)
		if qStatisticsIopsRawOther != "" {

			if err := r.SetQueryParam("statistics.iops_raw.other", qStatisticsIopsRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawRead != nil {

		// query param statistics.iops_raw.read
		var qrStatisticsIopsRawRead int64

		if o.StatisticsIopsRawRead != nil {
			qrStatisticsIopsRawRead = *o.StatisticsIopsRawRead
		}
		qStatisticsIopsRawRead := swag.FormatInt64(qrStatisticsIopsRawRead)
		if qStatisticsIopsRawRead != "" {

			if err := r.SetQueryParam("statistics.iops_raw.read", qStatisticsIopsRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawTotal != nil {

		// query param statistics.iops_raw.total
		var qrStatisticsIopsRawTotal int64

		if o.StatisticsIopsRawTotal != nil {
			qrStatisticsIopsRawTotal = *o.StatisticsIopsRawTotal
		}
		qStatisticsIopsRawTotal := swag.FormatInt64(qrStatisticsIopsRawTotal)
		if qStatisticsIopsRawTotal != "" {

			if err := r.SetQueryParam("statistics.iops_raw.total", qStatisticsIopsRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawWrite != nil {

		// query param statistics.iops_raw.write
		var qrStatisticsIopsRawWrite int64

		if o.StatisticsIopsRawWrite != nil {
			qrStatisticsIopsRawWrite = *o.StatisticsIopsRawWrite
		}
		qStatisticsIopsRawWrite := swag.FormatInt64(qrStatisticsIopsRawWrite)
		if qStatisticsIopsRawWrite != "" {

			if err := r.SetQueryParam("statistics.iops_raw.write", qStatisticsIopsRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawOther != nil {

		// query param statistics.latency_raw.other
		var qrStatisticsLatencyRawOther int64

		if o.StatisticsLatencyRawOther != nil {
			qrStatisticsLatencyRawOther = *o.StatisticsLatencyRawOther
		}
		qStatisticsLatencyRawOther := swag.FormatInt64(qrStatisticsLatencyRawOther)
		if qStatisticsLatencyRawOther != "" {

			if err := r.SetQueryParam("statistics.latency_raw.other", qStatisticsLatencyRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawRead != nil {

		// query param statistics.latency_raw.read
		var qrStatisticsLatencyRawRead int64

		if o.StatisticsLatencyRawRead != nil {
			qrStatisticsLatencyRawRead = *o.StatisticsLatencyRawRead
		}
		qStatisticsLatencyRawRead := swag.FormatInt64(qrStatisticsLatencyRawRead)
		if qStatisticsLatencyRawRead != "" {

			if err := r.SetQueryParam("statistics.latency_raw.read", qStatisticsLatencyRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawTotal != nil {

		// query param statistics.latency_raw.total
		var qrStatisticsLatencyRawTotal int64

		if o.StatisticsLatencyRawTotal != nil {
			qrStatisticsLatencyRawTotal = *o.StatisticsLatencyRawTotal
		}
		qStatisticsLatencyRawTotal := swag.FormatInt64(qrStatisticsLatencyRawTotal)
		if qStatisticsLatencyRawTotal != "" {

			if err := r.SetQueryParam("statistics.latency_raw.total", qStatisticsLatencyRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawWrite != nil {

		// query param statistics.latency_raw.write
		var qrStatisticsLatencyRawWrite int64

		if o.StatisticsLatencyRawWrite != nil {
			qrStatisticsLatencyRawWrite = *o.StatisticsLatencyRawWrite
		}
		qStatisticsLatencyRawWrite := swag.FormatInt64(qrStatisticsLatencyRawWrite)
		if qStatisticsLatencyRawWrite != "" {

			if err := r.SetQueryParam("statistics.latency_raw.write", qStatisticsLatencyRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsStatus != nil {

		// query param statistics.status
		var qrStatisticsStatus string

		if o.StatisticsStatus != nil {
			qrStatisticsStatus = *o.StatisticsStatus
		}
		qStatisticsStatus := qrStatisticsStatus
		if qStatisticsStatus != "" {

			if err := r.SetQueryParam("statistics.status", qStatisticsStatus); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawRead != nil {

		// query param statistics.throughput_raw.read
		var qrStatisticsThroughputRawRead int64

		if o.StatisticsThroughputRawRead != nil {
			qrStatisticsThroughputRawRead = *o.StatisticsThroughputRawRead
		}
		qStatisticsThroughputRawRead := swag.FormatInt64(qrStatisticsThroughputRawRead)
		if qStatisticsThroughputRawRead != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.read", qStatisticsThroughputRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawTotal != nil {

		// query param statistics.throughput_raw.total
		var qrStatisticsThroughputRawTotal int64

		if o.StatisticsThroughputRawTotal != nil {
			qrStatisticsThroughputRawTotal = *o.StatisticsThroughputRawTotal
		}
		qStatisticsThroughputRawTotal := swag.FormatInt64(qrStatisticsThroughputRawTotal)
		if qStatisticsThroughputRawTotal != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.total", qStatisticsThroughputRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawWrite != nil {

		// query param statistics.throughput_raw.write
		var qrStatisticsThroughputRawWrite int64

		if o.StatisticsThroughputRawWrite != nil {
			qrStatisticsThroughputRawWrite = *o.StatisticsThroughputRawWrite
		}
		qStatisticsThroughputRawWrite := swag.FormatInt64(qrStatisticsThroughputRawWrite)
		if qStatisticsThroughputRawWrite != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.write", qStatisticsThroughputRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsTimestamp != nil {

		// query param statistics.timestamp
		var qrStatisticsTimestamp string

		if o.StatisticsTimestamp != nil {
			qrStatisticsTimestamp = *o.StatisticsTimestamp
		}
		qStatisticsTimestamp := qrStatisticsTimestamp
		if qStatisticsTimestamp != "" {

			if err := r.SetQueryParam("statistics.timestamp", qStatisticsTimestamp); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.TenantID != nil {

		// query param tenant_id
		var qrTenantID string

		if o.TenantID != nil {
			qrTenantID = *o.TenantID
		}
		qTenantID := qrTenantID
		if qTenantID != "" {

			if err := r.SetQueryParam("tenant_id", qTenantID); err != nil {
				return err
			}
		}
	}

	if o.Timeout != nil {

		// query param timeout
		var qrTimeout int64

		if o.Timeout != nil {
			qrTimeout = *o.Timeout
		}
		qTimeout := swag.FormatInt64(qrTimeout)
		if qTimeout != "" {

			if err := r.SetQueryParam("timeout", qTimeout); err != nil {
				return err
			}
		}
	}

	if o.VerifyHost != nil {

		// query param verify_host
		var qrVerifyHost bool

		if o.VerifyHost != nil {
			qrVerifyHost = *o.VerifyHost
		}
		qVerifyHost := swag.FormatBool(qrVerifyHost)
		if qVerifyHost != "" {

			if err := r.SetQueryParam("verify_host", qVerifyHost); err != nil {
				return err
			}
		}
	}

	if o.Workgroup != nil {

		// query param workgroup
		var qrWorkgroup string

		if o.Workgroup != nil {
			qrWorkgroup = *o.Workgroup
		}
		qWorkgroup := qrWorkgroup
		if qWorkgroup != "" {

			if err := r.SetQueryParam("workgroup", qWorkgroup); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
