// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CifsServiceModifyCollectionReader is a Reader for the CifsServiceModifyCollection structure.
type CifsServiceModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CifsServiceModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCifsServiceModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewCifsServiceModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCifsServiceModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCifsServiceModifyCollectionOK creates a CifsServiceModifyCollectionOK with default headers values
func NewCifsServiceModifyCollectionOK() *CifsServiceModifyCollectionOK {
	return &CifsServiceModifyCollectionOK{}
}

/*
CifsServiceModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type CifsServiceModifyCollectionOK struct {
	Payload *models.CifsServiceJobLinkResponse
}

// IsSuccess returns true when this cifs service modify collection o k response has a 2xx status code
func (o *CifsServiceModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cifs service modify collection o k response has a 3xx status code
func (o *CifsServiceModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cifs service modify collection o k response has a 4xx status code
func (o *CifsServiceModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cifs service modify collection o k response has a 5xx status code
func (o *CifsServiceModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cifs service modify collection o k response a status code equal to that given
func (o *CifsServiceModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cifs service modify collection o k response
func (o *CifsServiceModifyCollectionOK) Code() int {
	return 200
}

func (o *CifsServiceModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/services][%d] cifsServiceModifyCollectionOK %s", 200, payload)
}

func (o *CifsServiceModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/services][%d] cifsServiceModifyCollectionOK %s", 200, payload)
}

func (o *CifsServiceModifyCollectionOK) GetPayload() *models.CifsServiceJobLinkResponse {
	return o.Payload
}

func (o *CifsServiceModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CifsServiceJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCifsServiceModifyCollectionAccepted creates a CifsServiceModifyCollectionAccepted with default headers values
func NewCifsServiceModifyCollectionAccepted() *CifsServiceModifyCollectionAccepted {
	return &CifsServiceModifyCollectionAccepted{}
}

/*
CifsServiceModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type CifsServiceModifyCollectionAccepted struct {
	Payload *models.CifsServiceJobLinkResponse
}

// IsSuccess returns true when this cifs service modify collection accepted response has a 2xx status code
func (o *CifsServiceModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cifs service modify collection accepted response has a 3xx status code
func (o *CifsServiceModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cifs service modify collection accepted response has a 4xx status code
func (o *CifsServiceModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this cifs service modify collection accepted response has a 5xx status code
func (o *CifsServiceModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this cifs service modify collection accepted response a status code equal to that given
func (o *CifsServiceModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the cifs service modify collection accepted response
func (o *CifsServiceModifyCollectionAccepted) Code() int {
	return 202
}

func (o *CifsServiceModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/services][%d] cifsServiceModifyCollectionAccepted %s", 202, payload)
}

func (o *CifsServiceModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/services][%d] cifsServiceModifyCollectionAccepted %s", 202, payload)
}

func (o *CifsServiceModifyCollectionAccepted) GetPayload() *models.CifsServiceJobLinkResponse {
	return o.Payload
}

func (o *CifsServiceModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CifsServiceJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCifsServiceModifyCollectionDefault creates a CifsServiceModifyCollectionDefault with default headers values
func NewCifsServiceModifyCollectionDefault(code int) *CifsServiceModifyCollectionDefault {
	return &CifsServiceModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	CifsServiceModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 3735751    | Failed to authenticate and retrieve the access token from the Azure OAuth host. |
| 3735752    | Failed to extract the private key from the Azure Key Vault certificate. |
| 3735753    | Unsupported content_type in the Azure secrets response. |
| 3735754    | Failed to parse the JSON response from Azure Key Vault. |
| 3735755    | REST API call to Azure failed. |
| 3735756    | Invalid client certificate. |
| 3735757    | Failed to generate client assertion. |
| 3735762    | The provided Azure Key Vault configuration is incorrect. |
| 3735763    | The provided Azure Key Vault configuration is incomplete. |
| 3735764    | Request to Azure failed. Reason - Azure error code and Azure error message. |
| 655390     | Failed to modify the CIFS server. Failure can occur due to multiple reasons. For example: STARTTLS and LDAPS cannot be used together or the group policy is already enabled for the SVM. |
| 655562     | NetBIOS name is longer than 15 characters. |
| 655538     | Unable to modify the CIFS server. The server name is already used by another SVM.|
| 655563     | NetBIOS name contains characters that are not allowed. |
| 655771     | The number of NetBIOS aliases cannot exceed the maximum supported number of '200'. |
| 655923     | Retrieving credentials from AKV is not supported because the effective cluster version is not ONTAP 9.15.0 or later. |
| 656473     | Fields security.kdc_encryption and security.advertised_kdc_encryptions are mutually exclusive. Specify only one of the two.|
*/
type CifsServiceModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cifs service modify collection default response has a 2xx status code
func (o *CifsServiceModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cifs service modify collection default response has a 3xx status code
func (o *CifsServiceModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cifs service modify collection default response has a 4xx status code
func (o *CifsServiceModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cifs service modify collection default response has a 5xx status code
func (o *CifsServiceModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cifs service modify collection default response a status code equal to that given
func (o *CifsServiceModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cifs service modify collection default response
func (o *CifsServiceModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *CifsServiceModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/services][%d] cifs_service_modify_collection default %s", o._statusCode, payload)
}

func (o *CifsServiceModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/services][%d] cifs_service_modify_collection default %s", o._statusCode, payload)
}

func (o *CifsServiceModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CifsServiceModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CifsServiceModifyCollectionBody cifs service modify collection body
swagger:model CifsServiceModifyCollectionBody
*/
type CifsServiceModifyCollectionBody struct {

	// links
	Links *models.CifsServiceInlineLinks `json:"_links,omitempty"`

	// ad domain
	AdDomain *models.AdDomain `json:"ad_domain,omitempty"`

	// Authentication type.
	// Example: domain
	// Read Only: true
	// Enum: ["domain","workgroup"]
	AuthStyle *string `json:"auth-style,omitempty"`

	// Specifies the type of user who can access the SMB Volume. The default is domain_user. In the case of a hybrid-user, ONTAP won't contact on-premise ADDS.
	//
	// Enum: ["domain_user","hybrid_user"]
	AuthUserType *string `json:"auth_user_type,omitempty"`

	// Specifies the authentication method.
	// The available values are:
	//   * client_secret
	//   * certificate
	//
	// Enum: ["client_secret","certificate"]
	AuthenticationMethod *string `json:"authentication_method,omitempty"`

	// cifs service response inline records
	CifsServiceResponseInlineRecords []*models.CifsService `json:"records,omitempty"`

	// PKCS12 certificate used by the application to prove its identity to AKV.
	// Example: PEM Cert
	// Format: password
	ClientCertificate *strfmt.Password `json:"client_certificate,omitempty"`

	// Application client ID of the deployed Azure application with appropriate access to an AKV or EntraId.
	// Example: e959d1b5-5a63-4284-9268-851e30e3eceb
	ClientID *string `json:"client_id,omitempty"`

	// Secret used by the application to prove its identity to AKV.
	// Example: _8E8Q~Qu866jtihUE3ia4Q5Y5IDEVC6UfskbZa6X
	// Format: password
	ClientSecret *strfmt.Password `json:"client_secret,omitempty"`

	// A descriptive text comment for the CIFS server. SMB clients can see the CIFS server comment when browsing servers on the network. If there is a space in the comment, you must enclose the entire string in quotation marks.
	// Example: This CIFS Server Belongs to CS Department
	// Max Length: 256
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Specifies the UNIX user to which any authenticated CIFS user is mapped to, if the normal user mapping rules fails.
	DefaultUnixUser *string `json:"default_unix_user,omitempty"`

	// Specifies if the CIFS service is administratively enabled.
	//
	Enabled *bool `json:"enabled,omitempty"`

	// If set to true, group policies will be applied to the SVM.
	GroupPolicyObjectEnabled *bool `json:"group_policy_object_enabled,omitempty"`

	// URI of the deployed AKV that is used by ONTAP for storing keys.
	// Example: https://kmip-akv-keyvault.vault.azure.net/
	// Format: uri
	KeyVaultURI *strfmt.URI `json:"key_vault_uri,omitempty"`

	// metric
	Metric *models.CifsServiceInlineMetric `json:"metric,omitempty"`

	// The name of the CIFS server.
	// Example: CIFS1
	// Max Length: 15
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// netbios
	Netbios *models.CifsNetbios `json:"netbios,omitempty"`

	// Open authorization server host name.
	// Example: login.microsoftonline.com
	OauthHost *string `json:"oauth_host,omitempty"`

	// options
	Options *models.CifsServiceOptions `json:"options,omitempty"`

	// Proxy host.
	// Example: proxy.eng.com
	ProxyHost *string `json:"proxy_host,omitempty"`

	// Proxy password. Password is not audited.
	// Example: proxypassword
	ProxyPassword *string `json:"proxy_password,omitempty"`

	// Proxy port.
	// Example: 1234
	ProxyPort *int64 `json:"proxy_port,omitempty"`

	// Proxy type.
	// Enum: ["http","https"]
	ProxyType *string `json:"proxy_type,omitempty"`

	// Proxy username.
	// Example: proxyuser
	ProxyUsername *string `json:"proxy_username,omitempty"`

	// security
	Security *models.CifsServiceSecurity `json:"security,omitempty"`

	// statistics
	Statistics *models.CifsServiceInlineStatistics `json:"statistics,omitempty"`

	// svm
	Svm *models.CifsServiceInlineSvm `json:"svm,omitempty"`

	// Directory (tenant) ID of the deployed Azure application with appropriate access to an AKV or EntraId.
	// Example: c9f32fcb-4ab7-40fe-af1b-1850d46cfbbe
	TenantID *string `json:"tenant_id,omitempty"`

	// AKV connection timeout, in seconds. The allowed range is between 0 to 30 seconds.
	// Example: 25
	Timeout *int64 `json:"timeout,omitempty"`

	// Verify the identity of the AKV host name. By default, verify_host is set to true.
	VerifyHost *bool `json:"verify_host,omitempty"`

	// The workgroup name.
	// Example: workgrp1
	// Max Length: 15
	// Min Length: 1
	Workgroup *string `json:"workgroup,omitempty"`
}

// Validate validates this cifs service modify collection body
func (o *CifsServiceModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAdDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAuthStyle(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAuthUserType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAuthenticationMethod(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCifsServiceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateClientCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateClientSecret(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateKeyVaultURI(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNetbios(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProxyType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecurity(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateWorkgroup(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsServiceModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) validateAdDomain(formats strfmt.Registry) error {
	if swag.IsZero(o.AdDomain) { // not required
		return nil
	}

	if o.AdDomain != nil {
		if err := o.AdDomain.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ad_domain")
			}
			return err
		}
	}

	return nil
}

var cifsServiceModifyCollectionBodyTypeAuthStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["domain","workgroup"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsServiceModifyCollectionBodyTypeAuthStylePropEnum = append(cifsServiceModifyCollectionBodyTypeAuthStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// CifsServiceModifyCollectionBody
	// CifsServiceModifyCollectionBody
	// auth-style
	// AuthStyle
	// domain
	// END DEBUGGING
	// CifsServiceModifyCollectionBodyAuthStyleDomain captures enum value "domain"
	CifsServiceModifyCollectionBodyAuthStyleDomain string = "domain"

	// BEGIN DEBUGGING
	// CifsServiceModifyCollectionBody
	// CifsServiceModifyCollectionBody
	// auth-style
	// AuthStyle
	// workgroup
	// END DEBUGGING
	// CifsServiceModifyCollectionBodyAuthStyleWorkgroup captures enum value "workgroup"
	CifsServiceModifyCollectionBodyAuthStyleWorkgroup string = "workgroup"
)

// prop value enum
func (o *CifsServiceModifyCollectionBody) validateAuthStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsServiceModifyCollectionBodyTypeAuthStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CifsServiceModifyCollectionBody) validateAuthStyle(formats strfmt.Registry) error {
	if swag.IsZero(o.AuthStyle) { // not required
		return nil
	}

	// value enum
	if err := o.validateAuthStyleEnum("info"+"."+"auth-style", "body", *o.AuthStyle); err != nil {
		return err
	}

	return nil
}

var cifsServiceModifyCollectionBodyTypeAuthUserTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["domain_user","hybrid_user"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsServiceModifyCollectionBodyTypeAuthUserTypePropEnum = append(cifsServiceModifyCollectionBodyTypeAuthUserTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// CifsServiceModifyCollectionBody
	// CifsServiceModifyCollectionBody
	// auth_user_type
	// AuthUserType
	// domain_user
	// END DEBUGGING
	// CifsServiceModifyCollectionBodyAuthUserTypeDomainUser captures enum value "domain_user"
	CifsServiceModifyCollectionBodyAuthUserTypeDomainUser string = "domain_user"

	// BEGIN DEBUGGING
	// CifsServiceModifyCollectionBody
	// CifsServiceModifyCollectionBody
	// auth_user_type
	// AuthUserType
	// hybrid_user
	// END DEBUGGING
	// CifsServiceModifyCollectionBodyAuthUserTypeHybridUser captures enum value "hybrid_user"
	CifsServiceModifyCollectionBodyAuthUserTypeHybridUser string = "hybrid_user"
)

// prop value enum
func (o *CifsServiceModifyCollectionBody) validateAuthUserTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsServiceModifyCollectionBodyTypeAuthUserTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CifsServiceModifyCollectionBody) validateAuthUserType(formats strfmt.Registry) error {
	if swag.IsZero(o.AuthUserType) { // not required
		return nil
	}

	// value enum
	if err := o.validateAuthUserTypeEnum("info"+"."+"auth_user_type", "body", *o.AuthUserType); err != nil {
		return err
	}

	return nil
}

var cifsServiceModifyCollectionBodyTypeAuthenticationMethodPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["client_secret","certificate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsServiceModifyCollectionBodyTypeAuthenticationMethodPropEnum = append(cifsServiceModifyCollectionBodyTypeAuthenticationMethodPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// CifsServiceModifyCollectionBody
	// CifsServiceModifyCollectionBody
	// authentication_method
	// AuthenticationMethod
	// client_secret
	// END DEBUGGING
	// CifsServiceModifyCollectionBodyAuthenticationMethodClientSecret captures enum value "client_secret"
	CifsServiceModifyCollectionBodyAuthenticationMethodClientSecret string = "client_secret"

	// BEGIN DEBUGGING
	// CifsServiceModifyCollectionBody
	// CifsServiceModifyCollectionBody
	// authentication_method
	// AuthenticationMethod
	// certificate
	// END DEBUGGING
	// CifsServiceModifyCollectionBodyAuthenticationMethodCertificate captures enum value "certificate"
	CifsServiceModifyCollectionBodyAuthenticationMethodCertificate string = "certificate"
)

// prop value enum
func (o *CifsServiceModifyCollectionBody) validateAuthenticationMethodEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsServiceModifyCollectionBodyTypeAuthenticationMethodPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CifsServiceModifyCollectionBody) validateAuthenticationMethod(formats strfmt.Registry) error {
	if swag.IsZero(o.AuthenticationMethod) { // not required
		return nil
	}

	// value enum
	if err := o.validateAuthenticationMethodEnum("info"+"."+"authentication_method", "body", *o.AuthenticationMethod); err != nil {
		return err
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) validateCifsServiceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.CifsServiceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.CifsServiceResponseInlineRecords); i++ {
		if swag.IsZero(o.CifsServiceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.CifsServiceResponseInlineRecords[i] != nil {
			if err := o.CifsServiceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) validateClientCertificate(formats strfmt.Registry) error {
	if swag.IsZero(o.ClientCertificate) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"client_certificate", "body", "password", o.ClientCertificate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) validateClientSecret(formats strfmt.Registry) error {
	if swag.IsZero(o.ClientSecret) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"client_secret", "body", "password", o.ClientSecret.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"comment", "body", *o.Comment, 256); err != nil {
		return err
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) validateKeyVaultURI(formats strfmt.Registry) error {
	if swag.IsZero(o.KeyVaultURI) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"key_vault_uri", "body", "uri", o.KeyVaultURI.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(o.Metric) { // not required
		return nil
	}

	if o.Metric != nil {
		if err := o.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 15); err != nil {
		return err
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) validateNetbios(formats strfmt.Registry) error {
	if swag.IsZero(o.Netbios) { // not required
		return nil
	}

	if o.Netbios != nil {
		if err := o.Netbios.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "netbios")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) validateOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.Options) { // not required
		return nil
	}

	if o.Options != nil {
		if err := o.Options.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "options")
			}
			return err
		}
	}

	return nil
}

var cifsServiceModifyCollectionBodyTypeProxyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["http","https"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsServiceModifyCollectionBodyTypeProxyTypePropEnum = append(cifsServiceModifyCollectionBodyTypeProxyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// CifsServiceModifyCollectionBody
	// CifsServiceModifyCollectionBody
	// proxy_type
	// ProxyType
	// http
	// END DEBUGGING
	// CifsServiceModifyCollectionBodyProxyTypeHTTP captures enum value "http"
	CifsServiceModifyCollectionBodyProxyTypeHTTP string = "http"

	// BEGIN DEBUGGING
	// CifsServiceModifyCollectionBody
	// CifsServiceModifyCollectionBody
	// proxy_type
	// ProxyType
	// https
	// END DEBUGGING
	// CifsServiceModifyCollectionBodyProxyTypeHTTPS captures enum value "https"
	CifsServiceModifyCollectionBodyProxyTypeHTTPS string = "https"
)

// prop value enum
func (o *CifsServiceModifyCollectionBody) validateProxyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsServiceModifyCollectionBodyTypeProxyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CifsServiceModifyCollectionBody) validateProxyType(formats strfmt.Registry) error {
	if swag.IsZero(o.ProxyType) { // not required
		return nil
	}

	// value enum
	if err := o.validateProxyTypeEnum("info"+"."+"proxy_type", "body", *o.ProxyType); err != nil {
		return err
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) validateSecurity(formats strfmt.Registry) error {
	if swag.IsZero(o.Security) { // not required
		return nil
	}

	if o.Security != nil {
		if err := o.Security.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "security")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(o.Statistics) { // not required
		return nil
	}

	if o.Statistics != nil {
		if err := o.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) validateWorkgroup(formats strfmt.Registry) error {
	if swag.IsZero(o.Workgroup) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"workgroup", "body", *o.Workgroup, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"workgroup", "body", *o.Workgroup, 15); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cifs service modify collection body based on the context it is used
func (o *CifsServiceModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAdDomain(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAuthStyle(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCifsServiceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNetbios(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSecurity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsServiceModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) contextValidateAdDomain(ctx context.Context, formats strfmt.Registry) error {

	if o.AdDomain != nil {
		if err := o.AdDomain.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ad_domain")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) contextValidateAuthStyle(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"auth-style", "body", o.AuthStyle); err != nil {
		return err
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) contextValidateCifsServiceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.CifsServiceResponseInlineRecords); i++ {

		if o.CifsServiceResponseInlineRecords[i] != nil {
			if err := o.CifsServiceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if o.Metric != nil {
		if err := o.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) contextValidateNetbios(ctx context.Context, formats strfmt.Registry) error {

	if o.Netbios != nil {
		if err := o.Netbios.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "netbios")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) contextValidateOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.Options != nil {
		if err := o.Options.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "options")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) contextValidateSecurity(ctx context.Context, formats strfmt.Registry) error {

	if o.Security != nil {
		if err := o.Security.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "security")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if o.Statistics != nil {
		if err := o.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsServiceModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsServiceModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res CifsServiceModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsServiceInlineLinks cifs service inline links
swagger:model cifs_service_inline__links
*/
type CifsServiceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cifs service inline links
func (o *CifsServiceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsServiceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs service inline links based on the context it is used
func (o *CifsServiceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsServiceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsServiceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsServiceInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsServiceInlineMetric Performance numbers, such as IOPS latency and throughput, for SVM protocols.
swagger:model cifs_service_inline_metric
*/
type CifsServiceInlineMetric struct {

	// links
	Links *models.CifsServiceInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *models.CifsServiceInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *models.CifsServiceInlineMetricInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *models.CifsServiceInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this cifs service inline metric
func (o *CifsServiceInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsServiceInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var cifsServiceInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsServiceInlineMetricTypeDurationPropEnum = append(cifsServiceInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// CifsServiceInlineMetricDurationPT15S captures enum value "PT15S"
	CifsServiceInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// CifsServiceInlineMetricDurationPT4M captures enum value "PT4M"
	CifsServiceInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// CifsServiceInlineMetricDurationPT30M captures enum value "PT30M"
	CifsServiceInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// CifsServiceInlineMetricDurationPT2H captures enum value "PT2H"
	CifsServiceInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// CifsServiceInlineMetricDurationP1D captures enum value "P1D"
	CifsServiceInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// CifsServiceInlineMetricDurationPT5M captures enum value "PT5M"
	CifsServiceInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (o *CifsServiceInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsServiceInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CifsServiceInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(o.Duration) { // not required
		return nil
	}

	// value enum
	if err := o.validateDurationEnum("info"+"."+"metric"+"."+"duration", "body", *o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *CifsServiceInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(o.Iops) { // not required
		return nil
	}

	if o.Iops != nil {
		if err := o.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(o.Latency) { // not required
		return nil
	}

	if o.Latency != nil {
		if err := o.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var cifsServiceInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsServiceInlineMetricTypeStatusPropEnum = append(cifsServiceInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// CifsServiceInlineMetricStatusOk captures enum value "ok"
	CifsServiceInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// CifsServiceInlineMetricStatusError captures enum value "error"
	CifsServiceInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// CifsServiceInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	CifsServiceInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// CifsServiceInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	CifsServiceInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// CifsServiceInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	CifsServiceInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// CifsServiceInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	CifsServiceInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// CifsServiceInlineMetricStatusNotFound captures enum value "not_found"
	CifsServiceInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// CifsServiceInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	CifsServiceInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// CifsServiceInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	CifsServiceInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// CifsServiceInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	CifsServiceInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// CifsServiceInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	CifsServiceInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *CifsServiceInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsServiceInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CifsServiceInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"metric"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *CifsServiceInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(o.Throughput) { // not required
		return nil
	}

	if o.Throughput != nil {
		if err := o.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"metric"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cifs service inline metric based on the context it is used
func (o *CifsServiceInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsServiceInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"duration", "body", o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *CifsServiceInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if o.Iops != nil {
		if err := o.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if o.Latency != nil {
		if err := o.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *CifsServiceInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if o.Throughput != nil {
		if err := o.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsServiceInlineMetric) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsServiceInlineMetric) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsServiceInlineMetricInlineLinks cifs service inline metric inline links
swagger:model cifs_service_inline_metric_inline__links
*/
type CifsServiceInlineMetricInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cifs service inline metric inline links
func (o *CifsServiceInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsServiceInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs service inline metric inline links based on the context it is used
func (o *CifsServiceInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsServiceInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsServiceInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsServiceInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsServiceInlineMetricInlineIops The rate of I/O operations observed at the storage object.
swagger:model cifs_service_inline_metric_inline_iops
*/
type CifsServiceInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cifs service inline metric inline iops
func (o *CifsServiceInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cifs service inline metric inline iops based on the context it is used
func (o *CifsServiceInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *CifsServiceInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsServiceInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsServiceInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
swagger:model cifs_service_inline_metric_inline_latency
*/
type CifsServiceInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cifs service inline metric inline latency
func (o *CifsServiceInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cifs service inline metric inline latency based on the context it is used
func (o *CifsServiceInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *CifsServiceInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsServiceInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsServiceInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
swagger:model cifs_service_inline_metric_inline_throughput
*/
type CifsServiceInlineMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cifs service inline metric inline throughput
func (o *CifsServiceInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cifs service inline metric inline throughput based on the context it is used
func (o *CifsServiceInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *CifsServiceInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsServiceInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsServiceInlineStatistics These are raw performance numbers, such as IOPS latency and throughput for SVM protocols. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
swagger:model cifs_service_inline_statistics
*/
type CifsServiceInlineStatistics struct {

	// iops raw
	IopsRaw *models.CifsServiceInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *models.CifsServiceInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *models.CifsServiceInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this cifs service inline statistics
func (o *CifsServiceInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsServiceInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.IopsRaw) { // not required
		return nil
	}

	if o.IopsRaw != nil {
		if err := o.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.LatencyRaw) { // not required
		return nil
	}

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var cifsServiceInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsServiceInlineStatisticsTypeStatusPropEnum = append(cifsServiceInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusOk captures enum value "ok"
	CifsServiceInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusError captures enum value "error"
	CifsServiceInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	CifsServiceInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	CifsServiceInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	CifsServiceInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	CifsServiceInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusNotFound captures enum value "not_found"
	CifsServiceInlineStatisticsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	CifsServiceInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	CifsServiceInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	CifsServiceInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	CifsServiceInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *CifsServiceInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsServiceInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CifsServiceInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"statistics"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *CifsServiceInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.ThroughputRaw) { // not required
		return nil
	}

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"statistics"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cifs service inline statistics based on the context it is used
func (o *CifsServiceInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsServiceInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.IopsRaw != nil {
		if err := o.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *CifsServiceInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *CifsServiceInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsServiceInlineStatistics) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsServiceInlineStatistics) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsServiceInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
swagger:model cifs_service_inline_statistics_inline_iops_raw
*/
type CifsServiceInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cifs service inline statistics inline iops raw
func (o *CifsServiceInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cifs service inline statistics inline iops raw based on the context it is used
func (o *CifsServiceInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *CifsServiceInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsServiceInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsServiceInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
swagger:model cifs_service_inline_statistics_inline_latency_raw
*/
type CifsServiceInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cifs service inline statistics inline latency raw
func (o *CifsServiceInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cifs service inline statistics inline latency raw based on the context it is used
func (o *CifsServiceInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *CifsServiceInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsServiceInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsServiceInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
swagger:model cifs_service_inline_statistics_inline_throughput_raw
*/
type CifsServiceInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cifs service inline statistics inline throughput raw
func (o *CifsServiceInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cifs service inline statistics inline throughput raw based on the context it is used
func (o *CifsServiceInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *CifsServiceInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsServiceInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsServiceInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model cifs_service_inline_svm
*/
type CifsServiceInlineSvm struct {

	// links
	Links *models.CifsServiceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cifs service inline svm
func (o *CifsServiceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsServiceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs service inline svm based on the context it is used
func (o *CifsServiceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsServiceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsServiceInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsServiceInlineSvm) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsServiceInlineSvmInlineLinks cifs service inline svm inline links
swagger:model cifs_service_inline_svm_inline__links
*/
type CifsServiceInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cifs service inline svm inline links
func (o *CifsServiceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsServiceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs service inline svm inline links based on the context it is used
func (o *CifsServiceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsServiceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsServiceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsServiceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
