// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCifsSessionCollectionGetParams creates a new CifsSessionCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCifsSessionCollectionGetParams() *CifsSessionCollectionGetParams {
	return &CifsSessionCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCifsSessionCollectionGetParamsWithTimeout creates a new CifsSessionCollectionGetParams object
// with the ability to set a timeout on a request.
func NewCifsSessionCollectionGetParamsWithTimeout(timeout time.Duration) *CifsSessionCollectionGetParams {
	return &CifsSessionCollectionGetParams{
		timeout: timeout,
	}
}

// NewCifsSessionCollectionGetParamsWithContext creates a new CifsSessionCollectionGetParams object
// with the ability to set a context for a request.
func NewCifsSessionCollectionGetParamsWithContext(ctx context.Context) *CifsSessionCollectionGetParams {
	return &CifsSessionCollectionGetParams{
		Context: ctx,
	}
}

// NewCifsSessionCollectionGetParamsWithHTTPClient creates a new CifsSessionCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewCifsSessionCollectionGetParamsWithHTTPClient(client *http.Client) *CifsSessionCollectionGetParams {
	return &CifsSessionCollectionGetParams{
		HTTPClient: client,
	}
}

/*
CifsSessionCollectionGetParams contains all the parameters to send to the API endpoint

	for the cifs session collection get operation.

	Typically these are written to a http.Request.
*/
type CifsSessionCollectionGetParams struct {

	/* Authentication.

	   Filter by authentication
	*/
	Authentication *string

	/* ClientIP.

	   Filter by client_ip
	*/
	ClientIP *string

	/* ConnectedDuration.

	   Filter by connected_duration
	*/
	ConnectedDuration *string

	/* ConnectionCount.

	   Filter by connection_count
	*/
	ConnectionCount *int64

	/* ConnectionID.

	   Filter by connection_id
	*/
	ConnectionID *int64

	/* ContinuousAvailability.

	   Filter by continuous_availability
	*/
	ContinuousAvailability *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Identifier.

	   Filter by identifier
	*/
	Identifier *int64

	/* IdleDuration.

	   Filter by idle_duration
	*/
	IdleDuration *string

	/* LargeMtu.

	   Filter by large_mtu
	*/
	LargeMtu *bool

	/* MappedUnixUser.

	   Filter by mapped_unix_user
	*/
	MappedUnixUser *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OpenFiles.

	   Filter by open_files
	*/
	OpenFiles *int64

	/* OpenOther.

	   Filter by open_other
	*/
	OpenOther *int64

	/* OpenShares.

	   Filter by open_shares
	*/
	OpenShares *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Protocol.

	   Filter by protocol
	*/
	Protocol *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* ServerIP.

	   Filter by server_ip
	*/
	ServerIP *string

	/* SmbEncryption.

	   Filter by smb_encryption
	*/
	SmbEncryption *string

	/* SmbSigning.

	   Filter by smb_signing
	*/
	SmbSigning *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* User.

	   Filter by user
	*/
	User *string

	/* VolumesName.

	   Filter by volumes.name
	*/
	VolumesName *string

	/* VolumesUUID.

	   Filter by volumes.uuid
	*/
	VolumesUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cifs session collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsSessionCollectionGetParams) WithDefaults() *CifsSessionCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cifs session collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsSessionCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := CifsSessionCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithTimeout(timeout time.Duration) *CifsSessionCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithContext(ctx context.Context) *CifsSessionCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithHTTPClient(client *http.Client) *CifsSessionCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAuthentication adds the authentication to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithAuthentication(authentication *string) *CifsSessionCollectionGetParams {
	o.SetAuthentication(authentication)
	return o
}

// SetAuthentication adds the authentication to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetAuthentication(authentication *string) {
	o.Authentication = authentication
}

// WithClientIP adds the clientIP to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithClientIP(clientIP *string) *CifsSessionCollectionGetParams {
	o.SetClientIP(clientIP)
	return o
}

// SetClientIP adds the clientIp to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetClientIP(clientIP *string) {
	o.ClientIP = clientIP
}

// WithConnectedDuration adds the connectedDuration to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithConnectedDuration(connectedDuration *string) *CifsSessionCollectionGetParams {
	o.SetConnectedDuration(connectedDuration)
	return o
}

// SetConnectedDuration adds the connectedDuration to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetConnectedDuration(connectedDuration *string) {
	o.ConnectedDuration = connectedDuration
}

// WithConnectionCount adds the connectionCount to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithConnectionCount(connectionCount *int64) *CifsSessionCollectionGetParams {
	o.SetConnectionCount(connectionCount)
	return o
}

// SetConnectionCount adds the connectionCount to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetConnectionCount(connectionCount *int64) {
	o.ConnectionCount = connectionCount
}

// WithConnectionID adds the connectionID to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithConnectionID(connectionID *int64) *CifsSessionCollectionGetParams {
	o.SetConnectionID(connectionID)
	return o
}

// SetConnectionID adds the connectionId to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetConnectionID(connectionID *int64) {
	o.ConnectionID = connectionID
}

// WithContinuousAvailability adds the continuousAvailability to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithContinuousAvailability(continuousAvailability *string) *CifsSessionCollectionGetParams {
	o.SetContinuousAvailability(continuousAvailability)
	return o
}

// SetContinuousAvailability adds the continuousAvailability to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetContinuousAvailability(continuousAvailability *string) {
	o.ContinuousAvailability = continuousAvailability
}

// WithFields adds the fields to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithFields(fields []string) *CifsSessionCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIdentifier adds the identifier to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithIdentifier(identifier *int64) *CifsSessionCollectionGetParams {
	o.SetIdentifier(identifier)
	return o
}

// SetIdentifier adds the identifier to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetIdentifier(identifier *int64) {
	o.Identifier = identifier
}

// WithIdleDuration adds the idleDuration to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithIdleDuration(idleDuration *string) *CifsSessionCollectionGetParams {
	o.SetIdleDuration(idleDuration)
	return o
}

// SetIdleDuration adds the idleDuration to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetIdleDuration(idleDuration *string) {
	o.IdleDuration = idleDuration
}

// WithLargeMtu adds the largeMtu to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithLargeMtu(largeMtu *bool) *CifsSessionCollectionGetParams {
	o.SetLargeMtu(largeMtu)
	return o
}

// SetLargeMtu adds the largeMtu to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetLargeMtu(largeMtu *bool) {
	o.LargeMtu = largeMtu
}

// WithMappedUnixUser adds the mappedUnixUser to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithMappedUnixUser(mappedUnixUser *string) *CifsSessionCollectionGetParams {
	o.SetMappedUnixUser(mappedUnixUser)
	return o
}

// SetMappedUnixUser adds the mappedUnixUser to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetMappedUnixUser(mappedUnixUser *string) {
	o.MappedUnixUser = mappedUnixUser
}

// WithMaxRecords adds the maxRecords to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithMaxRecords(maxRecords *int64) *CifsSessionCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNodeName adds the nodeName to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithNodeName(nodeName *string) *CifsSessionCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithNodeUUID(nodeUUID *string) *CifsSessionCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOpenFiles adds the openFiles to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithOpenFiles(openFiles *int64) *CifsSessionCollectionGetParams {
	o.SetOpenFiles(openFiles)
	return o
}

// SetOpenFiles adds the openFiles to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetOpenFiles(openFiles *int64) {
	o.OpenFiles = openFiles
}

// WithOpenOther adds the openOther to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithOpenOther(openOther *int64) *CifsSessionCollectionGetParams {
	o.SetOpenOther(openOther)
	return o
}

// SetOpenOther adds the openOther to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetOpenOther(openOther *int64) {
	o.OpenOther = openOther
}

// WithOpenShares adds the openShares to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithOpenShares(openShares *int64) *CifsSessionCollectionGetParams {
	o.SetOpenShares(openShares)
	return o
}

// SetOpenShares adds the openShares to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetOpenShares(openShares *int64) {
	o.OpenShares = openShares
}

// WithOrderBy adds the orderBy to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithOrderBy(orderBy []string) *CifsSessionCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithProtocol adds the protocol to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithProtocol(protocol *string) *CifsSessionCollectionGetParams {
	o.SetProtocol(protocol)
	return o
}

// SetProtocol adds the protocol to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetProtocol(protocol *string) {
	o.Protocol = protocol
}

// WithReturnRecords adds the returnRecords to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithReturnRecords(returnRecords *bool) *CifsSessionCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *CifsSessionCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithServerIP adds the serverIP to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithServerIP(serverIP *string) *CifsSessionCollectionGetParams {
	o.SetServerIP(serverIP)
	return o
}

// SetServerIP adds the serverIp to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetServerIP(serverIP *string) {
	o.ServerIP = serverIP
}

// WithSmbEncryption adds the smbEncryption to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithSmbEncryption(smbEncryption *string) *CifsSessionCollectionGetParams {
	o.SetSmbEncryption(smbEncryption)
	return o
}

// SetSmbEncryption adds the smbEncryption to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetSmbEncryption(smbEncryption *string) {
	o.SmbEncryption = smbEncryption
}

// WithSmbSigning adds the smbSigning to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithSmbSigning(smbSigning *bool) *CifsSessionCollectionGetParams {
	o.SetSmbSigning(smbSigning)
	return o
}

// SetSmbSigning adds the smbSigning to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetSmbSigning(smbSigning *bool) {
	o.SmbSigning = smbSigning
}

// WithSvmName adds the svmName to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithSvmName(svmName *string) *CifsSessionCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithSvmUUID(svmUUID *string) *CifsSessionCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUser adds the user to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithUser(user *string) *CifsSessionCollectionGetParams {
	o.SetUser(user)
	return o
}

// SetUser adds the user to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetUser(user *string) {
	o.User = user
}

// WithVolumesName adds the volumesName to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithVolumesName(volumesName *string) *CifsSessionCollectionGetParams {
	o.SetVolumesName(volumesName)
	return o
}

// SetVolumesName adds the volumesName to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetVolumesName(volumesName *string) {
	o.VolumesName = volumesName
}

// WithVolumesUUID adds the volumesUUID to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) WithVolumesUUID(volumesUUID *string) *CifsSessionCollectionGetParams {
	o.SetVolumesUUID(volumesUUID)
	return o
}

// SetVolumesUUID adds the volumesUuid to the cifs session collection get params
func (o *CifsSessionCollectionGetParams) SetVolumesUUID(volumesUUID *string) {
	o.VolumesUUID = volumesUUID
}

// WriteToRequest writes these params to a swagger request
func (o *CifsSessionCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Authentication != nil {

		// query param authentication
		var qrAuthentication string

		if o.Authentication != nil {
			qrAuthentication = *o.Authentication
		}
		qAuthentication := qrAuthentication
		if qAuthentication != "" {

			if err := r.SetQueryParam("authentication", qAuthentication); err != nil {
				return err
			}
		}
	}

	if o.ClientIP != nil {

		// query param client_ip
		var qrClientIP string

		if o.ClientIP != nil {
			qrClientIP = *o.ClientIP
		}
		qClientIP := qrClientIP
		if qClientIP != "" {

			if err := r.SetQueryParam("client_ip", qClientIP); err != nil {
				return err
			}
		}
	}

	if o.ConnectedDuration != nil {

		// query param connected_duration
		var qrConnectedDuration string

		if o.ConnectedDuration != nil {
			qrConnectedDuration = *o.ConnectedDuration
		}
		qConnectedDuration := qrConnectedDuration
		if qConnectedDuration != "" {

			if err := r.SetQueryParam("connected_duration", qConnectedDuration); err != nil {
				return err
			}
		}
	}

	if o.ConnectionCount != nil {

		// query param connection_count
		var qrConnectionCount int64

		if o.ConnectionCount != nil {
			qrConnectionCount = *o.ConnectionCount
		}
		qConnectionCount := swag.FormatInt64(qrConnectionCount)
		if qConnectionCount != "" {

			if err := r.SetQueryParam("connection_count", qConnectionCount); err != nil {
				return err
			}
		}
	}

	if o.ConnectionID != nil {

		// query param connection_id
		var qrConnectionID int64

		if o.ConnectionID != nil {
			qrConnectionID = *o.ConnectionID
		}
		qConnectionID := swag.FormatInt64(qrConnectionID)
		if qConnectionID != "" {

			if err := r.SetQueryParam("connection_id", qConnectionID); err != nil {
				return err
			}
		}
	}

	if o.ContinuousAvailability != nil {

		// query param continuous_availability
		var qrContinuousAvailability string

		if o.ContinuousAvailability != nil {
			qrContinuousAvailability = *o.ContinuousAvailability
		}
		qContinuousAvailability := qrContinuousAvailability
		if qContinuousAvailability != "" {

			if err := r.SetQueryParam("continuous_availability", qContinuousAvailability); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Identifier != nil {

		// query param identifier
		var qrIdentifier int64

		if o.Identifier != nil {
			qrIdentifier = *o.Identifier
		}
		qIdentifier := swag.FormatInt64(qrIdentifier)
		if qIdentifier != "" {

			if err := r.SetQueryParam("identifier", qIdentifier); err != nil {
				return err
			}
		}
	}

	if o.IdleDuration != nil {

		// query param idle_duration
		var qrIdleDuration string

		if o.IdleDuration != nil {
			qrIdleDuration = *o.IdleDuration
		}
		qIdleDuration := qrIdleDuration
		if qIdleDuration != "" {

			if err := r.SetQueryParam("idle_duration", qIdleDuration); err != nil {
				return err
			}
		}
	}

	if o.LargeMtu != nil {

		// query param large_mtu
		var qrLargeMtu bool

		if o.LargeMtu != nil {
			qrLargeMtu = *o.LargeMtu
		}
		qLargeMtu := swag.FormatBool(qrLargeMtu)
		if qLargeMtu != "" {

			if err := r.SetQueryParam("large_mtu", qLargeMtu); err != nil {
				return err
			}
		}
	}

	if o.MappedUnixUser != nil {

		// query param mapped_unix_user
		var qrMappedUnixUser string

		if o.MappedUnixUser != nil {
			qrMappedUnixUser = *o.MappedUnixUser
		}
		qMappedUnixUser := qrMappedUnixUser
		if qMappedUnixUser != "" {

			if err := r.SetQueryParam("mapped_unix_user", qMappedUnixUser); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OpenFiles != nil {

		// query param open_files
		var qrOpenFiles int64

		if o.OpenFiles != nil {
			qrOpenFiles = *o.OpenFiles
		}
		qOpenFiles := swag.FormatInt64(qrOpenFiles)
		if qOpenFiles != "" {

			if err := r.SetQueryParam("open_files", qOpenFiles); err != nil {
				return err
			}
		}
	}

	if o.OpenOther != nil {

		// query param open_other
		var qrOpenOther int64

		if o.OpenOther != nil {
			qrOpenOther = *o.OpenOther
		}
		qOpenOther := swag.FormatInt64(qrOpenOther)
		if qOpenOther != "" {

			if err := r.SetQueryParam("open_other", qOpenOther); err != nil {
				return err
			}
		}
	}

	if o.OpenShares != nil {

		// query param open_shares
		var qrOpenShares int64

		if o.OpenShares != nil {
			qrOpenShares = *o.OpenShares
		}
		qOpenShares := swag.FormatInt64(qrOpenShares)
		if qOpenShares != "" {

			if err := r.SetQueryParam("open_shares", qOpenShares); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Protocol != nil {

		// query param protocol
		var qrProtocol string

		if o.Protocol != nil {
			qrProtocol = *o.Protocol
		}
		qProtocol := qrProtocol
		if qProtocol != "" {

			if err := r.SetQueryParam("protocol", qProtocol); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.ServerIP != nil {

		// query param server_ip
		var qrServerIP string

		if o.ServerIP != nil {
			qrServerIP = *o.ServerIP
		}
		qServerIP := qrServerIP
		if qServerIP != "" {

			if err := r.SetQueryParam("server_ip", qServerIP); err != nil {
				return err
			}
		}
	}

	if o.SmbEncryption != nil {

		// query param smb_encryption
		var qrSmbEncryption string

		if o.SmbEncryption != nil {
			qrSmbEncryption = *o.SmbEncryption
		}
		qSmbEncryption := qrSmbEncryption
		if qSmbEncryption != "" {

			if err := r.SetQueryParam("smb_encryption", qSmbEncryption); err != nil {
				return err
			}
		}
	}

	if o.SmbSigning != nil {

		// query param smb_signing
		var qrSmbSigning bool

		if o.SmbSigning != nil {
			qrSmbSigning = *o.SmbSigning
		}
		qSmbSigning := swag.FormatBool(qrSmbSigning)
		if qSmbSigning != "" {

			if err := r.SetQueryParam("smb_signing", qSmbSigning); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.User != nil {

		// query param user
		var qrUser string

		if o.User != nil {
			qrUser = *o.User
		}
		qUser := qrUser
		if qUser != "" {

			if err := r.SetQueryParam("user", qUser); err != nil {
				return err
			}
		}
	}

	if o.VolumesName != nil {

		// query param volumes.name
		var qrVolumesName string

		if o.VolumesName != nil {
			qrVolumesName = *o.VolumesName
		}
		qVolumesName := qrVolumesName
		if qVolumesName != "" {

			if err := r.SetQueryParam("volumes.name", qVolumesName); err != nil {
				return err
			}
		}
	}

	if o.VolumesUUID != nil {

		// query param volumes.uuid
		var qrVolumesUUID string

		if o.VolumesUUID != nil {
			qrVolumesUUID = *o.VolumesUUID
		}
		qVolumesUUID := qrVolumesUUID
		if qVolumesUUID != "" {

			if err := r.SetQueryParam("volumes.uuid", qVolumesUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamCifsSessionCollectionGet binds the parameter fields
func (o *CifsSessionCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamCifsSessionCollectionGet binds the parameter order_by
func (o *CifsSessionCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
