// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCifsSessionDeleteCollectionParams creates a new CifsSessionDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCifsSessionDeleteCollectionParams() *CifsSessionDeleteCollectionParams {
	return &CifsSessionDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCifsSessionDeleteCollectionParamsWithTimeout creates a new CifsSessionDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewCifsSessionDeleteCollectionParamsWithTimeout(timeout time.Duration) *CifsSessionDeleteCollectionParams {
	return &CifsSessionDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewCifsSessionDeleteCollectionParamsWithContext creates a new CifsSessionDeleteCollectionParams object
// with the ability to set a context for a request.
func NewCifsSessionDeleteCollectionParamsWithContext(ctx context.Context) *CifsSessionDeleteCollectionParams {
	return &CifsSessionDeleteCollectionParams{
		Context: ctx,
	}
}

// NewCifsSessionDeleteCollectionParamsWithHTTPClient creates a new CifsSessionDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewCifsSessionDeleteCollectionParamsWithHTTPClient(client *http.Client) *CifsSessionDeleteCollectionParams {
	return &CifsSessionDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
CifsSessionDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the cifs session delete collection operation.

	Typically these are written to a http.Request.
*/
type CifsSessionDeleteCollectionParams struct {

	/* Authentication.

	   Filter by authentication
	*/
	Authentication *string

	/* ClientIP.

	   Filter by client_ip
	*/
	ClientIP *string

	/* ConnectedDuration.

	   Filter by connected_duration
	*/
	ConnectedDuration *string

	/* ConnectionCount.

	   Filter by connection_count
	*/
	ConnectionCount *int64

	/* ConnectionID.

	   Filter by connection_id
	*/
	ConnectionID *int64

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* ContinuousAvailability.

	   Filter by continuous_availability
	*/
	ContinuousAvailability *string

	/* Identifier.

	   Filter by identifier
	*/
	Identifier *int64

	/* IdleDuration.

	   Filter by idle_duration
	*/
	IdleDuration *string

	/* Info.

	   Info specification
	*/
	Info CifsSessionDeleteCollectionBody

	/* LargeMtu.

	   Filter by large_mtu
	*/
	LargeMtu *bool

	/* MappedUnixUser.

	   Filter by mapped_unix_user
	*/
	MappedUnixUser *string

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OpenFiles.

	   Filter by open_files
	*/
	OpenFiles *int64

	/* OpenOther.

	   Filter by open_other
	*/
	OpenOther *int64

	/* OpenShares.

	   Filter by open_shares
	*/
	OpenShares *int64

	/* Protocol.

	   Filter by protocol
	*/
	Protocol *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* ServerIP.

	   Filter by server_ip
	*/
	ServerIP *string

	/* SmbEncryption.

	   Filter by smb_encryption
	*/
	SmbEncryption *string

	/* SmbSigning.

	   Filter by smb_signing
	*/
	SmbSigning *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* User.

	   Filter by user
	*/
	User *string

	/* VolumesName.

	   Filter by volumes.name
	*/
	VolumesName *string

	/* VolumesUUID.

	   Filter by volumes.uuid
	*/
	VolumesUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cifs session delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsSessionDeleteCollectionParams) WithDefaults() *CifsSessionDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cifs session delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsSessionDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := CifsSessionDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithTimeout(timeout time.Duration) *CifsSessionDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithContext(ctx context.Context) *CifsSessionDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithHTTPClient(client *http.Client) *CifsSessionDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAuthentication adds the authentication to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithAuthentication(authentication *string) *CifsSessionDeleteCollectionParams {
	o.SetAuthentication(authentication)
	return o
}

// SetAuthentication adds the authentication to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetAuthentication(authentication *string) {
	o.Authentication = authentication
}

// WithClientIP adds the clientIP to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithClientIP(clientIP *string) *CifsSessionDeleteCollectionParams {
	o.SetClientIP(clientIP)
	return o
}

// SetClientIP adds the clientIp to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetClientIP(clientIP *string) {
	o.ClientIP = clientIP
}

// WithConnectedDuration adds the connectedDuration to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithConnectedDuration(connectedDuration *string) *CifsSessionDeleteCollectionParams {
	o.SetConnectedDuration(connectedDuration)
	return o
}

// SetConnectedDuration adds the connectedDuration to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetConnectedDuration(connectedDuration *string) {
	o.ConnectedDuration = connectedDuration
}

// WithConnectionCount adds the connectionCount to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithConnectionCount(connectionCount *int64) *CifsSessionDeleteCollectionParams {
	o.SetConnectionCount(connectionCount)
	return o
}

// SetConnectionCount adds the connectionCount to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetConnectionCount(connectionCount *int64) {
	o.ConnectionCount = connectionCount
}

// WithConnectionID adds the connectionID to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithConnectionID(connectionID *int64) *CifsSessionDeleteCollectionParams {
	o.SetConnectionID(connectionID)
	return o
}

// SetConnectionID adds the connectionId to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetConnectionID(connectionID *int64) {
	o.ConnectionID = connectionID
}

// WithContinueOnFailure adds the continueOnFailure to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *CifsSessionDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithContinuousAvailability adds the continuousAvailability to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithContinuousAvailability(continuousAvailability *string) *CifsSessionDeleteCollectionParams {
	o.SetContinuousAvailability(continuousAvailability)
	return o
}

// SetContinuousAvailability adds the continuousAvailability to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetContinuousAvailability(continuousAvailability *string) {
	o.ContinuousAvailability = continuousAvailability
}

// WithIdentifier adds the identifier to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithIdentifier(identifier *int64) *CifsSessionDeleteCollectionParams {
	o.SetIdentifier(identifier)
	return o
}

// SetIdentifier adds the identifier to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetIdentifier(identifier *int64) {
	o.Identifier = identifier
}

// WithIdleDuration adds the idleDuration to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithIdleDuration(idleDuration *string) *CifsSessionDeleteCollectionParams {
	o.SetIdleDuration(idleDuration)
	return o
}

// SetIdleDuration adds the idleDuration to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetIdleDuration(idleDuration *string) {
	o.IdleDuration = idleDuration
}

// WithInfo adds the info to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithInfo(info CifsSessionDeleteCollectionBody) *CifsSessionDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetInfo(info CifsSessionDeleteCollectionBody) {
	o.Info = info
}

// WithLargeMtu adds the largeMtu to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithLargeMtu(largeMtu *bool) *CifsSessionDeleteCollectionParams {
	o.SetLargeMtu(largeMtu)
	return o
}

// SetLargeMtu adds the largeMtu to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetLargeMtu(largeMtu *bool) {
	o.LargeMtu = largeMtu
}

// WithMappedUnixUser adds the mappedUnixUser to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithMappedUnixUser(mappedUnixUser *string) *CifsSessionDeleteCollectionParams {
	o.SetMappedUnixUser(mappedUnixUser)
	return o
}

// SetMappedUnixUser adds the mappedUnixUser to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetMappedUnixUser(mappedUnixUser *string) {
	o.MappedUnixUser = mappedUnixUser
}

// WithNodeName adds the nodeName to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithNodeName(nodeName *string) *CifsSessionDeleteCollectionParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithNodeUUID(nodeUUID *string) *CifsSessionDeleteCollectionParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOpenFiles adds the openFiles to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithOpenFiles(openFiles *int64) *CifsSessionDeleteCollectionParams {
	o.SetOpenFiles(openFiles)
	return o
}

// SetOpenFiles adds the openFiles to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetOpenFiles(openFiles *int64) {
	o.OpenFiles = openFiles
}

// WithOpenOther adds the openOther to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithOpenOther(openOther *int64) *CifsSessionDeleteCollectionParams {
	o.SetOpenOther(openOther)
	return o
}

// SetOpenOther adds the openOther to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetOpenOther(openOther *int64) {
	o.OpenOther = openOther
}

// WithOpenShares adds the openShares to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithOpenShares(openShares *int64) *CifsSessionDeleteCollectionParams {
	o.SetOpenShares(openShares)
	return o
}

// SetOpenShares adds the openShares to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetOpenShares(openShares *int64) {
	o.OpenShares = openShares
}

// WithProtocol adds the protocol to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithProtocol(protocol *string) *CifsSessionDeleteCollectionParams {
	o.SetProtocol(protocol)
	return o
}

// SetProtocol adds the protocol to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetProtocol(protocol *string) {
	o.Protocol = protocol
}

// WithReturnRecords adds the returnRecords to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *CifsSessionDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *CifsSessionDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *CifsSessionDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithServerIP adds the serverIP to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithServerIP(serverIP *string) *CifsSessionDeleteCollectionParams {
	o.SetServerIP(serverIP)
	return o
}

// SetServerIP adds the serverIp to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetServerIP(serverIP *string) {
	o.ServerIP = serverIP
}

// WithSmbEncryption adds the smbEncryption to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithSmbEncryption(smbEncryption *string) *CifsSessionDeleteCollectionParams {
	o.SetSmbEncryption(smbEncryption)
	return o
}

// SetSmbEncryption adds the smbEncryption to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetSmbEncryption(smbEncryption *string) {
	o.SmbEncryption = smbEncryption
}

// WithSmbSigning adds the smbSigning to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithSmbSigning(smbSigning *bool) *CifsSessionDeleteCollectionParams {
	o.SetSmbSigning(smbSigning)
	return o
}

// SetSmbSigning adds the smbSigning to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetSmbSigning(smbSigning *bool) {
	o.SmbSigning = smbSigning
}

// WithSvmName adds the svmName to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithSvmName(svmName *string) *CifsSessionDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithSvmUUID(svmUUID *string) *CifsSessionDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUser adds the user to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithUser(user *string) *CifsSessionDeleteCollectionParams {
	o.SetUser(user)
	return o
}

// SetUser adds the user to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetUser(user *string) {
	o.User = user
}

// WithVolumesName adds the volumesName to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithVolumesName(volumesName *string) *CifsSessionDeleteCollectionParams {
	o.SetVolumesName(volumesName)
	return o
}

// SetVolumesName adds the volumesName to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetVolumesName(volumesName *string) {
	o.VolumesName = volumesName
}

// WithVolumesUUID adds the volumesUUID to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) WithVolumesUUID(volumesUUID *string) *CifsSessionDeleteCollectionParams {
	o.SetVolumesUUID(volumesUUID)
	return o
}

// SetVolumesUUID adds the volumesUuid to the cifs session delete collection params
func (o *CifsSessionDeleteCollectionParams) SetVolumesUUID(volumesUUID *string) {
	o.VolumesUUID = volumesUUID
}

// WriteToRequest writes these params to a swagger request
func (o *CifsSessionDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Authentication != nil {

		// query param authentication
		var qrAuthentication string

		if o.Authentication != nil {
			qrAuthentication = *o.Authentication
		}
		qAuthentication := qrAuthentication
		if qAuthentication != "" {

			if err := r.SetQueryParam("authentication", qAuthentication); err != nil {
				return err
			}
		}
	}

	if o.ClientIP != nil {

		// query param client_ip
		var qrClientIP string

		if o.ClientIP != nil {
			qrClientIP = *o.ClientIP
		}
		qClientIP := qrClientIP
		if qClientIP != "" {

			if err := r.SetQueryParam("client_ip", qClientIP); err != nil {
				return err
			}
		}
	}

	if o.ConnectedDuration != nil {

		// query param connected_duration
		var qrConnectedDuration string

		if o.ConnectedDuration != nil {
			qrConnectedDuration = *o.ConnectedDuration
		}
		qConnectedDuration := qrConnectedDuration
		if qConnectedDuration != "" {

			if err := r.SetQueryParam("connected_duration", qConnectedDuration); err != nil {
				return err
			}
		}
	}

	if o.ConnectionCount != nil {

		// query param connection_count
		var qrConnectionCount int64

		if o.ConnectionCount != nil {
			qrConnectionCount = *o.ConnectionCount
		}
		qConnectionCount := swag.FormatInt64(qrConnectionCount)
		if qConnectionCount != "" {

			if err := r.SetQueryParam("connection_count", qConnectionCount); err != nil {
				return err
			}
		}
	}

	if o.ConnectionID != nil {

		// query param connection_id
		var qrConnectionID int64

		if o.ConnectionID != nil {
			qrConnectionID = *o.ConnectionID
		}
		qConnectionID := swag.FormatInt64(qrConnectionID)
		if qConnectionID != "" {

			if err := r.SetQueryParam("connection_id", qConnectionID); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.ContinuousAvailability != nil {

		// query param continuous_availability
		var qrContinuousAvailability string

		if o.ContinuousAvailability != nil {
			qrContinuousAvailability = *o.ContinuousAvailability
		}
		qContinuousAvailability := qrContinuousAvailability
		if qContinuousAvailability != "" {

			if err := r.SetQueryParam("continuous_availability", qContinuousAvailability); err != nil {
				return err
			}
		}
	}

	if o.Identifier != nil {

		// query param identifier
		var qrIdentifier int64

		if o.Identifier != nil {
			qrIdentifier = *o.Identifier
		}
		qIdentifier := swag.FormatInt64(qrIdentifier)
		if qIdentifier != "" {

			if err := r.SetQueryParam("identifier", qIdentifier); err != nil {
				return err
			}
		}
	}

	if o.IdleDuration != nil {

		// query param idle_duration
		var qrIdleDuration string

		if o.IdleDuration != nil {
			qrIdleDuration = *o.IdleDuration
		}
		qIdleDuration := qrIdleDuration
		if qIdleDuration != "" {

			if err := r.SetQueryParam("idle_duration", qIdleDuration); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.LargeMtu != nil {

		// query param large_mtu
		var qrLargeMtu bool

		if o.LargeMtu != nil {
			qrLargeMtu = *o.LargeMtu
		}
		qLargeMtu := swag.FormatBool(qrLargeMtu)
		if qLargeMtu != "" {

			if err := r.SetQueryParam("large_mtu", qLargeMtu); err != nil {
				return err
			}
		}
	}

	if o.MappedUnixUser != nil {

		// query param mapped_unix_user
		var qrMappedUnixUser string

		if o.MappedUnixUser != nil {
			qrMappedUnixUser = *o.MappedUnixUser
		}
		qMappedUnixUser := qrMappedUnixUser
		if qMappedUnixUser != "" {

			if err := r.SetQueryParam("mapped_unix_user", qMappedUnixUser); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OpenFiles != nil {

		// query param open_files
		var qrOpenFiles int64

		if o.OpenFiles != nil {
			qrOpenFiles = *o.OpenFiles
		}
		qOpenFiles := swag.FormatInt64(qrOpenFiles)
		if qOpenFiles != "" {

			if err := r.SetQueryParam("open_files", qOpenFiles); err != nil {
				return err
			}
		}
	}

	if o.OpenOther != nil {

		// query param open_other
		var qrOpenOther int64

		if o.OpenOther != nil {
			qrOpenOther = *o.OpenOther
		}
		qOpenOther := swag.FormatInt64(qrOpenOther)
		if qOpenOther != "" {

			if err := r.SetQueryParam("open_other", qOpenOther); err != nil {
				return err
			}
		}
	}

	if o.OpenShares != nil {

		// query param open_shares
		var qrOpenShares int64

		if o.OpenShares != nil {
			qrOpenShares = *o.OpenShares
		}
		qOpenShares := swag.FormatInt64(qrOpenShares)
		if qOpenShares != "" {

			if err := r.SetQueryParam("open_shares", qOpenShares); err != nil {
				return err
			}
		}
	}

	if o.Protocol != nil {

		// query param protocol
		var qrProtocol string

		if o.Protocol != nil {
			qrProtocol = *o.Protocol
		}
		qProtocol := qrProtocol
		if qProtocol != "" {

			if err := r.SetQueryParam("protocol", qProtocol); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.ServerIP != nil {

		// query param server_ip
		var qrServerIP string

		if o.ServerIP != nil {
			qrServerIP = *o.ServerIP
		}
		qServerIP := qrServerIP
		if qServerIP != "" {

			if err := r.SetQueryParam("server_ip", qServerIP); err != nil {
				return err
			}
		}
	}

	if o.SmbEncryption != nil {

		// query param smb_encryption
		var qrSmbEncryption string

		if o.SmbEncryption != nil {
			qrSmbEncryption = *o.SmbEncryption
		}
		qSmbEncryption := qrSmbEncryption
		if qSmbEncryption != "" {

			if err := r.SetQueryParam("smb_encryption", qSmbEncryption); err != nil {
				return err
			}
		}
	}

	if o.SmbSigning != nil {

		// query param smb_signing
		var qrSmbSigning bool

		if o.SmbSigning != nil {
			qrSmbSigning = *o.SmbSigning
		}
		qSmbSigning := swag.FormatBool(qrSmbSigning)
		if qSmbSigning != "" {

			if err := r.SetQueryParam("smb_signing", qSmbSigning); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.User != nil {

		// query param user
		var qrUser string

		if o.User != nil {
			qrUser = *o.User
		}
		qUser := qrUser
		if qUser != "" {

			if err := r.SetQueryParam("user", qUser); err != nil {
				return err
			}
		}
	}

	if o.VolumesName != nil {

		// query param volumes.name
		var qrVolumesName string

		if o.VolumesName != nil {
			qrVolumesName = *o.VolumesName
		}
		qVolumesName := qrVolumesName
		if qVolumesName != "" {

			if err := r.SetQueryParam("volumes.name", qVolumesName); err != nil {
				return err
			}
		}
	}

	if o.VolumesUUID != nil {

		// query param volumes.uuid
		var qrVolumesUUID string

		if o.VolumesUUID != nil {
			qrVolumesUUID = *o.VolumesUUID
		}
		qVolumesUUID := qrVolumesUUID
		if qVolumesUUID != "" {

			if err := r.SetQueryParam("volumes.uuid", qVolumesUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
