// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewCifsShareACLCreateParams creates a new CifsShareACLCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCifsShareACLCreateParams() *CifsShareACLCreateParams {
	return &CifsShareACLCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCifsShareACLCreateParamsWithTimeout creates a new CifsShareACLCreateParams object
// with the ability to set a timeout on a request.
func NewCifsShareACLCreateParamsWithTimeout(timeout time.Duration) *CifsShareACLCreateParams {
	return &CifsShareACLCreateParams{
		timeout: timeout,
	}
}

// NewCifsShareACLCreateParamsWithContext creates a new CifsShareACLCreateParams object
// with the ability to set a context for a request.
func NewCifsShareACLCreateParamsWithContext(ctx context.Context) *CifsShareACLCreateParams {
	return &CifsShareACLCreateParams{
		Context: ctx,
	}
}

// NewCifsShareACLCreateParamsWithHTTPClient creates a new CifsShareACLCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewCifsShareACLCreateParamsWithHTTPClient(client *http.Client) *CifsShareACLCreateParams {
	return &CifsShareACLCreateParams{
		HTTPClient: client,
	}
}

/*
CifsShareACLCreateParams contains all the parameters to send to the API endpoint

	for the cifs share acl create operation.

	Typically these are written to a http.Request.
*/
type CifsShareACLCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.CifsShareACL

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* Share.

	   CIFS Share Name
	*/
	Share string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cifs share acl create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsShareACLCreateParams) WithDefaults() *CifsShareACLCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cifs share acl create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsShareACLCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := CifsShareACLCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cifs share acl create params
func (o *CifsShareACLCreateParams) WithTimeout(timeout time.Duration) *CifsShareACLCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cifs share acl create params
func (o *CifsShareACLCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cifs share acl create params
func (o *CifsShareACLCreateParams) WithContext(ctx context.Context) *CifsShareACLCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cifs share acl create params
func (o *CifsShareACLCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cifs share acl create params
func (o *CifsShareACLCreateParams) WithHTTPClient(client *http.Client) *CifsShareACLCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cifs share acl create params
func (o *CifsShareACLCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the cifs share acl create params
func (o *CifsShareACLCreateParams) WithInfo(info *models.CifsShareACL) *CifsShareACLCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the cifs share acl create params
func (o *CifsShareACLCreateParams) SetInfo(info *models.CifsShareACL) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the cifs share acl create params
func (o *CifsShareACLCreateParams) WithReturnRecords(returnRecords *bool) *CifsShareACLCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cifs share acl create params
func (o *CifsShareACLCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithShare adds the share to the cifs share acl create params
func (o *CifsShareACLCreateParams) WithShare(share string) *CifsShareACLCreateParams {
	o.SetShare(share)
	return o
}

// SetShare adds the share to the cifs share acl create params
func (o *CifsShareACLCreateParams) SetShare(share string) {
	o.Share = share
}

// WithSvmUUID adds the svmUUID to the cifs share acl create params
func (o *CifsShareACLCreateParams) WithSvmUUID(svmUUID string) *CifsShareACLCreateParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the cifs share acl create params
func (o *CifsShareACLCreateParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *CifsShareACLCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	// path param share
	if err := r.SetPathParam("share", o.Share); err != nil {
		return err
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
