// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CifsShareACLCreateReader is a Reader for the CifsShareACLCreate structure.
type CifsShareACLCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CifsShareACLCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewCifsShareACLCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCifsShareACLCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCifsShareACLCreateCreated creates a CifsShareACLCreateCreated with default headers values
func NewCifsShareACLCreateCreated() *CifsShareACLCreateCreated {
	return &CifsShareACLCreateCreated{}
}

/*
CifsShareACLCreateCreated describes a response with status code 201, with default header values.

Created
*/
type CifsShareACLCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string
}

// IsSuccess returns true when this cifs share Acl create created response has a 2xx status code
func (o *CifsShareACLCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cifs share Acl create created response has a 3xx status code
func (o *CifsShareACLCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cifs share Acl create created response has a 4xx status code
func (o *CifsShareACLCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this cifs share Acl create created response has a 5xx status code
func (o *CifsShareACLCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this cifs share Acl create created response a status code equal to that given
func (o *CifsShareACLCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the cifs share Acl create created response
func (o *CifsShareACLCreateCreated) Code() int {
	return 201
}

func (o *CifsShareACLCreateCreated) Error() string {
	return fmt.Sprintf("[POST /protocols/cifs/shares/{svm.uuid}/{share}/acls][%d] cifsShareAclCreateCreated", 201)
}

func (o *CifsShareACLCreateCreated) String() string {
	return fmt.Sprintf("[POST /protocols/cifs/shares/{svm.uuid}/{share}/acls][%d] cifsShareAclCreateCreated", 201)
}

func (o *CifsShareACLCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	return nil
}

// NewCifsShareACLCreateDefault creates a CifsShareACLCreateDefault with default headers values
func NewCifsShareACLCreateDefault(code int) *CifsShareACLCreateDefault {
	return &CifsShareACLCreateDefault{
		_statusCode: code,
	}
}

/*
	CifsShareACLCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 655446     | Failed to resolve the security identifier (SID) for the account named {user_or_group}. Reason: {Reason}. |
| 4849678    | Failed to resolve {user_or_group} name to a UNIX ID. Reason: {Reason}. |
*/
type CifsShareACLCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cifs share acl create default response has a 2xx status code
func (o *CifsShareACLCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cifs share acl create default response has a 3xx status code
func (o *CifsShareACLCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cifs share acl create default response has a 4xx status code
func (o *CifsShareACLCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cifs share acl create default response has a 5xx status code
func (o *CifsShareACLCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cifs share acl create default response a status code equal to that given
func (o *CifsShareACLCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cifs share acl create default response
func (o *CifsShareACLCreateDefault) Code() int {
	return o._statusCode
}

func (o *CifsShareACLCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/cifs/shares/{svm.uuid}/{share}/acls][%d] cifs_share_acl_create default %s", o._statusCode, payload)
}

func (o *CifsShareACLCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/cifs/shares/{svm.uuid}/{share}/acls][%d] cifs_share_acl_create default %s", o._statusCode, payload)
}

func (o *CifsShareACLCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CifsShareACLCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
