// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCifsShareACLDeleteCollectionParams creates a new CifsShareACLDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCifsShareACLDeleteCollectionParams() *CifsShareACLDeleteCollectionParams {
	return &CifsShareACLDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCifsShareACLDeleteCollectionParamsWithTimeout creates a new CifsShareACLDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewCifsShareACLDeleteCollectionParamsWithTimeout(timeout time.Duration) *CifsShareACLDeleteCollectionParams {
	return &CifsShareACLDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewCifsShareACLDeleteCollectionParamsWithContext creates a new CifsShareACLDeleteCollectionParams object
// with the ability to set a context for a request.
func NewCifsShareACLDeleteCollectionParamsWithContext(ctx context.Context) *CifsShareACLDeleteCollectionParams {
	return &CifsShareACLDeleteCollectionParams{
		Context: ctx,
	}
}

// NewCifsShareACLDeleteCollectionParamsWithHTTPClient creates a new CifsShareACLDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewCifsShareACLDeleteCollectionParamsWithHTTPClient(client *http.Client) *CifsShareACLDeleteCollectionParams {
	return &CifsShareACLDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
CifsShareACLDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the cifs share acl delete collection operation.

	Typically these are written to a http.Request.
*/
type CifsShareACLDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info CifsShareACLDeleteCollectionBody

	/* Permission.

	   Filter by permission
	*/
	Permission *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Share.

	   CIFS Share Name
	*/
	Share string

	/* Sid.

	   Filter by sid
	*/
	Sid *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UnixID.

	   Filter by unix_id
	*/
	UnixID *int64

	/* UserOrGroup.

	   Filter by user_or_group
	*/
	UserOrGroup *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cifs share acl delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsShareACLDeleteCollectionParams) WithDefaults() *CifsShareACLDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cifs share acl delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsShareACLDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := CifsShareACLDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) WithTimeout(timeout time.Duration) *CifsShareACLDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) WithContext(ctx context.Context) *CifsShareACLDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) WithHTTPClient(client *http.Client) *CifsShareACLDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *CifsShareACLDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) WithInfo(info CifsShareACLDeleteCollectionBody) *CifsShareACLDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) SetInfo(info CifsShareACLDeleteCollectionBody) {
	o.Info = info
}

// WithPermission adds the permission to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) WithPermission(permission *string) *CifsShareACLDeleteCollectionParams {
	o.SetPermission(permission)
	return o
}

// SetPermission adds the permission to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) SetPermission(permission *string) {
	o.Permission = permission
}

// WithReturnRecords adds the returnRecords to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *CifsShareACLDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *CifsShareACLDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *CifsShareACLDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithShare adds the share to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) WithShare(share string) *CifsShareACLDeleteCollectionParams {
	o.SetShare(share)
	return o
}

// SetShare adds the share to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) SetShare(share string) {
	o.Share = share
}

// WithSid adds the sid to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) WithSid(sid *string) *CifsShareACLDeleteCollectionParams {
	o.SetSid(sid)
	return o
}

// SetSid adds the sid to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) SetSid(sid *string) {
	o.Sid = sid
}

// WithSvmName adds the svmName to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) WithSvmName(svmName *string) *CifsShareACLDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) WithSvmUUID(svmUUID string) *CifsShareACLDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithType adds the typeVar to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) WithType(typeVar *string) *CifsShareACLDeleteCollectionParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUnixID adds the unixID to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) WithUnixID(unixID *int64) *CifsShareACLDeleteCollectionParams {
	o.SetUnixID(unixID)
	return o
}

// SetUnixID adds the unixId to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) SetUnixID(unixID *int64) {
	o.UnixID = unixID
}

// WithUserOrGroup adds the userOrGroup to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) WithUserOrGroup(userOrGroup *string) *CifsShareACLDeleteCollectionParams {
	o.SetUserOrGroup(userOrGroup)
	return o
}

// SetUserOrGroup adds the userOrGroup to the cifs share acl delete collection params
func (o *CifsShareACLDeleteCollectionParams) SetUserOrGroup(userOrGroup *string) {
	o.UserOrGroup = userOrGroup
}

// WriteToRequest writes these params to a swagger request
func (o *CifsShareACLDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Permission != nil {

		// query param permission
		var qrPermission string

		if o.Permission != nil {
			qrPermission = *o.Permission
		}
		qPermission := qrPermission
		if qPermission != "" {

			if err := r.SetQueryParam("permission", qPermission); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	// path param share
	if err := r.SetPathParam("share", o.Share); err != nil {
		return err
	}

	if o.Sid != nil {

		// query param sid
		var qrSid string

		if o.Sid != nil {
			qrSid = *o.Sid
		}
		qSid := qrSid
		if qSid != "" {

			if err := r.SetQueryParam("sid", qSid); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UnixID != nil {

		// query param unix_id
		var qrUnixID int64

		if o.UnixID != nil {
			qrUnixID = *o.UnixID
		}
		qUnixID := swag.FormatInt64(qrUnixID)
		if qUnixID != "" {

			if err := r.SetQueryParam("unix_id", qUnixID); err != nil {
				return err
			}
		}
	}

	if o.UserOrGroup != nil {

		// query param user_or_group
		var qrUserOrGroup string

		if o.UserOrGroup != nil {
			qrUserOrGroup = *o.UserOrGroup
		}
		qUserOrGroup := qrUserOrGroup
		if qUserOrGroup != "" {

			if err := r.SetQueryParam("user_or_group", qUserOrGroup); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
