// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CifsShareACLModifyReader is a Reader for the CifsShareACLModify structure.
type CifsShareACLModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CifsShareACLModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCifsShareACLModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCifsShareACLModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCifsShareACLModifyOK creates a CifsShareACLModifyOK with default headers values
func NewCifsShareACLModifyOK() *CifsShareACLModifyOK {
	return &CifsShareACLModifyOK{}
}

/*
CifsShareACLModifyOK describes a response with status code 200, with default header values.

OK
*/
type CifsShareACLModifyOK struct {
}

// IsSuccess returns true when this cifs share Acl modify o k response has a 2xx status code
func (o *CifsShareACLModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cifs share Acl modify o k response has a 3xx status code
func (o *CifsShareACLModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cifs share Acl modify o k response has a 4xx status code
func (o *CifsShareACLModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cifs share Acl modify o k response has a 5xx status code
func (o *CifsShareACLModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cifs share Acl modify o k response a status code equal to that given
func (o *CifsShareACLModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cifs share Acl modify o k response
func (o *CifsShareACLModifyOK) Code() int {
	return 200
}

func (o *CifsShareACLModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/cifs/shares/{svm.uuid}/{share}/acls/{user_or_group}/{type}][%d] cifsShareAclModifyOK", 200)
}

func (o *CifsShareACLModifyOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/cifs/shares/{svm.uuid}/{share}/acls/{user_or_group}/{type}][%d] cifsShareAclModifyOK", 200)
}

func (o *CifsShareACLModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewCifsShareACLModifyDefault creates a CifsShareACLModifyDefault with default headers values
func NewCifsShareACLModifyDefault(code int) *CifsShareACLModifyDefault {
	return &CifsShareACLModifyDefault{
		_statusCode: code,
	}
}

/*
	CifsShareACLModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 655516     | The share ACL does not exist for given user and share |
*/
type CifsShareACLModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cifs share acl modify default response has a 2xx status code
func (o *CifsShareACLModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cifs share acl modify default response has a 3xx status code
func (o *CifsShareACLModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cifs share acl modify default response has a 4xx status code
func (o *CifsShareACLModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cifs share acl modify default response has a 5xx status code
func (o *CifsShareACLModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cifs share acl modify default response a status code equal to that given
func (o *CifsShareACLModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cifs share acl modify default response
func (o *CifsShareACLModifyDefault) Code() int {
	return o._statusCode
}

func (o *CifsShareACLModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/shares/{svm.uuid}/{share}/acls/{user_or_group}/{type}][%d] cifs_share_acl_modify default %s", o._statusCode, payload)
}

func (o *CifsShareACLModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/shares/{svm.uuid}/{share}/acls/{user_or_group}/{type}][%d] cifs_share_acl_modify default %s", o._statusCode, payload)
}

func (o *CifsShareACLModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CifsShareACLModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
