// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CifsShareModifyCollectionReader is a Reader for the CifsShareModifyCollection structure.
type CifsShareModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CifsShareModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCifsShareModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCifsShareModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCifsShareModifyCollectionOK creates a CifsShareModifyCollectionOK with default headers values
func NewCifsShareModifyCollectionOK() *CifsShareModifyCollectionOK {
	return &CifsShareModifyCollectionOK{}
}

/*
CifsShareModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type CifsShareModifyCollectionOK struct {
}

// IsSuccess returns true when this cifs share modify collection o k response has a 2xx status code
func (o *CifsShareModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cifs share modify collection o k response has a 3xx status code
func (o *CifsShareModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cifs share modify collection o k response has a 4xx status code
func (o *CifsShareModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cifs share modify collection o k response has a 5xx status code
func (o *CifsShareModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cifs share modify collection o k response a status code equal to that given
func (o *CifsShareModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cifs share modify collection o k response
func (o *CifsShareModifyCollectionOK) Code() int {
	return 200
}

func (o *CifsShareModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/cifs/shares][%d] cifsShareModifyCollectionOK", 200)
}

func (o *CifsShareModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/cifs/shares][%d] cifsShareModifyCollectionOK", 200)
}

func (o *CifsShareModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewCifsShareModifyCollectionDefault creates a CifsShareModifyCollectionDefault with default headers values
func NewCifsShareModifyCollectionDefault(code int) *CifsShareModifyCollectionDefault {
	return &CifsShareModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	CifsShareModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 655628     | 'SMB_ENCRYPTION' property cannot be set on CIFS share because the CIFS server does not support SMB3.0 |
| 655551     | CIFS Share modification failed because the specified path does not exist |
| 655620     | Cannot set symlink properties for admin shares                           |
| 656420     | Cannot modify the standard share ipc$                                    |
| 656421     | Cannot modify the standard share admin$                                  |
| 656422     | Failed to modify the home directory share because the directory shares must specify a path relative to one or more home directory search paths |
| 656423     | Failed to modify CIFS share. The Shares must define an absolute share path |
| 656425     | Failed to modify the CIFS share because the path for an administrative share cannot be modified |
| 656486     | Failed to modify CIFS share because the share cannot be made continuously available for FlexCache volumes. |
| 655395     | Failed to modify the CIFS share because share cannot be made continuously available unless running SMB3 or later. |
| 4849678    | Failed to modify the CIFS share because the specified UNIX group does not exist |
| 655622     | Invalid value for parameter {max-connections-per-share}. Maximum connections on CIFS share {name} must be between 1 to 4294967295.|
*/
type CifsShareModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cifs share modify collection default response has a 2xx status code
func (o *CifsShareModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cifs share modify collection default response has a 3xx status code
func (o *CifsShareModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cifs share modify collection default response has a 4xx status code
func (o *CifsShareModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cifs share modify collection default response has a 5xx status code
func (o *CifsShareModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cifs share modify collection default response a status code equal to that given
func (o *CifsShareModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cifs share modify collection default response
func (o *CifsShareModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *CifsShareModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/shares][%d] cifs_share_modify_collection default %s", o._statusCode, payload)
}

func (o *CifsShareModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/shares][%d] cifs_share_modify_collection default %s", o._statusCode, payload)
}

func (o *CifsShareModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CifsShareModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CifsShareModifyCollectionBody cifs share modify collection body
swagger:model CifsShareModifyCollectionBody
*/
type CifsShareModifyCollectionBody struct {

	// links
	Links *models.CifsShareInlineLinks `json:"_links,omitempty"`

	// If enabled, all folders inside this share are visible to a user based on that individual user access right; prevents
	// the display of folders or other shared resources that the user does not have access to.
	//
	AccessBasedEnumeration *bool `json:"access_based_enumeration,omitempty"`

	// Specifies whether or not the SMB2 clients are allowed to access the encrypted share.
	//
	AllowUnencryptedAccess *bool `json:"allow_unencrypted_access,omitempty"`

	// Specifies that connections through this share cache attributes for a short time to improve performance.
	//
	AttributeCache *bool `json:"attribute_cache,omitempty"`

	// Specifies whether or not the Windows clients can browse the share.
	//
	Browsable *bool `json:"browsable,omitempty"`

	// Specifies whether CIFS clients can request for change notifications for directories on this share.
	ChangeNotify *bool `json:"change_notify,omitempty"`

	// cifs share inline acls
	CifsShareInlineAcls []*models.CifsShareInlineAclsInlineArrayItem `json:"acls,omitempty"`

	// cifs share response inline records
	CifsShareResponseInlineRecords []*models.CifsShare `json:"records,omitempty"`

	// Specify the CIFS share descriptions.
	// Example: HR Department Share
	// Max Length: 256
	// Min Length: 1
	Comment *string `json:"comment,omitempty"`

	// Specifies whether or not the clients connecting to this share can open files in a persistent manner.
	// Files opened in this way are protected from disruptive events, such as, failover and giveback.
	// If the Vscan ONTAP feature is used, it is not supported in continuous availability (CA) shares.
	//
	ContinuouslyAvailable *bool `json:"continuously_available,omitempty"`

	// Directory Mode Creation Mask to be viewed as an octal number.
	// Example: 21
	DirUmask *string `json:"dir_umask,omitempty"`

	// Specifies that SMB encryption must be used when accessing this share. Clients that do not support encryption are not
	// able to access this share.
	//
	Encryption *bool `json:"encryption,omitempty"`

	// File Mode Creation Mask to be viewed as an octal number.
	// Example: 21
	FileUmask *string `json:"file_umask,omitempty"`

	// Specifies that all files that CIFS users create in a specific share belong to the same group
	// (also called the "force-group"). The "force-group" must be a predefined group in the UNIX group
	// database. This setting has no effect unless the security style of the volume is UNIX or mixed
	// security style.
	//
	ForceGroupForCreate *string `json:"force_group_for_create,omitempty"`

	// Specifies whether or not the share is a home directory share, where the share and path names are dynamic.
	// ONTAP home directory functionality automatically offer each user a dynamic share to their home directory without creating an
	// individual SMB share for each user.
	// The ONTAP CIFS home directory feature enable us to configure a share that maps to
	// different directories based on the user that connects to it. Instead of creating a separate shares for each user,
	// a single share with a home directory parameters can be created.
	// In a home directory share, ONTAP dynamically generates the share-name and share-path by substituting
	// %w, %u, and %d variables with the corresponding Windows user name, UNIX user name, and domain name, respectively.
	//
	HomeDirectory *bool `json:"home_directory,omitempty"`

	// Maximum number of tree connections on share.
	//
	MaxConnectionsPerShare *int64 `json:"max_connections_per_share,omitempty"`

	// Specifies the name of the CIFS share that you want to create. If this
	// is a home directory share then the share name includes the pattern as
	// %w (Windows user name), %u (UNIX user name) and %d (Windows domain name)
	// variables in any combination with this parameter to generate shares dynamically.
	//
	// Example: HR_SHARE
	// Max Length: 80
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// Specifies whether or not the SMB clients connecting to this share can cache the directory enumeration
	// results returned by the CIFS servers.
	//
	NamespaceCaching *bool `json:"namespace_caching,omitempty"`

	// Specifies whether or not CIFS clients can follow a unix symlinks outside the share boundaries.
	//
	NoStrictSecurity *bool `json:"no_strict_security,omitempty"`

	// Offline Files
	// The supported values are:
	//   * none - Clients are not permitted to cache files for offline access.
	//   * manual - Clients may cache files that are explicitly selected by the user for offline access.
	//   * documents - Clients may automatically cache files that are used by the user for offline access.
	//   * programs - Clients may automatically cache files that are used by the user for offline access
	//                and may use those files in an offline mode even if the share is available.
	//
	// Enum: ["none","manual","documents","programs"]
	OfflineFiles *string `json:"offline_files,omitempty"`

	// Specify whether opportunistic locks are enabled on this share. "Oplocks" allow clients to lock files and cache content locally,
	// which can increase performance for file operations.
	//
	Oplocks *bool `json:"oplocks,omitempty"`

	// The fully-qualified pathname in the owning SVM namespace that is shared through this share.
	// If this is a home directory share then the path should be dynamic by specifying the pattern
	// %w (Windows user name), %u (UNIX user name), or %d (domain name) variables in any combination.
	// ONTAP generates the path dynamically for the connected user and this path is appended to each
	// search path to find the full Home Directory path.
	//
	// Example: /volume_1/eng_vol/
	// Max Length: 256
	// Min Length: 1
	Path *string `json:"path,omitempty"`

	// Specifies that the previous version can be viewed and restored from the client.
	ShowPreviousVersions *bool `json:"show_previous_versions,omitempty"`

	// Specifies whether or not the snapshots can be viewed and traversed by clients.
	//
	ShowSnapshot *bool `json:"show_snapshot,omitempty"`

	// svm
	Svm *models.CifsShareInlineSvm `json:"svm,omitempty"`

	// Controls the access of UNIX symbolic links to CIFS clients.
	// The supported values are:
	//     * local - Enables only local symbolic links which is within the same CIFS share.
	//     * widelink - Enables both local symlinks and widelinks.
	//     * disable - Disables local symlinks and widelinks.
	//
	// Enum: ["local","widelink","disable"]
	UnixSymlink *string `json:"unix_symlink,omitempty"`

	// volume
	Volume *models.CifsShareInlineVolume `json:"volume,omitempty"`

	// Vscan File-Operations Profile
	// The supported values are:
	//   * no_scan - Virus scans are never triggered for accesses to this share.
	//   * standard - Virus scans can be triggered by open, close, and rename operations.
	//   * strict - Virus scans can be triggered by open, read, close, and rename operations.
	//   * writes_only - Virus scans can be triggered only when a file that has been modified is closed.
	//
	// Enum: ["no_scan","standard","strict","writes_only"]
	VscanProfile *string `json:"vscan_profile,omitempty"`
}

// Validate validates this cifs share modify collection body
func (o *CifsShareModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCifsShareInlineAcls(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCifsShareResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOfflineFiles(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePath(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUnixSymlink(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVscanProfile(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsShareModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *CifsShareModifyCollectionBody) validateCifsShareInlineAcls(formats strfmt.Registry) error {
	if swag.IsZero(o.CifsShareInlineAcls) { // not required
		return nil
	}

	for i := 0; i < len(o.CifsShareInlineAcls); i++ {
		if swag.IsZero(o.CifsShareInlineAcls[i]) { // not required
			continue
		}

		if o.CifsShareInlineAcls[i] != nil {
			if err := o.CifsShareInlineAcls[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "acls" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CifsShareModifyCollectionBody) validateCifsShareResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.CifsShareResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.CifsShareResponseInlineRecords); i++ {
		if swag.IsZero(o.CifsShareResponseInlineRecords[i]) { // not required
			continue
		}

		if o.CifsShareResponseInlineRecords[i] != nil {
			if err := o.CifsShareResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CifsShareModifyCollectionBody) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"comment", "body", *o.Comment, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"comment", "body", *o.Comment, 256); err != nil {
		return err
	}

	return nil
}

func (o *CifsShareModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 80); err != nil {
		return err
	}

	return nil
}

var cifsShareModifyCollectionBodyTypeOfflineFilesPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","manual","documents","programs"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsShareModifyCollectionBodyTypeOfflineFilesPropEnum = append(cifsShareModifyCollectionBodyTypeOfflineFilesPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// CifsShareModifyCollectionBody
	// CifsShareModifyCollectionBody
	// offline_files
	// OfflineFiles
	// none
	// END DEBUGGING
	// CifsShareModifyCollectionBodyOfflineFilesNone captures enum value "none"
	CifsShareModifyCollectionBodyOfflineFilesNone string = "none"

	// BEGIN DEBUGGING
	// CifsShareModifyCollectionBody
	// CifsShareModifyCollectionBody
	// offline_files
	// OfflineFiles
	// manual
	// END DEBUGGING
	// CifsShareModifyCollectionBodyOfflineFilesManual captures enum value "manual"
	CifsShareModifyCollectionBodyOfflineFilesManual string = "manual"

	// BEGIN DEBUGGING
	// CifsShareModifyCollectionBody
	// CifsShareModifyCollectionBody
	// offline_files
	// OfflineFiles
	// documents
	// END DEBUGGING
	// CifsShareModifyCollectionBodyOfflineFilesDocuments captures enum value "documents"
	CifsShareModifyCollectionBodyOfflineFilesDocuments string = "documents"

	// BEGIN DEBUGGING
	// CifsShareModifyCollectionBody
	// CifsShareModifyCollectionBody
	// offline_files
	// OfflineFiles
	// programs
	// END DEBUGGING
	// CifsShareModifyCollectionBodyOfflineFilesPrograms captures enum value "programs"
	CifsShareModifyCollectionBodyOfflineFilesPrograms string = "programs"
)

// prop value enum
func (o *CifsShareModifyCollectionBody) validateOfflineFilesEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsShareModifyCollectionBodyTypeOfflineFilesPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CifsShareModifyCollectionBody) validateOfflineFiles(formats strfmt.Registry) error {
	if swag.IsZero(o.OfflineFiles) { // not required
		return nil
	}

	// value enum
	if err := o.validateOfflineFilesEnum("info"+"."+"offline_files", "body", *o.OfflineFiles); err != nil {
		return err
	}

	return nil
}

func (o *CifsShareModifyCollectionBody) validatePath(formats strfmt.Registry) error {
	if swag.IsZero(o.Path) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"path", "body", *o.Path, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"path", "body", *o.Path, 256); err != nil {
		return err
	}

	return nil
}

func (o *CifsShareModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

var cifsShareModifyCollectionBodyTypeUnixSymlinkPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["local","widelink","disable"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsShareModifyCollectionBodyTypeUnixSymlinkPropEnum = append(cifsShareModifyCollectionBodyTypeUnixSymlinkPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// CifsShareModifyCollectionBody
	// CifsShareModifyCollectionBody
	// unix_symlink
	// UnixSymlink
	// local
	// END DEBUGGING
	// CifsShareModifyCollectionBodyUnixSymlinkLocal captures enum value "local"
	CifsShareModifyCollectionBodyUnixSymlinkLocal string = "local"

	// BEGIN DEBUGGING
	// CifsShareModifyCollectionBody
	// CifsShareModifyCollectionBody
	// unix_symlink
	// UnixSymlink
	// widelink
	// END DEBUGGING
	// CifsShareModifyCollectionBodyUnixSymlinkWidelink captures enum value "widelink"
	CifsShareModifyCollectionBodyUnixSymlinkWidelink string = "widelink"

	// BEGIN DEBUGGING
	// CifsShareModifyCollectionBody
	// CifsShareModifyCollectionBody
	// unix_symlink
	// UnixSymlink
	// disable
	// END DEBUGGING
	// CifsShareModifyCollectionBodyUnixSymlinkDisable captures enum value "disable"
	CifsShareModifyCollectionBodyUnixSymlinkDisable string = "disable"
)

// prop value enum
func (o *CifsShareModifyCollectionBody) validateUnixSymlinkEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsShareModifyCollectionBodyTypeUnixSymlinkPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CifsShareModifyCollectionBody) validateUnixSymlink(formats strfmt.Registry) error {
	if swag.IsZero(o.UnixSymlink) { // not required
		return nil
	}

	// value enum
	if err := o.validateUnixSymlinkEnum("info"+"."+"unix_symlink", "body", *o.UnixSymlink); err != nil {
		return err
	}

	return nil
}

func (o *CifsShareModifyCollectionBody) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(o.Volume) { // not required
		return nil
	}

	if o.Volume != nil {
		if err := o.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

var cifsShareModifyCollectionBodyTypeVscanProfilePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_scan","standard","strict","writes_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsShareModifyCollectionBodyTypeVscanProfilePropEnum = append(cifsShareModifyCollectionBodyTypeVscanProfilePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// CifsShareModifyCollectionBody
	// CifsShareModifyCollectionBody
	// vscan_profile
	// VscanProfile
	// no_scan
	// END DEBUGGING
	// CifsShareModifyCollectionBodyVscanProfileNoScan captures enum value "no_scan"
	CifsShareModifyCollectionBodyVscanProfileNoScan string = "no_scan"

	// BEGIN DEBUGGING
	// CifsShareModifyCollectionBody
	// CifsShareModifyCollectionBody
	// vscan_profile
	// VscanProfile
	// standard
	// END DEBUGGING
	// CifsShareModifyCollectionBodyVscanProfileStandard captures enum value "standard"
	CifsShareModifyCollectionBodyVscanProfileStandard string = "standard"

	// BEGIN DEBUGGING
	// CifsShareModifyCollectionBody
	// CifsShareModifyCollectionBody
	// vscan_profile
	// VscanProfile
	// strict
	// END DEBUGGING
	// CifsShareModifyCollectionBodyVscanProfileStrict captures enum value "strict"
	CifsShareModifyCollectionBodyVscanProfileStrict string = "strict"

	// BEGIN DEBUGGING
	// CifsShareModifyCollectionBody
	// CifsShareModifyCollectionBody
	// vscan_profile
	// VscanProfile
	// writes_only
	// END DEBUGGING
	// CifsShareModifyCollectionBodyVscanProfileWritesOnly captures enum value "writes_only"
	CifsShareModifyCollectionBodyVscanProfileWritesOnly string = "writes_only"
)

// prop value enum
func (o *CifsShareModifyCollectionBody) validateVscanProfileEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsShareModifyCollectionBodyTypeVscanProfilePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CifsShareModifyCollectionBody) validateVscanProfile(formats strfmt.Registry) error {
	if swag.IsZero(o.VscanProfile) { // not required
		return nil
	}

	// value enum
	if err := o.validateVscanProfileEnum("info"+"."+"vscan_profile", "body", *o.VscanProfile); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cifs share modify collection body based on the context it is used
func (o *CifsShareModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCifsShareInlineAcls(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCifsShareResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsShareModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *CifsShareModifyCollectionBody) contextValidateCifsShareInlineAcls(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.CifsShareInlineAcls); i++ {

		if o.CifsShareInlineAcls[i] != nil {
			if err := o.CifsShareInlineAcls[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "acls" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CifsShareModifyCollectionBody) contextValidateCifsShareResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.CifsShareResponseInlineRecords); i++ {

		if o.CifsShareResponseInlineRecords[i] != nil {
			if err := o.CifsShareResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CifsShareModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *CifsShareModifyCollectionBody) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if o.Volume != nil {
		if err := o.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsShareModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsShareModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res CifsShareModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsShareInlineLinks cifs share inline links
swagger:model cifs_share_inline__links
*/
type CifsShareInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cifs share inline links
func (o *CifsShareInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsShareInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs share inline links based on the context it is used
func (o *CifsShareInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsShareInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsShareInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsShareInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsShareInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsShareInlineAclsInlineArrayItem The permissions that users and groups have on a CIFS share.
swagger:model cifs_share_inline_acls_inline_array_item
*/
type CifsShareInlineAclsInlineArrayItem struct {

	// links
	Links *models.CifsShareInlineAclsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// Specifies the access rights that a user or group has on the defined CIFS Share.
	// The following values are allowed:
	// * no_access    - User does not have CIFS share access
	// * read         - User has only read access
	// * change       - User has change access
	// * full_control - User has full_control access
	//
	// Enum: ["no_access","read","change","full_control"]
	Permission *string `json:"permission,omitempty"`

	// Specifies the type of the user or group to add to the access control
	// list of a CIFS share. The following values are allowed:
	// * windows    - Windows user or group
	// * unix_user  - UNIX user
	// * unix_group - UNIX group
	//
	// Enum: ["windows","unix_user","unix_group"]
	Type *string `json:"type,omitempty"`

	// Specifies the user or group name to add to the access control list of a CIFS share.
	// Example: ENGDOMAIN\\ad_user
	UserOrGroup *string `json:"user_or_group,omitempty"`

	// Windows SID/UNIX ID depending on access-control type.
	WinSidUnixID *string `json:"win_sid_unix_id,omitempty"`
}

// Validate validates this cifs share inline acls inline array item
func (o *CifsShareInlineAclsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePermission(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsShareInlineAclsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var cifsShareInlineAclsInlineArrayItemTypePermissionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_access","read","change","full_control"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsShareInlineAclsInlineArrayItemTypePermissionPropEnum = append(cifsShareInlineAclsInlineArrayItemTypePermissionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_share_inline_acls_inline_array_item
	// CifsShareInlineAclsInlineArrayItem
	// permission
	// Permission
	// no_access
	// END DEBUGGING
	// CifsShareInlineAclsInlineArrayItemPermissionNoAccess captures enum value "no_access"
	CifsShareInlineAclsInlineArrayItemPermissionNoAccess string = "no_access"

	// BEGIN DEBUGGING
	// cifs_share_inline_acls_inline_array_item
	// CifsShareInlineAclsInlineArrayItem
	// permission
	// Permission
	// read
	// END DEBUGGING
	// CifsShareInlineAclsInlineArrayItemPermissionRead captures enum value "read"
	CifsShareInlineAclsInlineArrayItemPermissionRead string = "read"

	// BEGIN DEBUGGING
	// cifs_share_inline_acls_inline_array_item
	// CifsShareInlineAclsInlineArrayItem
	// permission
	// Permission
	// change
	// END DEBUGGING
	// CifsShareInlineAclsInlineArrayItemPermissionChange captures enum value "change"
	CifsShareInlineAclsInlineArrayItemPermissionChange string = "change"

	// BEGIN DEBUGGING
	// cifs_share_inline_acls_inline_array_item
	// CifsShareInlineAclsInlineArrayItem
	// permission
	// Permission
	// full_control
	// END DEBUGGING
	// CifsShareInlineAclsInlineArrayItemPermissionFullControl captures enum value "full_control"
	CifsShareInlineAclsInlineArrayItemPermissionFullControl string = "full_control"
)

// prop value enum
func (o *CifsShareInlineAclsInlineArrayItem) validatePermissionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsShareInlineAclsInlineArrayItemTypePermissionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CifsShareInlineAclsInlineArrayItem) validatePermission(formats strfmt.Registry) error {
	if swag.IsZero(o.Permission) { // not required
		return nil
	}

	// value enum
	if err := o.validatePermissionEnum("permission", "body", *o.Permission); err != nil {
		return err
	}

	return nil
}

var cifsShareInlineAclsInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["windows","unix_user","unix_group"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsShareInlineAclsInlineArrayItemTypeTypePropEnum = append(cifsShareInlineAclsInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_share_inline_acls_inline_array_item
	// CifsShareInlineAclsInlineArrayItem
	// type
	// Type
	// windows
	// END DEBUGGING
	// CifsShareInlineAclsInlineArrayItemTypeWindows captures enum value "windows"
	CifsShareInlineAclsInlineArrayItemTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// cifs_share_inline_acls_inline_array_item
	// CifsShareInlineAclsInlineArrayItem
	// type
	// Type
	// unix_user
	// END DEBUGGING
	// CifsShareInlineAclsInlineArrayItemTypeUnixUser captures enum value "unix_user"
	CifsShareInlineAclsInlineArrayItemTypeUnixUser string = "unix_user"

	// BEGIN DEBUGGING
	// cifs_share_inline_acls_inline_array_item
	// CifsShareInlineAclsInlineArrayItem
	// type
	// Type
	// unix_group
	// END DEBUGGING
	// CifsShareInlineAclsInlineArrayItemTypeUnixGroup captures enum value "unix_group"
	CifsShareInlineAclsInlineArrayItemTypeUnixGroup string = "unix_group"
)

// prop value enum
func (o *CifsShareInlineAclsInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsShareInlineAclsInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CifsShareInlineAclsInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cifs share inline acls inline array item based on the context it is used
func (o *CifsShareInlineAclsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsShareInlineAclsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsShareInlineAclsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsShareInlineAclsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res CifsShareInlineAclsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsShareInlineAclsInlineArrayItemInlineLinks cifs share inline acls inline array item inline links
swagger:model cifs_share_inline_acls_inline_array_item_inline__links
*/
type CifsShareInlineAclsInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cifs share inline acls inline array item inline links
func (o *CifsShareInlineAclsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsShareInlineAclsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs share inline acls inline array item inline links based on the context it is used
func (o *CifsShareInlineAclsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsShareInlineAclsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsShareInlineAclsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsShareInlineAclsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsShareInlineAclsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsShareInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model cifs_share_inline_svm
*/
type CifsShareInlineSvm struct {

	// links
	Links *models.CifsShareInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cifs share inline svm
func (o *CifsShareInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsShareInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs share inline svm based on the context it is used
func (o *CifsShareInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsShareInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsShareInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsShareInlineSvm) UnmarshalBinary(b []byte) error {
	var res CifsShareInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsShareInlineSvmInlineLinks cifs share inline svm inline links
swagger:model cifs_share_inline_svm_inline__links
*/
type CifsShareInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cifs share inline svm inline links
func (o *CifsShareInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsShareInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs share inline svm inline links based on the context it is used
func (o *CifsShareInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsShareInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsShareInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsShareInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsShareInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsShareInlineVolume cifs share inline volume
swagger:model cifs_share_inline_volume
*/
type CifsShareInlineVolume struct {

	// links
	Links *models.CifsShareInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cifs share inline volume
func (o *CifsShareInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsShareInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs share inline volume based on the context it is used
func (o *CifsShareInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsShareInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsShareInlineVolume) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsShareInlineVolume) UnmarshalBinary(b []byte) error {
	var res CifsShareInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsShareInlineVolumeInlineLinks cifs share inline volume inline links
swagger:model cifs_share_inline_volume_inline__links
*/
type CifsShareInlineVolumeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cifs share inline volume inline links
func (o *CifsShareInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsShareInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs share inline volume inline links based on the context it is used
func (o *CifsShareInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsShareInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsShareInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsShareInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsShareInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
