// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CifsSymlinkMappingModifyCollectionReader is a Reader for the CifsSymlinkMappingModifyCollection structure.
type CifsSymlinkMappingModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CifsSymlinkMappingModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCifsSymlinkMappingModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCifsSymlinkMappingModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCifsSymlinkMappingModifyCollectionOK creates a CifsSymlinkMappingModifyCollectionOK with default headers values
func NewCifsSymlinkMappingModifyCollectionOK() *CifsSymlinkMappingModifyCollectionOK {
	return &CifsSymlinkMappingModifyCollectionOK{}
}

/*
CifsSymlinkMappingModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type CifsSymlinkMappingModifyCollectionOK struct {
}

// IsSuccess returns true when this cifs symlink mapping modify collection o k response has a 2xx status code
func (o *CifsSymlinkMappingModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cifs symlink mapping modify collection o k response has a 3xx status code
func (o *CifsSymlinkMappingModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cifs symlink mapping modify collection o k response has a 4xx status code
func (o *CifsSymlinkMappingModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cifs symlink mapping modify collection o k response has a 5xx status code
func (o *CifsSymlinkMappingModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cifs symlink mapping modify collection o k response a status code equal to that given
func (o *CifsSymlinkMappingModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cifs symlink mapping modify collection o k response
func (o *CifsSymlinkMappingModifyCollectionOK) Code() int {
	return 200
}

func (o *CifsSymlinkMappingModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/cifs/unix-symlink-mapping][%d] cifsSymlinkMappingModifyCollectionOK", 200)
}

func (o *CifsSymlinkMappingModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/cifs/unix-symlink-mapping][%d] cifsSymlinkMappingModifyCollectionOK", 200)
}

func (o *CifsSymlinkMappingModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewCifsSymlinkMappingModifyCollectionDefault creates a CifsSymlinkMappingModifyCollectionDefault with default headers values
func NewCifsSymlinkMappingModifyCollectionDefault(code int) *CifsSymlinkMappingModifyCollectionDefault {
	return &CifsSymlinkMappingModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	CifsSymlinkMappingModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 655437     | Failed to modify the symlink mapping with locality "local" because the target share does not exist for the specified SVM |
| 655573     | Failed to modify the symlink mapping to target path because it contains illegal characters or is too long |
| 655575     | Failed to modify the symlink mapping to target server because it contains illegal characters or is too long |
| 655547     | Failed to modify symlink mapping because administrative share cannot be used as target share |
| 656481     | Failed to modify the widelink because the target share does not exist for the specified SVM |
*/
type CifsSymlinkMappingModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cifs symlink mapping modify collection default response has a 2xx status code
func (o *CifsSymlinkMappingModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cifs symlink mapping modify collection default response has a 3xx status code
func (o *CifsSymlinkMappingModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cifs symlink mapping modify collection default response has a 4xx status code
func (o *CifsSymlinkMappingModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cifs symlink mapping modify collection default response has a 5xx status code
func (o *CifsSymlinkMappingModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cifs symlink mapping modify collection default response a status code equal to that given
func (o *CifsSymlinkMappingModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cifs symlink mapping modify collection default response
func (o *CifsSymlinkMappingModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *CifsSymlinkMappingModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/unix-symlink-mapping][%d] cifs_symlink_mapping_modify_collection default %s", o._statusCode, payload)
}

func (o *CifsSymlinkMappingModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/unix-symlink-mapping][%d] cifs_symlink_mapping_modify_collection default %s", o._statusCode, payload)
}

func (o *CifsSymlinkMappingModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CifsSymlinkMappingModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CifsSymlinkMappingModifyCollectionBody cifs symlink mapping modify collection body
swagger:model CifsSymlinkMappingModifyCollectionBody
*/
type CifsSymlinkMappingModifyCollectionBody struct {

	// links
	Links *models.CifsSymlinkMappingInlineLinks `json:"_links,omitempty"`

	// cifs symlink mapping response inline records
	CifsSymlinkMappingResponseInlineRecords []*models.CifsSymlinkMapping `json:"records,omitempty"`

	// svm
	Svm *models.CifsSymlinkMappingInlineSvm `json:"svm,omitempty"`

	// target
	Target *models.CifsTarget `json:"target,omitempty"`

	// Specifies the UNIX path prefix to be matched for the mapping.
	// Example: /mnt/eng_volume/
	// Max Length: 256
	UnixPath *string `json:"unix_path,omitempty"`
}

// Validate validates this cifs symlink mapping modify collection body
func (o *CifsSymlinkMappingModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCifsSymlinkMappingResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTarget(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUnixPath(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsSymlinkMappingModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *CifsSymlinkMappingModifyCollectionBody) validateCifsSymlinkMappingResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.CifsSymlinkMappingResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.CifsSymlinkMappingResponseInlineRecords); i++ {
		if swag.IsZero(o.CifsSymlinkMappingResponseInlineRecords[i]) { // not required
			continue
		}

		if o.CifsSymlinkMappingResponseInlineRecords[i] != nil {
			if err := o.CifsSymlinkMappingResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CifsSymlinkMappingModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *CifsSymlinkMappingModifyCollectionBody) validateTarget(formats strfmt.Registry) error {
	if swag.IsZero(o.Target) { // not required
		return nil
	}

	if o.Target != nil {
		if err := o.Target.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "target")
			}
			return err
		}
	}

	return nil
}

func (o *CifsSymlinkMappingModifyCollectionBody) validateUnixPath(formats strfmt.Registry) error {
	if swag.IsZero(o.UnixPath) { // not required
		return nil
	}

	if err := validate.MaxLength("info"+"."+"unix_path", "body", *o.UnixPath, 256); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cifs symlink mapping modify collection body based on the context it is used
func (o *CifsSymlinkMappingModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCifsSymlinkMappingResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTarget(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsSymlinkMappingModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *CifsSymlinkMappingModifyCollectionBody) contextValidateCifsSymlinkMappingResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.CifsSymlinkMappingResponseInlineRecords); i++ {

		if o.CifsSymlinkMappingResponseInlineRecords[i] != nil {
			if err := o.CifsSymlinkMappingResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CifsSymlinkMappingModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *CifsSymlinkMappingModifyCollectionBody) contextValidateTarget(ctx context.Context, formats strfmt.Registry) error {

	if o.Target != nil {
		if err := o.Target.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "target")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsSymlinkMappingModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsSymlinkMappingModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res CifsSymlinkMappingModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsSymlinkMappingInlineLinks cifs symlink mapping inline links
swagger:model cifs_symlink_mapping_inline__links
*/
type CifsSymlinkMappingInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cifs symlink mapping inline links
func (o *CifsSymlinkMappingInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsSymlinkMappingInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs symlink mapping inline links based on the context it is used
func (o *CifsSymlinkMappingInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsSymlinkMappingInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsSymlinkMappingInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsSymlinkMappingInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsSymlinkMappingInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsSymlinkMappingInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model cifs_symlink_mapping_inline_svm
*/
type CifsSymlinkMappingInlineSvm struct {

	// links
	Links *models.CifsSymlinkMappingInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cifs symlink mapping inline svm
func (o *CifsSymlinkMappingInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsSymlinkMappingInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs symlink mapping inline svm based on the context it is used
func (o *CifsSymlinkMappingInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsSymlinkMappingInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsSymlinkMappingInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsSymlinkMappingInlineSvm) UnmarshalBinary(b []byte) error {
	var res CifsSymlinkMappingInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsSymlinkMappingInlineSvmInlineLinks cifs symlink mapping inline svm inline links
swagger:model cifs_symlink_mapping_inline_svm_inline__links
*/
type CifsSymlinkMappingInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cifs symlink mapping inline svm inline links
func (o *CifsSymlinkMappingInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsSymlinkMappingInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs symlink mapping inline svm inline links based on the context it is used
func (o *CifsSymlinkMappingInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsSymlinkMappingInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsSymlinkMappingInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsSymlinkMappingInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsSymlinkMappingInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
