// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CifsSymlinkMappingModifyReader is a Reader for the CifsSymlinkMappingModify structure.
type CifsSymlinkMappingModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CifsSymlinkMappingModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCifsSymlinkMappingModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCifsSymlinkMappingModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCifsSymlinkMappingModifyOK creates a CifsSymlinkMappingModifyOK with default headers values
func NewCifsSymlinkMappingModifyOK() *CifsSymlinkMappingModifyOK {
	return &CifsSymlinkMappingModifyOK{}
}

/*
CifsSymlinkMappingModifyOK describes a response with status code 200, with default header values.

OK
*/
type CifsSymlinkMappingModifyOK struct {
}

// IsSuccess returns true when this cifs symlink mapping modify o k response has a 2xx status code
func (o *CifsSymlinkMappingModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cifs symlink mapping modify o k response has a 3xx status code
func (o *CifsSymlinkMappingModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cifs symlink mapping modify o k response has a 4xx status code
func (o *CifsSymlinkMappingModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cifs symlink mapping modify o k response has a 5xx status code
func (o *CifsSymlinkMappingModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cifs symlink mapping modify o k response a status code equal to that given
func (o *CifsSymlinkMappingModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cifs symlink mapping modify o k response
func (o *CifsSymlinkMappingModifyOK) Code() int {
	return 200
}

func (o *CifsSymlinkMappingModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/cifs/unix-symlink-mapping/{svm.uuid}/{unix_path}][%d] cifsSymlinkMappingModifyOK", 200)
}

func (o *CifsSymlinkMappingModifyOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/cifs/unix-symlink-mapping/{svm.uuid}/{unix_path}][%d] cifsSymlinkMappingModifyOK", 200)
}

func (o *CifsSymlinkMappingModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewCifsSymlinkMappingModifyDefault creates a CifsSymlinkMappingModifyDefault with default headers values
func NewCifsSymlinkMappingModifyDefault(code int) *CifsSymlinkMappingModifyDefault {
	return &CifsSymlinkMappingModifyDefault{
		_statusCode: code,
	}
}

/*
	CifsSymlinkMappingModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 655437     | Failed to modify the symlink mapping with locality "local" because the target share does not exist for the specified SVM |
| 655573     | Failed to modify the symlink mapping to target path because it contains illegal characters or is too long |
| 655575     | Failed to modify the symlink mapping to target server because it contains illegal characters or is too long |
| 655547     | Failed to modify symlink mapping because administrative share cannot be used as target share |
| 656481     | Failed to modify the widelink because the target share does not exist for the specified SVM |
*/
type CifsSymlinkMappingModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cifs symlink mapping modify default response has a 2xx status code
func (o *CifsSymlinkMappingModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cifs symlink mapping modify default response has a 3xx status code
func (o *CifsSymlinkMappingModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cifs symlink mapping modify default response has a 4xx status code
func (o *CifsSymlinkMappingModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cifs symlink mapping modify default response has a 5xx status code
func (o *CifsSymlinkMappingModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cifs symlink mapping modify default response a status code equal to that given
func (o *CifsSymlinkMappingModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cifs symlink mapping modify default response
func (o *CifsSymlinkMappingModifyDefault) Code() int {
	return o._statusCode
}

func (o *CifsSymlinkMappingModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/unix-symlink-mapping/{svm.uuid}/{unix_path}][%d] cifs_symlink_mapping_modify default %s", o._statusCode, payload)
}

func (o *CifsSymlinkMappingModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/unix-symlink-mapping/{svm.uuid}/{unix_path}][%d] cifs_symlink_mapping_modify default %s", o._statusCode, payload)
}

func (o *CifsSymlinkMappingModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CifsSymlinkMappingModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
