// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ClientLockDeleteCollectionReader is a Reader for the ClientLockDeleteCollection structure.
type ClientLockDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ClientLockDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewClientLockDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewClientLockDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewClientLockDeleteCollectionOK creates a ClientLockDeleteCollectionOK with default headers values
func NewClientLockDeleteCollectionOK() *ClientLockDeleteCollectionOK {
	return &ClientLockDeleteCollectionOK{}
}

/*
ClientLockDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ClientLockDeleteCollectionOK struct {
}

// IsSuccess returns true when this client lock delete collection o k response has a 2xx status code
func (o *ClientLockDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this client lock delete collection o k response has a 3xx status code
func (o *ClientLockDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this client lock delete collection o k response has a 4xx status code
func (o *ClientLockDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this client lock delete collection o k response has a 5xx status code
func (o *ClientLockDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this client lock delete collection o k response a status code equal to that given
func (o *ClientLockDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the client lock delete collection o k response
func (o *ClientLockDeleteCollectionOK) Code() int {
	return 200
}

func (o *ClientLockDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/locks][%d] clientLockDeleteCollectionOK", 200)
}

func (o *ClientLockDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/locks][%d] clientLockDeleteCollectionOK", 200)
}

func (o *ClientLockDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewClientLockDeleteCollectionDefault creates a ClientLockDeleteCollectionDefault with default headers values
func NewClientLockDeleteCollectionDefault(code int) *ClientLockDeleteCollectionDefault {
	return &ClientLockDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
ClientLockDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type ClientLockDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this client lock delete collection default response has a 2xx status code
func (o *ClientLockDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this client lock delete collection default response has a 3xx status code
func (o *ClientLockDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this client lock delete collection default response has a 4xx status code
func (o *ClientLockDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this client lock delete collection default response has a 5xx status code
func (o *ClientLockDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this client lock delete collection default response a status code equal to that given
func (o *ClientLockDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the client lock delete collection default response
func (o *ClientLockDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ClientLockDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/locks][%d] client_lock_delete_collection default %s", o._statusCode, payload)
}

func (o *ClientLockDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/locks][%d] client_lock_delete_collection default %s", o._statusCode, payload)
}

func (o *ClientLockDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ClientLockDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ClientLockDeleteCollectionBody client lock delete collection body
swagger:model ClientLockDeleteCollectionBody
*/
type ClientLockDeleteCollectionBody struct {

	// client lock response inline records
	ClientLockResponseInlineRecords []*models.ClientLock `json:"records,omitempty"`
}

// Validate validates this client lock delete collection body
func (o *ClientLockDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateClientLockResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClientLockDeleteCollectionBody) validateClientLockResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ClientLockResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ClientLockResponseInlineRecords); i++ {
		if swag.IsZero(o.ClientLockResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ClientLockResponseInlineRecords[i] != nil {
			if err := o.ClientLockResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this client lock delete collection body based on the context it is used
func (o *ClientLockDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateClientLockResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClientLockDeleteCollectionBody) contextValidateClientLockResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ClientLockResponseInlineRecords); i++ {

		if o.ClientLockResponseInlineRecords[i] != nil {
			if err := o.ClientLockResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ClientLockDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ClientLockDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res ClientLockDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
