// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ClientLockGetReader is a Reader for the ClientLockGet structure.
type ClientLockGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ClientLockGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewClientLockGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewClientLockGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewClientLockGetOK creates a ClientLockGetOK with default headers values
func NewClientLockGetOK() *ClientLockGetOK {
	return &ClientLockGetOK{}
}

/*
ClientLockGetOK describes a response with status code 200, with default header values.

OK
*/
type ClientLockGetOK struct {
	Payload *models.ClientLock
}

// IsSuccess returns true when this client lock get o k response has a 2xx status code
func (o *ClientLockGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this client lock get o k response has a 3xx status code
func (o *ClientLockGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this client lock get o k response has a 4xx status code
func (o *ClientLockGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this client lock get o k response has a 5xx status code
func (o *ClientLockGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this client lock get o k response a status code equal to that given
func (o *ClientLockGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the client lock get o k response
func (o *ClientLockGetOK) Code() int {
	return 200
}

func (o *ClientLockGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/locks/{uuid}][%d] clientLockGetOK %s", 200, payload)
}

func (o *ClientLockGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/locks/{uuid}][%d] clientLockGetOK %s", 200, payload)
}

func (o *ClientLockGetOK) GetPayload() *models.ClientLock {
	return o.Payload
}

func (o *ClientLockGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ClientLock)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewClientLockGetDefault creates a ClientLockGetDefault with default headers values
func NewClientLockGetDefault(code int) *ClientLockGetDefault {
	return &ClientLockGetDefault{
		_statusCode: code,
	}
}

/*
ClientLockGetDefault describes a response with status code -1, with default header values.

Error
*/
type ClientLockGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this client lock get default response has a 2xx status code
func (o *ClientLockGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this client lock get default response has a 3xx status code
func (o *ClientLockGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this client lock get default response has a 4xx status code
func (o *ClientLockGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this client lock get default response has a 5xx status code
func (o *ClientLockGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this client lock get default response a status code equal to that given
func (o *ClientLockGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the client lock get default response
func (o *ClientLockGetDefault) Code() int {
	return o._statusCode
}

func (o *ClientLockGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/locks/{uuid}][%d] client_lock_get default %s", o._statusCode, payload)
}

func (o *ClientLockGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/locks/{uuid}][%d] client_lock_get default %s", o._statusCode, payload)
}

func (o *ClientLockGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ClientLockGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
