// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewExportPolicyCollectionGetParams creates a new ExportPolicyCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewExportPolicyCollectionGetParams() *ExportPolicyCollectionGetParams {
	return &ExportPolicyCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewExportPolicyCollectionGetParamsWithTimeout creates a new ExportPolicyCollectionGetParams object
// with the ability to set a timeout on a request.
func NewExportPolicyCollectionGetParamsWithTimeout(timeout time.Duration) *ExportPolicyCollectionGetParams {
	return &ExportPolicyCollectionGetParams{
		timeout: timeout,
	}
}

// NewExportPolicyCollectionGetParamsWithContext creates a new ExportPolicyCollectionGetParams object
// with the ability to set a context for a request.
func NewExportPolicyCollectionGetParamsWithContext(ctx context.Context) *ExportPolicyCollectionGetParams {
	return &ExportPolicyCollectionGetParams{
		Context: ctx,
	}
}

// NewExportPolicyCollectionGetParamsWithHTTPClient creates a new ExportPolicyCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewExportPolicyCollectionGetParamsWithHTTPClient(client *http.Client) *ExportPolicyCollectionGetParams {
	return &ExportPolicyCollectionGetParams{
		HTTPClient: client,
	}
}

/*
ExportPolicyCollectionGetParams contains all the parameters to send to the API endpoint

	for the export policy collection get operation.

	Typically these are written to a http.Request.
*/
type ExportPolicyCollectionGetParams struct {

	/* AreRulesTruncated.

	   Filter by are_rules_truncated
	*/
	AreRulesTruncated *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* ID.

	   Filter by id
	*/
	ID *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* RulesAllowDeviceCreation.

	   Filter by rules.allow_device_creation
	*/
	RulesAllowDeviceCreation *bool

	/* RulesAllowSuid.

	   Filter by rules.allow_suid
	*/
	RulesAllowSuid *bool

	/* RulesAnonymousUser.

	   Filter by rules.anonymous_user
	*/
	RulesAnonymousUser *string

	/* RulesChownMode.

	   Filter by rules.chown_mode
	*/
	RulesChownMode *string

	/* RulesClientsMatch.

	   Filter by rules.clients.match
	*/
	RulesClientsMatch *string

	/* RulesIndex.

	   Filter by rules.index
	*/
	RulesIndex *int64

	/* RulesNtfsUnixSecurity.

	   Filter by rules.ntfs_unix_security
	*/
	RulesNtfsUnixSecurity *string

	/* RulesProtocols.

	   Filter by rules.protocols
	*/
	RulesProtocols *string

	/* RulesRoRule.

	   Filter by rules.ro_rule
	*/
	RulesRoRule *string

	/* RulesRwRule.

	   Filter by rules.rw_rule
	*/
	RulesRwRule *string

	/* RulesSuperuser.

	   Filter by rules.superuser
	*/
	RulesSuperuser *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the export policy collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ExportPolicyCollectionGetParams) WithDefaults() *ExportPolicyCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the export policy collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ExportPolicyCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := ExportPolicyCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithTimeout(timeout time.Duration) *ExportPolicyCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithContext(ctx context.Context) *ExportPolicyCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithHTTPClient(client *http.Client) *ExportPolicyCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAreRulesTruncated adds the areRulesTruncated to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithAreRulesTruncated(areRulesTruncated *bool) *ExportPolicyCollectionGetParams {
	o.SetAreRulesTruncated(areRulesTruncated)
	return o
}

// SetAreRulesTruncated adds the areRulesTruncated to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetAreRulesTruncated(areRulesTruncated *bool) {
	o.AreRulesTruncated = areRulesTruncated
}

// WithFields adds the fields to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithFields(fields []string) *ExportPolicyCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithID adds the id to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithID(id *int64) *ExportPolicyCollectionGetParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetID(id *int64) {
	o.ID = id
}

// WithMaxRecords adds the maxRecords to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithMaxRecords(maxRecords *int64) *ExportPolicyCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithName(name *string) *ExportPolicyCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithOrderBy(orderBy []string) *ExportPolicyCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithReturnRecords(returnRecords *bool) *ExportPolicyCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *ExportPolicyCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithRulesAllowDeviceCreation adds the rulesAllowDeviceCreation to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithRulesAllowDeviceCreation(rulesAllowDeviceCreation *bool) *ExportPolicyCollectionGetParams {
	o.SetRulesAllowDeviceCreation(rulesAllowDeviceCreation)
	return o
}

// SetRulesAllowDeviceCreation adds the rulesAllowDeviceCreation to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetRulesAllowDeviceCreation(rulesAllowDeviceCreation *bool) {
	o.RulesAllowDeviceCreation = rulesAllowDeviceCreation
}

// WithRulesAllowSuid adds the rulesAllowSuid to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithRulesAllowSuid(rulesAllowSuid *bool) *ExportPolicyCollectionGetParams {
	o.SetRulesAllowSuid(rulesAllowSuid)
	return o
}

// SetRulesAllowSuid adds the rulesAllowSuid to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetRulesAllowSuid(rulesAllowSuid *bool) {
	o.RulesAllowSuid = rulesAllowSuid
}

// WithRulesAnonymousUser adds the rulesAnonymousUser to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithRulesAnonymousUser(rulesAnonymousUser *string) *ExportPolicyCollectionGetParams {
	o.SetRulesAnonymousUser(rulesAnonymousUser)
	return o
}

// SetRulesAnonymousUser adds the rulesAnonymousUser to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetRulesAnonymousUser(rulesAnonymousUser *string) {
	o.RulesAnonymousUser = rulesAnonymousUser
}

// WithRulesChownMode adds the rulesChownMode to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithRulesChownMode(rulesChownMode *string) *ExportPolicyCollectionGetParams {
	o.SetRulesChownMode(rulesChownMode)
	return o
}

// SetRulesChownMode adds the rulesChownMode to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetRulesChownMode(rulesChownMode *string) {
	o.RulesChownMode = rulesChownMode
}

// WithRulesClientsMatch adds the rulesClientsMatch to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithRulesClientsMatch(rulesClientsMatch *string) *ExportPolicyCollectionGetParams {
	o.SetRulesClientsMatch(rulesClientsMatch)
	return o
}

// SetRulesClientsMatch adds the rulesClientsMatch to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetRulesClientsMatch(rulesClientsMatch *string) {
	o.RulesClientsMatch = rulesClientsMatch
}

// WithRulesIndex adds the rulesIndex to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithRulesIndex(rulesIndex *int64) *ExportPolicyCollectionGetParams {
	o.SetRulesIndex(rulesIndex)
	return o
}

// SetRulesIndex adds the rulesIndex to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetRulesIndex(rulesIndex *int64) {
	o.RulesIndex = rulesIndex
}

// WithRulesNtfsUnixSecurity adds the rulesNtfsUnixSecurity to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithRulesNtfsUnixSecurity(rulesNtfsUnixSecurity *string) *ExportPolicyCollectionGetParams {
	o.SetRulesNtfsUnixSecurity(rulesNtfsUnixSecurity)
	return o
}

// SetRulesNtfsUnixSecurity adds the rulesNtfsUnixSecurity to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetRulesNtfsUnixSecurity(rulesNtfsUnixSecurity *string) {
	o.RulesNtfsUnixSecurity = rulesNtfsUnixSecurity
}

// WithRulesProtocols adds the rulesProtocols to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithRulesProtocols(rulesProtocols *string) *ExportPolicyCollectionGetParams {
	o.SetRulesProtocols(rulesProtocols)
	return o
}

// SetRulesProtocols adds the rulesProtocols to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetRulesProtocols(rulesProtocols *string) {
	o.RulesProtocols = rulesProtocols
}

// WithRulesRoRule adds the rulesRoRule to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithRulesRoRule(rulesRoRule *string) *ExportPolicyCollectionGetParams {
	o.SetRulesRoRule(rulesRoRule)
	return o
}

// SetRulesRoRule adds the rulesRoRule to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetRulesRoRule(rulesRoRule *string) {
	o.RulesRoRule = rulesRoRule
}

// WithRulesRwRule adds the rulesRwRule to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithRulesRwRule(rulesRwRule *string) *ExportPolicyCollectionGetParams {
	o.SetRulesRwRule(rulesRwRule)
	return o
}

// SetRulesRwRule adds the rulesRwRule to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetRulesRwRule(rulesRwRule *string) {
	o.RulesRwRule = rulesRwRule
}

// WithRulesSuperuser adds the rulesSuperuser to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithRulesSuperuser(rulesSuperuser *string) *ExportPolicyCollectionGetParams {
	o.SetRulesSuperuser(rulesSuperuser)
	return o
}

// SetRulesSuperuser adds the rulesSuperuser to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetRulesSuperuser(rulesSuperuser *string) {
	o.RulesSuperuser = rulesSuperuser
}

// WithSvmName adds the svmName to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithSvmName(svmName *string) *ExportPolicyCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) WithSvmUUID(svmUUID *string) *ExportPolicyCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the export policy collection get params
func (o *ExportPolicyCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *ExportPolicyCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AreRulesTruncated != nil {

		// query param are_rules_truncated
		var qrAreRulesTruncated bool

		if o.AreRulesTruncated != nil {
			qrAreRulesTruncated = *o.AreRulesTruncated
		}
		qAreRulesTruncated := swag.FormatBool(qrAreRulesTruncated)
		if qAreRulesTruncated != "" {

			if err := r.SetQueryParam("are_rules_truncated", qAreRulesTruncated); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.ID != nil {

		// query param id
		var qrID int64

		if o.ID != nil {
			qrID = *o.ID
		}
		qID := swag.FormatInt64(qrID)
		if qID != "" {

			if err := r.SetQueryParam("id", qID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.RulesAllowDeviceCreation != nil {

		// query param rules.allow_device_creation
		var qrRulesAllowDeviceCreation bool

		if o.RulesAllowDeviceCreation != nil {
			qrRulesAllowDeviceCreation = *o.RulesAllowDeviceCreation
		}
		qRulesAllowDeviceCreation := swag.FormatBool(qrRulesAllowDeviceCreation)
		if qRulesAllowDeviceCreation != "" {

			if err := r.SetQueryParam("rules.allow_device_creation", qRulesAllowDeviceCreation); err != nil {
				return err
			}
		}
	}

	if o.RulesAllowSuid != nil {

		// query param rules.allow_suid
		var qrRulesAllowSuid bool

		if o.RulesAllowSuid != nil {
			qrRulesAllowSuid = *o.RulesAllowSuid
		}
		qRulesAllowSuid := swag.FormatBool(qrRulesAllowSuid)
		if qRulesAllowSuid != "" {

			if err := r.SetQueryParam("rules.allow_suid", qRulesAllowSuid); err != nil {
				return err
			}
		}
	}

	if o.RulesAnonymousUser != nil {

		// query param rules.anonymous_user
		var qrRulesAnonymousUser string

		if o.RulesAnonymousUser != nil {
			qrRulesAnonymousUser = *o.RulesAnonymousUser
		}
		qRulesAnonymousUser := qrRulesAnonymousUser
		if qRulesAnonymousUser != "" {

			if err := r.SetQueryParam("rules.anonymous_user", qRulesAnonymousUser); err != nil {
				return err
			}
		}
	}

	if o.RulesChownMode != nil {

		// query param rules.chown_mode
		var qrRulesChownMode string

		if o.RulesChownMode != nil {
			qrRulesChownMode = *o.RulesChownMode
		}
		qRulesChownMode := qrRulesChownMode
		if qRulesChownMode != "" {

			if err := r.SetQueryParam("rules.chown_mode", qRulesChownMode); err != nil {
				return err
			}
		}
	}

	if o.RulesClientsMatch != nil {

		// query param rules.clients.match
		var qrRulesClientsMatch string

		if o.RulesClientsMatch != nil {
			qrRulesClientsMatch = *o.RulesClientsMatch
		}
		qRulesClientsMatch := qrRulesClientsMatch
		if qRulesClientsMatch != "" {

			if err := r.SetQueryParam("rules.clients.match", qRulesClientsMatch); err != nil {
				return err
			}
		}
	}

	if o.RulesIndex != nil {

		// query param rules.index
		var qrRulesIndex int64

		if o.RulesIndex != nil {
			qrRulesIndex = *o.RulesIndex
		}
		qRulesIndex := swag.FormatInt64(qrRulesIndex)
		if qRulesIndex != "" {

			if err := r.SetQueryParam("rules.index", qRulesIndex); err != nil {
				return err
			}
		}
	}

	if o.RulesNtfsUnixSecurity != nil {

		// query param rules.ntfs_unix_security
		var qrRulesNtfsUnixSecurity string

		if o.RulesNtfsUnixSecurity != nil {
			qrRulesNtfsUnixSecurity = *o.RulesNtfsUnixSecurity
		}
		qRulesNtfsUnixSecurity := qrRulesNtfsUnixSecurity
		if qRulesNtfsUnixSecurity != "" {

			if err := r.SetQueryParam("rules.ntfs_unix_security", qRulesNtfsUnixSecurity); err != nil {
				return err
			}
		}
	}

	if o.RulesProtocols != nil {

		// query param rules.protocols
		var qrRulesProtocols string

		if o.RulesProtocols != nil {
			qrRulesProtocols = *o.RulesProtocols
		}
		qRulesProtocols := qrRulesProtocols
		if qRulesProtocols != "" {

			if err := r.SetQueryParam("rules.protocols", qRulesProtocols); err != nil {
				return err
			}
		}
	}

	if o.RulesRoRule != nil {

		// query param rules.ro_rule
		var qrRulesRoRule string

		if o.RulesRoRule != nil {
			qrRulesRoRule = *o.RulesRoRule
		}
		qRulesRoRule := qrRulesRoRule
		if qRulesRoRule != "" {

			if err := r.SetQueryParam("rules.ro_rule", qRulesRoRule); err != nil {
				return err
			}
		}
	}

	if o.RulesRwRule != nil {

		// query param rules.rw_rule
		var qrRulesRwRule string

		if o.RulesRwRule != nil {
			qrRulesRwRule = *o.RulesRwRule
		}
		qRulesRwRule := qrRulesRwRule
		if qRulesRwRule != "" {

			if err := r.SetQueryParam("rules.rw_rule", qRulesRwRule); err != nil {
				return err
			}
		}
	}

	if o.RulesSuperuser != nil {

		// query param rules.superuser
		var qrRulesSuperuser string

		if o.RulesSuperuser != nil {
			qrRulesSuperuser = *o.RulesSuperuser
		}
		qRulesSuperuser := qrRulesSuperuser
		if qRulesSuperuser != "" {

			if err := r.SetQueryParam("rules.superuser", qRulesSuperuser); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamExportPolicyCollectionGet binds the parameter fields
func (o *ExportPolicyCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamExportPolicyCollectionGet binds the parameter order_by
func (o *ExportPolicyCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
