// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewExportPolicyCreateParams creates a new ExportPolicyCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewExportPolicyCreateParams() *ExportPolicyCreateParams {
	return &ExportPolicyCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewExportPolicyCreateParamsWithTimeout creates a new ExportPolicyCreateParams object
// with the ability to set a timeout on a request.
func NewExportPolicyCreateParamsWithTimeout(timeout time.Duration) *ExportPolicyCreateParams {
	return &ExportPolicyCreateParams{
		timeout: timeout,
	}
}

// NewExportPolicyCreateParamsWithContext creates a new ExportPolicyCreateParams object
// with the ability to set a context for a request.
func NewExportPolicyCreateParamsWithContext(ctx context.Context) *ExportPolicyCreateParams {
	return &ExportPolicyCreateParams{
		Context: ctx,
	}
}

// NewExportPolicyCreateParamsWithHTTPClient creates a new ExportPolicyCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewExportPolicyCreateParamsWithHTTPClient(client *http.Client) *ExportPolicyCreateParams {
	return &ExportPolicyCreateParams{
		HTTPClient: client,
	}
}

/*
ExportPolicyCreateParams contains all the parameters to send to the API endpoint

	for the export policy create operation.

	Typically these are written to a http.Request.
*/
type ExportPolicyCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.ExportPolicy

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the export policy create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ExportPolicyCreateParams) WithDefaults() *ExportPolicyCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the export policy create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ExportPolicyCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := ExportPolicyCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the export policy create params
func (o *ExportPolicyCreateParams) WithTimeout(timeout time.Duration) *ExportPolicyCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the export policy create params
func (o *ExportPolicyCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the export policy create params
func (o *ExportPolicyCreateParams) WithContext(ctx context.Context) *ExportPolicyCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the export policy create params
func (o *ExportPolicyCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the export policy create params
func (o *ExportPolicyCreateParams) WithHTTPClient(client *http.Client) *ExportPolicyCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the export policy create params
func (o *ExportPolicyCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the export policy create params
func (o *ExportPolicyCreateParams) WithInfo(info *models.ExportPolicy) *ExportPolicyCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the export policy create params
func (o *ExportPolicyCreateParams) SetInfo(info *models.ExportPolicy) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the export policy create params
func (o *ExportPolicyCreateParams) WithReturnRecords(returnRecords *bool) *ExportPolicyCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the export policy create params
func (o *ExportPolicyCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *ExportPolicyCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
