// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ExportPolicyDeleteCollectionReader is a Reader for the ExportPolicyDeleteCollection structure.
type ExportPolicyDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ExportPolicyDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewExportPolicyDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewExportPolicyDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewExportPolicyDeleteCollectionOK creates a ExportPolicyDeleteCollectionOK with default headers values
func NewExportPolicyDeleteCollectionOK() *ExportPolicyDeleteCollectionOK {
	return &ExportPolicyDeleteCollectionOK{}
}

/*
ExportPolicyDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ExportPolicyDeleteCollectionOK struct {
}

// IsSuccess returns true when this export policy delete collection o k response has a 2xx status code
func (o *ExportPolicyDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this export policy delete collection o k response has a 3xx status code
func (o *ExportPolicyDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this export policy delete collection o k response has a 4xx status code
func (o *ExportPolicyDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this export policy delete collection o k response has a 5xx status code
func (o *ExportPolicyDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this export policy delete collection o k response a status code equal to that given
func (o *ExportPolicyDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the export policy delete collection o k response
func (o *ExportPolicyDeleteCollectionOK) Code() int {
	return 200
}

func (o *ExportPolicyDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/nfs/export-policies][%d] exportPolicyDeleteCollectionOK", 200)
}

func (o *ExportPolicyDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/nfs/export-policies][%d] exportPolicyDeleteCollectionOK", 200)
}

func (o *ExportPolicyDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewExportPolicyDeleteCollectionDefault creates a ExportPolicyDeleteCollectionDefault with default headers values
func NewExportPolicyDeleteCollectionDefault(code int) *ExportPolicyDeleteCollectionDefault {
	return &ExportPolicyDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	ExportPolicyDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1703944    | Failed to delete rule |
| 1703945    | Ruleset is in use by a volume.  It cannot be deleted until all volumes that refer to it are first deleted|
| 1703946    | Cannot determine if the ruleset is in use by a volume.  It cannot be deleted until all volumes that refer to it are first deleted|
| 1703947    | Cannot delete default ruleset.  This ruleset will be deleted when the owning Vserver is deleted|
| 1703952    | Invalid ruleset name provided. No spaces are allowed in a ruleset name|
| 1703953    | This ruleset is in use by a qtree export policy.  It cannot be deleted until all qtree policies that refer to it are first deleted|
| 1704047    | The export policy name cannot be longer than 256 characters |
*/
type ExportPolicyDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this export policy delete collection default response has a 2xx status code
func (o *ExportPolicyDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this export policy delete collection default response has a 3xx status code
func (o *ExportPolicyDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this export policy delete collection default response has a 4xx status code
func (o *ExportPolicyDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this export policy delete collection default response has a 5xx status code
func (o *ExportPolicyDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this export policy delete collection default response a status code equal to that given
func (o *ExportPolicyDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the export policy delete collection default response
func (o *ExportPolicyDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ExportPolicyDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nfs/export-policies][%d] export_policy_delete_collection default %s", o._statusCode, payload)
}

func (o *ExportPolicyDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nfs/export-policies][%d] export_policy_delete_collection default %s", o._statusCode, payload)
}

func (o *ExportPolicyDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ExportPolicyDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ExportPolicyDeleteCollectionBody export policy delete collection body
swagger:model ExportPolicyDeleteCollectionBody
*/
type ExportPolicyDeleteCollectionBody struct {

	// export policy response inline records
	ExportPolicyResponseInlineRecords []*models.ExportPolicy `json:"records,omitempty"`
}

// Validate validates this export policy delete collection body
func (o *ExportPolicyDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateExportPolicyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportPolicyDeleteCollectionBody) validateExportPolicyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ExportPolicyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ExportPolicyResponseInlineRecords); i++ {
		if swag.IsZero(o.ExportPolicyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ExportPolicyResponseInlineRecords[i] != nil {
			if err := o.ExportPolicyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this export policy delete collection body based on the context it is used
func (o *ExportPolicyDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateExportPolicyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportPolicyDeleteCollectionBody) contextValidateExportPolicyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ExportPolicyResponseInlineRecords); i++ {

		if o.ExportPolicyResponseInlineRecords[i] != nil {
			if err := o.ExportPolicyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ExportPolicyDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ExportPolicyDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res ExportPolicyDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
