// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ExportPolicyModifyCollectionReader is a Reader for the ExportPolicyModifyCollection structure.
type ExportPolicyModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ExportPolicyModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewExportPolicyModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewExportPolicyModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewExportPolicyModifyCollectionOK creates a ExportPolicyModifyCollectionOK with default headers values
func NewExportPolicyModifyCollectionOK() *ExportPolicyModifyCollectionOK {
	return &ExportPolicyModifyCollectionOK{}
}

/*
ExportPolicyModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ExportPolicyModifyCollectionOK struct {
}

// IsSuccess returns true when this export policy modify collection o k response has a 2xx status code
func (o *ExportPolicyModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this export policy modify collection o k response has a 3xx status code
func (o *ExportPolicyModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this export policy modify collection o k response has a 4xx status code
func (o *ExportPolicyModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this export policy modify collection o k response has a 5xx status code
func (o *ExportPolicyModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this export policy modify collection o k response a status code equal to that given
func (o *ExportPolicyModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the export policy modify collection o k response
func (o *ExportPolicyModifyCollectionOK) Code() int {
	return 200
}

func (o *ExportPolicyModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/nfs/export-policies][%d] exportPolicyModifyCollectionOK", 200)
}

func (o *ExportPolicyModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/nfs/export-policies][%d] exportPolicyModifyCollectionOK", 200)
}

func (o *ExportPolicyModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewExportPolicyModifyCollectionDefault creates a ExportPolicyModifyCollectionDefault with default headers values
func NewExportPolicyModifyCollectionDefault(code int) *ExportPolicyModifyCollectionDefault {
	return &ExportPolicyModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	ExportPolicyModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1703950    | Failed to rename ruleset |
| 1703952    | Invalid ruleset name provided. No spaces are allowed in a ruleset name|
| 1704036    | Invalid clientmatch:  missing domain name |
| 1704037    | Invalid clientmatch:  missing network name |
| 1704038    | Invalid clientmatch:  missing netgroup name |
| 1704039    | Invalid clientmatch |
| 1704040    | Invalid clientmatch: address bytes masked out by netmask are non-zero |
| 1704041    | Invalid clientmatch: address bytes masked to zero by netmask |
| 1704042    | Invalid clientmatch: too many bits in netmask |
| 1704043    | Invalid clientmatch: invalid netmask |
| 1704044    | Invalid clientmatch: invalid characters in host name |
| 1704045    | Invalid clientmatch: invalid characters in domain name |
| 1704047    | The export policy name cannot be longer than 256 characters |
| 1704050    | Invalid clientmatch: clientmatch list contains a duplicate string. Duplicate strings in a clientmatch list are not supported |
| 1704054    | Invalid clientmatch: invalid characters in netgroup name. Valid characters for a netgroup name are 0-9, A-Z, a-z, ".", "_" and "-" |
| 1704064    | Clientmatch host name too long |
| 1704065    | Clientmatch domain name too long |
| 3277000    | Upgrade all nodes to ONTAP 9.0.0 or above to use krb5p as a security flavor in export-policy rules |
| 3277083    | User ID is not valid. Enter a value for User ID from 0 to 4294967295 |
| 3277149    | The "Anon" field cannot be an empty string |
*/
type ExportPolicyModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this export policy modify collection default response has a 2xx status code
func (o *ExportPolicyModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this export policy modify collection default response has a 3xx status code
func (o *ExportPolicyModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this export policy modify collection default response has a 4xx status code
func (o *ExportPolicyModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this export policy modify collection default response has a 5xx status code
func (o *ExportPolicyModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this export policy modify collection default response a status code equal to that given
func (o *ExportPolicyModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the export policy modify collection default response
func (o *ExportPolicyModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ExportPolicyModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/nfs/export-policies][%d] export_policy_modify_collection default %s", o._statusCode, payload)
}

func (o *ExportPolicyModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/nfs/export-policies][%d] export_policy_modify_collection default %s", o._statusCode, payload)
}

func (o *ExportPolicyModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ExportPolicyModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ExportPolicyModifyCollectionBody export policy modify collection body
swagger:model ExportPolicyModifyCollectionBody
*/
type ExportPolicyModifyCollectionBody struct {

	// links
	Links *models.ExportPolicyInlineLinks `json:"_links,omitempty"`

	// Indicates whether or not export-policy rules are truncated.
	// Read Only: true
	AreRulesTruncated *bool `json:"are_rules_truncated,omitempty"`

	// Rules of the Export Policy.
	ExportPolicyInlineRules []*models.ExportRules `json:"rules,omitempty"`

	// export policy response inline records
	ExportPolicyResponseInlineRecords []*models.ExportPolicy `json:"records,omitempty"`

	// Export Policy ID
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// Export Policy Name
	// Max Length: 256
	Name *string `json:"name,omitempty"`

	// svm
	Svm *models.ExportPolicyInlineSvm `json:"svm,omitempty"`
}

// Validate validates this export policy modify collection body
func (o *ExportPolicyModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExportPolicyInlineRules(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExportPolicyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportPolicyModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ExportPolicyModifyCollectionBody) validateExportPolicyInlineRules(formats strfmt.Registry) error {
	if swag.IsZero(o.ExportPolicyInlineRules) { // not required
		return nil
	}

	for i := 0; i < len(o.ExportPolicyInlineRules); i++ {
		if swag.IsZero(o.ExportPolicyInlineRules[i]) { // not required
			continue
		}

		if o.ExportPolicyInlineRules[i] != nil {
			if err := o.ExportPolicyInlineRules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ExportPolicyModifyCollectionBody) validateExportPolicyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ExportPolicyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ExportPolicyResponseInlineRecords); i++ {
		if swag.IsZero(o.ExportPolicyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ExportPolicyResponseInlineRecords[i] != nil {
			if err := o.ExportPolicyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ExportPolicyModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 256); err != nil {
		return err
	}

	return nil
}

func (o *ExportPolicyModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this export policy modify collection body based on the context it is used
func (o *ExportPolicyModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAreRulesTruncated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExportPolicyInlineRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExportPolicyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportPolicyModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ExportPolicyModifyCollectionBody) contextValidateAreRulesTruncated(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"are_rules_truncated", "body", o.AreRulesTruncated); err != nil {
		return err
	}

	return nil
}

func (o *ExportPolicyModifyCollectionBody) contextValidateExportPolicyInlineRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ExportPolicyInlineRules); i++ {

		if o.ExportPolicyInlineRules[i] != nil {
			if err := o.ExportPolicyInlineRules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ExportPolicyModifyCollectionBody) contextValidateExportPolicyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ExportPolicyResponseInlineRecords); i++ {

		if o.ExportPolicyResponseInlineRecords[i] != nil {
			if err := o.ExportPolicyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ExportPolicyModifyCollectionBody) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"id", "body", o.ID); err != nil {
		return err
	}

	return nil
}

func (o *ExportPolicyModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ExportPolicyModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ExportPolicyModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res ExportPolicyModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ExportPolicyInlineLinks export policy inline links
swagger:model export_policy_inline__links
*/
type ExportPolicyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this export policy inline links
func (o *ExportPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this export policy inline links based on the context it is used
func (o *ExportPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ExportPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ExportPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res ExportPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ExportPolicyInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model export_policy_inline_svm
*/
type ExportPolicyInlineSvm struct {

	// links
	Links *models.ExportPolicyInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this export policy inline svm
func (o *ExportPolicyInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportPolicyInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this export policy inline svm based on the context it is used
func (o *ExportPolicyInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportPolicyInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ExportPolicyInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ExportPolicyInlineSvm) UnmarshalBinary(b []byte) error {
	var res ExportPolicyInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ExportPolicyInlineSvmInlineLinks export policy inline svm inline links
swagger:model export_policy_inline_svm_inline__links
*/
type ExportPolicyInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this export policy inline svm inline links
func (o *ExportPolicyInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportPolicyInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this export policy inline svm inline links based on the context it is used
func (o *ExportPolicyInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportPolicyInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ExportPolicyInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ExportPolicyInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res ExportPolicyInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
