// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ExportRuleClientsDeleteCollectionReader is a Reader for the ExportRuleClientsDeleteCollection structure.
type ExportRuleClientsDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ExportRuleClientsDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewExportRuleClientsDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewExportRuleClientsDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewExportRuleClientsDeleteCollectionOK creates a ExportRuleClientsDeleteCollectionOK with default headers values
func NewExportRuleClientsDeleteCollectionOK() *ExportRuleClientsDeleteCollectionOK {
	return &ExportRuleClientsDeleteCollectionOK{}
}

/*
ExportRuleClientsDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ExportRuleClientsDeleteCollectionOK struct {
}

// IsSuccess returns true when this export rule clients delete collection o k response has a 2xx status code
func (o *ExportRuleClientsDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this export rule clients delete collection o k response has a 3xx status code
func (o *ExportRuleClientsDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this export rule clients delete collection o k response has a 4xx status code
func (o *ExportRuleClientsDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this export rule clients delete collection o k response has a 5xx status code
func (o *ExportRuleClientsDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this export rule clients delete collection o k response a status code equal to that given
func (o *ExportRuleClientsDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the export rule clients delete collection o k response
func (o *ExportRuleClientsDeleteCollectionOK) Code() int {
	return 200
}

func (o *ExportRuleClientsDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/nfs/export-policies/{policy.id}/rules/{index}/clients][%d] exportRuleClientsDeleteCollectionOK", 200)
}

func (o *ExportRuleClientsDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/nfs/export-policies/{policy.id}/rules/{index}/clients][%d] exportRuleClientsDeleteCollectionOK", 200)
}

func (o *ExportRuleClientsDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewExportRuleClientsDeleteCollectionDefault creates a ExportRuleClientsDeleteCollectionDefault with default headers values
func NewExportRuleClientsDeleteCollectionDefault(code int) *ExportRuleClientsDeleteCollectionDefault {
	return &ExportRuleClientsDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	ExportRuleClientsDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1703954    | Export policy does not exist |
| 1704036    | Invalid clientmatch:  missing domain name |
| 1704037    | Invalid clientmatch:  missing network name |
| 1704038    | Invalid clientmatch:  missing netgroup name |
| 1704039    | Invalid clientmatch |
| 1704040    | Invalid clientmatch: address bytes masked out by netmask are non-zero |
| 1704041    | Invalid clientmatch: address bytes masked to zero by netmask |
| 1704042    | Invalid clientmatch: too many bits in netmask |
| 1704043    | Invalid clientmatch: invalid netmask |
| 1704044    | Invalid clientmatch: invalid characters in host name |
| 1704045    | Invalid clientmatch: invalid characters in domain name |
| 1704050    | Invalid clientmatch: the clientmatch list contains a duplicate string. Duplicate strings in a clientmatch list are not supported |
| 1704054    | Invalid clientmatch: invalid characters in netgroup name. Valid characters for a netgroup name are 0-9, A-Z, a-z, ".", "_" and "-" |
| 1704064    | Clientmatch host name too long |
| 1704065    | Clientmatch domain name too long |
| 6691623    | User is not authorized |
*/
type ExportRuleClientsDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this export rule clients delete collection default response has a 2xx status code
func (o *ExportRuleClientsDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this export rule clients delete collection default response has a 3xx status code
func (o *ExportRuleClientsDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this export rule clients delete collection default response has a 4xx status code
func (o *ExportRuleClientsDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this export rule clients delete collection default response has a 5xx status code
func (o *ExportRuleClientsDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this export rule clients delete collection default response a status code equal to that given
func (o *ExportRuleClientsDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the export rule clients delete collection default response
func (o *ExportRuleClientsDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ExportRuleClientsDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nfs/export-policies/{policy.id}/rules/{index}/clients][%d] export_rule_clients_delete_collection default %s", o._statusCode, payload)
}

func (o *ExportRuleClientsDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nfs/export-policies/{policy.id}/rules/{index}/clients][%d] export_rule_clients_delete_collection default %s", o._statusCode, payload)
}

func (o *ExportRuleClientsDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ExportRuleClientsDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ExportRuleClientsDeleteCollectionBody export rule clients delete collection body
swagger:model ExportRuleClientsDeleteCollectionBody
*/
type ExportRuleClientsDeleteCollectionBody struct {

	// export client response inline records
	ExportClientResponseInlineRecords []*models.ExportClient `json:"records,omitempty"`
}

// Validate validates this export rule clients delete collection body
func (o *ExportRuleClientsDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateExportClientResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportRuleClientsDeleteCollectionBody) validateExportClientResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ExportClientResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ExportClientResponseInlineRecords); i++ {
		if swag.IsZero(o.ExportClientResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ExportClientResponseInlineRecords[i] != nil {
			if err := o.ExportClientResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this export rule clients delete collection body based on the context it is used
func (o *ExportRuleClientsDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateExportClientResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportRuleClientsDeleteCollectionBody) contextValidateExportClientResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ExportClientResponseInlineRecords); i++ {

		if o.ExportClientResponseInlineRecords[i] != nil {
			if err := o.ExportClientResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ExportRuleClientsDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ExportRuleClientsDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res ExportRuleClientsDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
