// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ExportRuleClientsGetReader is a Reader for the ExportRuleClientsGet structure.
type ExportRuleClientsGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ExportRuleClientsGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewExportRuleClientsGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewExportRuleClientsGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewExportRuleClientsGetOK creates a ExportRuleClientsGetOK with default headers values
func NewExportRuleClientsGetOK() *ExportRuleClientsGetOK {
	return &ExportRuleClientsGetOK{}
}

/*
ExportRuleClientsGetOK describes a response with status code 200, with default header values.

OK
*/
type ExportRuleClientsGetOK struct {
	Payload *models.ExportClientResponse
}

// IsSuccess returns true when this export rule clients get o k response has a 2xx status code
func (o *ExportRuleClientsGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this export rule clients get o k response has a 3xx status code
func (o *ExportRuleClientsGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this export rule clients get o k response has a 4xx status code
func (o *ExportRuleClientsGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this export rule clients get o k response has a 5xx status code
func (o *ExportRuleClientsGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this export rule clients get o k response a status code equal to that given
func (o *ExportRuleClientsGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the export rule clients get o k response
func (o *ExportRuleClientsGetOK) Code() int {
	return 200
}

func (o *ExportRuleClientsGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/nfs/export-policies/{policy.id}/rules/{index}/clients][%d] exportRuleClientsGetOK %s", 200, payload)
}

func (o *ExportRuleClientsGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/nfs/export-policies/{policy.id}/rules/{index}/clients][%d] exportRuleClientsGetOK %s", 200, payload)
}

func (o *ExportRuleClientsGetOK) GetPayload() *models.ExportClientResponse {
	return o.Payload
}

func (o *ExportRuleClientsGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ExportClientResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewExportRuleClientsGetDefault creates a ExportRuleClientsGetDefault with default headers values
func NewExportRuleClientsGetDefault(code int) *ExportRuleClientsGetDefault {
	return &ExportRuleClientsGetDefault{
		_statusCode: code,
	}
}

/*
	ExportRuleClientsGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 6691623    | User is not authorized |
*/
type ExportRuleClientsGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this export rule clients get default response has a 2xx status code
func (o *ExportRuleClientsGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this export rule clients get default response has a 3xx status code
func (o *ExportRuleClientsGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this export rule clients get default response has a 4xx status code
func (o *ExportRuleClientsGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this export rule clients get default response has a 5xx status code
func (o *ExportRuleClientsGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this export rule clients get default response a status code equal to that given
func (o *ExportRuleClientsGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the export rule clients get default response
func (o *ExportRuleClientsGetDefault) Code() int {
	return o._statusCode
}

func (o *ExportRuleClientsGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/nfs/export-policies/{policy.id}/rules/{index}/clients][%d] export_rule_clients_get default %s", o._statusCode, payload)
}

func (o *ExportRuleClientsGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/nfs/export-policies/{policy.id}/rules/{index}/clients][%d] export_rule_clients_get default %s", o._statusCode, payload)
}

func (o *ExportRuleClientsGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ExportRuleClientsGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
