// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewExportRuleCreateParams creates a new ExportRuleCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewExportRuleCreateParams() *ExportRuleCreateParams {
	return &ExportRuleCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewExportRuleCreateParamsWithTimeout creates a new ExportRuleCreateParams object
// with the ability to set a timeout on a request.
func NewExportRuleCreateParamsWithTimeout(timeout time.Duration) *ExportRuleCreateParams {
	return &ExportRuleCreateParams{
		timeout: timeout,
	}
}

// NewExportRuleCreateParamsWithContext creates a new ExportRuleCreateParams object
// with the ability to set a context for a request.
func NewExportRuleCreateParamsWithContext(ctx context.Context) *ExportRuleCreateParams {
	return &ExportRuleCreateParams{
		Context: ctx,
	}
}

// NewExportRuleCreateParamsWithHTTPClient creates a new ExportRuleCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewExportRuleCreateParamsWithHTTPClient(client *http.Client) *ExportRuleCreateParams {
	return &ExportRuleCreateParams{
		HTTPClient: client,
	}
}

/*
ExportRuleCreateParams contains all the parameters to send to the API endpoint

	for the export rule create operation.

	Typically these are written to a http.Request.
*/
type ExportRuleCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.ExportRule

	/* PolicyID.

	   Export Policy ID
	*/
	PolicyID int64

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the export rule create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ExportRuleCreateParams) WithDefaults() *ExportRuleCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the export rule create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ExportRuleCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := ExportRuleCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the export rule create params
func (o *ExportRuleCreateParams) WithTimeout(timeout time.Duration) *ExportRuleCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the export rule create params
func (o *ExportRuleCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the export rule create params
func (o *ExportRuleCreateParams) WithContext(ctx context.Context) *ExportRuleCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the export rule create params
func (o *ExportRuleCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the export rule create params
func (o *ExportRuleCreateParams) WithHTTPClient(client *http.Client) *ExportRuleCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the export rule create params
func (o *ExportRuleCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the export rule create params
func (o *ExportRuleCreateParams) WithInfo(info *models.ExportRule) *ExportRuleCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the export rule create params
func (o *ExportRuleCreateParams) SetInfo(info *models.ExportRule) {
	o.Info = info
}

// WithPolicyID adds the policyID to the export rule create params
func (o *ExportRuleCreateParams) WithPolicyID(policyID int64) *ExportRuleCreateParams {
	o.SetPolicyID(policyID)
	return o
}

// SetPolicyID adds the policyId to the export rule create params
func (o *ExportRuleCreateParams) SetPolicyID(policyID int64) {
	o.PolicyID = policyID
}

// WithReturnRecords adds the returnRecords to the export rule create params
func (o *ExportRuleCreateParams) WithReturnRecords(returnRecords *bool) *ExportRuleCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the export rule create params
func (o *ExportRuleCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *ExportRuleCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param policy.id
	if err := r.SetPathParam("policy.id", swag.FormatInt64(o.PolicyID)); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
