// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ExportRuleDeleteCollectionReader is a Reader for the ExportRuleDeleteCollection structure.
type ExportRuleDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ExportRuleDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewExportRuleDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewExportRuleDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewExportRuleDeleteCollectionOK creates a ExportRuleDeleteCollectionOK with default headers values
func NewExportRuleDeleteCollectionOK() *ExportRuleDeleteCollectionOK {
	return &ExportRuleDeleteCollectionOK{}
}

/*
ExportRuleDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ExportRuleDeleteCollectionOK struct {
}

// IsSuccess returns true when this export rule delete collection o k response has a 2xx status code
func (o *ExportRuleDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this export rule delete collection o k response has a 3xx status code
func (o *ExportRuleDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this export rule delete collection o k response has a 4xx status code
func (o *ExportRuleDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this export rule delete collection o k response has a 5xx status code
func (o *ExportRuleDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this export rule delete collection o k response a status code equal to that given
func (o *ExportRuleDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the export rule delete collection o k response
func (o *ExportRuleDeleteCollectionOK) Code() int {
	return 200
}

func (o *ExportRuleDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/nfs/export-policies/{policy.id}/rules][%d] exportRuleDeleteCollectionOK", 200)
}

func (o *ExportRuleDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/nfs/export-policies/{policy.id}/rules][%d] exportRuleDeleteCollectionOK", 200)
}

func (o *ExportRuleDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewExportRuleDeleteCollectionDefault creates a ExportRuleDeleteCollectionDefault with default headers values
func NewExportRuleDeleteCollectionDefault(code int) *ExportRuleDeleteCollectionDefault {
	return &ExportRuleDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	ExportRuleDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1703945    | Ruleset is in use by a volume.  It cannot be deleted until all volumes that refer to it are first deleted|
| 1703946    | Cannot determine if the ruleset is in use by a volume.  It cannot be deleted until all volumes that refer to it are first deleted|
| 1703954    | Export policy does not exist |
*/
type ExportRuleDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this export rule delete collection default response has a 2xx status code
func (o *ExportRuleDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this export rule delete collection default response has a 3xx status code
func (o *ExportRuleDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this export rule delete collection default response has a 4xx status code
func (o *ExportRuleDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this export rule delete collection default response has a 5xx status code
func (o *ExportRuleDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this export rule delete collection default response a status code equal to that given
func (o *ExportRuleDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the export rule delete collection default response
func (o *ExportRuleDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ExportRuleDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nfs/export-policies/{policy.id}/rules][%d] export_rule_delete_collection default %s", o._statusCode, payload)
}

func (o *ExportRuleDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nfs/export-policies/{policy.id}/rules][%d] export_rule_delete_collection default %s", o._statusCode, payload)
}

func (o *ExportRuleDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ExportRuleDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ExportRuleDeleteCollectionBody export rule delete collection body
swagger:model ExportRuleDeleteCollectionBody
*/
type ExportRuleDeleteCollectionBody struct {

	// export rule response inline records
	ExportRuleResponseInlineRecords []*models.ExportRule `json:"records,omitempty"`
}

// Validate validates this export rule delete collection body
func (o *ExportRuleDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateExportRuleResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportRuleDeleteCollectionBody) validateExportRuleResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ExportRuleResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ExportRuleResponseInlineRecords); i++ {
		if swag.IsZero(o.ExportRuleResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ExportRuleResponseInlineRecords[i] != nil {
			if err := o.ExportRuleResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this export rule delete collection body based on the context it is used
func (o *ExportRuleDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateExportRuleResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportRuleDeleteCollectionBody) contextValidateExportRuleResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ExportRuleResponseInlineRecords); i++ {

		if o.ExportRuleResponseInlineRecords[i] != nil {
			if err := o.ExportRuleResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ExportRuleDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ExportRuleDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res ExportRuleDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
