// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ExportRuleGetReader is a Reader for the ExportRuleGet structure.
type ExportRuleGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ExportRuleGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewExportRuleGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewExportRuleGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewExportRuleGetOK creates a ExportRuleGetOK with default headers values
func NewExportRuleGetOK() *ExportRuleGetOK {
	return &ExportRuleGetOK{}
}

/*
ExportRuleGetOK describes a response with status code 200, with default header values.

OK
*/
type ExportRuleGetOK struct {
	Payload *models.ExportRule
}

// IsSuccess returns true when this export rule get o k response has a 2xx status code
func (o *ExportRuleGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this export rule get o k response has a 3xx status code
func (o *ExportRuleGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this export rule get o k response has a 4xx status code
func (o *ExportRuleGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this export rule get o k response has a 5xx status code
func (o *ExportRuleGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this export rule get o k response a status code equal to that given
func (o *ExportRuleGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the export rule get o k response
func (o *ExportRuleGetOK) Code() int {
	return 200
}

func (o *ExportRuleGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/nfs/export-policies/{policy.id}/rules/{index}][%d] exportRuleGetOK %s", 200, payload)
}

func (o *ExportRuleGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/nfs/export-policies/{policy.id}/rules/{index}][%d] exportRuleGetOK %s", 200, payload)
}

func (o *ExportRuleGetOK) GetPayload() *models.ExportRule {
	return o.Payload
}

func (o *ExportRuleGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ExportRule)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewExportRuleGetDefault creates a ExportRuleGetDefault with default headers values
func NewExportRuleGetDefault(code int) *ExportRuleGetDefault {
	return &ExportRuleGetDefault{
		_statusCode: code,
	}
}

/*
	ExportRuleGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262197     | The value provided is invalid for the field |
| 6691623    | User is not authorized |
*/
type ExportRuleGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this export rule get default response has a 2xx status code
func (o *ExportRuleGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this export rule get default response has a 3xx status code
func (o *ExportRuleGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this export rule get default response has a 4xx status code
func (o *ExportRuleGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this export rule get default response has a 5xx status code
func (o *ExportRuleGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this export rule get default response a status code equal to that given
func (o *ExportRuleGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the export rule get default response
func (o *ExportRuleGetDefault) Code() int {
	return o._statusCode
}

func (o *ExportRuleGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/nfs/export-policies/{policy.id}/rules/{index}][%d] export_rule_get default %s", o._statusCode, payload)
}

func (o *ExportRuleGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/nfs/export-policies/{policy.id}/rules/{index}][%d] export_rule_get default %s", o._statusCode, payload)
}

func (o *ExportRuleGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ExportRuleGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
