// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ExportRuleModifyCollectionReader is a Reader for the ExportRuleModifyCollection structure.
type ExportRuleModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ExportRuleModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewExportRuleModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewExportRuleModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewExportRuleModifyCollectionOK creates a ExportRuleModifyCollectionOK with default headers values
func NewExportRuleModifyCollectionOK() *ExportRuleModifyCollectionOK {
	return &ExportRuleModifyCollectionOK{}
}

/*
ExportRuleModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ExportRuleModifyCollectionOK struct {
}

// IsSuccess returns true when this export rule modify collection o k response has a 2xx status code
func (o *ExportRuleModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this export rule modify collection o k response has a 3xx status code
func (o *ExportRuleModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this export rule modify collection o k response has a 4xx status code
func (o *ExportRuleModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this export rule modify collection o k response has a 5xx status code
func (o *ExportRuleModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this export rule modify collection o k response a status code equal to that given
func (o *ExportRuleModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the export rule modify collection o k response
func (o *ExportRuleModifyCollectionOK) Code() int {
	return 200
}

func (o *ExportRuleModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/nfs/export-policies/{policy.id}/rules][%d] exportRuleModifyCollectionOK", 200)
}

func (o *ExportRuleModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/nfs/export-policies/{policy.id}/rules][%d] exportRuleModifyCollectionOK", 200)
}

func (o *ExportRuleModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewExportRuleModifyCollectionDefault creates a ExportRuleModifyCollectionDefault with default headers values
func NewExportRuleModifyCollectionDefault(code int) *ExportRuleModifyCollectionDefault {
	return &ExportRuleModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	ExportRuleModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262196     | Field 'svm.name' is not supported in the body of PATCH request |
| 262197     | The value provided is invalid for the field |
| 262203     | Field 'svm.uuid' is not supported in the body of PATCH request |
| 1703954    | Export policy does not exist |
| 1704036    | Invalid clientmatch:  missing domain name |
| 1704037    | Invalid clientmatch:  missing network name |
| 1704038    | Invalid clientmatch:  missing netgroup name |
| 1704039    | Invalid clientmatch |
| 1704040    | Invalid clientmatch: address bytes masked out by netmask are non-zero |
| 1704041    | Invalid clientmatch: address bytes masked to zero by netmask |
| 1704042    | Invalid clientmatch: too many bits in netmask |
| 1704043    | Invalid clientmatch: invalid netmask |
| 1704044    | Invalid clientmatch: invalid characters in host name |
| 1704045    | Invalid clientmatch: invalid characters in domain name |
| 1704050    | Invalid clientmatch: clientmatch list contains a duplicate string. Duplicate strings in a clientmatch list are not supported |
| 1704054    | Invalid clientmatch: invalid characters in netgroup name. Valid characters for a netgroup name are 0-9, A-Z, a-z, ".", "_" and "-" |
| 1704064    | Clientmatch host name too long |
| 1704065    | Clientmatch domain name too long |
| 3277000    | Upgrade all nodes to ONTAP 9.0.0 or above to use krb5p as a security flavor in export-policy rules |
| 3277083    | User ID is not valid. Enter a value for User ID from 0 to 4294967295 |
| 3277149    | The "Anon" field cannot be an empty string |
| 6691623    | User is not authorized |
*/
type ExportRuleModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this export rule modify collection default response has a 2xx status code
func (o *ExportRuleModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this export rule modify collection default response has a 3xx status code
func (o *ExportRuleModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this export rule modify collection default response has a 4xx status code
func (o *ExportRuleModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this export rule modify collection default response has a 5xx status code
func (o *ExportRuleModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this export rule modify collection default response a status code equal to that given
func (o *ExportRuleModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the export rule modify collection default response
func (o *ExportRuleModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ExportRuleModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/nfs/export-policies/{policy.id}/rules][%d] export_rule_modify_collection default %s", o._statusCode, payload)
}

func (o *ExportRuleModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/nfs/export-policies/{policy.id}/rules][%d] export_rule_modify_collection default %s", o._statusCode, payload)
}

func (o *ExportRuleModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ExportRuleModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ExportRuleModifyCollectionBody export rule modify collection body
swagger:model ExportRuleModifyCollectionBody
*/
type ExportRuleModifyCollectionBody struct {

	// links
	Links *models.ExportRuleInlineLinks `json:"_links,omitempty"`

	// Specifies whether or not device creation is allowed.
	AllowDeviceCreation *bool `json:"allow_device_creation,omitempty"`

	// Specifies whether or not SetUID bits in SETATTR Op is to be honored.
	AllowSuid *bool `json:"allow_suid,omitempty"`

	// User ID To Which Anonymous Users Are Mapped.
	AnonymousUser *string `json:"anonymous_user,omitempty"`

	// Specifies who is authorized to change the ownership mode of a file.
	// Enum: ["restricted","unrestricted"]
	ChownMode *string `json:"chown_mode,omitempty"`

	// Array of client matches
	ExportRuleInlineClients []*models.ExportClients `json:"clients,omitempty"`

	// Authentication flavors that the read-only access rule governs
	//
	ExportRuleInlineRoRule []*models.ExportAuthenticationFlavor `json:"ro_rule,omitempty"`

	// Authentication flavors that the read/write access rule governs
	//
	ExportRuleInlineRwRule []*models.ExportAuthenticationFlavor `json:"rw_rule,omitempty"`

	// Authentication flavors that the superuser security type governs
	//
	ExportRuleInlineSuperuser []*models.ExportAuthenticationFlavor `json:"superuser,omitempty"`

	// export rule response inline records
	ExportRuleResponseInlineRecords []*models.ExportRule `json:"records,omitempty"`

	// Index of the rule within the export policy.
	//
	Index *int64 `json:"index,omitempty"`

	// NTFS export UNIX security options.
	// Enum: ["fail","ignore"]
	NtfsUnixSecurity *string `json:"ntfs_unix_security,omitempty"`

	// policy
	Policy *models.ExportRuleInlinePolicy `json:"policy,omitempty"`

	// protocols
	Protocols []*string `json:"protocols,omitempty"`

	// svm
	Svm *models.ExportRuleInlineSvm `json:"svm,omitempty"`
}

// Validate validates this export rule modify collection body
func (o *ExportRuleModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateChownMode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExportRuleInlineClients(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExportRuleInlineRoRule(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExportRuleInlineRwRule(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExportRuleInlineSuperuser(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExportRuleResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNtfsUnixSecurity(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProtocols(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportRuleModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var exportRuleModifyCollectionBodyTypeChownModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["restricted","unrestricted"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		exportRuleModifyCollectionBodyTypeChownModePropEnum = append(exportRuleModifyCollectionBodyTypeChownModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ExportRuleModifyCollectionBody
	// ExportRuleModifyCollectionBody
	// chown_mode
	// ChownMode
	// restricted
	// END DEBUGGING
	// ExportRuleModifyCollectionBodyChownModeRestricted captures enum value "restricted"
	ExportRuleModifyCollectionBodyChownModeRestricted string = "restricted"

	// BEGIN DEBUGGING
	// ExportRuleModifyCollectionBody
	// ExportRuleModifyCollectionBody
	// chown_mode
	// ChownMode
	// unrestricted
	// END DEBUGGING
	// ExportRuleModifyCollectionBodyChownModeUnrestricted captures enum value "unrestricted"
	ExportRuleModifyCollectionBodyChownModeUnrestricted string = "unrestricted"
)

// prop value enum
func (o *ExportRuleModifyCollectionBody) validateChownModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, exportRuleModifyCollectionBodyTypeChownModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ExportRuleModifyCollectionBody) validateChownMode(formats strfmt.Registry) error {
	if swag.IsZero(o.ChownMode) { // not required
		return nil
	}

	// value enum
	if err := o.validateChownModeEnum("info"+"."+"chown_mode", "body", *o.ChownMode); err != nil {
		return err
	}

	return nil
}

func (o *ExportRuleModifyCollectionBody) validateExportRuleInlineClients(formats strfmt.Registry) error {
	if swag.IsZero(o.ExportRuleInlineClients) { // not required
		return nil
	}

	for i := 0; i < len(o.ExportRuleInlineClients); i++ {
		if swag.IsZero(o.ExportRuleInlineClients[i]) { // not required
			continue
		}

		if o.ExportRuleInlineClients[i] != nil {
			if err := o.ExportRuleInlineClients[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "clients" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ExportRuleModifyCollectionBody) validateExportRuleInlineRoRule(formats strfmt.Registry) error {
	if swag.IsZero(o.ExportRuleInlineRoRule) { // not required
		return nil
	}

	for i := 0; i < len(o.ExportRuleInlineRoRule); i++ {
		if swag.IsZero(o.ExportRuleInlineRoRule[i]) { // not required
			continue
		}

		if o.ExportRuleInlineRoRule[i] != nil {
			if err := o.ExportRuleInlineRoRule[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "ro_rule" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ExportRuleModifyCollectionBody) validateExportRuleInlineRwRule(formats strfmt.Registry) error {
	if swag.IsZero(o.ExportRuleInlineRwRule) { // not required
		return nil
	}

	for i := 0; i < len(o.ExportRuleInlineRwRule); i++ {
		if swag.IsZero(o.ExportRuleInlineRwRule[i]) { // not required
			continue
		}

		if o.ExportRuleInlineRwRule[i] != nil {
			if err := o.ExportRuleInlineRwRule[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "rw_rule" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ExportRuleModifyCollectionBody) validateExportRuleInlineSuperuser(formats strfmt.Registry) error {
	if swag.IsZero(o.ExportRuleInlineSuperuser) { // not required
		return nil
	}

	for i := 0; i < len(o.ExportRuleInlineSuperuser); i++ {
		if swag.IsZero(o.ExportRuleInlineSuperuser[i]) { // not required
			continue
		}

		if o.ExportRuleInlineSuperuser[i] != nil {
			if err := o.ExportRuleInlineSuperuser[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "superuser" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ExportRuleModifyCollectionBody) validateExportRuleResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ExportRuleResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ExportRuleResponseInlineRecords); i++ {
		if swag.IsZero(o.ExportRuleResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ExportRuleResponseInlineRecords[i] != nil {
			if err := o.ExportRuleResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var exportRuleModifyCollectionBodyTypeNtfsUnixSecurityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fail","ignore"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		exportRuleModifyCollectionBodyTypeNtfsUnixSecurityPropEnum = append(exportRuleModifyCollectionBodyTypeNtfsUnixSecurityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ExportRuleModifyCollectionBody
	// ExportRuleModifyCollectionBody
	// ntfs_unix_security
	// NtfsUnixSecurity
	// fail
	// END DEBUGGING
	// ExportRuleModifyCollectionBodyNtfsUnixSecurityFail captures enum value "fail"
	ExportRuleModifyCollectionBodyNtfsUnixSecurityFail string = "fail"

	// BEGIN DEBUGGING
	// ExportRuleModifyCollectionBody
	// ExportRuleModifyCollectionBody
	// ntfs_unix_security
	// NtfsUnixSecurity
	// ignore
	// END DEBUGGING
	// ExportRuleModifyCollectionBodyNtfsUnixSecurityIgnore captures enum value "ignore"
	ExportRuleModifyCollectionBodyNtfsUnixSecurityIgnore string = "ignore"
)

// prop value enum
func (o *ExportRuleModifyCollectionBody) validateNtfsUnixSecurityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, exportRuleModifyCollectionBodyTypeNtfsUnixSecurityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ExportRuleModifyCollectionBody) validateNtfsUnixSecurity(formats strfmt.Registry) error {
	if swag.IsZero(o.NtfsUnixSecurity) { // not required
		return nil
	}

	// value enum
	if err := o.validateNtfsUnixSecurityEnum("info"+"."+"ntfs_unix_security", "body", *o.NtfsUnixSecurity); err != nil {
		return err
	}

	return nil
}

func (o *ExportRuleModifyCollectionBody) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

var exportRuleModifyCollectionBodyProtocolsItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["any","nfs","nfs3","nfs4","cifs","flexcache"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		exportRuleModifyCollectionBodyProtocolsItemsEnum = append(exportRuleModifyCollectionBodyProtocolsItemsEnum, v)
	}
}

func (o *ExportRuleModifyCollectionBody) validateProtocolsItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, exportRuleModifyCollectionBodyProtocolsItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ExportRuleModifyCollectionBody) validateProtocols(formats strfmt.Registry) error {
	if swag.IsZero(o.Protocols) { // not required
		return nil
	}

	for i := 0; i < len(o.Protocols); i++ {
		if swag.IsZero(o.Protocols[i]) { // not required
			continue
		}

		// value enum
		if err := o.validateProtocolsItemsEnum("info"+"."+"protocols"+"."+strconv.Itoa(i), "body", *o.Protocols[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *ExportRuleModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this export rule modify collection body based on the context it is used
func (o *ExportRuleModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExportRuleInlineClients(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExportRuleInlineRoRule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExportRuleInlineRwRule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExportRuleInlineSuperuser(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExportRuleResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportRuleModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ExportRuleModifyCollectionBody) contextValidateExportRuleInlineClients(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ExportRuleInlineClients); i++ {

		if o.ExportRuleInlineClients[i] != nil {
			if err := o.ExportRuleInlineClients[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "clients" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ExportRuleModifyCollectionBody) contextValidateExportRuleInlineRoRule(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ExportRuleInlineRoRule); i++ {

		if o.ExportRuleInlineRoRule[i] != nil {
			if err := o.ExportRuleInlineRoRule[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "ro_rule" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ExportRuleModifyCollectionBody) contextValidateExportRuleInlineRwRule(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ExportRuleInlineRwRule); i++ {

		if o.ExportRuleInlineRwRule[i] != nil {
			if err := o.ExportRuleInlineRwRule[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "rw_rule" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ExportRuleModifyCollectionBody) contextValidateExportRuleInlineSuperuser(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ExportRuleInlineSuperuser); i++ {

		if o.ExportRuleInlineSuperuser[i] != nil {
			if err := o.ExportRuleInlineSuperuser[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "superuser" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ExportRuleModifyCollectionBody) contextValidateExportRuleResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ExportRuleResponseInlineRecords); i++ {

		if o.ExportRuleResponseInlineRecords[i] != nil {
			if err := o.ExportRuleResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ExportRuleModifyCollectionBody) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

func (o *ExportRuleModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ExportRuleModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ExportRuleModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res ExportRuleModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ExportRuleInlineLinks export rule inline links
swagger:model export_rule_inline__links
*/
type ExportRuleInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this export rule inline links
func (o *ExportRuleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportRuleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this export rule inline links based on the context it is used
func (o *ExportRuleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportRuleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ExportRuleInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ExportRuleInlineLinks) UnmarshalBinary(b []byte) error {
	var res ExportRuleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ExportRuleInlinePolicy export rule inline policy
swagger:model export_rule_inline_policy
*/
type ExportRuleInlinePolicy struct {

	// Export policy ID
	ID *int64 `json:"id,omitempty"`

	// Export policy name
	Name *string `json:"name,omitempty"`
}

// Validate validates this export rule inline policy
func (o *ExportRuleInlinePolicy) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this export rule inline policy based on context it is used
func (o *ExportRuleInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ExportRuleInlinePolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ExportRuleInlinePolicy) UnmarshalBinary(b []byte) error {
	var res ExportRuleInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ExportRuleInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model export_rule_inline_svm
*/
type ExportRuleInlineSvm struct {

	// links
	Links *models.ExportRuleInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this export rule inline svm
func (o *ExportRuleInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportRuleInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this export rule inline svm based on the context it is used
func (o *ExportRuleInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportRuleInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ExportRuleInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ExportRuleInlineSvm) UnmarshalBinary(b []byte) error {
	var res ExportRuleInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ExportRuleInlineSvmInlineLinks export rule inline svm inline links
swagger:model export_rule_inline_svm_inline__links
*/
type ExportRuleInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this export rule inline svm inline links
func (o *ExportRuleInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportRuleInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this export rule inline svm inline links based on the context it is used
func (o *ExportRuleInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ExportRuleInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ExportRuleInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ExportRuleInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res ExportRuleInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
