// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FileDirectorySecurityCreateReader is a Reader for the FileDirectorySecurityCreate structure.
type FileDirectorySecurityCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FileDirectorySecurityCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewFileDirectorySecurityCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewFileDirectorySecurityCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFileDirectorySecurityCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFileDirectorySecurityCreateCreated creates a FileDirectorySecurityCreateCreated with default headers values
func NewFileDirectorySecurityCreateCreated() *FileDirectorySecurityCreateCreated {
	return &FileDirectorySecurityCreateCreated{}
}

/*
FileDirectorySecurityCreateCreated describes a response with status code 201, with default header values.

Created
*/
type FileDirectorySecurityCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.FileDirectorySecurityJobLinkResponse
}

// IsSuccess returns true when this file directory security create created response has a 2xx status code
func (o *FileDirectorySecurityCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this file directory security create created response has a 3xx status code
func (o *FileDirectorySecurityCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this file directory security create created response has a 4xx status code
func (o *FileDirectorySecurityCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this file directory security create created response has a 5xx status code
func (o *FileDirectorySecurityCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this file directory security create created response a status code equal to that given
func (o *FileDirectorySecurityCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the file directory security create created response
func (o *FileDirectorySecurityCreateCreated) Code() int {
	return 201
}

func (o *FileDirectorySecurityCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/file-security/permissions/{svm.uuid}/{path}][%d] fileDirectorySecurityCreateCreated %s", 201, payload)
}

func (o *FileDirectorySecurityCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/file-security/permissions/{svm.uuid}/{path}][%d] fileDirectorySecurityCreateCreated %s", 201, payload)
}

func (o *FileDirectorySecurityCreateCreated) GetPayload() *models.FileDirectorySecurityJobLinkResponse {
	return o.Payload
}

func (o *FileDirectorySecurityCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.FileDirectorySecurityJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFileDirectorySecurityCreateAccepted creates a FileDirectorySecurityCreateAccepted with default headers values
func NewFileDirectorySecurityCreateAccepted() *FileDirectorySecurityCreateAccepted {
	return &FileDirectorySecurityCreateAccepted{}
}

/*
FileDirectorySecurityCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type FileDirectorySecurityCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.FileDirectorySecurityJobLinkResponse
}

// IsSuccess returns true when this file directory security create accepted response has a 2xx status code
func (o *FileDirectorySecurityCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this file directory security create accepted response has a 3xx status code
func (o *FileDirectorySecurityCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this file directory security create accepted response has a 4xx status code
func (o *FileDirectorySecurityCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this file directory security create accepted response has a 5xx status code
func (o *FileDirectorySecurityCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this file directory security create accepted response a status code equal to that given
func (o *FileDirectorySecurityCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the file directory security create accepted response
func (o *FileDirectorySecurityCreateAccepted) Code() int {
	return 202
}

func (o *FileDirectorySecurityCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/file-security/permissions/{svm.uuid}/{path}][%d] fileDirectorySecurityCreateAccepted %s", 202, payload)
}

func (o *FileDirectorySecurityCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/file-security/permissions/{svm.uuid}/{path}][%d] fileDirectorySecurityCreateAccepted %s", 202, payload)
}

func (o *FileDirectorySecurityCreateAccepted) GetPayload() *models.FileDirectorySecurityJobLinkResponse {
	return o.Payload
}

func (o *FileDirectorySecurityCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.FileDirectorySecurityJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFileDirectorySecurityCreateDefault creates a FileDirectorySecurityCreateDefault with default headers values
func NewFileDirectorySecurityCreateDefault(code int) *FileDirectorySecurityCreateDefault {
	return &FileDirectorySecurityCreateDefault{
		_statusCode: code,
	}
}

/*
	FileDirectorySecurityCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 655865     | The specified file or directory does not exist.|
| 10485813   | All values corresponding to rights cannot be false.|
| 10485815   | The field \"acls.access_control\" is not allowed with POST method.|
| 10485810   | User is a required field.|
| 1260882    | Specified SVM not found.|
| 6691623    | User is not authorized.|
| 4849676    | The specified Windows user or group does not exist.|
| 4849677    | Failed to convert SID to a Windows name. Reason: \"SecD Error: object not found\".|
| 10485814   | The value provided for field control_flags is invalid.|
| 10485813   | All values cannot be false.|
*/
type FileDirectorySecurityCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this file directory security create default response has a 2xx status code
func (o *FileDirectorySecurityCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this file directory security create default response has a 3xx status code
func (o *FileDirectorySecurityCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this file directory security create default response has a 4xx status code
func (o *FileDirectorySecurityCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this file directory security create default response has a 5xx status code
func (o *FileDirectorySecurityCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this file directory security create default response a status code equal to that given
func (o *FileDirectorySecurityCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the file directory security create default response
func (o *FileDirectorySecurityCreateDefault) Code() int {
	return o._statusCode
}

func (o *FileDirectorySecurityCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/file-security/permissions/{svm.uuid}/{path}][%d] file_directory_security_create default %s", o._statusCode, payload)
}

func (o *FileDirectorySecurityCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/file-security/permissions/{svm.uuid}/{path}][%d] file_directory_security_create default %s", o._statusCode, payload)
}

func (o *FileDirectorySecurityCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FileDirectorySecurityCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
