// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FileDirectorySecurityDeleteReader is a Reader for the FileDirectorySecurityDelete structure.
type FileDirectorySecurityDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FileDirectorySecurityDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFileDirectorySecurityDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFileDirectorySecurityDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFileDirectorySecurityDeleteOK creates a FileDirectorySecurityDeleteOK with default headers values
func NewFileDirectorySecurityDeleteOK() *FileDirectorySecurityDeleteOK {
	return &FileDirectorySecurityDeleteOK{}
}

/*
FileDirectorySecurityDeleteOK describes a response with status code 200, with default header values.

OK
*/
type FileDirectorySecurityDeleteOK struct {
}

// IsSuccess returns true when this file directory security delete o k response has a 2xx status code
func (o *FileDirectorySecurityDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this file directory security delete o k response has a 3xx status code
func (o *FileDirectorySecurityDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this file directory security delete o k response has a 4xx status code
func (o *FileDirectorySecurityDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this file directory security delete o k response has a 5xx status code
func (o *FileDirectorySecurityDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this file directory security delete o k response a status code equal to that given
func (o *FileDirectorySecurityDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the file directory security delete o k response
func (o *FileDirectorySecurityDeleteOK) Code() int {
	return 200
}

func (o *FileDirectorySecurityDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/file-security/permissions/{svm.uuid}/{path}][%d] fileDirectorySecurityDeleteOK", 200)
}

func (o *FileDirectorySecurityDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/file-security/permissions/{svm.uuid}/{path}][%d] fileDirectorySecurityDeleteOK", 200)
}

func (o *FileDirectorySecurityDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewFileDirectorySecurityDeleteDefault creates a FileDirectorySecurityDeleteDefault with default headers values
func NewFileDirectorySecurityDeleteDefault(code int) *FileDirectorySecurityDeleteDefault {
	return &FileDirectorySecurityDeleteDefault{
		_statusCode: code,
	}
}

/*
	FileDirectorySecurityDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 655865     | The specified file or directory does not exist.|
| 10485811   | Access is a required field.|
| 1260882    | Specified SVM not found.|
| 6691623    | User is not authorized.|
*/
type FileDirectorySecurityDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this file directory security delete default response has a 2xx status code
func (o *FileDirectorySecurityDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this file directory security delete default response has a 3xx status code
func (o *FileDirectorySecurityDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this file directory security delete default response has a 4xx status code
func (o *FileDirectorySecurityDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this file directory security delete default response has a 5xx status code
func (o *FileDirectorySecurityDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this file directory security delete default response a status code equal to that given
func (o *FileDirectorySecurityDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the file directory security delete default response
func (o *FileDirectorySecurityDeleteDefault) Code() int {
	return o._statusCode
}

func (o *FileDirectorySecurityDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/file-security/permissions/{svm.uuid}/{path}][%d] file_directory_security_delete default %s", o._statusCode, payload)
}

func (o *FileDirectorySecurityDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/file-security/permissions/{svm.uuid}/{path}][%d] file_directory_security_delete default %s", o._statusCode, payload)
}

func (o *FileDirectorySecurityDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FileDirectorySecurityDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
