// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFileDirectorySecurityGetParams creates a new FileDirectorySecurityGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFileDirectorySecurityGetParams() *FileDirectorySecurityGetParams {
	return &FileDirectorySecurityGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFileDirectorySecurityGetParamsWithTimeout creates a new FileDirectorySecurityGetParams object
// with the ability to set a timeout on a request.
func NewFileDirectorySecurityGetParamsWithTimeout(timeout time.Duration) *FileDirectorySecurityGetParams {
	return &FileDirectorySecurityGetParams{
		timeout: timeout,
	}
}

// NewFileDirectorySecurityGetParamsWithContext creates a new FileDirectorySecurityGetParams object
// with the ability to set a context for a request.
func NewFileDirectorySecurityGetParamsWithContext(ctx context.Context) *FileDirectorySecurityGetParams {
	return &FileDirectorySecurityGetParams{
		Context: ctx,
	}
}

// NewFileDirectorySecurityGetParamsWithHTTPClient creates a new FileDirectorySecurityGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewFileDirectorySecurityGetParamsWithHTTPClient(client *http.Client) *FileDirectorySecurityGetParams {
	return &FileDirectorySecurityGetParams{
		HTTPClient: client,
	}
}

/*
FileDirectorySecurityGetParams contains all the parameters to send to the API endpoint

	for the file directory security get operation.

	Typically these are written to a http.Request.
*/
type FileDirectorySecurityGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* LookupNames.

	   Translate security identifiers into names.
	*/
	LookupNames *bool

	/* Path.

	   target path
	*/
	Path string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the file directory security get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FileDirectorySecurityGetParams) WithDefaults() *FileDirectorySecurityGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the file directory security get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FileDirectorySecurityGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the file directory security get params
func (o *FileDirectorySecurityGetParams) WithTimeout(timeout time.Duration) *FileDirectorySecurityGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the file directory security get params
func (o *FileDirectorySecurityGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the file directory security get params
func (o *FileDirectorySecurityGetParams) WithContext(ctx context.Context) *FileDirectorySecurityGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the file directory security get params
func (o *FileDirectorySecurityGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the file directory security get params
func (o *FileDirectorySecurityGetParams) WithHTTPClient(client *http.Client) *FileDirectorySecurityGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the file directory security get params
func (o *FileDirectorySecurityGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the file directory security get params
func (o *FileDirectorySecurityGetParams) WithFields(fields []string) *FileDirectorySecurityGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the file directory security get params
func (o *FileDirectorySecurityGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithLookupNames adds the lookupNames to the file directory security get params
func (o *FileDirectorySecurityGetParams) WithLookupNames(lookupNames *bool) *FileDirectorySecurityGetParams {
	o.SetLookupNames(lookupNames)
	return o
}

// SetLookupNames adds the lookupNames to the file directory security get params
func (o *FileDirectorySecurityGetParams) SetLookupNames(lookupNames *bool) {
	o.LookupNames = lookupNames
}

// WithPath adds the path to the file directory security get params
func (o *FileDirectorySecurityGetParams) WithPath(path string) *FileDirectorySecurityGetParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the file directory security get params
func (o *FileDirectorySecurityGetParams) SetPath(path string) {
	o.Path = path
}

// WithSvmUUID adds the svmUUID to the file directory security get params
func (o *FileDirectorySecurityGetParams) WithSvmUUID(svmUUID string) *FileDirectorySecurityGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the file directory security get params
func (o *FileDirectorySecurityGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *FileDirectorySecurityGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.LookupNames != nil {

		// query param lookup_names
		var qrLookupNames bool

		if o.LookupNames != nil {
			qrLookupNames = *o.LookupNames
		}
		qLookupNames := swag.FormatBool(qrLookupNames)
		if qLookupNames != "" {

			if err := r.SetQueryParam("lookup_names", qLookupNames); err != nil {
				return err
			}
		}
	}

	// path param path
	if err := r.SetPathParam("path", o.Path); err != nil {
		return err
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamFileDirectorySecurityGet binds the parameter fields
func (o *FileDirectorySecurityGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
