// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FpolicyConnectionModifyCollectionReader is a Reader for the FpolicyConnectionModifyCollection structure.
type FpolicyConnectionModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FpolicyConnectionModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFpolicyConnectionModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFpolicyConnectionModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFpolicyConnectionModifyCollectionOK creates a FpolicyConnectionModifyCollectionOK with default headers values
func NewFpolicyConnectionModifyCollectionOK() *FpolicyConnectionModifyCollectionOK {
	return &FpolicyConnectionModifyCollectionOK{}
}

/*
FpolicyConnectionModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type FpolicyConnectionModifyCollectionOK struct {
}

// IsSuccess returns true when this fpolicy connection modify collection o k response has a 2xx status code
func (o *FpolicyConnectionModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fpolicy connection modify collection o k response has a 3xx status code
func (o *FpolicyConnectionModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fpolicy connection modify collection o k response has a 4xx status code
func (o *FpolicyConnectionModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fpolicy connection modify collection o k response has a 5xx status code
func (o *FpolicyConnectionModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fpolicy connection modify collection o k response a status code equal to that given
func (o *FpolicyConnectionModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fpolicy connection modify collection o k response
func (o *FpolicyConnectionModifyCollectionOK) Code() int {
	return 200
}

func (o *FpolicyConnectionModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/fpolicy/{svm.uuid}/connections][%d] fpolicyConnectionModifyCollectionOK", 200)
}

func (o *FpolicyConnectionModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/fpolicy/{svm.uuid}/connections][%d] fpolicyConnectionModifyCollectionOK", 200)
}

func (o *FpolicyConnectionModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewFpolicyConnectionModifyCollectionDefault creates a FpolicyConnectionModifyCollectionDefault with default headers values
func NewFpolicyConnectionModifyCollectionDefault(code int) *FpolicyConnectionModifyCollectionDefault {
	return &FpolicyConnectionModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	FpolicyConnectionModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 9764954    | The specified policy does not exist |
| 9764911    | Failed to connect to the FPolicy server. Reason: The specified entry does not exist |
| 9764912    | Failed to disconnect the FPolicy server. Reason: The specified entry does not exist |
| 9764948    | The specified policy is disabled. Using a disabled policy with this API is not supported. Use the 'PATCH /protocols/fpolicy/{svm.uuid}/policies/{name}' API to enable the policy |
| 9764963    | The specified server is already connected |
| 9764964    | The specified server is already disconnected |
*/
type FpolicyConnectionModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fpolicy connection modify collection default response has a 2xx status code
func (o *FpolicyConnectionModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fpolicy connection modify collection default response has a 3xx status code
func (o *FpolicyConnectionModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fpolicy connection modify collection default response has a 4xx status code
func (o *FpolicyConnectionModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fpolicy connection modify collection default response has a 5xx status code
func (o *FpolicyConnectionModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fpolicy connection modify collection default response a status code equal to that given
func (o *FpolicyConnectionModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fpolicy connection modify collection default response
func (o *FpolicyConnectionModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *FpolicyConnectionModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/fpolicy/{svm.uuid}/connections][%d] fpolicy_connection_modify_collection default %s", o._statusCode, payload)
}

func (o *FpolicyConnectionModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/fpolicy/{svm.uuid}/connections][%d] fpolicy_connection_modify_collection default %s", o._statusCode, payload)
}

func (o *FpolicyConnectionModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FpolicyConnectionModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
FpolicyConnectionModifyCollectionBody fpolicy connection modify collection body
swagger:model FpolicyConnectionModifyCollectionBody
*/
type FpolicyConnectionModifyCollectionBody struct {

	// links
	Links *models.FpolicyConnectionInlineLinks `json:"_links,omitempty"`

	// disconnected reason
	DisconnectedReason *models.FpolicyConnectionInlineDisconnectedReason `json:"disconnected_reason,omitempty"`

	// fpolicy connection response inline records
	FpolicyConnectionResponseInlineRecords []*models.FpolicyConnection `json:"records,omitempty"`

	// node
	Node *models.FpolicyConnectionInlineNode `json:"node,omitempty"`

	// policy
	// Read Only: true
	Policy *models.FpolicyPolicyReference `json:"policy,omitempty"`

	// IP address of the FPolicy server.
	// Example: 10.132.145.20
	// Read Only: true
	Server *string `json:"server,omitempty"`

	// Unique session ID associated with each connection to the FPolicy server and it can be used to identify
	// the established connection.
	//
	// Example: 5224ec64-b336-11eb-841c-0050568e14c2
	// Read Only: true
	SessionUUID *string `json:"session_uuid,omitempty"`

	// Specifies the FPolicy server connection state indicating if it is in the connected or disconnected state.
	// The following is a list of the possible states:
	// * connected                 - Connected
	// * disconnected              - Disconnected
	//
	// Example: connected
	// Enum: ["connected","disconnected"]
	State *string `json:"state,omitempty"`

	// svm
	Svm *models.FpolicyConnectionInlineSvm `json:"svm,omitempty"`

	// FPolicy server type. The possible values are:
	//   * primary - Primary server
	//   * secondary  - Secondary server
	//
	// Example: primary
	// Read Only: true
	// Enum: ["primary","secondary"]
	Type *string `json:"type,omitempty"`

	// Specifies the time at which FPolicy server is connected or disconnected.
	// Example: 2019-06-12 11:00:16-04:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`
}

// Validate validates this fpolicy connection modify collection body
func (o *FpolicyConnectionModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDisconnectedReason(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFpolicyConnectionResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyConnectionModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *FpolicyConnectionModifyCollectionBody) validateDisconnectedReason(formats strfmt.Registry) error {
	if swag.IsZero(o.DisconnectedReason) { // not required
		return nil
	}

	if o.DisconnectedReason != nil {
		if err := o.DisconnectedReason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "disconnected_reason")
			}
			return err
		}
	}

	return nil
}

func (o *FpolicyConnectionModifyCollectionBody) validateFpolicyConnectionResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.FpolicyConnectionResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.FpolicyConnectionResponseInlineRecords); i++ {
		if swag.IsZero(o.FpolicyConnectionResponseInlineRecords[i]) { // not required
			continue
		}

		if o.FpolicyConnectionResponseInlineRecords[i] != nil {
			if err := o.FpolicyConnectionResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FpolicyConnectionModifyCollectionBody) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *FpolicyConnectionModifyCollectionBody) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

var fpolicyConnectionModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["connected","disconnected"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fpolicyConnectionModifyCollectionBodyTypeStatePropEnum = append(fpolicyConnectionModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// FpolicyConnectionModifyCollectionBody
	// FpolicyConnectionModifyCollectionBody
	// state
	// State
	// connected
	// END DEBUGGING
	// FpolicyConnectionModifyCollectionBodyStateConnected captures enum value "connected"
	FpolicyConnectionModifyCollectionBodyStateConnected string = "connected"

	// BEGIN DEBUGGING
	// FpolicyConnectionModifyCollectionBody
	// FpolicyConnectionModifyCollectionBody
	// state
	// State
	// disconnected
	// END DEBUGGING
	// FpolicyConnectionModifyCollectionBodyStateDisconnected captures enum value "disconnected"
	FpolicyConnectionModifyCollectionBodyStateDisconnected string = "disconnected"
)

// prop value enum
func (o *FpolicyConnectionModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fpolicyConnectionModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FpolicyConnectionModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *FpolicyConnectionModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

var fpolicyConnectionModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["primary","secondary"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fpolicyConnectionModifyCollectionBodyTypeTypePropEnum = append(fpolicyConnectionModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// FpolicyConnectionModifyCollectionBody
	// FpolicyConnectionModifyCollectionBody
	// type
	// Type
	// primary
	// END DEBUGGING
	// FpolicyConnectionModifyCollectionBodyTypePrimary captures enum value "primary"
	FpolicyConnectionModifyCollectionBodyTypePrimary string = "primary"

	// BEGIN DEBUGGING
	// FpolicyConnectionModifyCollectionBody
	// FpolicyConnectionModifyCollectionBody
	// type
	// Type
	// secondary
	// END DEBUGGING
	// FpolicyConnectionModifyCollectionBodyTypeSecondary captures enum value "secondary"
	FpolicyConnectionModifyCollectionBodyTypeSecondary string = "secondary"
)

// prop value enum
func (o *FpolicyConnectionModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fpolicyConnectionModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FpolicyConnectionModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

func (o *FpolicyConnectionModifyCollectionBody) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"update_time", "body", "date-time", o.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fpolicy connection modify collection body based on the context it is used
func (o *FpolicyConnectionModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDisconnectedReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFpolicyConnectionResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateServer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSessionUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyConnectionModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *FpolicyConnectionModifyCollectionBody) contextValidateDisconnectedReason(ctx context.Context, formats strfmt.Registry) error {

	if o.DisconnectedReason != nil {
		if err := o.DisconnectedReason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "disconnected_reason")
			}
			return err
		}
	}

	return nil
}

func (o *FpolicyConnectionModifyCollectionBody) contextValidateFpolicyConnectionResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.FpolicyConnectionResponseInlineRecords); i++ {

		if o.FpolicyConnectionResponseInlineRecords[i] != nil {
			if err := o.FpolicyConnectionResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FpolicyConnectionModifyCollectionBody) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *FpolicyConnectionModifyCollectionBody) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

func (o *FpolicyConnectionModifyCollectionBody) contextValidateServer(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"server", "body", o.Server); err != nil {
		return err
	}

	return nil
}

func (o *FpolicyConnectionModifyCollectionBody) contextValidateSessionUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"session_uuid", "body", o.SessionUUID); err != nil {
		return err
	}

	return nil
}

func (o *FpolicyConnectionModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *FpolicyConnectionModifyCollectionBody) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"type", "body", o.Type); err != nil {
		return err
	}

	return nil
}

func (o *FpolicyConnectionModifyCollectionBody) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"update_time", "body", o.UpdateTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FpolicyConnectionModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FpolicyConnectionModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res FpolicyConnectionModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FpolicyConnectionInlineLinks fpolicy connection inline links
swagger:model fpolicy_connection_inline__links
*/
type FpolicyConnectionInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this fpolicy connection inline links
func (o *FpolicyConnectionInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyConnectionInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fpolicy connection inline links based on the context it is used
func (o *FpolicyConnectionInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyConnectionInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FpolicyConnectionInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FpolicyConnectionInlineLinks) UnmarshalBinary(b []byte) error {
	var res FpolicyConnectionInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FpolicyConnectionInlineDisconnectedReason Indicates the reason for FPolicy server disconnection.
//
swagger:model fpolicy_connection_inline_disconnected_reason
*/
type FpolicyConnectionInlineDisconnectedReason struct {

	// Reason ID for the FPolicy Server disconnection.
	// Example: 9307
	Code *int64 `json:"code,omitempty"`

	// FPolicy server reason for disconnection message.
	// Example: TCP Connection to FPolicy server failed.
	Message *string `json:"message,omitempty"`
}

// Validate validates this fpolicy connection inline disconnected reason
func (o *FpolicyConnectionInlineDisconnectedReason) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fpolicy connection inline disconnected reason based on the context it is used
func (o *FpolicyConnectionInlineDisconnectedReason) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *FpolicyConnectionInlineDisconnectedReason) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FpolicyConnectionInlineDisconnectedReason) UnmarshalBinary(b []byte) error {
	var res FpolicyConnectionInlineDisconnectedReason
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FpolicyConnectionInlineNode fpolicy connection inline node
swagger:model fpolicy_connection_inline_node
*/
type FpolicyConnectionInlineNode struct {

	// links
	Links *models.FpolicyConnectionInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fpolicy connection inline node
func (o *FpolicyConnectionInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyConnectionInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fpolicy connection inline node based on the context it is used
func (o *FpolicyConnectionInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyConnectionInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FpolicyConnectionInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FpolicyConnectionInlineNode) UnmarshalBinary(b []byte) error {
	var res FpolicyConnectionInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FpolicyConnectionInlineNodeInlineLinks fpolicy connection inline node inline links
swagger:model fpolicy_connection_inline_node_inline__links
*/
type FpolicyConnectionInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this fpolicy connection inline node inline links
func (o *FpolicyConnectionInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyConnectionInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fpolicy connection inline node inline links based on the context it is used
func (o *FpolicyConnectionInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyConnectionInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FpolicyConnectionInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FpolicyConnectionInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res FpolicyConnectionInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FpolicyConnectionInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model fpolicy_connection_inline_svm
*/
type FpolicyConnectionInlineSvm struct {

	// links
	Links *models.FpolicyConnectionInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fpolicy connection inline svm
func (o *FpolicyConnectionInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyConnectionInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fpolicy connection inline svm based on the context it is used
func (o *FpolicyConnectionInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyConnectionInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FpolicyConnectionInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FpolicyConnectionInlineSvm) UnmarshalBinary(b []byte) error {
	var res FpolicyConnectionInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FpolicyConnectionInlineSvmInlineLinks fpolicy connection inline svm inline links
swagger:model fpolicy_connection_inline_svm_inline__links
*/
type FpolicyConnectionInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this fpolicy connection inline svm inline links
func (o *FpolicyConnectionInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyConnectionInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fpolicy connection inline svm inline links based on the context it is used
func (o *FpolicyConnectionInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyConnectionInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FpolicyConnectionInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FpolicyConnectionInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res FpolicyConnectionInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
