// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FpolicyDeleteCollectionReader is a Reader for the FpolicyDeleteCollection structure.
type FpolicyDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FpolicyDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFpolicyDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFpolicyDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFpolicyDeleteCollectionOK creates a FpolicyDeleteCollectionOK with default headers values
func NewFpolicyDeleteCollectionOK() *FpolicyDeleteCollectionOK {
	return &FpolicyDeleteCollectionOK{}
}

/*
FpolicyDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type FpolicyDeleteCollectionOK struct {
}

// IsSuccess returns true when this fpolicy delete collection o k response has a 2xx status code
func (o *FpolicyDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fpolicy delete collection o k response has a 3xx status code
func (o *FpolicyDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fpolicy delete collection o k response has a 4xx status code
func (o *FpolicyDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fpolicy delete collection o k response has a 5xx status code
func (o *FpolicyDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fpolicy delete collection o k response a status code equal to that given
func (o *FpolicyDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fpolicy delete collection o k response
func (o *FpolicyDeleteCollectionOK) Code() int {
	return 200
}

func (o *FpolicyDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/fpolicy][%d] fpolicyDeleteCollectionOK", 200)
}

func (o *FpolicyDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/fpolicy][%d] fpolicyDeleteCollectionOK", 200)
}

func (o *FpolicyDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewFpolicyDeleteCollectionDefault creates a FpolicyDeleteCollectionDefault with default headers values
func NewFpolicyDeleteCollectionDefault(code int) *FpolicyDeleteCollectionDefault {
	return &FpolicyDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	FpolicyDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 9765031    | If any of the FPolicy engine, FPolicy event or FPolicy policy deletion fails due to a systemic error or hardware failure, the cause of the failure is detailed in the error message. |
*/
type FpolicyDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fpolicy delete collection default response has a 2xx status code
func (o *FpolicyDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fpolicy delete collection default response has a 3xx status code
func (o *FpolicyDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fpolicy delete collection default response has a 4xx status code
func (o *FpolicyDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fpolicy delete collection default response has a 5xx status code
func (o *FpolicyDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fpolicy delete collection default response a status code equal to that given
func (o *FpolicyDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fpolicy delete collection default response
func (o *FpolicyDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *FpolicyDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/fpolicy][%d] fpolicy_delete_collection default %s", o._statusCode, payload)
}

func (o *FpolicyDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/fpolicy][%d] fpolicy_delete_collection default %s", o._statusCode, payload)
}

func (o *FpolicyDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FpolicyDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
FpolicyDeleteCollectionBody fpolicy delete collection body
swagger:model FpolicyDeleteCollectionBody
*/
type FpolicyDeleteCollectionBody struct {

	// fpolicy response inline records
	FpolicyResponseInlineRecords []*models.Fpolicy `json:"records,omitempty"`
}

// Validate validates this fpolicy delete collection body
func (o *FpolicyDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateFpolicyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyDeleteCollectionBody) validateFpolicyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.FpolicyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.FpolicyResponseInlineRecords); i++ {
		if swag.IsZero(o.FpolicyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.FpolicyResponseInlineRecords[i] != nil {
			if err := o.FpolicyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this fpolicy delete collection body based on the context it is used
func (o *FpolicyDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateFpolicyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyDeleteCollectionBody) contextValidateFpolicyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.FpolicyResponseInlineRecords); i++ {

		if o.FpolicyResponseInlineRecords[i] != nil {
			if err := o.FpolicyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *FpolicyDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FpolicyDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res FpolicyDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
