// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFpolicyEngineCollectionGetParams creates a new FpolicyEngineCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFpolicyEngineCollectionGetParams() *FpolicyEngineCollectionGetParams {
	return &FpolicyEngineCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFpolicyEngineCollectionGetParamsWithTimeout creates a new FpolicyEngineCollectionGetParams object
// with the ability to set a timeout on a request.
func NewFpolicyEngineCollectionGetParamsWithTimeout(timeout time.Duration) *FpolicyEngineCollectionGetParams {
	return &FpolicyEngineCollectionGetParams{
		timeout: timeout,
	}
}

// NewFpolicyEngineCollectionGetParamsWithContext creates a new FpolicyEngineCollectionGetParams object
// with the ability to set a context for a request.
func NewFpolicyEngineCollectionGetParamsWithContext(ctx context.Context) *FpolicyEngineCollectionGetParams {
	return &FpolicyEngineCollectionGetParams{
		Context: ctx,
	}
}

// NewFpolicyEngineCollectionGetParamsWithHTTPClient creates a new FpolicyEngineCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewFpolicyEngineCollectionGetParamsWithHTTPClient(client *http.Client) *FpolicyEngineCollectionGetParams {
	return &FpolicyEngineCollectionGetParams{
		HTTPClient: client,
	}
}

/*
FpolicyEngineCollectionGetParams contains all the parameters to send to the API endpoint

	for the fpolicy engine collection get operation.

	Typically these are written to a http.Request.
*/
type FpolicyEngineCollectionGetParams struct {

	/* BufferSizeRecvBuffer.

	   Filter by buffer_size.recv_buffer
	*/
	BufferSizeRecvBuffer *int64

	/* BufferSizeSendBuffer.

	   Filter by buffer_size.send_buffer
	*/
	BufferSizeSendBuffer *int64

	/* CertificateCa.

	   Filter by certificate.ca
	*/
	CertificateCa *string

	/* CertificateName.

	   Filter by certificate.name
	*/
	CertificateName *string

	/* CertificateSerialNumber.

	   Filter by certificate.serial_number
	*/
	CertificateSerialNumber *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Format.

	   Filter by format
	*/
	Format *string

	/* KeepAliveInterval.

	   Filter by keep_alive_interval
	*/
	KeepAliveInterval *string

	/* MaxConnectionRetries.

	   Filter by max_connection_retries
	*/
	MaxConnectionRetries *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* MaxServerRequests.

	   Filter by max_server_requests
	*/
	MaxServerRequests *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Port.

	   Filter by port
	*/
	Port *int64

	/* PrimaryServers.

	   Filter by primary_servers
	*/
	PrimaryServers *string

	/* RequestAbortTimeout.

	   Filter by request_abort_timeout
	*/
	RequestAbortTimeout *string

	/* RequestCancelTimeout.

	   Filter by request_cancel_timeout
	*/
	RequestCancelTimeout *string

	/* ResiliencyDirectoryPath.

	   Filter by resiliency.directory_path
	*/
	ResiliencyDirectoryPath *string

	/* ResiliencyEnabled.

	   Filter by resiliency.enabled
	*/
	ResiliencyEnabled *bool

	/* ResiliencyRetentionDuration.

	   Filter by resiliency.retention_duration
	*/
	ResiliencyRetentionDuration *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SecondaryServers.

	   Filter by secondary_servers
	*/
	SecondaryServers *string

	/* ServerProgressTimeout.

	   Filter by server_progress_timeout
	*/
	ServerProgressTimeout *string

	/* SessionTimeout.

	   Filter by session_timeout
	*/
	SessionTimeout *string

	/* SslOption.

	   Filter by ssl_option
	*/
	SslOption *string

	/* StatusRequestInterval.

	   Filter by status_request_interval
	*/
	StatusRequestInterval *string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	/* Type.

	   Filter by type
	*/
	Type *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the fpolicy engine collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FpolicyEngineCollectionGetParams) WithDefaults() *FpolicyEngineCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the fpolicy engine collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FpolicyEngineCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := FpolicyEngineCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithTimeout(timeout time.Duration) *FpolicyEngineCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithContext(ctx context.Context) *FpolicyEngineCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithHTTPClient(client *http.Client) *FpolicyEngineCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBufferSizeRecvBuffer adds the bufferSizeRecvBuffer to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithBufferSizeRecvBuffer(bufferSizeRecvBuffer *int64) *FpolicyEngineCollectionGetParams {
	o.SetBufferSizeRecvBuffer(bufferSizeRecvBuffer)
	return o
}

// SetBufferSizeRecvBuffer adds the bufferSizeRecvBuffer to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetBufferSizeRecvBuffer(bufferSizeRecvBuffer *int64) {
	o.BufferSizeRecvBuffer = bufferSizeRecvBuffer
}

// WithBufferSizeSendBuffer adds the bufferSizeSendBuffer to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithBufferSizeSendBuffer(bufferSizeSendBuffer *int64) *FpolicyEngineCollectionGetParams {
	o.SetBufferSizeSendBuffer(bufferSizeSendBuffer)
	return o
}

// SetBufferSizeSendBuffer adds the bufferSizeSendBuffer to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetBufferSizeSendBuffer(bufferSizeSendBuffer *int64) {
	o.BufferSizeSendBuffer = bufferSizeSendBuffer
}

// WithCertificateCa adds the certificateCa to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithCertificateCa(certificateCa *string) *FpolicyEngineCollectionGetParams {
	o.SetCertificateCa(certificateCa)
	return o
}

// SetCertificateCa adds the certificateCa to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetCertificateCa(certificateCa *string) {
	o.CertificateCa = certificateCa
}

// WithCertificateName adds the certificateName to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithCertificateName(certificateName *string) *FpolicyEngineCollectionGetParams {
	o.SetCertificateName(certificateName)
	return o
}

// SetCertificateName adds the certificateName to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetCertificateName(certificateName *string) {
	o.CertificateName = certificateName
}

// WithCertificateSerialNumber adds the certificateSerialNumber to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithCertificateSerialNumber(certificateSerialNumber *string) *FpolicyEngineCollectionGetParams {
	o.SetCertificateSerialNumber(certificateSerialNumber)
	return o
}

// SetCertificateSerialNumber adds the certificateSerialNumber to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetCertificateSerialNumber(certificateSerialNumber *string) {
	o.CertificateSerialNumber = certificateSerialNumber
}

// WithFields adds the fields to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithFields(fields []string) *FpolicyEngineCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFormat adds the format to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithFormat(format *string) *FpolicyEngineCollectionGetParams {
	o.SetFormat(format)
	return o
}

// SetFormat adds the format to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetFormat(format *string) {
	o.Format = format
}

// WithKeepAliveInterval adds the keepAliveInterval to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithKeepAliveInterval(keepAliveInterval *string) *FpolicyEngineCollectionGetParams {
	o.SetKeepAliveInterval(keepAliveInterval)
	return o
}

// SetKeepAliveInterval adds the keepAliveInterval to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetKeepAliveInterval(keepAliveInterval *string) {
	o.KeepAliveInterval = keepAliveInterval
}

// WithMaxConnectionRetries adds the maxConnectionRetries to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithMaxConnectionRetries(maxConnectionRetries *int64) *FpolicyEngineCollectionGetParams {
	o.SetMaxConnectionRetries(maxConnectionRetries)
	return o
}

// SetMaxConnectionRetries adds the maxConnectionRetries to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetMaxConnectionRetries(maxConnectionRetries *int64) {
	o.MaxConnectionRetries = maxConnectionRetries
}

// WithMaxRecords adds the maxRecords to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithMaxRecords(maxRecords *int64) *FpolicyEngineCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMaxServerRequests adds the maxServerRequests to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithMaxServerRequests(maxServerRequests *int64) *FpolicyEngineCollectionGetParams {
	o.SetMaxServerRequests(maxServerRequests)
	return o
}

// SetMaxServerRequests adds the maxServerRequests to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetMaxServerRequests(maxServerRequests *int64) {
	o.MaxServerRequests = maxServerRequests
}

// WithName adds the name to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithName(name *string) *FpolicyEngineCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithOrderBy(orderBy []string) *FpolicyEngineCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPort adds the port to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithPort(port *int64) *FpolicyEngineCollectionGetParams {
	o.SetPort(port)
	return o
}

// SetPort adds the port to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetPort(port *int64) {
	o.Port = port
}

// WithPrimaryServers adds the primaryServers to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithPrimaryServers(primaryServers *string) *FpolicyEngineCollectionGetParams {
	o.SetPrimaryServers(primaryServers)
	return o
}

// SetPrimaryServers adds the primaryServers to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetPrimaryServers(primaryServers *string) {
	o.PrimaryServers = primaryServers
}

// WithRequestAbortTimeout adds the requestAbortTimeout to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithRequestAbortTimeout(requestAbortTimeout *string) *FpolicyEngineCollectionGetParams {
	o.SetRequestAbortTimeout(requestAbortTimeout)
	return o
}

// SetRequestAbortTimeout adds the requestAbortTimeout to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetRequestAbortTimeout(requestAbortTimeout *string) {
	o.RequestAbortTimeout = requestAbortTimeout
}

// WithRequestCancelTimeout adds the requestCancelTimeout to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithRequestCancelTimeout(requestCancelTimeout *string) *FpolicyEngineCollectionGetParams {
	o.SetRequestCancelTimeout(requestCancelTimeout)
	return o
}

// SetRequestCancelTimeout adds the requestCancelTimeout to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetRequestCancelTimeout(requestCancelTimeout *string) {
	o.RequestCancelTimeout = requestCancelTimeout
}

// WithResiliencyDirectoryPath adds the resiliencyDirectoryPath to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithResiliencyDirectoryPath(resiliencyDirectoryPath *string) *FpolicyEngineCollectionGetParams {
	o.SetResiliencyDirectoryPath(resiliencyDirectoryPath)
	return o
}

// SetResiliencyDirectoryPath adds the resiliencyDirectoryPath to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetResiliencyDirectoryPath(resiliencyDirectoryPath *string) {
	o.ResiliencyDirectoryPath = resiliencyDirectoryPath
}

// WithResiliencyEnabled adds the resiliencyEnabled to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithResiliencyEnabled(resiliencyEnabled *bool) *FpolicyEngineCollectionGetParams {
	o.SetResiliencyEnabled(resiliencyEnabled)
	return o
}

// SetResiliencyEnabled adds the resiliencyEnabled to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetResiliencyEnabled(resiliencyEnabled *bool) {
	o.ResiliencyEnabled = resiliencyEnabled
}

// WithResiliencyRetentionDuration adds the resiliencyRetentionDuration to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithResiliencyRetentionDuration(resiliencyRetentionDuration *string) *FpolicyEngineCollectionGetParams {
	o.SetResiliencyRetentionDuration(resiliencyRetentionDuration)
	return o
}

// SetResiliencyRetentionDuration adds the resiliencyRetentionDuration to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetResiliencyRetentionDuration(resiliencyRetentionDuration *string) {
	o.ResiliencyRetentionDuration = resiliencyRetentionDuration
}

// WithReturnRecords adds the returnRecords to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithReturnRecords(returnRecords *bool) *FpolicyEngineCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *FpolicyEngineCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSecondaryServers adds the secondaryServers to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithSecondaryServers(secondaryServers *string) *FpolicyEngineCollectionGetParams {
	o.SetSecondaryServers(secondaryServers)
	return o
}

// SetSecondaryServers adds the secondaryServers to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetSecondaryServers(secondaryServers *string) {
	o.SecondaryServers = secondaryServers
}

// WithServerProgressTimeout adds the serverProgressTimeout to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithServerProgressTimeout(serverProgressTimeout *string) *FpolicyEngineCollectionGetParams {
	o.SetServerProgressTimeout(serverProgressTimeout)
	return o
}

// SetServerProgressTimeout adds the serverProgressTimeout to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetServerProgressTimeout(serverProgressTimeout *string) {
	o.ServerProgressTimeout = serverProgressTimeout
}

// WithSessionTimeout adds the sessionTimeout to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithSessionTimeout(sessionTimeout *string) *FpolicyEngineCollectionGetParams {
	o.SetSessionTimeout(sessionTimeout)
	return o
}

// SetSessionTimeout adds the sessionTimeout to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetSessionTimeout(sessionTimeout *string) {
	o.SessionTimeout = sessionTimeout
}

// WithSslOption adds the sslOption to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithSslOption(sslOption *string) *FpolicyEngineCollectionGetParams {
	o.SetSslOption(sslOption)
	return o
}

// SetSslOption adds the sslOption to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetSslOption(sslOption *string) {
	o.SslOption = sslOption
}

// WithStatusRequestInterval adds the statusRequestInterval to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithStatusRequestInterval(statusRequestInterval *string) *FpolicyEngineCollectionGetParams {
	o.SetStatusRequestInterval(statusRequestInterval)
	return o
}

// SetStatusRequestInterval adds the statusRequestInterval to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetStatusRequestInterval(statusRequestInterval *string) {
	o.StatusRequestInterval = statusRequestInterval
}

// WithSvmUUID adds the svmUUID to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithSvmUUID(svmUUID string) *FpolicyEngineCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithType adds the typeVar to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) WithType(typeVar *string) *FpolicyEngineCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the fpolicy engine collection get params
func (o *FpolicyEngineCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WriteToRequest writes these params to a swagger request
func (o *FpolicyEngineCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.BufferSizeRecvBuffer != nil {

		// query param buffer_size.recv_buffer
		var qrBufferSizeRecvBuffer int64

		if o.BufferSizeRecvBuffer != nil {
			qrBufferSizeRecvBuffer = *o.BufferSizeRecvBuffer
		}
		qBufferSizeRecvBuffer := swag.FormatInt64(qrBufferSizeRecvBuffer)
		if qBufferSizeRecvBuffer != "" {

			if err := r.SetQueryParam("buffer_size.recv_buffer", qBufferSizeRecvBuffer); err != nil {
				return err
			}
		}
	}

	if o.BufferSizeSendBuffer != nil {

		// query param buffer_size.send_buffer
		var qrBufferSizeSendBuffer int64

		if o.BufferSizeSendBuffer != nil {
			qrBufferSizeSendBuffer = *o.BufferSizeSendBuffer
		}
		qBufferSizeSendBuffer := swag.FormatInt64(qrBufferSizeSendBuffer)
		if qBufferSizeSendBuffer != "" {

			if err := r.SetQueryParam("buffer_size.send_buffer", qBufferSizeSendBuffer); err != nil {
				return err
			}
		}
	}

	if o.CertificateCa != nil {

		// query param certificate.ca
		var qrCertificateCa string

		if o.CertificateCa != nil {
			qrCertificateCa = *o.CertificateCa
		}
		qCertificateCa := qrCertificateCa
		if qCertificateCa != "" {

			if err := r.SetQueryParam("certificate.ca", qCertificateCa); err != nil {
				return err
			}
		}
	}

	if o.CertificateName != nil {

		// query param certificate.name
		var qrCertificateName string

		if o.CertificateName != nil {
			qrCertificateName = *o.CertificateName
		}
		qCertificateName := qrCertificateName
		if qCertificateName != "" {

			if err := r.SetQueryParam("certificate.name", qCertificateName); err != nil {
				return err
			}
		}
	}

	if o.CertificateSerialNumber != nil {

		// query param certificate.serial_number
		var qrCertificateSerialNumber string

		if o.CertificateSerialNumber != nil {
			qrCertificateSerialNumber = *o.CertificateSerialNumber
		}
		qCertificateSerialNumber := qrCertificateSerialNumber
		if qCertificateSerialNumber != "" {

			if err := r.SetQueryParam("certificate.serial_number", qCertificateSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Format != nil {

		// query param format
		var qrFormat string

		if o.Format != nil {
			qrFormat = *o.Format
		}
		qFormat := qrFormat
		if qFormat != "" {

			if err := r.SetQueryParam("format", qFormat); err != nil {
				return err
			}
		}
	}

	if o.KeepAliveInterval != nil {

		// query param keep_alive_interval
		var qrKeepAliveInterval string

		if o.KeepAliveInterval != nil {
			qrKeepAliveInterval = *o.KeepAliveInterval
		}
		qKeepAliveInterval := qrKeepAliveInterval
		if qKeepAliveInterval != "" {

			if err := r.SetQueryParam("keep_alive_interval", qKeepAliveInterval); err != nil {
				return err
			}
		}
	}

	if o.MaxConnectionRetries != nil {

		// query param max_connection_retries
		var qrMaxConnectionRetries int64

		if o.MaxConnectionRetries != nil {
			qrMaxConnectionRetries = *o.MaxConnectionRetries
		}
		qMaxConnectionRetries := swag.FormatInt64(qrMaxConnectionRetries)
		if qMaxConnectionRetries != "" {

			if err := r.SetQueryParam("max_connection_retries", qMaxConnectionRetries); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.MaxServerRequests != nil {

		// query param max_server_requests
		var qrMaxServerRequests int64

		if o.MaxServerRequests != nil {
			qrMaxServerRequests = *o.MaxServerRequests
		}
		qMaxServerRequests := swag.FormatInt64(qrMaxServerRequests)
		if qMaxServerRequests != "" {

			if err := r.SetQueryParam("max_server_requests", qMaxServerRequests); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Port != nil {

		// query param port
		var qrPort int64

		if o.Port != nil {
			qrPort = *o.Port
		}
		qPort := swag.FormatInt64(qrPort)
		if qPort != "" {

			if err := r.SetQueryParam("port", qPort); err != nil {
				return err
			}
		}
	}

	if o.PrimaryServers != nil {

		// query param primary_servers
		var qrPrimaryServers string

		if o.PrimaryServers != nil {
			qrPrimaryServers = *o.PrimaryServers
		}
		qPrimaryServers := qrPrimaryServers
		if qPrimaryServers != "" {

			if err := r.SetQueryParam("primary_servers", qPrimaryServers); err != nil {
				return err
			}
		}
	}

	if o.RequestAbortTimeout != nil {

		// query param request_abort_timeout
		var qrRequestAbortTimeout string

		if o.RequestAbortTimeout != nil {
			qrRequestAbortTimeout = *o.RequestAbortTimeout
		}
		qRequestAbortTimeout := qrRequestAbortTimeout
		if qRequestAbortTimeout != "" {

			if err := r.SetQueryParam("request_abort_timeout", qRequestAbortTimeout); err != nil {
				return err
			}
		}
	}

	if o.RequestCancelTimeout != nil {

		// query param request_cancel_timeout
		var qrRequestCancelTimeout string

		if o.RequestCancelTimeout != nil {
			qrRequestCancelTimeout = *o.RequestCancelTimeout
		}
		qRequestCancelTimeout := qrRequestCancelTimeout
		if qRequestCancelTimeout != "" {

			if err := r.SetQueryParam("request_cancel_timeout", qRequestCancelTimeout); err != nil {
				return err
			}
		}
	}

	if o.ResiliencyDirectoryPath != nil {

		// query param resiliency.directory_path
		var qrResiliencyDirectoryPath string

		if o.ResiliencyDirectoryPath != nil {
			qrResiliencyDirectoryPath = *o.ResiliencyDirectoryPath
		}
		qResiliencyDirectoryPath := qrResiliencyDirectoryPath
		if qResiliencyDirectoryPath != "" {

			if err := r.SetQueryParam("resiliency.directory_path", qResiliencyDirectoryPath); err != nil {
				return err
			}
		}
	}

	if o.ResiliencyEnabled != nil {

		// query param resiliency.enabled
		var qrResiliencyEnabled bool

		if o.ResiliencyEnabled != nil {
			qrResiliencyEnabled = *o.ResiliencyEnabled
		}
		qResiliencyEnabled := swag.FormatBool(qrResiliencyEnabled)
		if qResiliencyEnabled != "" {

			if err := r.SetQueryParam("resiliency.enabled", qResiliencyEnabled); err != nil {
				return err
			}
		}
	}

	if o.ResiliencyRetentionDuration != nil {

		// query param resiliency.retention_duration
		var qrResiliencyRetentionDuration string

		if o.ResiliencyRetentionDuration != nil {
			qrResiliencyRetentionDuration = *o.ResiliencyRetentionDuration
		}
		qResiliencyRetentionDuration := qrResiliencyRetentionDuration
		if qResiliencyRetentionDuration != "" {

			if err := r.SetQueryParam("resiliency.retention_duration", qResiliencyRetentionDuration); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SecondaryServers != nil {

		// query param secondary_servers
		var qrSecondaryServers string

		if o.SecondaryServers != nil {
			qrSecondaryServers = *o.SecondaryServers
		}
		qSecondaryServers := qrSecondaryServers
		if qSecondaryServers != "" {

			if err := r.SetQueryParam("secondary_servers", qSecondaryServers); err != nil {
				return err
			}
		}
	}

	if o.ServerProgressTimeout != nil {

		// query param server_progress_timeout
		var qrServerProgressTimeout string

		if o.ServerProgressTimeout != nil {
			qrServerProgressTimeout = *o.ServerProgressTimeout
		}
		qServerProgressTimeout := qrServerProgressTimeout
		if qServerProgressTimeout != "" {

			if err := r.SetQueryParam("server_progress_timeout", qServerProgressTimeout); err != nil {
				return err
			}
		}
	}

	if o.SessionTimeout != nil {

		// query param session_timeout
		var qrSessionTimeout string

		if o.SessionTimeout != nil {
			qrSessionTimeout = *o.SessionTimeout
		}
		qSessionTimeout := qrSessionTimeout
		if qSessionTimeout != "" {

			if err := r.SetQueryParam("session_timeout", qSessionTimeout); err != nil {
				return err
			}
		}
	}

	if o.SslOption != nil {

		// query param ssl_option
		var qrSslOption string

		if o.SslOption != nil {
			qrSslOption = *o.SslOption
		}
		qSslOption := qrSslOption
		if qSslOption != "" {

			if err := r.SetQueryParam("ssl_option", qSslOption); err != nil {
				return err
			}
		}
	}

	if o.StatusRequestInterval != nil {

		// query param status_request_interval
		var qrStatusRequestInterval string

		if o.StatusRequestInterval != nil {
			qrStatusRequestInterval = *o.StatusRequestInterval
		}
		qStatusRequestInterval := qrStatusRequestInterval
		if qStatusRequestInterval != "" {

			if err := r.SetQueryParam("status_request_interval", qStatusRequestInterval); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamFpolicyEngineCollectionGet binds the parameter fields
func (o *FpolicyEngineCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamFpolicyEngineCollectionGet binds the parameter order_by
func (o *FpolicyEngineCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
