// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FpolicyEngineDeleteCollectionReader is a Reader for the FpolicyEngineDeleteCollection structure.
type FpolicyEngineDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FpolicyEngineDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFpolicyEngineDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFpolicyEngineDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFpolicyEngineDeleteCollectionOK creates a FpolicyEngineDeleteCollectionOK with default headers values
func NewFpolicyEngineDeleteCollectionOK() *FpolicyEngineDeleteCollectionOK {
	return &FpolicyEngineDeleteCollectionOK{}
}

/*
FpolicyEngineDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type FpolicyEngineDeleteCollectionOK struct {
}

// IsSuccess returns true when this fpolicy engine delete collection o k response has a 2xx status code
func (o *FpolicyEngineDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fpolicy engine delete collection o k response has a 3xx status code
func (o *FpolicyEngineDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fpolicy engine delete collection o k response has a 4xx status code
func (o *FpolicyEngineDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fpolicy engine delete collection o k response has a 5xx status code
func (o *FpolicyEngineDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fpolicy engine delete collection o k response a status code equal to that given
func (o *FpolicyEngineDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fpolicy engine delete collection o k response
func (o *FpolicyEngineDeleteCollectionOK) Code() int {
	return 200
}

func (o *FpolicyEngineDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/engines][%d] fpolicyEngineDeleteCollectionOK", 200)
}

func (o *FpolicyEngineDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/engines][%d] fpolicyEngineDeleteCollectionOK", 200)
}

func (o *FpolicyEngineDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewFpolicyEngineDeleteCollectionDefault creates a FpolicyEngineDeleteCollectionDefault with default headers values
func NewFpolicyEngineDeleteCollectionDefault(code int) *FpolicyEngineDeleteCollectionDefault {
	return &FpolicyEngineDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	FpolicyEngineDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 9764940    | At least one FPolicy policy is using the FPolicy engine |
| 9764887    | The FPolicy engine is a cluster level FPolicy engine |
*/
type FpolicyEngineDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fpolicy engine delete collection default response has a 2xx status code
func (o *FpolicyEngineDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fpolicy engine delete collection default response has a 3xx status code
func (o *FpolicyEngineDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fpolicy engine delete collection default response has a 4xx status code
func (o *FpolicyEngineDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fpolicy engine delete collection default response has a 5xx status code
func (o *FpolicyEngineDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fpolicy engine delete collection default response a status code equal to that given
func (o *FpolicyEngineDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fpolicy engine delete collection default response
func (o *FpolicyEngineDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *FpolicyEngineDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/engines][%d] fpolicy_engine_delete_collection default %s", o._statusCode, payload)
}

func (o *FpolicyEngineDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/engines][%d] fpolicy_engine_delete_collection default %s", o._statusCode, payload)
}

func (o *FpolicyEngineDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FpolicyEngineDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
FpolicyEngineDeleteCollectionBody fpolicy engine delete collection body
swagger:model FpolicyEngineDeleteCollectionBody
*/
type FpolicyEngineDeleteCollectionBody struct {

	// fpolicy engine response inline records
	FpolicyEngineResponseInlineRecords []*models.FpolicyEngine `json:"records,omitempty"`
}

// Validate validates this fpolicy engine delete collection body
func (o *FpolicyEngineDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateFpolicyEngineResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyEngineDeleteCollectionBody) validateFpolicyEngineResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.FpolicyEngineResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.FpolicyEngineResponseInlineRecords); i++ {
		if swag.IsZero(o.FpolicyEngineResponseInlineRecords[i]) { // not required
			continue
		}

		if o.FpolicyEngineResponseInlineRecords[i] != nil {
			if err := o.FpolicyEngineResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this fpolicy engine delete collection body based on the context it is used
func (o *FpolicyEngineDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateFpolicyEngineResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyEngineDeleteCollectionBody) contextValidateFpolicyEngineResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.FpolicyEngineResponseInlineRecords); i++ {

		if o.FpolicyEngineResponseInlineRecords[i] != nil {
			if err := o.FpolicyEngineResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *FpolicyEngineDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FpolicyEngineDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res FpolicyEngineDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
