// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FpolicyEngineModifyCollectionReader is a Reader for the FpolicyEngineModifyCollection structure.
type FpolicyEngineModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FpolicyEngineModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFpolicyEngineModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFpolicyEngineModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFpolicyEngineModifyCollectionOK creates a FpolicyEngineModifyCollectionOK with default headers values
func NewFpolicyEngineModifyCollectionOK() *FpolicyEngineModifyCollectionOK {
	return &FpolicyEngineModifyCollectionOK{}
}

/*
FpolicyEngineModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type FpolicyEngineModifyCollectionOK struct {
}

// IsSuccess returns true when this fpolicy engine modify collection o k response has a 2xx status code
func (o *FpolicyEngineModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fpolicy engine modify collection o k response has a 3xx status code
func (o *FpolicyEngineModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fpolicy engine modify collection o k response has a 4xx status code
func (o *FpolicyEngineModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fpolicy engine modify collection o k response has a 5xx status code
func (o *FpolicyEngineModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fpolicy engine modify collection o k response a status code equal to that given
func (o *FpolicyEngineModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fpolicy engine modify collection o k response
func (o *FpolicyEngineModifyCollectionOK) Code() int {
	return 200
}

func (o *FpolicyEngineModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/fpolicy/{svm.uuid}/engines][%d] fpolicyEngineModifyCollectionOK", 200)
}

func (o *FpolicyEngineModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/fpolicy/{svm.uuid}/engines][%d] fpolicyEngineModifyCollectionOK", 200)
}

func (o *FpolicyEngineModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewFpolicyEngineModifyCollectionDefault creates a FpolicyEngineModifyCollectionDefault with default headers values
func NewFpolicyEngineModifyCollectionDefault(code int) *FpolicyEngineModifyCollectionDefault {
	return &FpolicyEngineModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	FpolicyEngineModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 9764922    | The primary and secondary server has a redundant IP address |
| 9764942    | At least one FPolicy policy is using the FPolicy engine |
| 9764886    | FPolicy engine is a cluster-level FPolicy engine |
| 9765011    | The resiliency feature is not supported with mandatory screening |
| 9765012    | The specified resiliency directory path does not exist|
| 9765042    | The specified send buffer size exceeds the maximum limit |
| 9765043    | The specified receive buffer size exceeds the maximum limit |
| 9765063    | Policy with Persistent Store feature does not support a "synchronous" |
| 9765004    | The specified session timeout exceeds the maximum limit |
| 9764935    | The specified max connection retries exceeds the maximum limit |
*/
type FpolicyEngineModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fpolicy engine modify collection default response has a 2xx status code
func (o *FpolicyEngineModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fpolicy engine modify collection default response has a 3xx status code
func (o *FpolicyEngineModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fpolicy engine modify collection default response has a 4xx status code
func (o *FpolicyEngineModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fpolicy engine modify collection default response has a 5xx status code
func (o *FpolicyEngineModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fpolicy engine modify collection default response a status code equal to that given
func (o *FpolicyEngineModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fpolicy engine modify collection default response
func (o *FpolicyEngineModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *FpolicyEngineModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/fpolicy/{svm.uuid}/engines][%d] fpolicy_engine_modify_collection default %s", o._statusCode, payload)
}

func (o *FpolicyEngineModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/fpolicy/{svm.uuid}/engines][%d] fpolicy_engine_modify_collection default %s", o._statusCode, payload)
}

func (o *FpolicyEngineModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FpolicyEngineModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
FpolicyEngineModifyCollectionBody fpolicy engine modify collection body
swagger:model FpolicyEngineModifyCollectionBody
*/
type FpolicyEngineModifyCollectionBody struct {

	// buffer size
	BufferSize *models.FpolicyEngineInlineBufferSize `json:"buffer_size,omitempty"`

	// certificate
	Certificate *models.FpolicyEngineInlineCertificate `json:"certificate,omitempty"`

	// The format for the notification messages sent to the FPolicy servers.
	//   The possible values are:
	//     * xml  - Notifications sent to the FPolicy server will be formatted using the XML schema.
	//     * protobuf - Notifications sent to the FPolicy server will be formatted using Protobuf schema, which is a binary form.
	//
	// Enum: ["xml","protobuf"]
	Format *string `json:"format,omitempty"`

	// fpolicy engine inline primary servers
	// Example: ["10.132.145.20","10.140.101.109"]
	FpolicyEngineInlinePrimaryServers []*string `json:"primary_servers,omitempty"`

	// fpolicy engine inline secondary servers
	// Example: ["10.132.145.20","10.132.145.21"]
	FpolicyEngineInlineSecondaryServers []*string `json:"secondary_servers,omitempty"`

	// fpolicy engine response inline records
	FpolicyEngineResponseInlineRecords []*models.FpolicyEngine `json:"records,omitempty"`

	// Specifies the ISO-8601 interval time for a storage appliance to send Keep Alive message to an FPolicy server. The allowed range is between 10 to 600 seconds.
	// Example: PT2M
	KeepAliveInterval *string `json:"keep_alive_interval,omitempty"`

	// This parameter specifies the maximum number of attempts to reconnect to the FPolicy server from an SVM. It is used to specify the number of times a broken connection will be retried. The value for this field must be between 0 and 20. By default, it is 5.
	// Example: 5
	// Maximum: 20
	// Minimum: 0
	MaxConnectionRetries *int64 `json:"max_connection_retries,omitempty"`

	// Specifies the maximum number of outstanding requests for the FPolicy server. It is used to specify maximum outstanding requests that will be queued up for the FPolicy server. The value for this field must be between 1 and 10000.  The default values are 500, 1000 or 2000 for Low-end(<64 GB memory), Mid-end(>=64 GB memory) and High-end(>=128 GB memory) Platforms respectively.
	// Example: 500
	// Maximum: 10000
	// Minimum: 1
	MaxServerRequests *int64 `json:"max_server_requests,omitempty"`

	// Specifies the name to assign to the external server configuration.
	// Example: fp_ex_eng
	Name *string `json:"name,omitempty"`

	// Port number of the FPolicy server application.
	// Example: 9876
	Port *int64 `json:"port,omitempty"`

	// Specifies the ISO-8601 timeout duration for a screen request to be aborted by a storage appliance. The allowed range is between 0 to 200 seconds.
	// Example: PT40S
	RequestAbortTimeout *string `json:"request_abort_timeout,omitempty"`

	// Specifies the ISO-8601 timeout duration for a screen request to be processed by an FPolicy server. The allowed range is between 0 to 100 seconds.
	// Example: PT20S
	RequestCancelTimeout *string `json:"request_cancel_timeout,omitempty"`

	// resiliency
	Resiliency *models.FpolicyEngineInlineResiliency `json:"resiliency,omitempty"`

	// Specifies the ISO-8601 timeout duration in which a throttled FPolicy server must complete at least one screen request. If no request is processed within the timeout, connection to the FPolicy server is terminated. The allowed range is between 0 to 100 seconds.
	// Example: PT1M
	ServerProgressTimeout *string `json:"server_progress_timeout,omitempty"`

	// This parameter specifies the interval after which a new session ID is sent to the FPolicy server during reconnection attempts. The default value is set to 10 seconds. If the connection between the storage controller and the FPolicy server is terminated and reconnection is made within the -session-timeout interval, the old session ID is sent to the FPolicy server so that it can send responses for old notifications.
	// Example: PT10S
	SessionTimeout *string `json:"session_timeout,omitempty"`

	// Specifies the SSL option for external communication with the FPolicy server. Possible values include the following:
	// * no_auth       When set to "no_auth", no authentication takes place.
	// * server_auth   When set to "server_auth", only the FPolicy server is authenticated by the SVM. With this option, before creating the FPolicy external engine, the administrator must install the public certificate of the certificate authority (CA) that signed the FPolicy server certificate.
	// * mutual_auth   When set to "mutual_auth", mutual authentication takes place between the SVM and the FPolicy server. This means authentication of the FPolicy server by the SVM along with authentication of the SVM by the FPolicy server. With this option, before creating the FPolicy external engine, the administrator must install the public certificate of the certificate authority (CA) that signed the FPolicy server certificate along with the public certificate and key file for authentication of the SVM.
	//
	// Enum: ["no_auth","server_auth","mutual_auth"]
	SslOption *string `json:"ssl_option,omitempty"`

	// Specifies the ISO-8601 interval time for a storage appliance to query a status request from an FPolicy server. The allowed range is between 0 to 50 seconds.
	// Example: PT10S
	StatusRequestInterval *string `json:"status_request_interval,omitempty"`

	// svm
	Svm *models.FpolicyEngineInlineSvm `json:"svm,omitempty"`

	// The notification mode determines what ONTAP does after sending notifications to FPolicy servers.
	//   The possible values are:
	//     * synchronous  - After sending a notification, wait for a response from the FPolicy server.
	//     * asynchronous - After sending a notification, file request processing continues.
	//
	// Enum: ["synchronous","asynchronous"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this fpolicy engine modify collection body
func (o *FpolicyEngineModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateBufferSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFormat(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFpolicyEngineResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxConnectionRetries(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxServerRequests(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateResiliency(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSslOption(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyEngineModifyCollectionBody) validateBufferSize(formats strfmt.Registry) error {
	if swag.IsZero(o.BufferSize) { // not required
		return nil
	}

	if o.BufferSize != nil {
		if err := o.BufferSize.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "buffer_size")
			}
			return err
		}
	}

	return nil
}

func (o *FpolicyEngineModifyCollectionBody) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(o.Certificate) { // not required
		return nil
	}

	if o.Certificate != nil {
		if err := o.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate")
			}
			return err
		}
	}

	return nil
}

var fpolicyEngineModifyCollectionBodyTypeFormatPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["xml","protobuf"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fpolicyEngineModifyCollectionBodyTypeFormatPropEnum = append(fpolicyEngineModifyCollectionBodyTypeFormatPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// FpolicyEngineModifyCollectionBody
	// FpolicyEngineModifyCollectionBody
	// format
	// Format
	// xml
	// END DEBUGGING
	// FpolicyEngineModifyCollectionBodyFormatXML captures enum value "xml"
	FpolicyEngineModifyCollectionBodyFormatXML string = "xml"

	// BEGIN DEBUGGING
	// FpolicyEngineModifyCollectionBody
	// FpolicyEngineModifyCollectionBody
	// format
	// Format
	// protobuf
	// END DEBUGGING
	// FpolicyEngineModifyCollectionBodyFormatProtobuf captures enum value "protobuf"
	FpolicyEngineModifyCollectionBodyFormatProtobuf string = "protobuf"
)

// prop value enum
func (o *FpolicyEngineModifyCollectionBody) validateFormatEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fpolicyEngineModifyCollectionBodyTypeFormatPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FpolicyEngineModifyCollectionBody) validateFormat(formats strfmt.Registry) error {
	if swag.IsZero(o.Format) { // not required
		return nil
	}

	// value enum
	if err := o.validateFormatEnum("info"+"."+"format", "body", *o.Format); err != nil {
		return err
	}

	return nil
}

func (o *FpolicyEngineModifyCollectionBody) validateFpolicyEngineResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.FpolicyEngineResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.FpolicyEngineResponseInlineRecords); i++ {
		if swag.IsZero(o.FpolicyEngineResponseInlineRecords[i]) { // not required
			continue
		}

		if o.FpolicyEngineResponseInlineRecords[i] != nil {
			if err := o.FpolicyEngineResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FpolicyEngineModifyCollectionBody) validateMaxConnectionRetries(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxConnectionRetries) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"max_connection_retries", "body", *o.MaxConnectionRetries, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"max_connection_retries", "body", *o.MaxConnectionRetries, 20, false); err != nil {
		return err
	}

	return nil
}

func (o *FpolicyEngineModifyCollectionBody) validateMaxServerRequests(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxServerRequests) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"max_server_requests", "body", *o.MaxServerRequests, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"max_server_requests", "body", *o.MaxServerRequests, 10000, false); err != nil {
		return err
	}

	return nil
}

func (o *FpolicyEngineModifyCollectionBody) validateResiliency(formats strfmt.Registry) error {
	if swag.IsZero(o.Resiliency) { // not required
		return nil
	}

	if o.Resiliency != nil {
		if err := o.Resiliency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "resiliency")
			}
			return err
		}
	}

	return nil
}

var fpolicyEngineModifyCollectionBodyTypeSslOptionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_auth","server_auth","mutual_auth"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fpolicyEngineModifyCollectionBodyTypeSslOptionPropEnum = append(fpolicyEngineModifyCollectionBodyTypeSslOptionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// FpolicyEngineModifyCollectionBody
	// FpolicyEngineModifyCollectionBody
	// ssl_option
	// SslOption
	// no_auth
	// END DEBUGGING
	// FpolicyEngineModifyCollectionBodySslOptionNoAuth captures enum value "no_auth"
	FpolicyEngineModifyCollectionBodySslOptionNoAuth string = "no_auth"

	// BEGIN DEBUGGING
	// FpolicyEngineModifyCollectionBody
	// FpolicyEngineModifyCollectionBody
	// ssl_option
	// SslOption
	// server_auth
	// END DEBUGGING
	// FpolicyEngineModifyCollectionBodySslOptionServerAuth captures enum value "server_auth"
	FpolicyEngineModifyCollectionBodySslOptionServerAuth string = "server_auth"

	// BEGIN DEBUGGING
	// FpolicyEngineModifyCollectionBody
	// FpolicyEngineModifyCollectionBody
	// ssl_option
	// SslOption
	// mutual_auth
	// END DEBUGGING
	// FpolicyEngineModifyCollectionBodySslOptionMutualAuth captures enum value "mutual_auth"
	FpolicyEngineModifyCollectionBodySslOptionMutualAuth string = "mutual_auth"
)

// prop value enum
func (o *FpolicyEngineModifyCollectionBody) validateSslOptionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fpolicyEngineModifyCollectionBodyTypeSslOptionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FpolicyEngineModifyCollectionBody) validateSslOption(formats strfmt.Registry) error {
	if swag.IsZero(o.SslOption) { // not required
		return nil
	}

	// value enum
	if err := o.validateSslOptionEnum("info"+"."+"ssl_option", "body", *o.SslOption); err != nil {
		return err
	}

	return nil
}

func (o *FpolicyEngineModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

var fpolicyEngineModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["synchronous","asynchronous"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fpolicyEngineModifyCollectionBodyTypeTypePropEnum = append(fpolicyEngineModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// FpolicyEngineModifyCollectionBody
	// FpolicyEngineModifyCollectionBody
	// type
	// Type
	// synchronous
	// END DEBUGGING
	// FpolicyEngineModifyCollectionBodyTypeSynchronous captures enum value "synchronous"
	FpolicyEngineModifyCollectionBodyTypeSynchronous string = "synchronous"

	// BEGIN DEBUGGING
	// FpolicyEngineModifyCollectionBody
	// FpolicyEngineModifyCollectionBody
	// type
	// Type
	// asynchronous
	// END DEBUGGING
	// FpolicyEngineModifyCollectionBodyTypeAsynchronous captures enum value "asynchronous"
	FpolicyEngineModifyCollectionBodyTypeAsynchronous string = "asynchronous"
)

// prop value enum
func (o *FpolicyEngineModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fpolicyEngineModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FpolicyEngineModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fpolicy engine modify collection body based on the context it is used
func (o *FpolicyEngineModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateBufferSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFpolicyEngineResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateResiliency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyEngineModifyCollectionBody) contextValidateBufferSize(ctx context.Context, formats strfmt.Registry) error {

	if o.BufferSize != nil {
		if err := o.BufferSize.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "buffer_size")
			}
			return err
		}
	}

	return nil
}

func (o *FpolicyEngineModifyCollectionBody) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if o.Certificate != nil {
		if err := o.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate")
			}
			return err
		}
	}

	return nil
}

func (o *FpolicyEngineModifyCollectionBody) contextValidateFpolicyEngineResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.FpolicyEngineResponseInlineRecords); i++ {

		if o.FpolicyEngineResponseInlineRecords[i] != nil {
			if err := o.FpolicyEngineResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FpolicyEngineModifyCollectionBody) contextValidateResiliency(ctx context.Context, formats strfmt.Registry) error {

	if o.Resiliency != nil {
		if err := o.Resiliency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "resiliency")
			}
			return err
		}
	}

	return nil
}

func (o *FpolicyEngineModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FpolicyEngineModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FpolicyEngineModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res FpolicyEngineModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FpolicyEngineInlineBufferSize Specifies the send and receive buffer size of the connected socket for the FPolicy server.
swagger:model fpolicy_engine_inline_buffer_size
*/
type FpolicyEngineInlineBufferSize struct {

	// Specifies the receive buffer size of the connected socket for the FPolicy server. Default value is 256KB.
	// Maximum: 7.89516e+06
	// Minimum: 0
	RecvBuffer *int64 `json:"recv_buffer,omitempty"`

	// Specifies the send buffer size of the connected socket for the FPolicy server. Default value 1MB.
	// Maximum: 7.89516e+06
	// Minimum: 0
	SendBuffer *int64 `json:"send_buffer,omitempty"`
}

// Validate validates this fpolicy engine inline buffer size
func (o *FpolicyEngineInlineBufferSize) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRecvBuffer(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSendBuffer(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyEngineInlineBufferSize) validateRecvBuffer(formats strfmt.Registry) error {
	if swag.IsZero(o.RecvBuffer) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"buffer_size"+"."+"recv_buffer", "body", *o.RecvBuffer, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"buffer_size"+"."+"recv_buffer", "body", *o.RecvBuffer, 7.89516e+06, false); err != nil {
		return err
	}

	return nil
}

func (o *FpolicyEngineInlineBufferSize) validateSendBuffer(formats strfmt.Registry) error {
	if swag.IsZero(o.SendBuffer) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"buffer_size"+"."+"send_buffer", "body", *o.SendBuffer, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"buffer_size"+"."+"send_buffer", "body", *o.SendBuffer, 7.89516e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this fpolicy engine inline buffer size based on context it is used
func (o *FpolicyEngineInlineBufferSize) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *FpolicyEngineInlineBufferSize) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FpolicyEngineInlineBufferSize) UnmarshalBinary(b []byte) error {
	var res FpolicyEngineInlineBufferSize
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FpolicyEngineInlineCertificate Provides details about certificate used to authenticate the FPolicy server.
swagger:model fpolicy_engine_inline_certificate
*/
type FpolicyEngineInlineCertificate struct {

	// Specifies the certificate authority (CA) name of the certificate
	// used for authentication if SSL authentication between the SVM and the FPolicy
	// server is configured.
	//
	// Example: TASample1
	Ca *string `json:"ca,omitempty"`

	// Specifies the certificate name as a fully qualified domain
	// name (FQDN) or custom common name. The certificate is used if SSL authentication
	// between the SVM and the FPolicy server is configured.
	//
	// Example: Sample1-FPolicy-Client
	Name *string `json:"name,omitempty"`

	// Specifies the serial number of the certificate used for
	// authentication if SSL authentication between the SVM and the FPolicy
	// server is configured.
	//
	// Example: 8DDE112A114D1FBC
	SerialNumber *string `json:"serial_number,omitempty"`
}

// Validate validates this fpolicy engine inline certificate
func (o *FpolicyEngineInlineCertificate) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this fpolicy engine inline certificate based on context it is used
func (o *FpolicyEngineInlineCertificate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *FpolicyEngineInlineCertificate) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FpolicyEngineInlineCertificate) UnmarshalBinary(b []byte) error {
	var res FpolicyEngineInlineCertificate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FpolicyEngineInlineResiliency If all primary and secondary servers are down, or if no response is received from the FPolicy servers, file access events are stored inside the storage controller under the specified resiliency-directory-path.
swagger:model fpolicy_engine_inline_resiliency
*/
type FpolicyEngineInlineResiliency struct {

	// Specifies the directory path under the SVM namespace,
	// where notifications are stored in the files whenever a network outage happens.
	//
	// Example: /dir1
	DirectoryPath *string `json:"directory_path,omitempty"`

	// Specifies whether the resiliency feature is enabled or not.
	// Default is false.
	//
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies the ISO-8601 duration, for which the notifications are written
	// to files inside the storage controller during a network outage. The value for
	// this field must be between 0 and 600 seconds. Default is 180 seconds.
	//
	// Example: PT3M
	RetentionDuration *string `json:"retention_duration,omitempty"`
}

// Validate validates this fpolicy engine inline resiliency
func (o *FpolicyEngineInlineResiliency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this fpolicy engine inline resiliency based on context it is used
func (o *FpolicyEngineInlineResiliency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *FpolicyEngineInlineResiliency) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FpolicyEngineInlineResiliency) UnmarshalBinary(b []byte) error {
	var res FpolicyEngineInlineResiliency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FpolicyEngineInlineSvm fpolicy engine inline svm
swagger:model fpolicy_engine_inline_svm
*/
type FpolicyEngineInlineSvm struct {

	// SVM UUID
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fpolicy engine inline svm
func (o *FpolicyEngineInlineSvm) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fpolicy engine inline svm based on the context it is used
func (o *FpolicyEngineInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyEngineInlineSvm) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"svm"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FpolicyEngineInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FpolicyEngineInlineSvm) UnmarshalBinary(b []byte) error {
	var res FpolicyEngineInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
