// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewFpolicyEventCreateParams creates a new FpolicyEventCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFpolicyEventCreateParams() *FpolicyEventCreateParams {
	return &FpolicyEventCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFpolicyEventCreateParamsWithTimeout creates a new FpolicyEventCreateParams object
// with the ability to set a timeout on a request.
func NewFpolicyEventCreateParamsWithTimeout(timeout time.Duration) *FpolicyEventCreateParams {
	return &FpolicyEventCreateParams{
		timeout: timeout,
	}
}

// NewFpolicyEventCreateParamsWithContext creates a new FpolicyEventCreateParams object
// with the ability to set a context for a request.
func NewFpolicyEventCreateParamsWithContext(ctx context.Context) *FpolicyEventCreateParams {
	return &FpolicyEventCreateParams{
		Context: ctx,
	}
}

// NewFpolicyEventCreateParamsWithHTTPClient creates a new FpolicyEventCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewFpolicyEventCreateParamsWithHTTPClient(client *http.Client) *FpolicyEventCreateParams {
	return &FpolicyEventCreateParams{
		HTTPClient: client,
	}
}

/*
FpolicyEventCreateParams contains all the parameters to send to the API endpoint

	for the fpolicy event create operation.

	Typically these are written to a http.Request.
*/
type FpolicyEventCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.FpolicyEvent

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the fpolicy event create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FpolicyEventCreateParams) WithDefaults() *FpolicyEventCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the fpolicy event create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FpolicyEventCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := FpolicyEventCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the fpolicy event create params
func (o *FpolicyEventCreateParams) WithTimeout(timeout time.Duration) *FpolicyEventCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the fpolicy event create params
func (o *FpolicyEventCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the fpolicy event create params
func (o *FpolicyEventCreateParams) WithContext(ctx context.Context) *FpolicyEventCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the fpolicy event create params
func (o *FpolicyEventCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the fpolicy event create params
func (o *FpolicyEventCreateParams) WithHTTPClient(client *http.Client) *FpolicyEventCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the fpolicy event create params
func (o *FpolicyEventCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the fpolicy event create params
func (o *FpolicyEventCreateParams) WithInfo(info *models.FpolicyEvent) *FpolicyEventCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the fpolicy event create params
func (o *FpolicyEventCreateParams) SetInfo(info *models.FpolicyEvent) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the fpolicy event create params
func (o *FpolicyEventCreateParams) WithReturnRecords(returnRecords *bool) *FpolicyEventCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the fpolicy event create params
func (o *FpolicyEventCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithSvmUUID adds the svmUUID to the fpolicy event create params
func (o *FpolicyEventCreateParams) WithSvmUUID(svmUUID string) *FpolicyEventCreateParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the fpolicy event create params
func (o *FpolicyEventCreateParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *FpolicyEventCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
