// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FpolicyEventDeleteCollectionReader is a Reader for the FpolicyEventDeleteCollection structure.
type FpolicyEventDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FpolicyEventDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFpolicyEventDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFpolicyEventDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFpolicyEventDeleteCollectionOK creates a FpolicyEventDeleteCollectionOK with default headers values
func NewFpolicyEventDeleteCollectionOK() *FpolicyEventDeleteCollectionOK {
	return &FpolicyEventDeleteCollectionOK{}
}

/*
FpolicyEventDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type FpolicyEventDeleteCollectionOK struct {
}

// IsSuccess returns true when this fpolicy event delete collection o k response has a 2xx status code
func (o *FpolicyEventDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fpolicy event delete collection o k response has a 3xx status code
func (o *FpolicyEventDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fpolicy event delete collection o k response has a 4xx status code
func (o *FpolicyEventDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fpolicy event delete collection o k response has a 5xx status code
func (o *FpolicyEventDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fpolicy event delete collection o k response a status code equal to that given
func (o *FpolicyEventDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fpolicy event delete collection o k response
func (o *FpolicyEventDeleteCollectionOK) Code() int {
	return 200
}

func (o *FpolicyEventDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/events][%d] fpolicyEventDeleteCollectionOK", 200)
}

func (o *FpolicyEventDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/events][%d] fpolicyEventDeleteCollectionOK", 200)
}

func (o *FpolicyEventDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewFpolicyEventDeleteCollectionDefault creates a FpolicyEventDeleteCollectionDefault with default headers values
func NewFpolicyEventDeleteCollectionDefault(code int) *FpolicyEventDeleteCollectionDefault {
	return &FpolicyEventDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	FpolicyEventDeleteCollectionDefault describes a response with status code -1, with default header values.

	| Error Code | Description |

| ---------- | ----------- |
| 9764874    | The FPolicy event is a cluster event |
| 9764947    | The FPolicy event is attached to an FPolicy policy |
*/
type FpolicyEventDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fpolicy event delete collection default response has a 2xx status code
func (o *FpolicyEventDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fpolicy event delete collection default response has a 3xx status code
func (o *FpolicyEventDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fpolicy event delete collection default response has a 4xx status code
func (o *FpolicyEventDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fpolicy event delete collection default response has a 5xx status code
func (o *FpolicyEventDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fpolicy event delete collection default response a status code equal to that given
func (o *FpolicyEventDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fpolicy event delete collection default response
func (o *FpolicyEventDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *FpolicyEventDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/events][%d] fpolicy_event_delete_collection default %s", o._statusCode, payload)
}

func (o *FpolicyEventDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/events][%d] fpolicy_event_delete_collection default %s", o._statusCode, payload)
}

func (o *FpolicyEventDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FpolicyEventDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
FpolicyEventDeleteCollectionBody fpolicy event delete collection body
swagger:model FpolicyEventDeleteCollectionBody
*/
type FpolicyEventDeleteCollectionBody struct {

	// fpolicy event response inline records
	FpolicyEventResponseInlineRecords []*models.FpolicyEvent `json:"records,omitempty"`
}

// Validate validates this fpolicy event delete collection body
func (o *FpolicyEventDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateFpolicyEventResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyEventDeleteCollectionBody) validateFpolicyEventResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.FpolicyEventResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.FpolicyEventResponseInlineRecords); i++ {
		if swag.IsZero(o.FpolicyEventResponseInlineRecords[i]) { // not required
			continue
		}

		if o.FpolicyEventResponseInlineRecords[i] != nil {
			if err := o.FpolicyEventResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this fpolicy event delete collection body based on the context it is used
func (o *FpolicyEventDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateFpolicyEventResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyEventDeleteCollectionBody) contextValidateFpolicyEventResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.FpolicyEventResponseInlineRecords); i++ {

		if o.FpolicyEventResponseInlineRecords[i] != nil {
			if err := o.FpolicyEventResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *FpolicyEventDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FpolicyEventDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res FpolicyEventDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
