// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FpolicyEventDeleteReader is a Reader for the FpolicyEventDelete structure.
type FpolicyEventDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FpolicyEventDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFpolicyEventDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFpolicyEventDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFpolicyEventDeleteOK creates a FpolicyEventDeleteOK with default headers values
func NewFpolicyEventDeleteOK() *FpolicyEventDeleteOK {
	return &FpolicyEventDeleteOK{}
}

/*
FpolicyEventDeleteOK describes a response with status code 200, with default header values.

OK
*/
type FpolicyEventDeleteOK struct {
}

// IsSuccess returns true when this fpolicy event delete o k response has a 2xx status code
func (o *FpolicyEventDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fpolicy event delete o k response has a 3xx status code
func (o *FpolicyEventDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fpolicy event delete o k response has a 4xx status code
func (o *FpolicyEventDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fpolicy event delete o k response has a 5xx status code
func (o *FpolicyEventDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fpolicy event delete o k response a status code equal to that given
func (o *FpolicyEventDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fpolicy event delete o k response
func (o *FpolicyEventDeleteOK) Code() int {
	return 200
}

func (o *FpolicyEventDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/events/{name}][%d] fpolicyEventDeleteOK", 200)
}

func (o *FpolicyEventDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/events/{name}][%d] fpolicyEventDeleteOK", 200)
}

func (o *FpolicyEventDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewFpolicyEventDeleteDefault creates a FpolicyEventDeleteDefault with default headers values
func NewFpolicyEventDeleteDefault(code int) *FpolicyEventDeleteDefault {
	return &FpolicyEventDeleteDefault{
		_statusCode: code,
	}
}

/*
	FpolicyEventDeleteDefault describes a response with status code -1, with default header values.

	| Error Code | Description |

| ---------- | ----------- |
| 9764874    | The FPolicy event is a cluster event |
| 9764947    | The FPolicy event is attached to an FPolicy policy |
*/
type FpolicyEventDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fpolicy event delete default response has a 2xx status code
func (o *FpolicyEventDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fpolicy event delete default response has a 3xx status code
func (o *FpolicyEventDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fpolicy event delete default response has a 4xx status code
func (o *FpolicyEventDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fpolicy event delete default response has a 5xx status code
func (o *FpolicyEventDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fpolicy event delete default response a status code equal to that given
func (o *FpolicyEventDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fpolicy event delete default response
func (o *FpolicyEventDeleteDefault) Code() int {
	return o._statusCode
}

func (o *FpolicyEventDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/events/{name}][%d] fpolicy_event_delete default %s", o._statusCode, payload)
}

func (o *FpolicyEventDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/events/{name}][%d] fpolicy_event_delete default %s", o._statusCode, payload)
}

func (o *FpolicyEventDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FpolicyEventDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
