// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FpolicyGetReader is a Reader for the FpolicyGet structure.
type FpolicyGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FpolicyGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFpolicyGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFpolicyGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFpolicyGetOK creates a FpolicyGetOK with default headers values
func NewFpolicyGetOK() *FpolicyGetOK {
	return &FpolicyGetOK{}
}

/*
FpolicyGetOK describes a response with status code 200, with default header values.

OK
*/
type FpolicyGetOK struct {
	Payload *models.Fpolicy
}

// IsSuccess returns true when this fpolicy get o k response has a 2xx status code
func (o *FpolicyGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fpolicy get o k response has a 3xx status code
func (o *FpolicyGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fpolicy get o k response has a 4xx status code
func (o *FpolicyGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fpolicy get o k response has a 5xx status code
func (o *FpolicyGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fpolicy get o k response a status code equal to that given
func (o *FpolicyGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fpolicy get o k response
func (o *FpolicyGetOK) Code() int {
	return 200
}

func (o *FpolicyGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/fpolicy/{svm.uuid}][%d] fpolicyGetOK %s", 200, payload)
}

func (o *FpolicyGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/fpolicy/{svm.uuid}][%d] fpolicyGetOK %s", 200, payload)
}

func (o *FpolicyGetOK) GetPayload() *models.Fpolicy {
	return o.Payload
}

func (o *FpolicyGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Fpolicy)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFpolicyGetDefault creates a FpolicyGetDefault with default headers values
func NewFpolicyGetDefault(code int) *FpolicyGetDefault {
	return &FpolicyGetDefault{
		_statusCode: code,
	}
}

/*
FpolicyGetDefault describes a response with status code -1, with default header values.

Error
*/
type FpolicyGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fpolicy get default response has a 2xx status code
func (o *FpolicyGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fpolicy get default response has a 3xx status code
func (o *FpolicyGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fpolicy get default response has a 4xx status code
func (o *FpolicyGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fpolicy get default response has a 5xx status code
func (o *FpolicyGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fpolicy get default response a status code equal to that given
func (o *FpolicyGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fpolicy get default response
func (o *FpolicyGetDefault) Code() int {
	return o._statusCode
}

func (o *FpolicyGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/fpolicy/{svm.uuid}][%d] fpolicy_get default %s", o._statusCode, payload)
}

func (o *FpolicyGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/fpolicy/{svm.uuid}][%d] fpolicy_get default %s", o._statusCode, payload)
}

func (o *FpolicyGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FpolicyGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
