// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFpolicyPersistentStoreCollectionGetParams creates a new FpolicyPersistentStoreCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFpolicyPersistentStoreCollectionGetParams() *FpolicyPersistentStoreCollectionGetParams {
	return &FpolicyPersistentStoreCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFpolicyPersistentStoreCollectionGetParamsWithTimeout creates a new FpolicyPersistentStoreCollectionGetParams object
// with the ability to set a timeout on a request.
func NewFpolicyPersistentStoreCollectionGetParamsWithTimeout(timeout time.Duration) *FpolicyPersistentStoreCollectionGetParams {
	return &FpolicyPersistentStoreCollectionGetParams{
		timeout: timeout,
	}
}

// NewFpolicyPersistentStoreCollectionGetParamsWithContext creates a new FpolicyPersistentStoreCollectionGetParams object
// with the ability to set a context for a request.
func NewFpolicyPersistentStoreCollectionGetParamsWithContext(ctx context.Context) *FpolicyPersistentStoreCollectionGetParams {
	return &FpolicyPersistentStoreCollectionGetParams{
		Context: ctx,
	}
}

// NewFpolicyPersistentStoreCollectionGetParamsWithHTTPClient creates a new FpolicyPersistentStoreCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewFpolicyPersistentStoreCollectionGetParamsWithHTTPClient(client *http.Client) *FpolicyPersistentStoreCollectionGetParams {
	return &FpolicyPersistentStoreCollectionGetParams{
		HTTPClient: client,
	}
}

/*
FpolicyPersistentStoreCollectionGetParams contains all the parameters to send to the API endpoint

	for the fpolicy persistent store collection get operation.

	Typically these are written to a http.Request.
*/
type FpolicyPersistentStoreCollectionGetParams struct {

	/* AutosizeMode.

	   Filter by autosize_mode
	*/
	AutosizeMode *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Size.

	   Filter by size
	*/
	Size *int64

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	/* Volume.

	   Filter by volume
	*/
	Volume *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the fpolicy persistent store collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FpolicyPersistentStoreCollectionGetParams) WithDefaults() *FpolicyPersistentStoreCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the fpolicy persistent store collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FpolicyPersistentStoreCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := FpolicyPersistentStoreCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) WithTimeout(timeout time.Duration) *FpolicyPersistentStoreCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) WithContext(ctx context.Context) *FpolicyPersistentStoreCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) WithHTTPClient(client *http.Client) *FpolicyPersistentStoreCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAutosizeMode adds the autosizeMode to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) WithAutosizeMode(autosizeMode *string) *FpolicyPersistentStoreCollectionGetParams {
	o.SetAutosizeMode(autosizeMode)
	return o
}

// SetAutosizeMode adds the autosizeMode to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) SetAutosizeMode(autosizeMode *string) {
	o.AutosizeMode = autosizeMode
}

// WithFields adds the fields to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) WithFields(fields []string) *FpolicyPersistentStoreCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) WithMaxRecords(maxRecords *int64) *FpolicyPersistentStoreCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) WithName(name *string) *FpolicyPersistentStoreCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) WithOrderBy(orderBy []string) *FpolicyPersistentStoreCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) WithReturnRecords(returnRecords *bool) *FpolicyPersistentStoreCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *FpolicyPersistentStoreCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSize adds the size to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) WithSize(size *int64) *FpolicyPersistentStoreCollectionGetParams {
	o.SetSize(size)
	return o
}

// SetSize adds the size to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) SetSize(size *int64) {
	o.Size = size
}

// WithSvmUUID adds the svmUUID to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) WithSvmUUID(svmUUID string) *FpolicyPersistentStoreCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithVolume adds the volume to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) WithVolume(volume *string) *FpolicyPersistentStoreCollectionGetParams {
	o.SetVolume(volume)
	return o
}

// SetVolume adds the volume to the fpolicy persistent store collection get params
func (o *FpolicyPersistentStoreCollectionGetParams) SetVolume(volume *string) {
	o.Volume = volume
}

// WriteToRequest writes these params to a swagger request
func (o *FpolicyPersistentStoreCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AutosizeMode != nil {

		// query param autosize_mode
		var qrAutosizeMode string

		if o.AutosizeMode != nil {
			qrAutosizeMode = *o.AutosizeMode
		}
		qAutosizeMode := qrAutosizeMode
		if qAutosizeMode != "" {

			if err := r.SetQueryParam("autosize_mode", qAutosizeMode); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Size != nil {

		// query param size
		var qrSize int64

		if o.Size != nil {
			qrSize = *o.Size
		}
		qSize := swag.FormatInt64(qrSize)
		if qSize != "" {

			if err := r.SetQueryParam("size", qSize); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if o.Volume != nil {

		// query param volume
		var qrVolume string

		if o.Volume != nil {
			qrVolume = *o.Volume
		}
		qVolume := qrVolume
		if qVolume != "" {

			if err := r.SetQueryParam("volume", qVolume); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamFpolicyPersistentStoreCollectionGet binds the parameter fields
func (o *FpolicyPersistentStoreCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamFpolicyPersistentStoreCollectionGet binds the parameter order_by
func (o *FpolicyPersistentStoreCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
