// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FpolicyPersistentStoreCreateReader is a Reader for the FpolicyPersistentStoreCreate structure.
type FpolicyPersistentStoreCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FpolicyPersistentStoreCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewFpolicyPersistentStoreCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFpolicyPersistentStoreCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFpolicyPersistentStoreCreateCreated creates a FpolicyPersistentStoreCreateCreated with default headers values
func NewFpolicyPersistentStoreCreateCreated() *FpolicyPersistentStoreCreateCreated {
	return &FpolicyPersistentStoreCreateCreated{}
}

/*
FpolicyPersistentStoreCreateCreated describes a response with status code 201, with default header values.

Created
*/
type FpolicyPersistentStoreCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.FpolicyPersistentStoreResponse
}

// IsSuccess returns true when this fpolicy persistent store create created response has a 2xx status code
func (o *FpolicyPersistentStoreCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fpolicy persistent store create created response has a 3xx status code
func (o *FpolicyPersistentStoreCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fpolicy persistent store create created response has a 4xx status code
func (o *FpolicyPersistentStoreCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this fpolicy persistent store create created response has a 5xx status code
func (o *FpolicyPersistentStoreCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this fpolicy persistent store create created response a status code equal to that given
func (o *FpolicyPersistentStoreCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the fpolicy persistent store create created response
func (o *FpolicyPersistentStoreCreateCreated) Code() int {
	return 201
}

func (o *FpolicyPersistentStoreCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/fpolicy/{svm.uuid}/persistent-stores][%d] fpolicyPersistentStoreCreateCreated %s", 201, payload)
}

func (o *FpolicyPersistentStoreCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/fpolicy/{svm.uuid}/persistent-stores][%d] fpolicyPersistentStoreCreateCreated %s", 201, payload)
}

func (o *FpolicyPersistentStoreCreateCreated) GetPayload() *models.FpolicyPersistentStoreResponse {
	return o.Payload
}

func (o *FpolicyPersistentStoreCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.FpolicyPersistentStoreResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFpolicyPersistentStoreCreateDefault creates a FpolicyPersistentStoreCreateDefault with default headers values
func NewFpolicyPersistentStoreCreateDefault(code int) *FpolicyPersistentStoreCreateDefault {
	return &FpolicyPersistentStoreCreateDefault{
		_statusCode: code,
	}
}

/*
	FpolicyPersistentStoreCreateDefault describes a response with status code -1, with default header values.

	| Error Code | Description |

| ---------- | ----------- |
| 9765052    | Cannot create more than one Persistent Store per SVM |
| 9765053    | Volume mentioned does not exist in the SVM |
| 9765068    | The Persistent Store name is too long. It must not exceed 500 characters |
| 2621516    | This operation is only supported on a data SVM |
| 9765069    | Volume is not a FlexVol volume. Only FlexVol volumes are supported for this operation. |
| 9765072    | Volume is not of type RW. Only volumes of type RW are supported. |
| 9765074    | Size is a required parameter for the creation of the Persistent Store. |
| 9765077    | The SVM is not associated with any aggregates. |
| 524849     | Attribute cannot be modified for the target volume because of the specified reason. |
| 917533     | The target volume is not eligible for modification due to certain constraints, such as the volume being offline or currently engaged in a volume move operation. |
| 917826     | Volume minimum autosize must be greater than zero. |
| 918647     | The designated size exceeds the maximum available capacity of the intended volume. |
| 917534     | The value specified for the field \\"-size\\" is too small. Update the field \\"-size\\" with the minimum size allowed and retry the operation. |
*/
type FpolicyPersistentStoreCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fpolicy persistent store create default response has a 2xx status code
func (o *FpolicyPersistentStoreCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fpolicy persistent store create default response has a 3xx status code
func (o *FpolicyPersistentStoreCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fpolicy persistent store create default response has a 4xx status code
func (o *FpolicyPersistentStoreCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fpolicy persistent store create default response has a 5xx status code
func (o *FpolicyPersistentStoreCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fpolicy persistent store create default response a status code equal to that given
func (o *FpolicyPersistentStoreCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fpolicy persistent store create default response
func (o *FpolicyPersistentStoreCreateDefault) Code() int {
	return o._statusCode
}

func (o *FpolicyPersistentStoreCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/fpolicy/{svm.uuid}/persistent-stores][%d] fpolicy_persistent_store_create default %s", o._statusCode, payload)
}

func (o *FpolicyPersistentStoreCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/fpolicy/{svm.uuid}/persistent-stores][%d] fpolicy_persistent_store_create default %s", o._statusCode, payload)
}

func (o *FpolicyPersistentStoreCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FpolicyPersistentStoreCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
