// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FpolicyPersistentStoreDeleteCollectionReader is a Reader for the FpolicyPersistentStoreDeleteCollection structure.
type FpolicyPersistentStoreDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FpolicyPersistentStoreDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFpolicyPersistentStoreDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFpolicyPersistentStoreDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFpolicyPersistentStoreDeleteCollectionOK creates a FpolicyPersistentStoreDeleteCollectionOK with default headers values
func NewFpolicyPersistentStoreDeleteCollectionOK() *FpolicyPersistentStoreDeleteCollectionOK {
	return &FpolicyPersistentStoreDeleteCollectionOK{}
}

/*
FpolicyPersistentStoreDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type FpolicyPersistentStoreDeleteCollectionOK struct {
}

// IsSuccess returns true when this fpolicy persistent store delete collection o k response has a 2xx status code
func (o *FpolicyPersistentStoreDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fpolicy persistent store delete collection o k response has a 3xx status code
func (o *FpolicyPersistentStoreDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fpolicy persistent store delete collection o k response has a 4xx status code
func (o *FpolicyPersistentStoreDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fpolicy persistent store delete collection o k response has a 5xx status code
func (o *FpolicyPersistentStoreDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fpolicy persistent store delete collection o k response a status code equal to that given
func (o *FpolicyPersistentStoreDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fpolicy persistent store delete collection o k response
func (o *FpolicyPersistentStoreDeleteCollectionOK) Code() int {
	return 200
}

func (o *FpolicyPersistentStoreDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/persistent-stores][%d] fpolicyPersistentStoreDeleteCollectionOK", 200)
}

func (o *FpolicyPersistentStoreDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/persistent-stores][%d] fpolicyPersistentStoreDeleteCollectionOK", 200)
}

func (o *FpolicyPersistentStoreDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewFpolicyPersistentStoreDeleteCollectionDefault creates a FpolicyPersistentStoreDeleteCollectionDefault with default headers values
func NewFpolicyPersistentStoreDeleteCollectionDefault(code int) *FpolicyPersistentStoreDeleteCollectionDefault {
	return &FpolicyPersistentStoreDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	FpolicyPersistentStoreDeleteCollectionDefault describes a response with status code -1, with default header values.

	| Error Code | Description |

| ---------- | ----------- |
| 9765064    | Persistent Store is active on at least one policy |
*/
type FpolicyPersistentStoreDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fpolicy persistent store delete collection default response has a 2xx status code
func (o *FpolicyPersistentStoreDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fpolicy persistent store delete collection default response has a 3xx status code
func (o *FpolicyPersistentStoreDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fpolicy persistent store delete collection default response has a 4xx status code
func (o *FpolicyPersistentStoreDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fpolicy persistent store delete collection default response has a 5xx status code
func (o *FpolicyPersistentStoreDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fpolicy persistent store delete collection default response a status code equal to that given
func (o *FpolicyPersistentStoreDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fpolicy persistent store delete collection default response
func (o *FpolicyPersistentStoreDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *FpolicyPersistentStoreDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/persistent-stores][%d] fpolicy_persistent_store_delete_collection default %s", o._statusCode, payload)
}

func (o *FpolicyPersistentStoreDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/persistent-stores][%d] fpolicy_persistent_store_delete_collection default %s", o._statusCode, payload)
}

func (o *FpolicyPersistentStoreDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FpolicyPersistentStoreDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
FpolicyPersistentStoreDeleteCollectionBody fpolicy persistent store delete collection body
swagger:model FpolicyPersistentStoreDeleteCollectionBody
*/
type FpolicyPersistentStoreDeleteCollectionBody struct {

	// fpolicy persistent store response inline records
	FpolicyPersistentStoreResponseInlineRecords []*models.FpolicyPersistentStore `json:"records,omitempty"`
}

// Validate validates this fpolicy persistent store delete collection body
func (o *FpolicyPersistentStoreDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateFpolicyPersistentStoreResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyPersistentStoreDeleteCollectionBody) validateFpolicyPersistentStoreResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.FpolicyPersistentStoreResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.FpolicyPersistentStoreResponseInlineRecords); i++ {
		if swag.IsZero(o.FpolicyPersistentStoreResponseInlineRecords[i]) { // not required
			continue
		}

		if o.FpolicyPersistentStoreResponseInlineRecords[i] != nil {
			if err := o.FpolicyPersistentStoreResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this fpolicy persistent store delete collection body based on the context it is used
func (o *FpolicyPersistentStoreDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateFpolicyPersistentStoreResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyPersistentStoreDeleteCollectionBody) contextValidateFpolicyPersistentStoreResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.FpolicyPersistentStoreResponseInlineRecords); i++ {

		if o.FpolicyPersistentStoreResponseInlineRecords[i] != nil {
			if err := o.FpolicyPersistentStoreResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *FpolicyPersistentStoreDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FpolicyPersistentStoreDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res FpolicyPersistentStoreDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
