// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFpolicyPersistentStoreDeleteParams creates a new FpolicyPersistentStoreDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFpolicyPersistentStoreDeleteParams() *FpolicyPersistentStoreDeleteParams {
	return &FpolicyPersistentStoreDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFpolicyPersistentStoreDeleteParamsWithTimeout creates a new FpolicyPersistentStoreDeleteParams object
// with the ability to set a timeout on a request.
func NewFpolicyPersistentStoreDeleteParamsWithTimeout(timeout time.Duration) *FpolicyPersistentStoreDeleteParams {
	return &FpolicyPersistentStoreDeleteParams{
		timeout: timeout,
	}
}

// NewFpolicyPersistentStoreDeleteParamsWithContext creates a new FpolicyPersistentStoreDeleteParams object
// with the ability to set a context for a request.
func NewFpolicyPersistentStoreDeleteParamsWithContext(ctx context.Context) *FpolicyPersistentStoreDeleteParams {
	return &FpolicyPersistentStoreDeleteParams{
		Context: ctx,
	}
}

// NewFpolicyPersistentStoreDeleteParamsWithHTTPClient creates a new FpolicyPersistentStoreDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewFpolicyPersistentStoreDeleteParamsWithHTTPClient(client *http.Client) *FpolicyPersistentStoreDeleteParams {
	return &FpolicyPersistentStoreDeleteParams{
		HTTPClient: client,
	}
}

/*
FpolicyPersistentStoreDeleteParams contains all the parameters to send to the API endpoint

	for the fpolicy persistent store delete operation.

	Typically these are written to a http.Request.
*/
type FpolicyPersistentStoreDeleteParams struct {

	/* DeleteVolume.

	   Delete the associated volume of the Persistent Store.
	*/
	DeleteVolume *bool

	// Name.
	Name string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the fpolicy persistent store delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FpolicyPersistentStoreDeleteParams) WithDefaults() *FpolicyPersistentStoreDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the fpolicy persistent store delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FpolicyPersistentStoreDeleteParams) SetDefaults() {
	var (
		deleteVolumeDefault = bool(false)
	)

	val := FpolicyPersistentStoreDeleteParams{
		DeleteVolume: &deleteVolumeDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the fpolicy persistent store delete params
func (o *FpolicyPersistentStoreDeleteParams) WithTimeout(timeout time.Duration) *FpolicyPersistentStoreDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the fpolicy persistent store delete params
func (o *FpolicyPersistentStoreDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the fpolicy persistent store delete params
func (o *FpolicyPersistentStoreDeleteParams) WithContext(ctx context.Context) *FpolicyPersistentStoreDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the fpolicy persistent store delete params
func (o *FpolicyPersistentStoreDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the fpolicy persistent store delete params
func (o *FpolicyPersistentStoreDeleteParams) WithHTTPClient(client *http.Client) *FpolicyPersistentStoreDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the fpolicy persistent store delete params
func (o *FpolicyPersistentStoreDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDeleteVolume adds the deleteVolume to the fpolicy persistent store delete params
func (o *FpolicyPersistentStoreDeleteParams) WithDeleteVolume(deleteVolume *bool) *FpolicyPersistentStoreDeleteParams {
	o.SetDeleteVolume(deleteVolume)
	return o
}

// SetDeleteVolume adds the deleteVolume to the fpolicy persistent store delete params
func (o *FpolicyPersistentStoreDeleteParams) SetDeleteVolume(deleteVolume *bool) {
	o.DeleteVolume = deleteVolume
}

// WithName adds the name to the fpolicy persistent store delete params
func (o *FpolicyPersistentStoreDeleteParams) WithName(name string) *FpolicyPersistentStoreDeleteParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the fpolicy persistent store delete params
func (o *FpolicyPersistentStoreDeleteParams) SetName(name string) {
	o.Name = name
}

// WithSvmUUID adds the svmUUID to the fpolicy persistent store delete params
func (o *FpolicyPersistentStoreDeleteParams) WithSvmUUID(svmUUID string) *FpolicyPersistentStoreDeleteParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the fpolicy persistent store delete params
func (o *FpolicyPersistentStoreDeleteParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *FpolicyPersistentStoreDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.DeleteVolume != nil {

		// query param delete_volume
		var qrDeleteVolume bool

		if o.DeleteVolume != nil {
			qrDeleteVolume = *o.DeleteVolume
		}
		qDeleteVolume := swag.FormatBool(qrDeleteVolume)
		if qDeleteVolume != "" {

			if err := r.SetQueryParam("delete_volume", qDeleteVolume); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
