// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewFpolicyPersistentStoreModifyParams creates a new FpolicyPersistentStoreModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFpolicyPersistentStoreModifyParams() *FpolicyPersistentStoreModifyParams {
	return &FpolicyPersistentStoreModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFpolicyPersistentStoreModifyParamsWithTimeout creates a new FpolicyPersistentStoreModifyParams object
// with the ability to set a timeout on a request.
func NewFpolicyPersistentStoreModifyParamsWithTimeout(timeout time.Duration) *FpolicyPersistentStoreModifyParams {
	return &FpolicyPersistentStoreModifyParams{
		timeout: timeout,
	}
}

// NewFpolicyPersistentStoreModifyParamsWithContext creates a new FpolicyPersistentStoreModifyParams object
// with the ability to set a context for a request.
func NewFpolicyPersistentStoreModifyParamsWithContext(ctx context.Context) *FpolicyPersistentStoreModifyParams {
	return &FpolicyPersistentStoreModifyParams{
		Context: ctx,
	}
}

// NewFpolicyPersistentStoreModifyParamsWithHTTPClient creates a new FpolicyPersistentStoreModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewFpolicyPersistentStoreModifyParamsWithHTTPClient(client *http.Client) *FpolicyPersistentStoreModifyParams {
	return &FpolicyPersistentStoreModifyParams{
		HTTPClient: client,
	}
}

/*
FpolicyPersistentStoreModifyParams contains all the parameters to send to the API endpoint

	for the fpolicy persistent store modify operation.

	Typically these are written to a http.Request.
*/
type FpolicyPersistentStoreModifyParams struct {

	/* DeleteVolume.

	   Delete the previous volume of a Persistent Store if a new volume is provided.
	*/
	DeleteVolume *bool

	/* Info.

	   Info specification
	*/
	Info *models.FpolicyPersistentStore

	// Name.
	Name string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the fpolicy persistent store modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FpolicyPersistentStoreModifyParams) WithDefaults() *FpolicyPersistentStoreModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the fpolicy persistent store modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FpolicyPersistentStoreModifyParams) SetDefaults() {
	var (
		deleteVolumeDefault = bool(false)
	)

	val := FpolicyPersistentStoreModifyParams{
		DeleteVolume: &deleteVolumeDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the fpolicy persistent store modify params
func (o *FpolicyPersistentStoreModifyParams) WithTimeout(timeout time.Duration) *FpolicyPersistentStoreModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the fpolicy persistent store modify params
func (o *FpolicyPersistentStoreModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the fpolicy persistent store modify params
func (o *FpolicyPersistentStoreModifyParams) WithContext(ctx context.Context) *FpolicyPersistentStoreModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the fpolicy persistent store modify params
func (o *FpolicyPersistentStoreModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the fpolicy persistent store modify params
func (o *FpolicyPersistentStoreModifyParams) WithHTTPClient(client *http.Client) *FpolicyPersistentStoreModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the fpolicy persistent store modify params
func (o *FpolicyPersistentStoreModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDeleteVolume adds the deleteVolume to the fpolicy persistent store modify params
func (o *FpolicyPersistentStoreModifyParams) WithDeleteVolume(deleteVolume *bool) *FpolicyPersistentStoreModifyParams {
	o.SetDeleteVolume(deleteVolume)
	return o
}

// SetDeleteVolume adds the deleteVolume to the fpolicy persistent store modify params
func (o *FpolicyPersistentStoreModifyParams) SetDeleteVolume(deleteVolume *bool) {
	o.DeleteVolume = deleteVolume
}

// WithInfo adds the info to the fpolicy persistent store modify params
func (o *FpolicyPersistentStoreModifyParams) WithInfo(info *models.FpolicyPersistentStore) *FpolicyPersistentStoreModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the fpolicy persistent store modify params
func (o *FpolicyPersistentStoreModifyParams) SetInfo(info *models.FpolicyPersistentStore) {
	o.Info = info
}

// WithName adds the name to the fpolicy persistent store modify params
func (o *FpolicyPersistentStoreModifyParams) WithName(name string) *FpolicyPersistentStoreModifyParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the fpolicy persistent store modify params
func (o *FpolicyPersistentStoreModifyParams) SetName(name string) {
	o.Name = name
}

// WithSvmUUID adds the svmUUID to the fpolicy persistent store modify params
func (o *FpolicyPersistentStoreModifyParams) WithSvmUUID(svmUUID string) *FpolicyPersistentStoreModifyParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the fpolicy persistent store modify params
func (o *FpolicyPersistentStoreModifyParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *FpolicyPersistentStoreModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.DeleteVolume != nil {

		// query param delete_volume
		var qrDeleteVolume bool

		if o.DeleteVolume != nil {
			qrDeleteVolume = *o.DeleteVolume
		}
		qDeleteVolume := swag.FormatBool(qrDeleteVolume)
		if qDeleteVolume != "" {

			if err := r.SetQueryParam("delete_volume", qDeleteVolume); err != nil {
				return err
			}
		}
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
