// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewFpolicyPolicyCreateParams creates a new FpolicyPolicyCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFpolicyPolicyCreateParams() *FpolicyPolicyCreateParams {
	return &FpolicyPolicyCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFpolicyPolicyCreateParamsWithTimeout creates a new FpolicyPolicyCreateParams object
// with the ability to set a timeout on a request.
func NewFpolicyPolicyCreateParamsWithTimeout(timeout time.Duration) *FpolicyPolicyCreateParams {
	return &FpolicyPolicyCreateParams{
		timeout: timeout,
	}
}

// NewFpolicyPolicyCreateParamsWithContext creates a new FpolicyPolicyCreateParams object
// with the ability to set a context for a request.
func NewFpolicyPolicyCreateParamsWithContext(ctx context.Context) *FpolicyPolicyCreateParams {
	return &FpolicyPolicyCreateParams{
		Context: ctx,
	}
}

// NewFpolicyPolicyCreateParamsWithHTTPClient creates a new FpolicyPolicyCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewFpolicyPolicyCreateParamsWithHTTPClient(client *http.Client) *FpolicyPolicyCreateParams {
	return &FpolicyPolicyCreateParams{
		HTTPClient: client,
	}
}

/*
FpolicyPolicyCreateParams contains all the parameters to send to the API endpoint

	for the fpolicy policy create operation.

	Typically these are written to a http.Request.
*/
type FpolicyPolicyCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.FpolicyPolicy

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the fpolicy policy create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FpolicyPolicyCreateParams) WithDefaults() *FpolicyPolicyCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the fpolicy policy create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FpolicyPolicyCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := FpolicyPolicyCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the fpolicy policy create params
func (o *FpolicyPolicyCreateParams) WithTimeout(timeout time.Duration) *FpolicyPolicyCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the fpolicy policy create params
func (o *FpolicyPolicyCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the fpolicy policy create params
func (o *FpolicyPolicyCreateParams) WithContext(ctx context.Context) *FpolicyPolicyCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the fpolicy policy create params
func (o *FpolicyPolicyCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the fpolicy policy create params
func (o *FpolicyPolicyCreateParams) WithHTTPClient(client *http.Client) *FpolicyPolicyCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the fpolicy policy create params
func (o *FpolicyPolicyCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the fpolicy policy create params
func (o *FpolicyPolicyCreateParams) WithInfo(info *models.FpolicyPolicy) *FpolicyPolicyCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the fpolicy policy create params
func (o *FpolicyPolicyCreateParams) SetInfo(info *models.FpolicyPolicy) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the fpolicy policy create params
func (o *FpolicyPolicyCreateParams) WithReturnRecords(returnRecords *bool) *FpolicyPolicyCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the fpolicy policy create params
func (o *FpolicyPolicyCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithSvmUUID adds the svmUUID to the fpolicy policy create params
func (o *FpolicyPolicyCreateParams) WithSvmUUID(svmUUID string) *FpolicyPolicyCreateParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the fpolicy policy create params
func (o *FpolicyPolicyCreateParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *FpolicyPolicyCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
