// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FpolicyPolicyDeleteCollectionReader is a Reader for the FpolicyPolicyDeleteCollection structure.
type FpolicyPolicyDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FpolicyPolicyDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFpolicyPolicyDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFpolicyPolicyDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFpolicyPolicyDeleteCollectionOK creates a FpolicyPolicyDeleteCollectionOK with default headers values
func NewFpolicyPolicyDeleteCollectionOK() *FpolicyPolicyDeleteCollectionOK {
	return &FpolicyPolicyDeleteCollectionOK{}
}

/*
FpolicyPolicyDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type FpolicyPolicyDeleteCollectionOK struct {
}

// IsSuccess returns true when this fpolicy policy delete collection o k response has a 2xx status code
func (o *FpolicyPolicyDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fpolicy policy delete collection o k response has a 3xx status code
func (o *FpolicyPolicyDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fpolicy policy delete collection o k response has a 4xx status code
func (o *FpolicyPolicyDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fpolicy policy delete collection o k response has a 5xx status code
func (o *FpolicyPolicyDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fpolicy policy delete collection o k response a status code equal to that given
func (o *FpolicyPolicyDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fpolicy policy delete collection o k response
func (o *FpolicyPolicyDeleteCollectionOK) Code() int {
	return 200
}

func (o *FpolicyPolicyDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/policies][%d] fpolicyPolicyDeleteCollectionOK", 200)
}

func (o *FpolicyPolicyDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/policies][%d] fpolicyPolicyDeleteCollectionOK", 200)
}

func (o *FpolicyPolicyDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewFpolicyPolicyDeleteCollectionDefault creates a FpolicyPolicyDeleteCollectionDefault with default headers values
func NewFpolicyPolicyDeleteCollectionDefault(code int) *FpolicyPolicyDeleteCollectionDefault {
	return &FpolicyPolicyDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	FpolicyPolicyDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 9764900    | Deletion of a cluster level FPolicy policy is not supported |
*/
type FpolicyPolicyDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fpolicy policy delete collection default response has a 2xx status code
func (o *FpolicyPolicyDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fpolicy policy delete collection default response has a 3xx status code
func (o *FpolicyPolicyDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fpolicy policy delete collection default response has a 4xx status code
func (o *FpolicyPolicyDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fpolicy policy delete collection default response has a 5xx status code
func (o *FpolicyPolicyDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fpolicy policy delete collection default response a status code equal to that given
func (o *FpolicyPolicyDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fpolicy policy delete collection default response
func (o *FpolicyPolicyDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *FpolicyPolicyDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/policies][%d] fpolicy_policy_delete_collection default %s", o._statusCode, payload)
}

func (o *FpolicyPolicyDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/policies][%d] fpolicy_policy_delete_collection default %s", o._statusCode, payload)
}

func (o *FpolicyPolicyDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FpolicyPolicyDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
FpolicyPolicyDeleteCollectionBody fpolicy policy delete collection body
swagger:model FpolicyPolicyDeleteCollectionBody
*/
type FpolicyPolicyDeleteCollectionBody struct {

	// fpolicy policy response inline records
	FpolicyPolicyResponseInlineRecords []*models.FpolicyPolicy `json:"records,omitempty"`
}

// Validate validates this fpolicy policy delete collection body
func (o *FpolicyPolicyDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateFpolicyPolicyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyPolicyDeleteCollectionBody) validateFpolicyPolicyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.FpolicyPolicyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.FpolicyPolicyResponseInlineRecords); i++ {
		if swag.IsZero(o.FpolicyPolicyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.FpolicyPolicyResponseInlineRecords[i] != nil {
			if err := o.FpolicyPolicyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this fpolicy policy delete collection body based on the context it is used
func (o *FpolicyPolicyDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateFpolicyPolicyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyPolicyDeleteCollectionBody) contextValidateFpolicyPolicyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.FpolicyPolicyResponseInlineRecords); i++ {

		if o.FpolicyPolicyResponseInlineRecords[i] != nil {
			if err := o.FpolicyPolicyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *FpolicyPolicyDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FpolicyPolicyDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res FpolicyPolicyDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
