// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FpolicyPolicyDeleteReader is a Reader for the FpolicyPolicyDelete structure.
type FpolicyPolicyDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FpolicyPolicyDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFpolicyPolicyDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFpolicyPolicyDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFpolicyPolicyDeleteOK creates a FpolicyPolicyDeleteOK with default headers values
func NewFpolicyPolicyDeleteOK() *FpolicyPolicyDeleteOK {
	return &FpolicyPolicyDeleteOK{}
}

/*
FpolicyPolicyDeleteOK describes a response with status code 200, with default header values.

OK
*/
type FpolicyPolicyDeleteOK struct {
}

// IsSuccess returns true when this fpolicy policy delete o k response has a 2xx status code
func (o *FpolicyPolicyDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fpolicy policy delete o k response has a 3xx status code
func (o *FpolicyPolicyDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fpolicy policy delete o k response has a 4xx status code
func (o *FpolicyPolicyDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fpolicy policy delete o k response has a 5xx status code
func (o *FpolicyPolicyDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fpolicy policy delete o k response a status code equal to that given
func (o *FpolicyPolicyDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fpolicy policy delete o k response
func (o *FpolicyPolicyDeleteOK) Code() int {
	return 200
}

func (o *FpolicyPolicyDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/policies/{name}][%d] fpolicyPolicyDeleteOK", 200)
}

func (o *FpolicyPolicyDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/policies/{name}][%d] fpolicyPolicyDeleteOK", 200)
}

func (o *FpolicyPolicyDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewFpolicyPolicyDeleteDefault creates a FpolicyPolicyDeleteDefault with default headers values
func NewFpolicyPolicyDeleteDefault(code int) *FpolicyPolicyDeleteDefault {
	return &FpolicyPolicyDeleteDefault{
		_statusCode: code,
	}
}

/*
	FpolicyPolicyDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 9764900    | Deletion of a cluster level FPolicy policy is not supported |
*/
type FpolicyPolicyDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fpolicy policy delete default response has a 2xx status code
func (o *FpolicyPolicyDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fpolicy policy delete default response has a 3xx status code
func (o *FpolicyPolicyDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fpolicy policy delete default response has a 4xx status code
func (o *FpolicyPolicyDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fpolicy policy delete default response has a 5xx status code
func (o *FpolicyPolicyDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fpolicy policy delete default response a status code equal to that given
func (o *FpolicyPolicyDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fpolicy policy delete default response
func (o *FpolicyPolicyDeleteDefault) Code() int {
	return o._statusCode
}

func (o *FpolicyPolicyDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/policies/{name}][%d] fpolicy_policy_delete default %s", o._statusCode, payload)
}

func (o *FpolicyPolicyDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/fpolicy/{svm.uuid}/policies/{name}][%d] fpolicy_policy_delete default %s", o._statusCode, payload)
}

func (o *FpolicyPolicyDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FpolicyPolicyDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
