// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FpolicyPolicyModifyCollectionReader is a Reader for the FpolicyPolicyModifyCollection structure.
type FpolicyPolicyModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FpolicyPolicyModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFpolicyPolicyModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFpolicyPolicyModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFpolicyPolicyModifyCollectionOK creates a FpolicyPolicyModifyCollectionOK with default headers values
func NewFpolicyPolicyModifyCollectionOK() *FpolicyPolicyModifyCollectionOK {
	return &FpolicyPolicyModifyCollectionOK{}
}

/*
FpolicyPolicyModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type FpolicyPolicyModifyCollectionOK struct {
}

// IsSuccess returns true when this fpolicy policy modify collection o k response has a 2xx status code
func (o *FpolicyPolicyModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fpolicy policy modify collection o k response has a 3xx status code
func (o *FpolicyPolicyModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fpolicy policy modify collection o k response has a 4xx status code
func (o *FpolicyPolicyModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fpolicy policy modify collection o k response has a 5xx status code
func (o *FpolicyPolicyModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fpolicy policy modify collection o k response a status code equal to that given
func (o *FpolicyPolicyModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fpolicy policy modify collection o k response
func (o *FpolicyPolicyModifyCollectionOK) Code() int {
	return 200
}

func (o *FpolicyPolicyModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/fpolicy/{svm.uuid}/policies][%d] fpolicyPolicyModifyCollectionOK", 200)
}

func (o *FpolicyPolicyModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/fpolicy/{svm.uuid}/policies][%d] fpolicyPolicyModifyCollectionOK", 200)
}

func (o *FpolicyPolicyModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewFpolicyPolicyModifyCollectionDefault creates a FpolicyPolicyModifyCollectionDefault with default headers values
func NewFpolicyPolicyModifyCollectionDefault(code int) *FpolicyPolicyModifyCollectionDefault {
	return &FpolicyPolicyModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	FpolicyPolicyModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 9764875    | An FPolicy event does not exist |
| 9764888    | An FPolicy engine does not exist |
| 9765026    | The priority must be specified when enabling the FPolicy policy |
| 9765025    | Cannot disable an FPolicy policy when the priority is specified |
| 9764899    | Cannot modify an enabled FPolicy policy |
| 9764899    | Deletion of a cluster policy is not supported |
| 9764907    | An FPolicy policy is already enabled |
| 9764908    | An FPolicy policy is already disabled |
| 9765029    | An FPolicy was modified but disable/enable failed as the policy is already disabled/enabled |
| 9765036    | Cannot modify an FPolicy policy as passthrough-read policies are not supported without privileged user |
| 9765038    | Passthrough-read policies are not supported with an external engine of type "asynchronous" |
| 9765039    | Passthrough-read policies are not supported with native engine |
| 9765056    | The specified Persistent Store does not exist |
| 9765062    | Policy with Persistent Store does not support mandatory screening |
| 9765065    | A valid privileged user name must be in the form "domain-name\\user-name" |
| 9765066    | The privileged user contains characters that are not allowed |
*/
type FpolicyPolicyModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fpolicy policy modify collection default response has a 2xx status code
func (o *FpolicyPolicyModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fpolicy policy modify collection default response has a 3xx status code
func (o *FpolicyPolicyModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fpolicy policy modify collection default response has a 4xx status code
func (o *FpolicyPolicyModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fpolicy policy modify collection default response has a 5xx status code
func (o *FpolicyPolicyModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fpolicy policy modify collection default response a status code equal to that given
func (o *FpolicyPolicyModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fpolicy policy modify collection default response
func (o *FpolicyPolicyModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *FpolicyPolicyModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/fpolicy/{svm.uuid}/policies][%d] fpolicy_policy_modify_collection default %s", o._statusCode, payload)
}

func (o *FpolicyPolicyModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/fpolicy/{svm.uuid}/policies][%d] fpolicy_policy_modify_collection default %s", o._statusCode, payload)
}

func (o *FpolicyPolicyModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FpolicyPolicyModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
FpolicyPolicyModifyCollectionBody fpolicy policy modify collection body
swagger:model FpolicyPolicyModifyCollectionBody
*/
type FpolicyPolicyModifyCollectionBody struct {

	// Specifies whether privileged access is required for FPolicy servers.
	// Privileged access is used when the FPolicy server requires direct
	// access to the cluster nodes. When this parameter is set to true,
	// FPolicy servers can access files on the cluster using a separate
	// data channel with privileged access.
	//
	AllowPrivilegedAccess *bool `json:"allow_privileged_access,omitempty"`

	// Specifies if the policy is enabled on the SVM or not. If no value is
	// mentioned for this field but priority is set, then this policy will be enabled.
	//
	Enabled *bool `json:"enabled,omitempty"`

	// engine
	Engine *models.FpolicyEngineReference `json:"engine,omitempty"`

	// fpolicy policy inline events
	// Example: ["event_cifs","event_open"]
	FpolicyPolicyInlineEvents []*models.FpolicyEventReference `json:"events,omitempty"`

	// fpolicy policy response inline records
	FpolicyPolicyResponseInlineRecords []*models.FpolicyPolicy `json:"records,omitempty"`

	// Specifies what action to take on a file access event in a case when all primary and secondary servers are down or no response is received from the FPolicy servers within a given timeout period. When this parameter is set to true, file access events will be denied under these circumstances.
	Mandatory *bool `json:"mandatory,omitempty"`

	// Specifies the name of the policy.
	// Example: fp_policy_1
	Name *string `json:"name,omitempty"`

	// Specifies whether passthrough-read should be allowed for FPolicy servers
	// registered for the policy. Passthrough-read is a way to read data for
	// offline files without restoring the files to primary storage. Offline
	// files are files that have been moved to secondary storage.
	//
	PassthroughRead *bool `json:"passthrough_read,omitempty"`

	// Specifies the persistent storage name. This can then be used
	// to enable persistent mode for FPolicy events.
	//
	// Example: ps1
	PersistentStore *string `json:"persistent_store,omitempty"`

	// Specifies the priority that is assigned to this policy.
	// Example: 1
	// Maximum: 10
	// Minimum: 1
	Priority *int64 `json:"priority,omitempty"`

	// Specifies the privileged user name for accessing files on the cluster
	// using a separate data channel with privileged access. The input for
	// this field should be in "domain\username" format.
	//
	// Example: mydomain\\testuser
	PrivilegedUser *string `json:"privileged_user,omitempty"`

	// scope
	Scope *models.FpolicyPolicyInlineScope `json:"scope,omitempty"`

	// svm
	Svm *models.FpolicyPolicyInlineSvm `json:"svm,omitempty"`
}

// Validate validates this fpolicy policy modify collection body
func (o *FpolicyPolicyModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateEngine(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFpolicyPolicyInlineEvents(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFpolicyPolicyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePriority(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyPolicyModifyCollectionBody) validateEngine(formats strfmt.Registry) error {
	if swag.IsZero(o.Engine) { // not required
		return nil
	}

	if o.Engine != nil {
		if err := o.Engine.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "engine")
			}
			return err
		}
	}

	return nil
}

func (o *FpolicyPolicyModifyCollectionBody) validateFpolicyPolicyInlineEvents(formats strfmt.Registry) error {
	if swag.IsZero(o.FpolicyPolicyInlineEvents) { // not required
		return nil
	}

	for i := 0; i < len(o.FpolicyPolicyInlineEvents); i++ {
		if swag.IsZero(o.FpolicyPolicyInlineEvents[i]) { // not required
			continue
		}

		if o.FpolicyPolicyInlineEvents[i] != nil {
			if err := o.FpolicyPolicyInlineEvents[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "events" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FpolicyPolicyModifyCollectionBody) validateFpolicyPolicyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.FpolicyPolicyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.FpolicyPolicyResponseInlineRecords); i++ {
		if swag.IsZero(o.FpolicyPolicyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.FpolicyPolicyResponseInlineRecords[i] != nil {
			if err := o.FpolicyPolicyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FpolicyPolicyModifyCollectionBody) validatePriority(formats strfmt.Registry) error {
	if swag.IsZero(o.Priority) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"priority", "body", *o.Priority, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"priority", "body", *o.Priority, 10, false); err != nil {
		return err
	}

	return nil
}

func (o *FpolicyPolicyModifyCollectionBody) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(o.Scope) { // not required
		return nil
	}

	if o.Scope != nil {
		if err := o.Scope.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "scope")
			}
			return err
		}
	}

	return nil
}

func (o *FpolicyPolicyModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fpolicy policy modify collection body based on the context it is used
func (o *FpolicyPolicyModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateEngine(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFpolicyPolicyInlineEvents(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFpolicyPolicyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyPolicyModifyCollectionBody) contextValidateEngine(ctx context.Context, formats strfmt.Registry) error {

	if o.Engine != nil {
		if err := o.Engine.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "engine")
			}
			return err
		}
	}

	return nil
}

func (o *FpolicyPolicyModifyCollectionBody) contextValidateFpolicyPolicyInlineEvents(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.FpolicyPolicyInlineEvents); i++ {

		if o.FpolicyPolicyInlineEvents[i] != nil {
			if err := o.FpolicyPolicyInlineEvents[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "events" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FpolicyPolicyModifyCollectionBody) contextValidateFpolicyPolicyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.FpolicyPolicyResponseInlineRecords); i++ {

		if o.FpolicyPolicyResponseInlineRecords[i] != nil {
			if err := o.FpolicyPolicyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FpolicyPolicyModifyCollectionBody) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if o.Scope != nil {
		if err := o.Scope.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "scope")
			}
			return err
		}
	}

	return nil
}

func (o *FpolicyPolicyModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FpolicyPolicyModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FpolicyPolicyModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res FpolicyPolicyModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FpolicyPolicyInlineScope fpolicy policy inline scope
swagger:model fpolicy_policy_inline_scope
*/
type FpolicyPolicyInlineScope struct {

	// Specifies whether the file name extension checks also apply to directory objects. If this parameter is set to true,
	// the directory objects are subjected to the same extension checks as regular files. If this parameter is set to false,
	// the directory names are not matched for extensions and notifications are sent for directories even if their name
	// extensions do not match. Default is false.
	//
	CheckExtensionsOnDirectories *bool `json:"check_extensions_on_directories,omitempty"`

	// exclude export policies
	ExcludeExportPolicies []*string `json:"exclude_export_policies,omitempty"`

	// exclude extension
	ExcludeExtension []*string `json:"exclude_extension,omitempty"`

	// exclude shares
	ExcludeShares []*string `json:"exclude_shares,omitempty"`

	// exclude volumes
	// Example: ["vol1","vol_svm1","*"]
	ExcludeVolumes []*string `json:"exclude_volumes,omitempty"`

	// include export policies
	IncludeExportPolicies []*string `json:"include_export_policies,omitempty"`

	// include extension
	IncludeExtension []*string `json:"include_extension,omitempty"`

	// include shares
	// Example: ["sh1","share_cifs"]
	IncludeShares []*string `json:"include_shares,omitempty"`

	// include volumes
	// Example: ["vol1","vol_svm1"]
	IncludeVolumes []*string `json:"include_volumes,omitempty"`

	// Specifies whether the extension checks also apply to objects with no extension. If this parameter is set to true,
	// all objects with or without extensions are monitored. Default is false.
	//
	ObjectMonitoringWithNoExtension *bool `json:"object_monitoring_with_no_extension,omitempty"`
}

// Validate validates this fpolicy policy inline scope
func (o *FpolicyPolicyInlineScope) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this fpolicy policy inline scope based on context it is used
func (o *FpolicyPolicyInlineScope) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *FpolicyPolicyInlineScope) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FpolicyPolicyInlineScope) UnmarshalBinary(b []byte) error {
	var res FpolicyPolicyInlineScope
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FpolicyPolicyInlineSvm fpolicy policy inline svm
swagger:model fpolicy_policy_inline_svm
*/
type FpolicyPolicyInlineSvm struct {

	// SVM UUID
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fpolicy policy inline svm
func (o *FpolicyPolicyInlineSvm) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fpolicy policy inline svm based on the context it is used
func (o *FpolicyPolicyInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FpolicyPolicyInlineSvm) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"svm"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FpolicyPolicyInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FpolicyPolicyInlineSvm) UnmarshalBinary(b []byte) error {
	var res FpolicyPolicyInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
