// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGroupPoliciesToBeAppliedModifyCollectionParams creates a new GroupPoliciesToBeAppliedModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGroupPoliciesToBeAppliedModifyCollectionParams() *GroupPoliciesToBeAppliedModifyCollectionParams {
	return &GroupPoliciesToBeAppliedModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGroupPoliciesToBeAppliedModifyCollectionParamsWithTimeout creates a new GroupPoliciesToBeAppliedModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewGroupPoliciesToBeAppliedModifyCollectionParamsWithTimeout(timeout time.Duration) *GroupPoliciesToBeAppliedModifyCollectionParams {
	return &GroupPoliciesToBeAppliedModifyCollectionParams{
		timeout: timeout,
	}
}

// NewGroupPoliciesToBeAppliedModifyCollectionParamsWithContext creates a new GroupPoliciesToBeAppliedModifyCollectionParams object
// with the ability to set a context for a request.
func NewGroupPoliciesToBeAppliedModifyCollectionParamsWithContext(ctx context.Context) *GroupPoliciesToBeAppliedModifyCollectionParams {
	return &GroupPoliciesToBeAppliedModifyCollectionParams{
		Context: ctx,
	}
}

// NewGroupPoliciesToBeAppliedModifyCollectionParamsWithHTTPClient creates a new GroupPoliciesToBeAppliedModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewGroupPoliciesToBeAppliedModifyCollectionParamsWithHTTPClient(client *http.Client) *GroupPoliciesToBeAppliedModifyCollectionParams {
	return &GroupPoliciesToBeAppliedModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
GroupPoliciesToBeAppliedModifyCollectionParams contains all the parameters to send to the API endpoint

	for the group policies to be applied modify collection operation.

	Typically these are written to a http.Request.
*/
type GroupPoliciesToBeAppliedModifyCollectionParams struct {

	/* ApplyUpdates.

	   Indicates whether to apply updates or not.

	   Default: true
	*/
	ApplyUpdates *bool

	/* CentralAccessPolicySettings.

	   Filter by central_access_policy_settings
	*/
	CentralAccessPolicySettings *string

	/* CentralAccessPolicyStagingAuditType.

	   Filter by central_access_policy_staging_audit_type
	*/
	CentralAccessPolicyStagingAuditType *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Extensions.

	   Filter by extensions
	*/
	Extensions *string

	/* FileSystemPath.

	   Filter by file_system_path
	*/
	FileSystemPath *string

	/* ForceReapplyAllSettings.

	   Indicates whether or not a re-applying of all settings is enforced.
	*/
	ForceReapplyAllSettings *bool

	/* Index.

	   Filter by index
	*/
	Index *int64

	/* Info.

	   Info specification
	*/
	Info GroupPoliciesToBeAppliedModifyCollectionBody

	/* LdapPath.

	   Filter by ldap_path
	*/
	LdapPath *string

	/* Link.

	   Filter by link
	*/
	Link *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* RegistrySettingsBranchcacheHashPublicationMode.

	   Filter by registry_settings.branchcache.hash_publication_mode
	*/
	RegistrySettingsBranchcacheHashPublicationMode *string

	/* RegistrySettingsBranchcacheSupportedHashVersion.

	   Filter by registry_settings.branchcache.supported_hash_version
	*/
	RegistrySettingsBranchcacheSupportedHashVersion *string

	/* RegistrySettingsRefreshTimeInterval.

	   Filter by registry_settings.refresh_time_interval
	*/
	RegistrySettingsRefreshTimeInterval *string

	/* RegistrySettingsRefreshTimeRandomOffset.

	   Filter by registry_settings.refresh_time_random_offset
	*/
	RegistrySettingsRefreshTimeRandomOffset *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SecuritySettingsEventAuditSettingsLogonType.

	   Filter by security_settings.event_audit_settings.logon_type
	*/
	SecuritySettingsEventAuditSettingsLogonType *string

	/* SecuritySettingsEventAuditSettingsObjectAccessType.

	   Filter by security_settings.event_audit_settings.object_access_type
	*/
	SecuritySettingsEventAuditSettingsObjectAccessType *string

	/* SecuritySettingsEventLogSettingsMaxSize.

	   Filter by security_settings.event_log_settings.max_size
	*/
	SecuritySettingsEventLogSettingsMaxSize *int64

	/* SecuritySettingsEventLogSettingsRetentionMethod.

	   Filter by security_settings.event_log_settings.retention_method
	*/
	SecuritySettingsEventLogSettingsRetentionMethod *string

	/* SecuritySettingsFilesOrFolders.

	   Filter by security_settings.files_or_folders
	*/
	SecuritySettingsFilesOrFolders *string

	/* SecuritySettingsKerberosMaxClockSkew.

	   Filter by security_settings.kerberos.max_clock_skew
	*/
	SecuritySettingsKerberosMaxClockSkew *string

	/* SecuritySettingsKerberosMaxRenewAge.

	   Filter by security_settings.kerberos.max_renew_age
	*/
	SecuritySettingsKerberosMaxRenewAge *string

	/* SecuritySettingsKerberosMaxTicketAge.

	   Filter by security_settings.kerberos.max_ticket_age
	*/
	SecuritySettingsKerberosMaxTicketAge *string

	/* SecuritySettingsPrivilegeRightsChangeNotifyUsers.

	   Filter by security_settings.privilege_rights.change_notify_users
	*/
	SecuritySettingsPrivilegeRightsChangeNotifyUsers *string

	/* SecuritySettingsPrivilegeRightsSecurityPrivilegeUsers.

	   Filter by security_settings.privilege_rights.security_privilege_users
	*/
	SecuritySettingsPrivilegeRightsSecurityPrivilegeUsers *string

	/* SecuritySettingsPrivilegeRightsTakeOwnershipUsers.

	   Filter by security_settings.privilege_rights.take_ownership_users
	*/
	SecuritySettingsPrivilegeRightsTakeOwnershipUsers *string

	/* SecuritySettingsRegistryValuesSigningRequired.

	   Filter by security_settings.registry_values.signing_required
	*/
	SecuritySettingsRegistryValuesSigningRequired *bool

	/* SecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted.

	   Filter by security_settings.restrict_anonymous.anonymous_access_to_shares_and_named_pipes_restricted
	*/
	SecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted *bool

	/* SecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser.

	   Filter by security_settings.restrict_anonymous.combined_restriction_for_anonymous_user
	*/
	SecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser *string

	/* SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts.

	   Filter by security_settings.restrict_anonymous.no_enumeration_of_sam_accounts
	*/
	SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts *bool

	/* SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares.

	   Filter by security_settings.restrict_anonymous.no_enumeration_of_sam_accounts_and_shares
	*/
	SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares *bool

	/* SecuritySettingsRestrictedGroups.

	   Filter by security_settings.restricted_groups
	*/
	SecuritySettingsRestrictedGroups *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* Version.

	   Filter by version
	*/
	Version *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the group policies to be applied modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithDefaults() *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the group policies to be applied modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetDefaults() {
	var (
		applyUpdatesDefault = bool(true)

		continueOnFailureDefault = bool(false)

		forceReapplyAllSettingsDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := GroupPoliciesToBeAppliedModifyCollectionParams{
		ApplyUpdates:            &applyUpdatesDefault,
		ContinueOnFailure:       &continueOnFailureDefault,
		ForceReapplyAllSettings: &forceReapplyAllSettingsDefault,
		ReturnRecords:           &returnRecordsDefault,
		ReturnTimeout:           &returnTimeoutDefault,
		SerialRecords:           &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithTimeout(timeout time.Duration) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithContext(ctx context.Context) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithHTTPClient(client *http.Client) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplyUpdates adds the applyUpdates to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithApplyUpdates(applyUpdates *bool) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetApplyUpdates(applyUpdates)
	return o
}

// SetApplyUpdates adds the applyUpdates to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetApplyUpdates(applyUpdates *bool) {
	o.ApplyUpdates = applyUpdates
}

// WithCentralAccessPolicySettings adds the centralAccessPolicySettings to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithCentralAccessPolicySettings(centralAccessPolicySettings *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetCentralAccessPolicySettings(centralAccessPolicySettings)
	return o
}

// SetCentralAccessPolicySettings adds the centralAccessPolicySettings to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetCentralAccessPolicySettings(centralAccessPolicySettings *string) {
	o.CentralAccessPolicySettings = centralAccessPolicySettings
}

// WithCentralAccessPolicyStagingAuditType adds the centralAccessPolicyStagingAuditType to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithCentralAccessPolicyStagingAuditType(centralAccessPolicyStagingAuditType *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetCentralAccessPolicyStagingAuditType(centralAccessPolicyStagingAuditType)
	return o
}

// SetCentralAccessPolicyStagingAuditType adds the centralAccessPolicyStagingAuditType to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetCentralAccessPolicyStagingAuditType(centralAccessPolicyStagingAuditType *string) {
	o.CentralAccessPolicyStagingAuditType = centralAccessPolicyStagingAuditType
}

// WithContinueOnFailure adds the continueOnFailure to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithEnabled adds the enabled to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithEnabled(enabled *bool) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithExtensions adds the extensions to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithExtensions(extensions *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetExtensions(extensions)
	return o
}

// SetExtensions adds the extensions to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetExtensions(extensions *string) {
	o.Extensions = extensions
}

// WithFileSystemPath adds the fileSystemPath to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithFileSystemPath(fileSystemPath *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetFileSystemPath(fileSystemPath)
	return o
}

// SetFileSystemPath adds the fileSystemPath to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetFileSystemPath(fileSystemPath *string) {
	o.FileSystemPath = fileSystemPath
}

// WithForceReapplyAllSettings adds the forceReapplyAllSettings to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithForceReapplyAllSettings(forceReapplyAllSettings *bool) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetForceReapplyAllSettings(forceReapplyAllSettings)
	return o
}

// SetForceReapplyAllSettings adds the forceReapplyAllSettings to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetForceReapplyAllSettings(forceReapplyAllSettings *bool) {
	o.ForceReapplyAllSettings = forceReapplyAllSettings
}

// WithIndex adds the index to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithIndex(index *int64) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetIndex(index *int64) {
	o.Index = index
}

// WithInfo adds the info to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithInfo(info GroupPoliciesToBeAppliedModifyCollectionBody) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetInfo(info GroupPoliciesToBeAppliedModifyCollectionBody) {
	o.Info = info
}

// WithLdapPath adds the ldapPath to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithLdapPath(ldapPath *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetLdapPath(ldapPath)
	return o
}

// SetLdapPath adds the ldapPath to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetLdapPath(ldapPath *string) {
	o.LdapPath = ldapPath
}

// WithLink adds the link to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithLink(link *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetLink(link)
	return o
}

// SetLink adds the link to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetLink(link *string) {
	o.Link = link
}

// WithName adds the name to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithName(name *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithRegistrySettingsBranchcacheHashPublicationMode adds the registrySettingsBranchcacheHashPublicationMode to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithRegistrySettingsBranchcacheHashPublicationMode(registrySettingsBranchcacheHashPublicationMode *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetRegistrySettingsBranchcacheHashPublicationMode(registrySettingsBranchcacheHashPublicationMode)
	return o
}

// SetRegistrySettingsBranchcacheHashPublicationMode adds the registrySettingsBranchcacheHashPublicationMode to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetRegistrySettingsBranchcacheHashPublicationMode(registrySettingsBranchcacheHashPublicationMode *string) {
	o.RegistrySettingsBranchcacheHashPublicationMode = registrySettingsBranchcacheHashPublicationMode
}

// WithRegistrySettingsBranchcacheSupportedHashVersion adds the registrySettingsBranchcacheSupportedHashVersion to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithRegistrySettingsBranchcacheSupportedHashVersion(registrySettingsBranchcacheSupportedHashVersion *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetRegistrySettingsBranchcacheSupportedHashVersion(registrySettingsBranchcacheSupportedHashVersion)
	return o
}

// SetRegistrySettingsBranchcacheSupportedHashVersion adds the registrySettingsBranchcacheSupportedHashVersion to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetRegistrySettingsBranchcacheSupportedHashVersion(registrySettingsBranchcacheSupportedHashVersion *string) {
	o.RegistrySettingsBranchcacheSupportedHashVersion = registrySettingsBranchcacheSupportedHashVersion
}

// WithRegistrySettingsRefreshTimeInterval adds the registrySettingsRefreshTimeInterval to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithRegistrySettingsRefreshTimeInterval(registrySettingsRefreshTimeInterval *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetRegistrySettingsRefreshTimeInterval(registrySettingsRefreshTimeInterval)
	return o
}

// SetRegistrySettingsRefreshTimeInterval adds the registrySettingsRefreshTimeInterval to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetRegistrySettingsRefreshTimeInterval(registrySettingsRefreshTimeInterval *string) {
	o.RegistrySettingsRefreshTimeInterval = registrySettingsRefreshTimeInterval
}

// WithRegistrySettingsRefreshTimeRandomOffset adds the registrySettingsRefreshTimeRandomOffset to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithRegistrySettingsRefreshTimeRandomOffset(registrySettingsRefreshTimeRandomOffset *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetRegistrySettingsRefreshTimeRandomOffset(registrySettingsRefreshTimeRandomOffset)
	return o
}

// SetRegistrySettingsRefreshTimeRandomOffset adds the registrySettingsRefreshTimeRandomOffset to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetRegistrySettingsRefreshTimeRandomOffset(registrySettingsRefreshTimeRandomOffset *string) {
	o.RegistrySettingsRefreshTimeRandomOffset = registrySettingsRefreshTimeRandomOffset
}

// WithReturnRecords adds the returnRecords to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithReturnRecords(returnRecords *bool) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSecuritySettingsEventAuditSettingsLogonType adds the securitySettingsEventAuditSettingsLogonType to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithSecuritySettingsEventAuditSettingsLogonType(securitySettingsEventAuditSettingsLogonType *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetSecuritySettingsEventAuditSettingsLogonType(securitySettingsEventAuditSettingsLogonType)
	return o
}

// SetSecuritySettingsEventAuditSettingsLogonType adds the securitySettingsEventAuditSettingsLogonType to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetSecuritySettingsEventAuditSettingsLogonType(securitySettingsEventAuditSettingsLogonType *string) {
	o.SecuritySettingsEventAuditSettingsLogonType = securitySettingsEventAuditSettingsLogonType
}

// WithSecuritySettingsEventAuditSettingsObjectAccessType adds the securitySettingsEventAuditSettingsObjectAccessType to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithSecuritySettingsEventAuditSettingsObjectAccessType(securitySettingsEventAuditSettingsObjectAccessType *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetSecuritySettingsEventAuditSettingsObjectAccessType(securitySettingsEventAuditSettingsObjectAccessType)
	return o
}

// SetSecuritySettingsEventAuditSettingsObjectAccessType adds the securitySettingsEventAuditSettingsObjectAccessType to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetSecuritySettingsEventAuditSettingsObjectAccessType(securitySettingsEventAuditSettingsObjectAccessType *string) {
	o.SecuritySettingsEventAuditSettingsObjectAccessType = securitySettingsEventAuditSettingsObjectAccessType
}

// WithSecuritySettingsEventLogSettingsMaxSize adds the securitySettingsEventLogSettingsMaxSize to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithSecuritySettingsEventLogSettingsMaxSize(securitySettingsEventLogSettingsMaxSize *int64) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetSecuritySettingsEventLogSettingsMaxSize(securitySettingsEventLogSettingsMaxSize)
	return o
}

// SetSecuritySettingsEventLogSettingsMaxSize adds the securitySettingsEventLogSettingsMaxSize to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetSecuritySettingsEventLogSettingsMaxSize(securitySettingsEventLogSettingsMaxSize *int64) {
	o.SecuritySettingsEventLogSettingsMaxSize = securitySettingsEventLogSettingsMaxSize
}

// WithSecuritySettingsEventLogSettingsRetentionMethod adds the securitySettingsEventLogSettingsRetentionMethod to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithSecuritySettingsEventLogSettingsRetentionMethod(securitySettingsEventLogSettingsRetentionMethod *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetSecuritySettingsEventLogSettingsRetentionMethod(securitySettingsEventLogSettingsRetentionMethod)
	return o
}

// SetSecuritySettingsEventLogSettingsRetentionMethod adds the securitySettingsEventLogSettingsRetentionMethod to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetSecuritySettingsEventLogSettingsRetentionMethod(securitySettingsEventLogSettingsRetentionMethod *string) {
	o.SecuritySettingsEventLogSettingsRetentionMethod = securitySettingsEventLogSettingsRetentionMethod
}

// WithSecuritySettingsFilesOrFolders adds the securitySettingsFilesOrFolders to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithSecuritySettingsFilesOrFolders(securitySettingsFilesOrFolders *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetSecuritySettingsFilesOrFolders(securitySettingsFilesOrFolders)
	return o
}

// SetSecuritySettingsFilesOrFolders adds the securitySettingsFilesOrFolders to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetSecuritySettingsFilesOrFolders(securitySettingsFilesOrFolders *string) {
	o.SecuritySettingsFilesOrFolders = securitySettingsFilesOrFolders
}

// WithSecuritySettingsKerberosMaxClockSkew adds the securitySettingsKerberosMaxClockSkew to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithSecuritySettingsKerberosMaxClockSkew(securitySettingsKerberosMaxClockSkew *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetSecuritySettingsKerberosMaxClockSkew(securitySettingsKerberosMaxClockSkew)
	return o
}

// SetSecuritySettingsKerberosMaxClockSkew adds the securitySettingsKerberosMaxClockSkew to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetSecuritySettingsKerberosMaxClockSkew(securitySettingsKerberosMaxClockSkew *string) {
	o.SecuritySettingsKerberosMaxClockSkew = securitySettingsKerberosMaxClockSkew
}

// WithSecuritySettingsKerberosMaxRenewAge adds the securitySettingsKerberosMaxRenewAge to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithSecuritySettingsKerberosMaxRenewAge(securitySettingsKerberosMaxRenewAge *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetSecuritySettingsKerberosMaxRenewAge(securitySettingsKerberosMaxRenewAge)
	return o
}

// SetSecuritySettingsKerberosMaxRenewAge adds the securitySettingsKerberosMaxRenewAge to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetSecuritySettingsKerberosMaxRenewAge(securitySettingsKerberosMaxRenewAge *string) {
	o.SecuritySettingsKerberosMaxRenewAge = securitySettingsKerberosMaxRenewAge
}

// WithSecuritySettingsKerberosMaxTicketAge adds the securitySettingsKerberosMaxTicketAge to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithSecuritySettingsKerberosMaxTicketAge(securitySettingsKerberosMaxTicketAge *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetSecuritySettingsKerberosMaxTicketAge(securitySettingsKerberosMaxTicketAge)
	return o
}

// SetSecuritySettingsKerberosMaxTicketAge adds the securitySettingsKerberosMaxTicketAge to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetSecuritySettingsKerberosMaxTicketAge(securitySettingsKerberosMaxTicketAge *string) {
	o.SecuritySettingsKerberosMaxTicketAge = securitySettingsKerberosMaxTicketAge
}

// WithSecuritySettingsPrivilegeRightsChangeNotifyUsers adds the securitySettingsPrivilegeRightsChangeNotifyUsers to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithSecuritySettingsPrivilegeRightsChangeNotifyUsers(securitySettingsPrivilegeRightsChangeNotifyUsers *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetSecuritySettingsPrivilegeRightsChangeNotifyUsers(securitySettingsPrivilegeRightsChangeNotifyUsers)
	return o
}

// SetSecuritySettingsPrivilegeRightsChangeNotifyUsers adds the securitySettingsPrivilegeRightsChangeNotifyUsers to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetSecuritySettingsPrivilegeRightsChangeNotifyUsers(securitySettingsPrivilegeRightsChangeNotifyUsers *string) {
	o.SecuritySettingsPrivilegeRightsChangeNotifyUsers = securitySettingsPrivilegeRightsChangeNotifyUsers
}

// WithSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers adds the securitySettingsPrivilegeRightsSecurityPrivilegeUsers to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers(securitySettingsPrivilegeRightsSecurityPrivilegeUsers *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers(securitySettingsPrivilegeRightsSecurityPrivilegeUsers)
	return o
}

// SetSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers adds the securitySettingsPrivilegeRightsSecurityPrivilegeUsers to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers(securitySettingsPrivilegeRightsSecurityPrivilegeUsers *string) {
	o.SecuritySettingsPrivilegeRightsSecurityPrivilegeUsers = securitySettingsPrivilegeRightsSecurityPrivilegeUsers
}

// WithSecuritySettingsPrivilegeRightsTakeOwnershipUsers adds the securitySettingsPrivilegeRightsTakeOwnershipUsers to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithSecuritySettingsPrivilegeRightsTakeOwnershipUsers(securitySettingsPrivilegeRightsTakeOwnershipUsers *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetSecuritySettingsPrivilegeRightsTakeOwnershipUsers(securitySettingsPrivilegeRightsTakeOwnershipUsers)
	return o
}

// SetSecuritySettingsPrivilegeRightsTakeOwnershipUsers adds the securitySettingsPrivilegeRightsTakeOwnershipUsers to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetSecuritySettingsPrivilegeRightsTakeOwnershipUsers(securitySettingsPrivilegeRightsTakeOwnershipUsers *string) {
	o.SecuritySettingsPrivilegeRightsTakeOwnershipUsers = securitySettingsPrivilegeRightsTakeOwnershipUsers
}

// WithSecuritySettingsRegistryValuesSigningRequired adds the securitySettingsRegistryValuesSigningRequired to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithSecuritySettingsRegistryValuesSigningRequired(securitySettingsRegistryValuesSigningRequired *bool) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetSecuritySettingsRegistryValuesSigningRequired(securitySettingsRegistryValuesSigningRequired)
	return o
}

// SetSecuritySettingsRegistryValuesSigningRequired adds the securitySettingsRegistryValuesSigningRequired to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetSecuritySettingsRegistryValuesSigningRequired(securitySettingsRegistryValuesSigningRequired *bool) {
	o.SecuritySettingsRegistryValuesSigningRequired = securitySettingsRegistryValuesSigningRequired
}

// WithSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted adds the securitySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted(securitySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted *bool) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted(securitySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted)
	return o
}

// SetSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted adds the securitySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted(securitySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted *bool) {
	o.SecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted = securitySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted
}

// WithSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser adds the securitySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser(securitySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser(securitySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser)
	return o
}

// SetSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser adds the securitySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser(securitySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser *string) {
	o.SecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser = securitySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser
}

// WithSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts adds the securitySettingsRestrictAnonymousNoEnumerationOfSamAccounts to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts(securitySettingsRestrictAnonymousNoEnumerationOfSamAccounts *bool) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts(securitySettingsRestrictAnonymousNoEnumerationOfSamAccounts)
	return o
}

// SetSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts adds the securitySettingsRestrictAnonymousNoEnumerationOfSamAccounts to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts(securitySettingsRestrictAnonymousNoEnumerationOfSamAccounts *bool) {
	o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts = securitySettingsRestrictAnonymousNoEnumerationOfSamAccounts
}

// WithSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares adds the securitySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares(securitySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares *bool) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares(securitySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares)
	return o
}

// SetSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares adds the securitySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares(securitySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares *bool) {
	o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares = securitySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares
}

// WithSecuritySettingsRestrictedGroups adds the securitySettingsRestrictedGroups to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithSecuritySettingsRestrictedGroups(securitySettingsRestrictedGroups *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetSecuritySettingsRestrictedGroups(securitySettingsRestrictedGroups)
	return o
}

// SetSecuritySettingsRestrictedGroups adds the securitySettingsRestrictedGroups to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetSecuritySettingsRestrictedGroups(securitySettingsRestrictedGroups *string) {
	o.SecuritySettingsRestrictedGroups = securitySettingsRestrictedGroups
}

// WithSerialRecords adds the serialRecords to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithSerialRecords(serialRecords *bool) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithSvmName(svmName *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithSvmUUID(svmUUID *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithUUID(uuid *string) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVersion adds the version to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WithVersion(version *int64) *GroupPoliciesToBeAppliedModifyCollectionParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the group policies to be applied modify collection params
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) SetVersion(version *int64) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *GroupPoliciesToBeAppliedModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ApplyUpdates != nil {

		// query param apply_updates
		var qrApplyUpdates bool

		if o.ApplyUpdates != nil {
			qrApplyUpdates = *o.ApplyUpdates
		}
		qApplyUpdates := swag.FormatBool(qrApplyUpdates)
		if qApplyUpdates != "" {

			if err := r.SetQueryParam("apply_updates", qApplyUpdates); err != nil {
				return err
			}
		}
	}

	if o.CentralAccessPolicySettings != nil {

		// query param central_access_policy_settings
		var qrCentralAccessPolicySettings string

		if o.CentralAccessPolicySettings != nil {
			qrCentralAccessPolicySettings = *o.CentralAccessPolicySettings
		}
		qCentralAccessPolicySettings := qrCentralAccessPolicySettings
		if qCentralAccessPolicySettings != "" {

			if err := r.SetQueryParam("central_access_policy_settings", qCentralAccessPolicySettings); err != nil {
				return err
			}
		}
	}

	if o.CentralAccessPolicyStagingAuditType != nil {

		// query param central_access_policy_staging_audit_type
		var qrCentralAccessPolicyStagingAuditType string

		if o.CentralAccessPolicyStagingAuditType != nil {
			qrCentralAccessPolicyStagingAuditType = *o.CentralAccessPolicyStagingAuditType
		}
		qCentralAccessPolicyStagingAuditType := qrCentralAccessPolicyStagingAuditType
		if qCentralAccessPolicyStagingAuditType != "" {

			if err := r.SetQueryParam("central_access_policy_staging_audit_type", qCentralAccessPolicyStagingAuditType); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.Extensions != nil {

		// query param extensions
		var qrExtensions string

		if o.Extensions != nil {
			qrExtensions = *o.Extensions
		}
		qExtensions := qrExtensions
		if qExtensions != "" {

			if err := r.SetQueryParam("extensions", qExtensions); err != nil {
				return err
			}
		}
	}

	if o.FileSystemPath != nil {

		// query param file_system_path
		var qrFileSystemPath string

		if o.FileSystemPath != nil {
			qrFileSystemPath = *o.FileSystemPath
		}
		qFileSystemPath := qrFileSystemPath
		if qFileSystemPath != "" {

			if err := r.SetQueryParam("file_system_path", qFileSystemPath); err != nil {
				return err
			}
		}
	}

	if o.ForceReapplyAllSettings != nil {

		// query param force_reapply_all_settings
		var qrForceReapplyAllSettings bool

		if o.ForceReapplyAllSettings != nil {
			qrForceReapplyAllSettings = *o.ForceReapplyAllSettings
		}
		qForceReapplyAllSettings := swag.FormatBool(qrForceReapplyAllSettings)
		if qForceReapplyAllSettings != "" {

			if err := r.SetQueryParam("force_reapply_all_settings", qForceReapplyAllSettings); err != nil {
				return err
			}
		}
	}

	if o.Index != nil {

		// query param index
		var qrIndex int64

		if o.Index != nil {
			qrIndex = *o.Index
		}
		qIndex := swag.FormatInt64(qrIndex)
		if qIndex != "" {

			if err := r.SetQueryParam("index", qIndex); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.LdapPath != nil {

		// query param ldap_path
		var qrLdapPath string

		if o.LdapPath != nil {
			qrLdapPath = *o.LdapPath
		}
		qLdapPath := qrLdapPath
		if qLdapPath != "" {

			if err := r.SetQueryParam("ldap_path", qLdapPath); err != nil {
				return err
			}
		}
	}

	if o.Link != nil {

		// query param link
		var qrLink string

		if o.Link != nil {
			qrLink = *o.Link
		}
		qLink := qrLink
		if qLink != "" {

			if err := r.SetQueryParam("link", qLink); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.RegistrySettingsBranchcacheHashPublicationMode != nil {

		// query param registry_settings.branchcache.hash_publication_mode
		var qrRegistrySettingsBranchcacheHashPublicationMode string

		if o.RegistrySettingsBranchcacheHashPublicationMode != nil {
			qrRegistrySettingsBranchcacheHashPublicationMode = *o.RegistrySettingsBranchcacheHashPublicationMode
		}
		qRegistrySettingsBranchcacheHashPublicationMode := qrRegistrySettingsBranchcacheHashPublicationMode
		if qRegistrySettingsBranchcacheHashPublicationMode != "" {

			if err := r.SetQueryParam("registry_settings.branchcache.hash_publication_mode", qRegistrySettingsBranchcacheHashPublicationMode); err != nil {
				return err
			}
		}
	}

	if o.RegistrySettingsBranchcacheSupportedHashVersion != nil {

		// query param registry_settings.branchcache.supported_hash_version
		var qrRegistrySettingsBranchcacheSupportedHashVersion string

		if o.RegistrySettingsBranchcacheSupportedHashVersion != nil {
			qrRegistrySettingsBranchcacheSupportedHashVersion = *o.RegistrySettingsBranchcacheSupportedHashVersion
		}
		qRegistrySettingsBranchcacheSupportedHashVersion := qrRegistrySettingsBranchcacheSupportedHashVersion
		if qRegistrySettingsBranchcacheSupportedHashVersion != "" {

			if err := r.SetQueryParam("registry_settings.branchcache.supported_hash_version", qRegistrySettingsBranchcacheSupportedHashVersion); err != nil {
				return err
			}
		}
	}

	if o.RegistrySettingsRefreshTimeInterval != nil {

		// query param registry_settings.refresh_time_interval
		var qrRegistrySettingsRefreshTimeInterval string

		if o.RegistrySettingsRefreshTimeInterval != nil {
			qrRegistrySettingsRefreshTimeInterval = *o.RegistrySettingsRefreshTimeInterval
		}
		qRegistrySettingsRefreshTimeInterval := qrRegistrySettingsRefreshTimeInterval
		if qRegistrySettingsRefreshTimeInterval != "" {

			if err := r.SetQueryParam("registry_settings.refresh_time_interval", qRegistrySettingsRefreshTimeInterval); err != nil {
				return err
			}
		}
	}

	if o.RegistrySettingsRefreshTimeRandomOffset != nil {

		// query param registry_settings.refresh_time_random_offset
		var qrRegistrySettingsRefreshTimeRandomOffset string

		if o.RegistrySettingsRefreshTimeRandomOffset != nil {
			qrRegistrySettingsRefreshTimeRandomOffset = *o.RegistrySettingsRefreshTimeRandomOffset
		}
		qRegistrySettingsRefreshTimeRandomOffset := qrRegistrySettingsRefreshTimeRandomOffset
		if qRegistrySettingsRefreshTimeRandomOffset != "" {

			if err := r.SetQueryParam("registry_settings.refresh_time_random_offset", qRegistrySettingsRefreshTimeRandomOffset); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsEventAuditSettingsLogonType != nil {

		// query param security_settings.event_audit_settings.logon_type
		var qrSecuritySettingsEventAuditSettingsLogonType string

		if o.SecuritySettingsEventAuditSettingsLogonType != nil {
			qrSecuritySettingsEventAuditSettingsLogonType = *o.SecuritySettingsEventAuditSettingsLogonType
		}
		qSecuritySettingsEventAuditSettingsLogonType := qrSecuritySettingsEventAuditSettingsLogonType
		if qSecuritySettingsEventAuditSettingsLogonType != "" {

			if err := r.SetQueryParam("security_settings.event_audit_settings.logon_type", qSecuritySettingsEventAuditSettingsLogonType); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsEventAuditSettingsObjectAccessType != nil {

		// query param security_settings.event_audit_settings.object_access_type
		var qrSecuritySettingsEventAuditSettingsObjectAccessType string

		if o.SecuritySettingsEventAuditSettingsObjectAccessType != nil {
			qrSecuritySettingsEventAuditSettingsObjectAccessType = *o.SecuritySettingsEventAuditSettingsObjectAccessType
		}
		qSecuritySettingsEventAuditSettingsObjectAccessType := qrSecuritySettingsEventAuditSettingsObjectAccessType
		if qSecuritySettingsEventAuditSettingsObjectAccessType != "" {

			if err := r.SetQueryParam("security_settings.event_audit_settings.object_access_type", qSecuritySettingsEventAuditSettingsObjectAccessType); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsEventLogSettingsMaxSize != nil {

		// query param security_settings.event_log_settings.max_size
		var qrSecuritySettingsEventLogSettingsMaxSize int64

		if o.SecuritySettingsEventLogSettingsMaxSize != nil {
			qrSecuritySettingsEventLogSettingsMaxSize = *o.SecuritySettingsEventLogSettingsMaxSize
		}
		qSecuritySettingsEventLogSettingsMaxSize := swag.FormatInt64(qrSecuritySettingsEventLogSettingsMaxSize)
		if qSecuritySettingsEventLogSettingsMaxSize != "" {

			if err := r.SetQueryParam("security_settings.event_log_settings.max_size", qSecuritySettingsEventLogSettingsMaxSize); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsEventLogSettingsRetentionMethod != nil {

		// query param security_settings.event_log_settings.retention_method
		var qrSecuritySettingsEventLogSettingsRetentionMethod string

		if o.SecuritySettingsEventLogSettingsRetentionMethod != nil {
			qrSecuritySettingsEventLogSettingsRetentionMethod = *o.SecuritySettingsEventLogSettingsRetentionMethod
		}
		qSecuritySettingsEventLogSettingsRetentionMethod := qrSecuritySettingsEventLogSettingsRetentionMethod
		if qSecuritySettingsEventLogSettingsRetentionMethod != "" {

			if err := r.SetQueryParam("security_settings.event_log_settings.retention_method", qSecuritySettingsEventLogSettingsRetentionMethod); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsFilesOrFolders != nil {

		// query param security_settings.files_or_folders
		var qrSecuritySettingsFilesOrFolders string

		if o.SecuritySettingsFilesOrFolders != nil {
			qrSecuritySettingsFilesOrFolders = *o.SecuritySettingsFilesOrFolders
		}
		qSecuritySettingsFilesOrFolders := qrSecuritySettingsFilesOrFolders
		if qSecuritySettingsFilesOrFolders != "" {

			if err := r.SetQueryParam("security_settings.files_or_folders", qSecuritySettingsFilesOrFolders); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsKerberosMaxClockSkew != nil {

		// query param security_settings.kerberos.max_clock_skew
		var qrSecuritySettingsKerberosMaxClockSkew string

		if o.SecuritySettingsKerberosMaxClockSkew != nil {
			qrSecuritySettingsKerberosMaxClockSkew = *o.SecuritySettingsKerberosMaxClockSkew
		}
		qSecuritySettingsKerberosMaxClockSkew := qrSecuritySettingsKerberosMaxClockSkew
		if qSecuritySettingsKerberosMaxClockSkew != "" {

			if err := r.SetQueryParam("security_settings.kerberos.max_clock_skew", qSecuritySettingsKerberosMaxClockSkew); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsKerberosMaxRenewAge != nil {

		// query param security_settings.kerberos.max_renew_age
		var qrSecuritySettingsKerberosMaxRenewAge string

		if o.SecuritySettingsKerberosMaxRenewAge != nil {
			qrSecuritySettingsKerberosMaxRenewAge = *o.SecuritySettingsKerberosMaxRenewAge
		}
		qSecuritySettingsKerberosMaxRenewAge := qrSecuritySettingsKerberosMaxRenewAge
		if qSecuritySettingsKerberosMaxRenewAge != "" {

			if err := r.SetQueryParam("security_settings.kerberos.max_renew_age", qSecuritySettingsKerberosMaxRenewAge); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsKerberosMaxTicketAge != nil {

		// query param security_settings.kerberos.max_ticket_age
		var qrSecuritySettingsKerberosMaxTicketAge string

		if o.SecuritySettingsKerberosMaxTicketAge != nil {
			qrSecuritySettingsKerberosMaxTicketAge = *o.SecuritySettingsKerberosMaxTicketAge
		}
		qSecuritySettingsKerberosMaxTicketAge := qrSecuritySettingsKerberosMaxTicketAge
		if qSecuritySettingsKerberosMaxTicketAge != "" {

			if err := r.SetQueryParam("security_settings.kerberos.max_ticket_age", qSecuritySettingsKerberosMaxTicketAge); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsPrivilegeRightsChangeNotifyUsers != nil {

		// query param security_settings.privilege_rights.change_notify_users
		var qrSecuritySettingsPrivilegeRightsChangeNotifyUsers string

		if o.SecuritySettingsPrivilegeRightsChangeNotifyUsers != nil {
			qrSecuritySettingsPrivilegeRightsChangeNotifyUsers = *o.SecuritySettingsPrivilegeRightsChangeNotifyUsers
		}
		qSecuritySettingsPrivilegeRightsChangeNotifyUsers := qrSecuritySettingsPrivilegeRightsChangeNotifyUsers
		if qSecuritySettingsPrivilegeRightsChangeNotifyUsers != "" {

			if err := r.SetQueryParam("security_settings.privilege_rights.change_notify_users", qSecuritySettingsPrivilegeRightsChangeNotifyUsers); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsPrivilegeRightsSecurityPrivilegeUsers != nil {

		// query param security_settings.privilege_rights.security_privilege_users
		var qrSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers string

		if o.SecuritySettingsPrivilegeRightsSecurityPrivilegeUsers != nil {
			qrSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers = *o.SecuritySettingsPrivilegeRightsSecurityPrivilegeUsers
		}
		qSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers := qrSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers
		if qSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers != "" {

			if err := r.SetQueryParam("security_settings.privilege_rights.security_privilege_users", qSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsPrivilegeRightsTakeOwnershipUsers != nil {

		// query param security_settings.privilege_rights.take_ownership_users
		var qrSecuritySettingsPrivilegeRightsTakeOwnershipUsers string

		if o.SecuritySettingsPrivilegeRightsTakeOwnershipUsers != nil {
			qrSecuritySettingsPrivilegeRightsTakeOwnershipUsers = *o.SecuritySettingsPrivilegeRightsTakeOwnershipUsers
		}
		qSecuritySettingsPrivilegeRightsTakeOwnershipUsers := qrSecuritySettingsPrivilegeRightsTakeOwnershipUsers
		if qSecuritySettingsPrivilegeRightsTakeOwnershipUsers != "" {

			if err := r.SetQueryParam("security_settings.privilege_rights.take_ownership_users", qSecuritySettingsPrivilegeRightsTakeOwnershipUsers); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsRegistryValuesSigningRequired != nil {

		// query param security_settings.registry_values.signing_required
		var qrSecuritySettingsRegistryValuesSigningRequired bool

		if o.SecuritySettingsRegistryValuesSigningRequired != nil {
			qrSecuritySettingsRegistryValuesSigningRequired = *o.SecuritySettingsRegistryValuesSigningRequired
		}
		qSecuritySettingsRegistryValuesSigningRequired := swag.FormatBool(qrSecuritySettingsRegistryValuesSigningRequired)
		if qSecuritySettingsRegistryValuesSigningRequired != "" {

			if err := r.SetQueryParam("security_settings.registry_values.signing_required", qSecuritySettingsRegistryValuesSigningRequired); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted != nil {

		// query param security_settings.restrict_anonymous.anonymous_access_to_shares_and_named_pipes_restricted
		var qrSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted bool

		if o.SecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted != nil {
			qrSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted = *o.SecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted
		}
		qSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted := swag.FormatBool(qrSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted)
		if qSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted != "" {

			if err := r.SetQueryParam("security_settings.restrict_anonymous.anonymous_access_to_shares_and_named_pipes_restricted", qSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser != nil {

		// query param security_settings.restrict_anonymous.combined_restriction_for_anonymous_user
		var qrSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser string

		if o.SecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser != nil {
			qrSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser = *o.SecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser
		}
		qSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser := qrSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser
		if qSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser != "" {

			if err := r.SetQueryParam("security_settings.restrict_anonymous.combined_restriction_for_anonymous_user", qSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts != nil {

		// query param security_settings.restrict_anonymous.no_enumeration_of_sam_accounts
		var qrSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts bool

		if o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts != nil {
			qrSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts = *o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts
		}
		qSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts := swag.FormatBool(qrSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts)
		if qSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts != "" {

			if err := r.SetQueryParam("security_settings.restrict_anonymous.no_enumeration_of_sam_accounts", qSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares != nil {

		// query param security_settings.restrict_anonymous.no_enumeration_of_sam_accounts_and_shares
		var qrSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares bool

		if o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares != nil {
			qrSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares = *o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares
		}
		qSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares := swag.FormatBool(qrSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares)
		if qSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares != "" {

			if err := r.SetQueryParam("security_settings.restrict_anonymous.no_enumeration_of_sam_accounts_and_shares", qSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsRestrictedGroups != nil {

		// query param security_settings.restricted_groups
		var qrSecuritySettingsRestrictedGroups string

		if o.SecuritySettingsRestrictedGroups != nil {
			qrSecuritySettingsRestrictedGroups = *o.SecuritySettingsRestrictedGroups
		}
		qSecuritySettingsRestrictedGroups := qrSecuritySettingsRestrictedGroups
		if qSecuritySettingsRestrictedGroups != "" {

			if err := r.SetQueryParam("security_settings.restricted_groups", qSecuritySettingsRestrictedGroups); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.Version != nil {

		// query param version
		var qrVersion int64

		if o.Version != nil {
			qrVersion = *o.Version
		}
		qVersion := swag.FormatInt64(qrVersion)
		if qVersion != "" {

			if err := r.SetQueryParam("version", qVersion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
