// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// GroupPoliciesToBeAppliedModifyCollectionReader is a Reader for the GroupPoliciesToBeAppliedModifyCollection structure.
type GroupPoliciesToBeAppliedModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GroupPoliciesToBeAppliedModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGroupPoliciesToBeAppliedModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGroupPoliciesToBeAppliedModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGroupPoliciesToBeAppliedModifyCollectionOK creates a GroupPoliciesToBeAppliedModifyCollectionOK with default headers values
func NewGroupPoliciesToBeAppliedModifyCollectionOK() *GroupPoliciesToBeAppliedModifyCollectionOK {
	return &GroupPoliciesToBeAppliedModifyCollectionOK{}
}

/*
GroupPoliciesToBeAppliedModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type GroupPoliciesToBeAppliedModifyCollectionOK struct {
}

// IsSuccess returns true when this group policies to be applied modify collection o k response has a 2xx status code
func (o *GroupPoliciesToBeAppliedModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this group policies to be applied modify collection o k response has a 3xx status code
func (o *GroupPoliciesToBeAppliedModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this group policies to be applied modify collection o k response has a 4xx status code
func (o *GroupPoliciesToBeAppliedModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this group policies to be applied modify collection o k response has a 5xx status code
func (o *GroupPoliciesToBeAppliedModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this group policies to be applied modify collection o k response a status code equal to that given
func (o *GroupPoliciesToBeAppliedModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the group policies to be applied modify collection o k response
func (o *GroupPoliciesToBeAppliedModifyCollectionOK) Code() int {
	return 200
}

func (o *GroupPoliciesToBeAppliedModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/cifs/group-policies][%d] groupPoliciesToBeAppliedModifyCollectionOK", 200)
}

func (o *GroupPoliciesToBeAppliedModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/cifs/group-policies][%d] groupPoliciesToBeAppliedModifyCollectionOK", 200)
}

func (o *GroupPoliciesToBeAppliedModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGroupPoliciesToBeAppliedModifyCollectionDefault creates a GroupPoliciesToBeAppliedModifyCollectionDefault with default headers values
func NewGroupPoliciesToBeAppliedModifyCollectionDefault(code int) *GroupPoliciesToBeAppliedModifyCollectionDefault {
	return &GroupPoliciesToBeAppliedModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	GroupPoliciesToBeAppliedModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 4456649 | Unable to get Group Policy information for SVM. |
| 4456650 | Group Policy is disabled for SVM. |
| 4456651 | Unable to get CIFS server information for SVM. |
| 4456652 | CIFS server is down for SVM. |
| 4456851 | An update is already in progress for specified SVM. Wait a few minutes, then try the command again. |
| 4456852 | Failed to set forced update for specified SVM. Reason: Internal error. Starting normal update. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type GroupPoliciesToBeAppliedModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this group policies to be applied modify collection default response has a 2xx status code
func (o *GroupPoliciesToBeAppliedModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this group policies to be applied modify collection default response has a 3xx status code
func (o *GroupPoliciesToBeAppliedModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this group policies to be applied modify collection default response has a 4xx status code
func (o *GroupPoliciesToBeAppliedModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this group policies to be applied modify collection default response has a 5xx status code
func (o *GroupPoliciesToBeAppliedModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this group policies to be applied modify collection default response a status code equal to that given
func (o *GroupPoliciesToBeAppliedModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the group policies to be applied modify collection default response
func (o *GroupPoliciesToBeAppliedModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *GroupPoliciesToBeAppliedModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/group-policies][%d] group_policies_to_be_applied_modify_collection default %s", o._statusCode, payload)
}

func (o *GroupPoliciesToBeAppliedModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/group-policies][%d] group_policies_to_be_applied_modify_collection default %s", o._statusCode, payload)
}

func (o *GroupPoliciesToBeAppliedModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GroupPoliciesToBeAppliedModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
GroupPoliciesToBeAppliedModifyCollectionBody group policies to be applied modify collection body
swagger:model GroupPoliciesToBeAppliedModifyCollectionBody
*/
type GroupPoliciesToBeAppliedModifyCollectionBody struct {

	// policies and rules to be applied response inline records
	PoliciesAndRulesToBeAppliedResponseInlineRecords []*models.PoliciesAndRulesToBeApplied `json:"records,omitempty"`

	// svm
	Svm *models.PoliciesAndRulesToBeAppliedInlineSvm `json:"svm,omitempty"`

	// to be applied
	ToBeApplied *models.PoliciesAndRulesToBeAppliedInlineToBeApplied `json:"to_be_applied,omitempty"`
}

// Validate validates this group policies to be applied modify collection body
func (o *GroupPoliciesToBeAppliedModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePoliciesAndRulesToBeAppliedResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateToBeApplied(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GroupPoliciesToBeAppliedModifyCollectionBody) validatePoliciesAndRulesToBeAppliedResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.PoliciesAndRulesToBeAppliedResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.PoliciesAndRulesToBeAppliedResponseInlineRecords); i++ {
		if swag.IsZero(o.PoliciesAndRulesToBeAppliedResponseInlineRecords[i]) { // not required
			continue
		}

		if o.PoliciesAndRulesToBeAppliedResponseInlineRecords[i] != nil {
			if err := o.PoliciesAndRulesToBeAppliedResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *GroupPoliciesToBeAppliedModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *GroupPoliciesToBeAppliedModifyCollectionBody) validateToBeApplied(formats strfmt.Registry) error {
	if swag.IsZero(o.ToBeApplied) { // not required
		return nil
	}

	if o.ToBeApplied != nil {
		if err := o.ToBeApplied.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "to_be_applied")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this group policies to be applied modify collection body based on the context it is used
func (o *GroupPoliciesToBeAppliedModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePoliciesAndRulesToBeAppliedResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateToBeApplied(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GroupPoliciesToBeAppliedModifyCollectionBody) contextValidatePoliciesAndRulesToBeAppliedResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.PoliciesAndRulesToBeAppliedResponseInlineRecords); i++ {

		if o.PoliciesAndRulesToBeAppliedResponseInlineRecords[i] != nil {
			if err := o.PoliciesAndRulesToBeAppliedResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *GroupPoliciesToBeAppliedModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *GroupPoliciesToBeAppliedModifyCollectionBody) contextValidateToBeApplied(ctx context.Context, formats strfmt.Registry) error {

	if o.ToBeApplied != nil {
		if err := o.ToBeApplied.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "to_be_applied")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GroupPoliciesToBeAppliedModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GroupPoliciesToBeAppliedModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res GroupPoliciesToBeAppliedModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PoliciesAndRulesToBeAppliedInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model policies_and_rules_to_be_applied_inline_svm
*/
type PoliciesAndRulesToBeAppliedInlineSvm struct {

	// links
	Links *models.PoliciesAndRulesToBeAppliedInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this policies and rules to be applied inline svm
func (o *PoliciesAndRulesToBeAppliedInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PoliciesAndRulesToBeAppliedInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this policies and rules to be applied inline svm based on the context it is used
func (o *PoliciesAndRulesToBeAppliedInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PoliciesAndRulesToBeAppliedInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PoliciesAndRulesToBeAppliedInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PoliciesAndRulesToBeAppliedInlineSvm) UnmarshalBinary(b []byte) error {
	var res PoliciesAndRulesToBeAppliedInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PoliciesAndRulesToBeAppliedInlineSvmInlineLinks policies and rules to be applied inline svm inline links
swagger:model policies_and_rules_to_be_applied_inline_svm_inline__links
*/
type PoliciesAndRulesToBeAppliedInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this policies and rules to be applied inline svm inline links
func (o *PoliciesAndRulesToBeAppliedInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PoliciesAndRulesToBeAppliedInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this policies and rules to be applied inline svm inline links based on the context it is used
func (o *PoliciesAndRulesToBeAppliedInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PoliciesAndRulesToBeAppliedInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PoliciesAndRulesToBeAppliedInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PoliciesAndRulesToBeAppliedInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res PoliciesAndRulesToBeAppliedInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PoliciesAndRulesToBeAppliedInlineToBeApplied policies and rules to be applied inline to be applied
swagger:model policies_and_rules_to_be_applied_inline_to_be_applied
*/
type PoliciesAndRulesToBeAppliedInlineToBeApplied struct {

	// access policies
	AccessPolicies []*models.GroupPolicyObjectCentralAccessPolicy `json:"access_policies,omitempty"`

	// access rules
	AccessRules []*models.GroupPolicyObjectCentralAccessRule `json:"access_rules,omitempty"`

	// objects
	Objects []*models.GroupPolicyObject `json:"objects,omitempty"`

	// restricted groups
	RestrictedGroups []*models.GroupPolicyObjectRestrictedGroup `json:"restricted_groups,omitempty"`
}

// Validate validates this policies and rules to be applied inline to be applied
func (o *PoliciesAndRulesToBeAppliedInlineToBeApplied) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAccessPolicies(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAccessRules(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateObjects(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRestrictedGroups(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PoliciesAndRulesToBeAppliedInlineToBeApplied) validateAccessPolicies(formats strfmt.Registry) error {
	if swag.IsZero(o.AccessPolicies) { // not required
		return nil
	}

	for i := 0; i < len(o.AccessPolicies); i++ {
		if swag.IsZero(o.AccessPolicies[i]) { // not required
			continue
		}

		if o.AccessPolicies[i] != nil {
			if err := o.AccessPolicies[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "to_be_applied" + "." + "access_policies" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *PoliciesAndRulesToBeAppliedInlineToBeApplied) validateAccessRules(formats strfmt.Registry) error {
	if swag.IsZero(o.AccessRules) { // not required
		return nil
	}

	for i := 0; i < len(o.AccessRules); i++ {
		if swag.IsZero(o.AccessRules[i]) { // not required
			continue
		}

		if o.AccessRules[i] != nil {
			if err := o.AccessRules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "to_be_applied" + "." + "access_rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *PoliciesAndRulesToBeAppliedInlineToBeApplied) validateObjects(formats strfmt.Registry) error {
	if swag.IsZero(o.Objects) { // not required
		return nil
	}

	for i := 0; i < len(o.Objects); i++ {
		if swag.IsZero(o.Objects[i]) { // not required
			continue
		}

		if o.Objects[i] != nil {
			if err := o.Objects[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "to_be_applied" + "." + "objects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *PoliciesAndRulesToBeAppliedInlineToBeApplied) validateRestrictedGroups(formats strfmt.Registry) error {
	if swag.IsZero(o.RestrictedGroups) { // not required
		return nil
	}

	for i := 0; i < len(o.RestrictedGroups); i++ {
		if swag.IsZero(o.RestrictedGroups[i]) { // not required
			continue
		}

		if o.RestrictedGroups[i] != nil {
			if err := o.RestrictedGroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "to_be_applied" + "." + "restricted_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this policies and rules to be applied inline to be applied based on the context it is used
func (o *PoliciesAndRulesToBeAppliedInlineToBeApplied) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAccessPolicies(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAccessRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateObjects(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRestrictedGroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PoliciesAndRulesToBeAppliedInlineToBeApplied) contextValidateAccessPolicies(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.AccessPolicies); i++ {

		if o.AccessPolicies[i] != nil {
			if err := o.AccessPolicies[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "to_be_applied" + "." + "access_policies" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *PoliciesAndRulesToBeAppliedInlineToBeApplied) contextValidateAccessRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.AccessRules); i++ {

		if o.AccessRules[i] != nil {
			if err := o.AccessRules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "to_be_applied" + "." + "access_rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *PoliciesAndRulesToBeAppliedInlineToBeApplied) contextValidateObjects(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Objects); i++ {

		if o.Objects[i] != nil {
			if err := o.Objects[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "to_be_applied" + "." + "objects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *PoliciesAndRulesToBeAppliedInlineToBeApplied) contextValidateRestrictedGroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.RestrictedGroups); i++ {

		if o.RestrictedGroups[i] != nil {
			if err := o.RestrictedGroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "to_be_applied" + "." + "restricted_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *PoliciesAndRulesToBeAppliedInlineToBeApplied) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PoliciesAndRulesToBeAppliedInlineToBeApplied) UnmarshalBinary(b []byte) error {
	var res PoliciesAndRulesToBeAppliedInlineToBeApplied
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
