// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGroupPolicyObjectCollectionGetParams creates a new GroupPolicyObjectCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGroupPolicyObjectCollectionGetParams() *GroupPolicyObjectCollectionGetParams {
	return &GroupPolicyObjectCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGroupPolicyObjectCollectionGetParamsWithTimeout creates a new GroupPolicyObjectCollectionGetParams object
// with the ability to set a timeout on a request.
func NewGroupPolicyObjectCollectionGetParamsWithTimeout(timeout time.Duration) *GroupPolicyObjectCollectionGetParams {
	return &GroupPolicyObjectCollectionGetParams{
		timeout: timeout,
	}
}

// NewGroupPolicyObjectCollectionGetParamsWithContext creates a new GroupPolicyObjectCollectionGetParams object
// with the ability to set a context for a request.
func NewGroupPolicyObjectCollectionGetParamsWithContext(ctx context.Context) *GroupPolicyObjectCollectionGetParams {
	return &GroupPolicyObjectCollectionGetParams{
		Context: ctx,
	}
}

// NewGroupPolicyObjectCollectionGetParamsWithHTTPClient creates a new GroupPolicyObjectCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewGroupPolicyObjectCollectionGetParamsWithHTTPClient(client *http.Client) *GroupPolicyObjectCollectionGetParams {
	return &GroupPolicyObjectCollectionGetParams{
		HTTPClient: client,
	}
}

/*
GroupPolicyObjectCollectionGetParams contains all the parameters to send to the API endpoint

	for the group policy object collection get operation.

	Typically these are written to a http.Request.
*/
type GroupPolicyObjectCollectionGetParams struct {

	/* CentralAccessPolicySettings.

	   Filter by central_access_policy_settings
	*/
	CentralAccessPolicySettings *string

	/* CentralAccessPolicyStagingAuditType.

	   Filter by central_access_policy_staging_audit_type
	*/
	CentralAccessPolicyStagingAuditType *string

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Extensions.

	   Filter by extensions
	*/
	Extensions *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* FileSystemPath.

	   Filter by file_system_path
	*/
	FileSystemPath *string

	/* Index.

	   Filter by index
	*/
	Index *int64

	/* LdapPath.

	   Filter by ldap_path
	*/
	LdapPath *string

	/* Link.

	   Filter by link
	*/
	Link *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* RegistrySettingsBranchcacheHashPublicationMode.

	   Filter by registry_settings.branchcache.hash_publication_mode
	*/
	RegistrySettingsBranchcacheHashPublicationMode *string

	/* RegistrySettingsBranchcacheSupportedHashVersion.

	   Filter by registry_settings.branchcache.supported_hash_version
	*/
	RegistrySettingsBranchcacheSupportedHashVersion *string

	/* RegistrySettingsRefreshTimeInterval.

	   Filter by registry_settings.refresh_time_interval
	*/
	RegistrySettingsRefreshTimeInterval *string

	/* RegistrySettingsRefreshTimeRandomOffset.

	   Filter by registry_settings.refresh_time_random_offset
	*/
	RegistrySettingsRefreshTimeRandomOffset *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SecuritySettingsEventAuditSettingsLogonType.

	   Filter by security_settings.event_audit_settings.logon_type
	*/
	SecuritySettingsEventAuditSettingsLogonType *string

	/* SecuritySettingsEventAuditSettingsObjectAccessType.

	   Filter by security_settings.event_audit_settings.object_access_type
	*/
	SecuritySettingsEventAuditSettingsObjectAccessType *string

	/* SecuritySettingsEventLogSettingsMaxSize.

	   Filter by security_settings.event_log_settings.max_size
	*/
	SecuritySettingsEventLogSettingsMaxSize *int64

	/* SecuritySettingsEventLogSettingsRetentionMethod.

	   Filter by security_settings.event_log_settings.retention_method
	*/
	SecuritySettingsEventLogSettingsRetentionMethod *string

	/* SecuritySettingsFilesOrFolders.

	   Filter by security_settings.files_or_folders
	*/
	SecuritySettingsFilesOrFolders *string

	/* SecuritySettingsKerberosMaxClockSkew.

	   Filter by security_settings.kerberos.max_clock_skew
	*/
	SecuritySettingsKerberosMaxClockSkew *string

	/* SecuritySettingsKerberosMaxRenewAge.

	   Filter by security_settings.kerberos.max_renew_age
	*/
	SecuritySettingsKerberosMaxRenewAge *string

	/* SecuritySettingsKerberosMaxTicketAge.

	   Filter by security_settings.kerberos.max_ticket_age
	*/
	SecuritySettingsKerberosMaxTicketAge *string

	/* SecuritySettingsPrivilegeRightsChangeNotifyUsers.

	   Filter by security_settings.privilege_rights.change_notify_users
	*/
	SecuritySettingsPrivilegeRightsChangeNotifyUsers *string

	/* SecuritySettingsPrivilegeRightsSecurityPrivilegeUsers.

	   Filter by security_settings.privilege_rights.security_privilege_users
	*/
	SecuritySettingsPrivilegeRightsSecurityPrivilegeUsers *string

	/* SecuritySettingsPrivilegeRightsTakeOwnershipUsers.

	   Filter by security_settings.privilege_rights.take_ownership_users
	*/
	SecuritySettingsPrivilegeRightsTakeOwnershipUsers *string

	/* SecuritySettingsRegistryValuesSigningRequired.

	   Filter by security_settings.registry_values.signing_required
	*/
	SecuritySettingsRegistryValuesSigningRequired *bool

	/* SecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted.

	   Filter by security_settings.restrict_anonymous.anonymous_access_to_shares_and_named_pipes_restricted
	*/
	SecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted *bool

	/* SecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser.

	   Filter by security_settings.restrict_anonymous.combined_restriction_for_anonymous_user
	*/
	SecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser *string

	/* SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts.

	   Filter by security_settings.restrict_anonymous.no_enumeration_of_sam_accounts
	*/
	SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts *bool

	/* SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares.

	   Filter by security_settings.restrict_anonymous.no_enumeration_of_sam_accounts_and_shares
	*/
	SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares *bool

	/* SecuritySettingsRestrictedGroups.

	   Filter by security_settings.restricted_groups
	*/
	SecuritySettingsRestrictedGroups *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* Version.

	   Filter by version
	*/
	Version *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the group policy object collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupPolicyObjectCollectionGetParams) WithDefaults() *GroupPolicyObjectCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the group policy object collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupPolicyObjectCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := GroupPolicyObjectCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithTimeout(timeout time.Duration) *GroupPolicyObjectCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithContext(ctx context.Context) *GroupPolicyObjectCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithHTTPClient(client *http.Client) *GroupPolicyObjectCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCentralAccessPolicySettings adds the centralAccessPolicySettings to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithCentralAccessPolicySettings(centralAccessPolicySettings *string) *GroupPolicyObjectCollectionGetParams {
	o.SetCentralAccessPolicySettings(centralAccessPolicySettings)
	return o
}

// SetCentralAccessPolicySettings adds the centralAccessPolicySettings to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetCentralAccessPolicySettings(centralAccessPolicySettings *string) {
	o.CentralAccessPolicySettings = centralAccessPolicySettings
}

// WithCentralAccessPolicyStagingAuditType adds the centralAccessPolicyStagingAuditType to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithCentralAccessPolicyStagingAuditType(centralAccessPolicyStagingAuditType *string) *GroupPolicyObjectCollectionGetParams {
	o.SetCentralAccessPolicyStagingAuditType(centralAccessPolicyStagingAuditType)
	return o
}

// SetCentralAccessPolicyStagingAuditType adds the centralAccessPolicyStagingAuditType to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetCentralAccessPolicyStagingAuditType(centralAccessPolicyStagingAuditType *string) {
	o.CentralAccessPolicyStagingAuditType = centralAccessPolicyStagingAuditType
}

// WithEnabled adds the enabled to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithEnabled(enabled *bool) *GroupPolicyObjectCollectionGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithExtensions adds the extensions to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithExtensions(extensions *string) *GroupPolicyObjectCollectionGetParams {
	o.SetExtensions(extensions)
	return o
}

// SetExtensions adds the extensions to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetExtensions(extensions *string) {
	o.Extensions = extensions
}

// WithFields adds the fields to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithFields(fields []string) *GroupPolicyObjectCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFileSystemPath adds the fileSystemPath to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithFileSystemPath(fileSystemPath *string) *GroupPolicyObjectCollectionGetParams {
	o.SetFileSystemPath(fileSystemPath)
	return o
}

// SetFileSystemPath adds the fileSystemPath to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetFileSystemPath(fileSystemPath *string) {
	o.FileSystemPath = fileSystemPath
}

// WithIndex adds the index to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithIndex(index *int64) *GroupPolicyObjectCollectionGetParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetIndex(index *int64) {
	o.Index = index
}

// WithLdapPath adds the ldapPath to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithLdapPath(ldapPath *string) *GroupPolicyObjectCollectionGetParams {
	o.SetLdapPath(ldapPath)
	return o
}

// SetLdapPath adds the ldapPath to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetLdapPath(ldapPath *string) {
	o.LdapPath = ldapPath
}

// WithLink adds the link to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithLink(link *string) *GroupPolicyObjectCollectionGetParams {
	o.SetLink(link)
	return o
}

// SetLink adds the link to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetLink(link *string) {
	o.Link = link
}

// WithMaxRecords adds the maxRecords to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithMaxRecords(maxRecords *int64) *GroupPolicyObjectCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithName(name *string) *GroupPolicyObjectCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithOrderBy(orderBy []string) *GroupPolicyObjectCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithRegistrySettingsBranchcacheHashPublicationMode adds the registrySettingsBranchcacheHashPublicationMode to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithRegistrySettingsBranchcacheHashPublicationMode(registrySettingsBranchcacheHashPublicationMode *string) *GroupPolicyObjectCollectionGetParams {
	o.SetRegistrySettingsBranchcacheHashPublicationMode(registrySettingsBranchcacheHashPublicationMode)
	return o
}

// SetRegistrySettingsBranchcacheHashPublicationMode adds the registrySettingsBranchcacheHashPublicationMode to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetRegistrySettingsBranchcacheHashPublicationMode(registrySettingsBranchcacheHashPublicationMode *string) {
	o.RegistrySettingsBranchcacheHashPublicationMode = registrySettingsBranchcacheHashPublicationMode
}

// WithRegistrySettingsBranchcacheSupportedHashVersion adds the registrySettingsBranchcacheSupportedHashVersion to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithRegistrySettingsBranchcacheSupportedHashVersion(registrySettingsBranchcacheSupportedHashVersion *string) *GroupPolicyObjectCollectionGetParams {
	o.SetRegistrySettingsBranchcacheSupportedHashVersion(registrySettingsBranchcacheSupportedHashVersion)
	return o
}

// SetRegistrySettingsBranchcacheSupportedHashVersion adds the registrySettingsBranchcacheSupportedHashVersion to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetRegistrySettingsBranchcacheSupportedHashVersion(registrySettingsBranchcacheSupportedHashVersion *string) {
	o.RegistrySettingsBranchcacheSupportedHashVersion = registrySettingsBranchcacheSupportedHashVersion
}

// WithRegistrySettingsRefreshTimeInterval adds the registrySettingsRefreshTimeInterval to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithRegistrySettingsRefreshTimeInterval(registrySettingsRefreshTimeInterval *string) *GroupPolicyObjectCollectionGetParams {
	o.SetRegistrySettingsRefreshTimeInterval(registrySettingsRefreshTimeInterval)
	return o
}

// SetRegistrySettingsRefreshTimeInterval adds the registrySettingsRefreshTimeInterval to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetRegistrySettingsRefreshTimeInterval(registrySettingsRefreshTimeInterval *string) {
	o.RegistrySettingsRefreshTimeInterval = registrySettingsRefreshTimeInterval
}

// WithRegistrySettingsRefreshTimeRandomOffset adds the registrySettingsRefreshTimeRandomOffset to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithRegistrySettingsRefreshTimeRandomOffset(registrySettingsRefreshTimeRandomOffset *string) *GroupPolicyObjectCollectionGetParams {
	o.SetRegistrySettingsRefreshTimeRandomOffset(registrySettingsRefreshTimeRandomOffset)
	return o
}

// SetRegistrySettingsRefreshTimeRandomOffset adds the registrySettingsRefreshTimeRandomOffset to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetRegistrySettingsRefreshTimeRandomOffset(registrySettingsRefreshTimeRandomOffset *string) {
	o.RegistrySettingsRefreshTimeRandomOffset = registrySettingsRefreshTimeRandomOffset
}

// WithReturnRecords adds the returnRecords to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithReturnRecords(returnRecords *bool) *GroupPolicyObjectCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *GroupPolicyObjectCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSecuritySettingsEventAuditSettingsLogonType adds the securitySettingsEventAuditSettingsLogonType to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithSecuritySettingsEventAuditSettingsLogonType(securitySettingsEventAuditSettingsLogonType *string) *GroupPolicyObjectCollectionGetParams {
	o.SetSecuritySettingsEventAuditSettingsLogonType(securitySettingsEventAuditSettingsLogonType)
	return o
}

// SetSecuritySettingsEventAuditSettingsLogonType adds the securitySettingsEventAuditSettingsLogonType to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetSecuritySettingsEventAuditSettingsLogonType(securitySettingsEventAuditSettingsLogonType *string) {
	o.SecuritySettingsEventAuditSettingsLogonType = securitySettingsEventAuditSettingsLogonType
}

// WithSecuritySettingsEventAuditSettingsObjectAccessType adds the securitySettingsEventAuditSettingsObjectAccessType to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithSecuritySettingsEventAuditSettingsObjectAccessType(securitySettingsEventAuditSettingsObjectAccessType *string) *GroupPolicyObjectCollectionGetParams {
	o.SetSecuritySettingsEventAuditSettingsObjectAccessType(securitySettingsEventAuditSettingsObjectAccessType)
	return o
}

// SetSecuritySettingsEventAuditSettingsObjectAccessType adds the securitySettingsEventAuditSettingsObjectAccessType to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetSecuritySettingsEventAuditSettingsObjectAccessType(securitySettingsEventAuditSettingsObjectAccessType *string) {
	o.SecuritySettingsEventAuditSettingsObjectAccessType = securitySettingsEventAuditSettingsObjectAccessType
}

// WithSecuritySettingsEventLogSettingsMaxSize adds the securitySettingsEventLogSettingsMaxSize to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithSecuritySettingsEventLogSettingsMaxSize(securitySettingsEventLogSettingsMaxSize *int64) *GroupPolicyObjectCollectionGetParams {
	o.SetSecuritySettingsEventLogSettingsMaxSize(securitySettingsEventLogSettingsMaxSize)
	return o
}

// SetSecuritySettingsEventLogSettingsMaxSize adds the securitySettingsEventLogSettingsMaxSize to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetSecuritySettingsEventLogSettingsMaxSize(securitySettingsEventLogSettingsMaxSize *int64) {
	o.SecuritySettingsEventLogSettingsMaxSize = securitySettingsEventLogSettingsMaxSize
}

// WithSecuritySettingsEventLogSettingsRetentionMethod adds the securitySettingsEventLogSettingsRetentionMethod to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithSecuritySettingsEventLogSettingsRetentionMethod(securitySettingsEventLogSettingsRetentionMethod *string) *GroupPolicyObjectCollectionGetParams {
	o.SetSecuritySettingsEventLogSettingsRetentionMethod(securitySettingsEventLogSettingsRetentionMethod)
	return o
}

// SetSecuritySettingsEventLogSettingsRetentionMethod adds the securitySettingsEventLogSettingsRetentionMethod to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetSecuritySettingsEventLogSettingsRetentionMethod(securitySettingsEventLogSettingsRetentionMethod *string) {
	o.SecuritySettingsEventLogSettingsRetentionMethod = securitySettingsEventLogSettingsRetentionMethod
}

// WithSecuritySettingsFilesOrFolders adds the securitySettingsFilesOrFolders to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithSecuritySettingsFilesOrFolders(securitySettingsFilesOrFolders *string) *GroupPolicyObjectCollectionGetParams {
	o.SetSecuritySettingsFilesOrFolders(securitySettingsFilesOrFolders)
	return o
}

// SetSecuritySettingsFilesOrFolders adds the securitySettingsFilesOrFolders to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetSecuritySettingsFilesOrFolders(securitySettingsFilesOrFolders *string) {
	o.SecuritySettingsFilesOrFolders = securitySettingsFilesOrFolders
}

// WithSecuritySettingsKerberosMaxClockSkew adds the securitySettingsKerberosMaxClockSkew to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithSecuritySettingsKerberosMaxClockSkew(securitySettingsKerberosMaxClockSkew *string) *GroupPolicyObjectCollectionGetParams {
	o.SetSecuritySettingsKerberosMaxClockSkew(securitySettingsKerberosMaxClockSkew)
	return o
}

// SetSecuritySettingsKerberosMaxClockSkew adds the securitySettingsKerberosMaxClockSkew to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetSecuritySettingsKerberosMaxClockSkew(securitySettingsKerberosMaxClockSkew *string) {
	o.SecuritySettingsKerberosMaxClockSkew = securitySettingsKerberosMaxClockSkew
}

// WithSecuritySettingsKerberosMaxRenewAge adds the securitySettingsKerberosMaxRenewAge to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithSecuritySettingsKerberosMaxRenewAge(securitySettingsKerberosMaxRenewAge *string) *GroupPolicyObjectCollectionGetParams {
	o.SetSecuritySettingsKerberosMaxRenewAge(securitySettingsKerberosMaxRenewAge)
	return o
}

// SetSecuritySettingsKerberosMaxRenewAge adds the securitySettingsKerberosMaxRenewAge to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetSecuritySettingsKerberosMaxRenewAge(securitySettingsKerberosMaxRenewAge *string) {
	o.SecuritySettingsKerberosMaxRenewAge = securitySettingsKerberosMaxRenewAge
}

// WithSecuritySettingsKerberosMaxTicketAge adds the securitySettingsKerberosMaxTicketAge to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithSecuritySettingsKerberosMaxTicketAge(securitySettingsKerberosMaxTicketAge *string) *GroupPolicyObjectCollectionGetParams {
	o.SetSecuritySettingsKerberosMaxTicketAge(securitySettingsKerberosMaxTicketAge)
	return o
}

// SetSecuritySettingsKerberosMaxTicketAge adds the securitySettingsKerberosMaxTicketAge to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetSecuritySettingsKerberosMaxTicketAge(securitySettingsKerberosMaxTicketAge *string) {
	o.SecuritySettingsKerberosMaxTicketAge = securitySettingsKerberosMaxTicketAge
}

// WithSecuritySettingsPrivilegeRightsChangeNotifyUsers adds the securitySettingsPrivilegeRightsChangeNotifyUsers to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithSecuritySettingsPrivilegeRightsChangeNotifyUsers(securitySettingsPrivilegeRightsChangeNotifyUsers *string) *GroupPolicyObjectCollectionGetParams {
	o.SetSecuritySettingsPrivilegeRightsChangeNotifyUsers(securitySettingsPrivilegeRightsChangeNotifyUsers)
	return o
}

// SetSecuritySettingsPrivilegeRightsChangeNotifyUsers adds the securitySettingsPrivilegeRightsChangeNotifyUsers to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetSecuritySettingsPrivilegeRightsChangeNotifyUsers(securitySettingsPrivilegeRightsChangeNotifyUsers *string) {
	o.SecuritySettingsPrivilegeRightsChangeNotifyUsers = securitySettingsPrivilegeRightsChangeNotifyUsers
}

// WithSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers adds the securitySettingsPrivilegeRightsSecurityPrivilegeUsers to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers(securitySettingsPrivilegeRightsSecurityPrivilegeUsers *string) *GroupPolicyObjectCollectionGetParams {
	o.SetSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers(securitySettingsPrivilegeRightsSecurityPrivilegeUsers)
	return o
}

// SetSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers adds the securitySettingsPrivilegeRightsSecurityPrivilegeUsers to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers(securitySettingsPrivilegeRightsSecurityPrivilegeUsers *string) {
	o.SecuritySettingsPrivilegeRightsSecurityPrivilegeUsers = securitySettingsPrivilegeRightsSecurityPrivilegeUsers
}

// WithSecuritySettingsPrivilegeRightsTakeOwnershipUsers adds the securitySettingsPrivilegeRightsTakeOwnershipUsers to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithSecuritySettingsPrivilegeRightsTakeOwnershipUsers(securitySettingsPrivilegeRightsTakeOwnershipUsers *string) *GroupPolicyObjectCollectionGetParams {
	o.SetSecuritySettingsPrivilegeRightsTakeOwnershipUsers(securitySettingsPrivilegeRightsTakeOwnershipUsers)
	return o
}

// SetSecuritySettingsPrivilegeRightsTakeOwnershipUsers adds the securitySettingsPrivilegeRightsTakeOwnershipUsers to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetSecuritySettingsPrivilegeRightsTakeOwnershipUsers(securitySettingsPrivilegeRightsTakeOwnershipUsers *string) {
	o.SecuritySettingsPrivilegeRightsTakeOwnershipUsers = securitySettingsPrivilegeRightsTakeOwnershipUsers
}

// WithSecuritySettingsRegistryValuesSigningRequired adds the securitySettingsRegistryValuesSigningRequired to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithSecuritySettingsRegistryValuesSigningRequired(securitySettingsRegistryValuesSigningRequired *bool) *GroupPolicyObjectCollectionGetParams {
	o.SetSecuritySettingsRegistryValuesSigningRequired(securitySettingsRegistryValuesSigningRequired)
	return o
}

// SetSecuritySettingsRegistryValuesSigningRequired adds the securitySettingsRegistryValuesSigningRequired to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetSecuritySettingsRegistryValuesSigningRequired(securitySettingsRegistryValuesSigningRequired *bool) {
	o.SecuritySettingsRegistryValuesSigningRequired = securitySettingsRegistryValuesSigningRequired
}

// WithSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted adds the securitySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted(securitySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted *bool) *GroupPolicyObjectCollectionGetParams {
	o.SetSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted(securitySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted)
	return o
}

// SetSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted adds the securitySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted(securitySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted *bool) {
	o.SecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted = securitySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted
}

// WithSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser adds the securitySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser(securitySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser *string) *GroupPolicyObjectCollectionGetParams {
	o.SetSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser(securitySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser)
	return o
}

// SetSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser adds the securitySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser(securitySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser *string) {
	o.SecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser = securitySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser
}

// WithSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts adds the securitySettingsRestrictAnonymousNoEnumerationOfSamAccounts to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts(securitySettingsRestrictAnonymousNoEnumerationOfSamAccounts *bool) *GroupPolicyObjectCollectionGetParams {
	o.SetSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts(securitySettingsRestrictAnonymousNoEnumerationOfSamAccounts)
	return o
}

// SetSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts adds the securitySettingsRestrictAnonymousNoEnumerationOfSamAccounts to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts(securitySettingsRestrictAnonymousNoEnumerationOfSamAccounts *bool) {
	o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts = securitySettingsRestrictAnonymousNoEnumerationOfSamAccounts
}

// WithSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares adds the securitySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares(securitySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares *bool) *GroupPolicyObjectCollectionGetParams {
	o.SetSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares(securitySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares)
	return o
}

// SetSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares adds the securitySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares(securitySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares *bool) {
	o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares = securitySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares
}

// WithSecuritySettingsRestrictedGroups adds the securitySettingsRestrictedGroups to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithSecuritySettingsRestrictedGroups(securitySettingsRestrictedGroups *string) *GroupPolicyObjectCollectionGetParams {
	o.SetSecuritySettingsRestrictedGroups(securitySettingsRestrictedGroups)
	return o
}

// SetSecuritySettingsRestrictedGroups adds the securitySettingsRestrictedGroups to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetSecuritySettingsRestrictedGroups(securitySettingsRestrictedGroups *string) {
	o.SecuritySettingsRestrictedGroups = securitySettingsRestrictedGroups
}

// WithSvmName adds the svmName to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithSvmName(svmName *string) *GroupPolicyObjectCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithSvmUUID(svmUUID string) *GroupPolicyObjectCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithUUID(uuid *string) *GroupPolicyObjectCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVersion adds the version to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) WithVersion(version *int64) *GroupPolicyObjectCollectionGetParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the group policy object collection get params
func (o *GroupPolicyObjectCollectionGetParams) SetVersion(version *int64) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *GroupPolicyObjectCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CentralAccessPolicySettings != nil {

		// query param central_access_policy_settings
		var qrCentralAccessPolicySettings string

		if o.CentralAccessPolicySettings != nil {
			qrCentralAccessPolicySettings = *o.CentralAccessPolicySettings
		}
		qCentralAccessPolicySettings := qrCentralAccessPolicySettings
		if qCentralAccessPolicySettings != "" {

			if err := r.SetQueryParam("central_access_policy_settings", qCentralAccessPolicySettings); err != nil {
				return err
			}
		}
	}

	if o.CentralAccessPolicyStagingAuditType != nil {

		// query param central_access_policy_staging_audit_type
		var qrCentralAccessPolicyStagingAuditType string

		if o.CentralAccessPolicyStagingAuditType != nil {
			qrCentralAccessPolicyStagingAuditType = *o.CentralAccessPolicyStagingAuditType
		}
		qCentralAccessPolicyStagingAuditType := qrCentralAccessPolicyStagingAuditType
		if qCentralAccessPolicyStagingAuditType != "" {

			if err := r.SetQueryParam("central_access_policy_staging_audit_type", qCentralAccessPolicyStagingAuditType); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.Extensions != nil {

		// query param extensions
		var qrExtensions string

		if o.Extensions != nil {
			qrExtensions = *o.Extensions
		}
		qExtensions := qrExtensions
		if qExtensions != "" {

			if err := r.SetQueryParam("extensions", qExtensions); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.FileSystemPath != nil {

		// query param file_system_path
		var qrFileSystemPath string

		if o.FileSystemPath != nil {
			qrFileSystemPath = *o.FileSystemPath
		}
		qFileSystemPath := qrFileSystemPath
		if qFileSystemPath != "" {

			if err := r.SetQueryParam("file_system_path", qFileSystemPath); err != nil {
				return err
			}
		}
	}

	if o.Index != nil {

		// query param index
		var qrIndex int64

		if o.Index != nil {
			qrIndex = *o.Index
		}
		qIndex := swag.FormatInt64(qrIndex)
		if qIndex != "" {

			if err := r.SetQueryParam("index", qIndex); err != nil {
				return err
			}
		}
	}

	if o.LdapPath != nil {

		// query param ldap_path
		var qrLdapPath string

		if o.LdapPath != nil {
			qrLdapPath = *o.LdapPath
		}
		qLdapPath := qrLdapPath
		if qLdapPath != "" {

			if err := r.SetQueryParam("ldap_path", qLdapPath); err != nil {
				return err
			}
		}
	}

	if o.Link != nil {

		// query param link
		var qrLink string

		if o.Link != nil {
			qrLink = *o.Link
		}
		qLink := qrLink
		if qLink != "" {

			if err := r.SetQueryParam("link", qLink); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.RegistrySettingsBranchcacheHashPublicationMode != nil {

		// query param registry_settings.branchcache.hash_publication_mode
		var qrRegistrySettingsBranchcacheHashPublicationMode string

		if o.RegistrySettingsBranchcacheHashPublicationMode != nil {
			qrRegistrySettingsBranchcacheHashPublicationMode = *o.RegistrySettingsBranchcacheHashPublicationMode
		}
		qRegistrySettingsBranchcacheHashPublicationMode := qrRegistrySettingsBranchcacheHashPublicationMode
		if qRegistrySettingsBranchcacheHashPublicationMode != "" {

			if err := r.SetQueryParam("registry_settings.branchcache.hash_publication_mode", qRegistrySettingsBranchcacheHashPublicationMode); err != nil {
				return err
			}
		}
	}

	if o.RegistrySettingsBranchcacheSupportedHashVersion != nil {

		// query param registry_settings.branchcache.supported_hash_version
		var qrRegistrySettingsBranchcacheSupportedHashVersion string

		if o.RegistrySettingsBranchcacheSupportedHashVersion != nil {
			qrRegistrySettingsBranchcacheSupportedHashVersion = *o.RegistrySettingsBranchcacheSupportedHashVersion
		}
		qRegistrySettingsBranchcacheSupportedHashVersion := qrRegistrySettingsBranchcacheSupportedHashVersion
		if qRegistrySettingsBranchcacheSupportedHashVersion != "" {

			if err := r.SetQueryParam("registry_settings.branchcache.supported_hash_version", qRegistrySettingsBranchcacheSupportedHashVersion); err != nil {
				return err
			}
		}
	}

	if o.RegistrySettingsRefreshTimeInterval != nil {

		// query param registry_settings.refresh_time_interval
		var qrRegistrySettingsRefreshTimeInterval string

		if o.RegistrySettingsRefreshTimeInterval != nil {
			qrRegistrySettingsRefreshTimeInterval = *o.RegistrySettingsRefreshTimeInterval
		}
		qRegistrySettingsRefreshTimeInterval := qrRegistrySettingsRefreshTimeInterval
		if qRegistrySettingsRefreshTimeInterval != "" {

			if err := r.SetQueryParam("registry_settings.refresh_time_interval", qRegistrySettingsRefreshTimeInterval); err != nil {
				return err
			}
		}
	}

	if o.RegistrySettingsRefreshTimeRandomOffset != nil {

		// query param registry_settings.refresh_time_random_offset
		var qrRegistrySettingsRefreshTimeRandomOffset string

		if o.RegistrySettingsRefreshTimeRandomOffset != nil {
			qrRegistrySettingsRefreshTimeRandomOffset = *o.RegistrySettingsRefreshTimeRandomOffset
		}
		qRegistrySettingsRefreshTimeRandomOffset := qrRegistrySettingsRefreshTimeRandomOffset
		if qRegistrySettingsRefreshTimeRandomOffset != "" {

			if err := r.SetQueryParam("registry_settings.refresh_time_random_offset", qRegistrySettingsRefreshTimeRandomOffset); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsEventAuditSettingsLogonType != nil {

		// query param security_settings.event_audit_settings.logon_type
		var qrSecuritySettingsEventAuditSettingsLogonType string

		if o.SecuritySettingsEventAuditSettingsLogonType != nil {
			qrSecuritySettingsEventAuditSettingsLogonType = *o.SecuritySettingsEventAuditSettingsLogonType
		}
		qSecuritySettingsEventAuditSettingsLogonType := qrSecuritySettingsEventAuditSettingsLogonType
		if qSecuritySettingsEventAuditSettingsLogonType != "" {

			if err := r.SetQueryParam("security_settings.event_audit_settings.logon_type", qSecuritySettingsEventAuditSettingsLogonType); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsEventAuditSettingsObjectAccessType != nil {

		// query param security_settings.event_audit_settings.object_access_type
		var qrSecuritySettingsEventAuditSettingsObjectAccessType string

		if o.SecuritySettingsEventAuditSettingsObjectAccessType != nil {
			qrSecuritySettingsEventAuditSettingsObjectAccessType = *o.SecuritySettingsEventAuditSettingsObjectAccessType
		}
		qSecuritySettingsEventAuditSettingsObjectAccessType := qrSecuritySettingsEventAuditSettingsObjectAccessType
		if qSecuritySettingsEventAuditSettingsObjectAccessType != "" {

			if err := r.SetQueryParam("security_settings.event_audit_settings.object_access_type", qSecuritySettingsEventAuditSettingsObjectAccessType); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsEventLogSettingsMaxSize != nil {

		// query param security_settings.event_log_settings.max_size
		var qrSecuritySettingsEventLogSettingsMaxSize int64

		if o.SecuritySettingsEventLogSettingsMaxSize != nil {
			qrSecuritySettingsEventLogSettingsMaxSize = *o.SecuritySettingsEventLogSettingsMaxSize
		}
		qSecuritySettingsEventLogSettingsMaxSize := swag.FormatInt64(qrSecuritySettingsEventLogSettingsMaxSize)
		if qSecuritySettingsEventLogSettingsMaxSize != "" {

			if err := r.SetQueryParam("security_settings.event_log_settings.max_size", qSecuritySettingsEventLogSettingsMaxSize); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsEventLogSettingsRetentionMethod != nil {

		// query param security_settings.event_log_settings.retention_method
		var qrSecuritySettingsEventLogSettingsRetentionMethod string

		if o.SecuritySettingsEventLogSettingsRetentionMethod != nil {
			qrSecuritySettingsEventLogSettingsRetentionMethod = *o.SecuritySettingsEventLogSettingsRetentionMethod
		}
		qSecuritySettingsEventLogSettingsRetentionMethod := qrSecuritySettingsEventLogSettingsRetentionMethod
		if qSecuritySettingsEventLogSettingsRetentionMethod != "" {

			if err := r.SetQueryParam("security_settings.event_log_settings.retention_method", qSecuritySettingsEventLogSettingsRetentionMethod); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsFilesOrFolders != nil {

		// query param security_settings.files_or_folders
		var qrSecuritySettingsFilesOrFolders string

		if o.SecuritySettingsFilesOrFolders != nil {
			qrSecuritySettingsFilesOrFolders = *o.SecuritySettingsFilesOrFolders
		}
		qSecuritySettingsFilesOrFolders := qrSecuritySettingsFilesOrFolders
		if qSecuritySettingsFilesOrFolders != "" {

			if err := r.SetQueryParam("security_settings.files_or_folders", qSecuritySettingsFilesOrFolders); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsKerberosMaxClockSkew != nil {

		// query param security_settings.kerberos.max_clock_skew
		var qrSecuritySettingsKerberosMaxClockSkew string

		if o.SecuritySettingsKerberosMaxClockSkew != nil {
			qrSecuritySettingsKerberosMaxClockSkew = *o.SecuritySettingsKerberosMaxClockSkew
		}
		qSecuritySettingsKerberosMaxClockSkew := qrSecuritySettingsKerberosMaxClockSkew
		if qSecuritySettingsKerberosMaxClockSkew != "" {

			if err := r.SetQueryParam("security_settings.kerberos.max_clock_skew", qSecuritySettingsKerberosMaxClockSkew); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsKerberosMaxRenewAge != nil {

		// query param security_settings.kerberos.max_renew_age
		var qrSecuritySettingsKerberosMaxRenewAge string

		if o.SecuritySettingsKerberosMaxRenewAge != nil {
			qrSecuritySettingsKerberosMaxRenewAge = *o.SecuritySettingsKerberosMaxRenewAge
		}
		qSecuritySettingsKerberosMaxRenewAge := qrSecuritySettingsKerberosMaxRenewAge
		if qSecuritySettingsKerberosMaxRenewAge != "" {

			if err := r.SetQueryParam("security_settings.kerberos.max_renew_age", qSecuritySettingsKerberosMaxRenewAge); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsKerberosMaxTicketAge != nil {

		// query param security_settings.kerberos.max_ticket_age
		var qrSecuritySettingsKerberosMaxTicketAge string

		if o.SecuritySettingsKerberosMaxTicketAge != nil {
			qrSecuritySettingsKerberosMaxTicketAge = *o.SecuritySettingsKerberosMaxTicketAge
		}
		qSecuritySettingsKerberosMaxTicketAge := qrSecuritySettingsKerberosMaxTicketAge
		if qSecuritySettingsKerberosMaxTicketAge != "" {

			if err := r.SetQueryParam("security_settings.kerberos.max_ticket_age", qSecuritySettingsKerberosMaxTicketAge); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsPrivilegeRightsChangeNotifyUsers != nil {

		// query param security_settings.privilege_rights.change_notify_users
		var qrSecuritySettingsPrivilegeRightsChangeNotifyUsers string

		if o.SecuritySettingsPrivilegeRightsChangeNotifyUsers != nil {
			qrSecuritySettingsPrivilegeRightsChangeNotifyUsers = *o.SecuritySettingsPrivilegeRightsChangeNotifyUsers
		}
		qSecuritySettingsPrivilegeRightsChangeNotifyUsers := qrSecuritySettingsPrivilegeRightsChangeNotifyUsers
		if qSecuritySettingsPrivilegeRightsChangeNotifyUsers != "" {

			if err := r.SetQueryParam("security_settings.privilege_rights.change_notify_users", qSecuritySettingsPrivilegeRightsChangeNotifyUsers); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsPrivilegeRightsSecurityPrivilegeUsers != nil {

		// query param security_settings.privilege_rights.security_privilege_users
		var qrSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers string

		if o.SecuritySettingsPrivilegeRightsSecurityPrivilegeUsers != nil {
			qrSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers = *o.SecuritySettingsPrivilegeRightsSecurityPrivilegeUsers
		}
		qSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers := qrSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers
		if qSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers != "" {

			if err := r.SetQueryParam("security_settings.privilege_rights.security_privilege_users", qSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsPrivilegeRightsTakeOwnershipUsers != nil {

		// query param security_settings.privilege_rights.take_ownership_users
		var qrSecuritySettingsPrivilegeRightsTakeOwnershipUsers string

		if o.SecuritySettingsPrivilegeRightsTakeOwnershipUsers != nil {
			qrSecuritySettingsPrivilegeRightsTakeOwnershipUsers = *o.SecuritySettingsPrivilegeRightsTakeOwnershipUsers
		}
		qSecuritySettingsPrivilegeRightsTakeOwnershipUsers := qrSecuritySettingsPrivilegeRightsTakeOwnershipUsers
		if qSecuritySettingsPrivilegeRightsTakeOwnershipUsers != "" {

			if err := r.SetQueryParam("security_settings.privilege_rights.take_ownership_users", qSecuritySettingsPrivilegeRightsTakeOwnershipUsers); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsRegistryValuesSigningRequired != nil {

		// query param security_settings.registry_values.signing_required
		var qrSecuritySettingsRegistryValuesSigningRequired bool

		if o.SecuritySettingsRegistryValuesSigningRequired != nil {
			qrSecuritySettingsRegistryValuesSigningRequired = *o.SecuritySettingsRegistryValuesSigningRequired
		}
		qSecuritySettingsRegistryValuesSigningRequired := swag.FormatBool(qrSecuritySettingsRegistryValuesSigningRequired)
		if qSecuritySettingsRegistryValuesSigningRequired != "" {

			if err := r.SetQueryParam("security_settings.registry_values.signing_required", qSecuritySettingsRegistryValuesSigningRequired); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted != nil {

		// query param security_settings.restrict_anonymous.anonymous_access_to_shares_and_named_pipes_restricted
		var qrSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted bool

		if o.SecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted != nil {
			qrSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted = *o.SecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted
		}
		qSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted := swag.FormatBool(qrSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted)
		if qSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted != "" {

			if err := r.SetQueryParam("security_settings.restrict_anonymous.anonymous_access_to_shares_and_named_pipes_restricted", qSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser != nil {

		// query param security_settings.restrict_anonymous.combined_restriction_for_anonymous_user
		var qrSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser string

		if o.SecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser != nil {
			qrSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser = *o.SecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser
		}
		qSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser := qrSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser
		if qSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser != "" {

			if err := r.SetQueryParam("security_settings.restrict_anonymous.combined_restriction_for_anonymous_user", qSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts != nil {

		// query param security_settings.restrict_anonymous.no_enumeration_of_sam_accounts
		var qrSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts bool

		if o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts != nil {
			qrSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts = *o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts
		}
		qSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts := swag.FormatBool(qrSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts)
		if qSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts != "" {

			if err := r.SetQueryParam("security_settings.restrict_anonymous.no_enumeration_of_sam_accounts", qSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares != nil {

		// query param security_settings.restrict_anonymous.no_enumeration_of_sam_accounts_and_shares
		var qrSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares bool

		if o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares != nil {
			qrSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares = *o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares
		}
		qSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares := swag.FormatBool(qrSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares)
		if qSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares != "" {

			if err := r.SetQueryParam("security_settings.restrict_anonymous.no_enumeration_of_sam_accounts_and_shares", qSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsRestrictedGroups != nil {

		// query param security_settings.restricted_groups
		var qrSecuritySettingsRestrictedGroups string

		if o.SecuritySettingsRestrictedGroups != nil {
			qrSecuritySettingsRestrictedGroups = *o.SecuritySettingsRestrictedGroups
		}
		qSecuritySettingsRestrictedGroups := qrSecuritySettingsRestrictedGroups
		if qSecuritySettingsRestrictedGroups != "" {

			if err := r.SetQueryParam("security_settings.restricted_groups", qSecuritySettingsRestrictedGroups); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.Version != nil {

		// query param version
		var qrVersion int64

		if o.Version != nil {
			qrVersion = *o.Version
		}
		qVersion := swag.FormatInt64(qrVersion)
		if qVersion != "" {

			if err := r.SetQueryParam("version", qVersion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGroupPolicyObjectCollectionGet binds the parameter fields
func (o *GroupPolicyObjectCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamGroupPolicyObjectCollectionGet binds the parameter order_by
func (o *GroupPolicyObjectCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
