// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGroupPolicyObjectGetParams creates a new GroupPolicyObjectGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGroupPolicyObjectGetParams() *GroupPolicyObjectGetParams {
	return &GroupPolicyObjectGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGroupPolicyObjectGetParamsWithTimeout creates a new GroupPolicyObjectGetParams object
// with the ability to set a timeout on a request.
func NewGroupPolicyObjectGetParamsWithTimeout(timeout time.Duration) *GroupPolicyObjectGetParams {
	return &GroupPolicyObjectGetParams{
		timeout: timeout,
	}
}

// NewGroupPolicyObjectGetParamsWithContext creates a new GroupPolicyObjectGetParams object
// with the ability to set a context for a request.
func NewGroupPolicyObjectGetParamsWithContext(ctx context.Context) *GroupPolicyObjectGetParams {
	return &GroupPolicyObjectGetParams{
		Context: ctx,
	}
}

// NewGroupPolicyObjectGetParamsWithHTTPClient creates a new GroupPolicyObjectGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewGroupPolicyObjectGetParamsWithHTTPClient(client *http.Client) *GroupPolicyObjectGetParams {
	return &GroupPolicyObjectGetParams{
		HTTPClient: client,
	}
}

/*
GroupPolicyObjectGetParams contains all the parameters to send to the API endpoint

	for the group policy object get operation.

	Typically these are written to a http.Request.
*/
type GroupPolicyObjectGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Index.

	   Restricted group index.
	*/
	Index int64

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the group policy object get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupPolicyObjectGetParams) WithDefaults() *GroupPolicyObjectGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the group policy object get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupPolicyObjectGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the group policy object get params
func (o *GroupPolicyObjectGetParams) WithTimeout(timeout time.Duration) *GroupPolicyObjectGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the group policy object get params
func (o *GroupPolicyObjectGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the group policy object get params
func (o *GroupPolicyObjectGetParams) WithContext(ctx context.Context) *GroupPolicyObjectGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the group policy object get params
func (o *GroupPolicyObjectGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the group policy object get params
func (o *GroupPolicyObjectGetParams) WithHTTPClient(client *http.Client) *GroupPolicyObjectGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the group policy object get params
func (o *GroupPolicyObjectGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the group policy object get params
func (o *GroupPolicyObjectGetParams) WithFields(fields []string) *GroupPolicyObjectGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the group policy object get params
func (o *GroupPolicyObjectGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIndex adds the index to the group policy object get params
func (o *GroupPolicyObjectGetParams) WithIndex(index int64) *GroupPolicyObjectGetParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the group policy object get params
func (o *GroupPolicyObjectGetParams) SetIndex(index int64) {
	o.Index = index
}

// WithSvmUUID adds the svmUUID to the group policy object get params
func (o *GroupPolicyObjectGetParams) WithSvmUUID(svmUUID string) *GroupPolicyObjectGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the group policy object get params
func (o *GroupPolicyObjectGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *GroupPolicyObjectGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param index
	if err := r.SetPathParam("index", swag.FormatInt64(o.Index)); err != nil {
		return err
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGroupPolicyObjectGet binds the parameter fields
func (o *GroupPolicyObjectGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
