// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGroupPolicyObjectRestrictedGroupCollectionGetParams creates a new GroupPolicyObjectRestrictedGroupCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGroupPolicyObjectRestrictedGroupCollectionGetParams() *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	return &GroupPolicyObjectRestrictedGroupCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGroupPolicyObjectRestrictedGroupCollectionGetParamsWithTimeout creates a new GroupPolicyObjectRestrictedGroupCollectionGetParams object
// with the ability to set a timeout on a request.
func NewGroupPolicyObjectRestrictedGroupCollectionGetParamsWithTimeout(timeout time.Duration) *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	return &GroupPolicyObjectRestrictedGroupCollectionGetParams{
		timeout: timeout,
	}
}

// NewGroupPolicyObjectRestrictedGroupCollectionGetParamsWithContext creates a new GroupPolicyObjectRestrictedGroupCollectionGetParams object
// with the ability to set a context for a request.
func NewGroupPolicyObjectRestrictedGroupCollectionGetParamsWithContext(ctx context.Context) *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	return &GroupPolicyObjectRestrictedGroupCollectionGetParams{
		Context: ctx,
	}
}

// NewGroupPolicyObjectRestrictedGroupCollectionGetParamsWithHTTPClient creates a new GroupPolicyObjectRestrictedGroupCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewGroupPolicyObjectRestrictedGroupCollectionGetParamsWithHTTPClient(client *http.Client) *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	return &GroupPolicyObjectRestrictedGroupCollectionGetParams{
		HTTPClient: client,
	}
}

/*
GroupPolicyObjectRestrictedGroupCollectionGetParams contains all the parameters to send to the API endpoint

	for the group policy object restricted group collection get operation.

	Typically these are written to a http.Request.
*/
type GroupPolicyObjectRestrictedGroupCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* GroupName.

	   Filter by group_name
	*/
	GroupName *string

	/* Link.

	   Filter by link
	*/
	Link *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Members.

	   Filter by members
	*/
	Members *string

	/* Memberships.

	   Filter by memberships
	*/
	Memberships *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PolicyName.

	   Filter by policy_name
	*/
	PolicyName *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	/* Version.

	   Filter by version
	*/
	Version *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the group policy object restricted group collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) WithDefaults() *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the group policy object restricted group collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := GroupPolicyObjectRestrictedGroupCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) WithTimeout(timeout time.Duration) *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) WithContext(ctx context.Context) *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) WithHTTPClient(client *http.Client) *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) WithFields(fields []string) *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithGroupName adds the groupName to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) WithGroupName(groupName *string) *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	o.SetGroupName(groupName)
	return o
}

// SetGroupName adds the groupName to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) SetGroupName(groupName *string) {
	o.GroupName = groupName
}

// WithLink adds the link to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) WithLink(link *string) *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	o.SetLink(link)
	return o
}

// SetLink adds the link to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) SetLink(link *string) {
	o.Link = link
}

// WithMaxRecords adds the maxRecords to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) WithMaxRecords(maxRecords *int64) *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMembers adds the members to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) WithMembers(members *string) *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	o.SetMembers(members)
	return o
}

// SetMembers adds the members to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) SetMembers(members *string) {
	o.Members = members
}

// WithMemberships adds the memberships to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) WithMemberships(memberships *string) *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	o.SetMemberships(memberships)
	return o
}

// SetMemberships adds the memberships to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) SetMemberships(memberships *string) {
	o.Memberships = memberships
}

// WithOrderBy adds the orderBy to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) WithOrderBy(orderBy []string) *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPolicyName adds the policyName to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) WithPolicyName(policyName *string) *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	o.SetPolicyName(policyName)
	return o
}

// SetPolicyName adds the policyName to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) SetPolicyName(policyName *string) {
	o.PolicyName = policyName
}

// WithReturnRecords adds the returnRecords to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) WithReturnRecords(returnRecords *bool) *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) WithSvmName(svmName *string) *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) WithSvmUUID(svmUUID string) *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithVersion adds the version to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) WithVersion(version *int64) *GroupPolicyObjectRestrictedGroupCollectionGetParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the group policy object restricted group collection get params
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) SetVersion(version *int64) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.GroupName != nil {

		// query param group_name
		var qrGroupName string

		if o.GroupName != nil {
			qrGroupName = *o.GroupName
		}
		qGroupName := qrGroupName
		if qGroupName != "" {

			if err := r.SetQueryParam("group_name", qGroupName); err != nil {
				return err
			}
		}
	}

	if o.Link != nil {

		// query param link
		var qrLink string

		if o.Link != nil {
			qrLink = *o.Link
		}
		qLink := qrLink
		if qLink != "" {

			if err := r.SetQueryParam("link", qLink); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Members != nil {

		// query param members
		var qrMembers string

		if o.Members != nil {
			qrMembers = *o.Members
		}
		qMembers := qrMembers
		if qMembers != "" {

			if err := r.SetQueryParam("members", qMembers); err != nil {
				return err
			}
		}
	}

	if o.Memberships != nil {

		// query param memberships
		var qrMemberships string

		if o.Memberships != nil {
			qrMemberships = *o.Memberships
		}
		qMemberships := qrMemberships
		if qMemberships != "" {

			if err := r.SetQueryParam("memberships", qMemberships); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PolicyName != nil {

		// query param policy_name
		var qrPolicyName string

		if o.PolicyName != nil {
			qrPolicyName = *o.PolicyName
		}
		qPolicyName := qrPolicyName
		if qPolicyName != "" {

			if err := r.SetQueryParam("policy_name", qPolicyName); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if o.Version != nil {

		// query param version
		var qrVersion int64

		if o.Version != nil {
			qrVersion = *o.Version
		}
		qVersion := swag.FormatInt64(qrVersion)
		if qVersion != "" {

			if err := r.SetQueryParam("version", qVersion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGroupPolicyObjectRestrictedGroupCollectionGet binds the parameter fields
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamGroupPolicyObjectRestrictedGroupCollectionGet binds the parameter order_by
func (o *GroupPolicyObjectRestrictedGroupCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
