// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGroupPolicyObjectRestrictedGroupGetParams creates a new GroupPolicyObjectRestrictedGroupGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGroupPolicyObjectRestrictedGroupGetParams() *GroupPolicyObjectRestrictedGroupGetParams {
	return &GroupPolicyObjectRestrictedGroupGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGroupPolicyObjectRestrictedGroupGetParamsWithTimeout creates a new GroupPolicyObjectRestrictedGroupGetParams object
// with the ability to set a timeout on a request.
func NewGroupPolicyObjectRestrictedGroupGetParamsWithTimeout(timeout time.Duration) *GroupPolicyObjectRestrictedGroupGetParams {
	return &GroupPolicyObjectRestrictedGroupGetParams{
		timeout: timeout,
	}
}

// NewGroupPolicyObjectRestrictedGroupGetParamsWithContext creates a new GroupPolicyObjectRestrictedGroupGetParams object
// with the ability to set a context for a request.
func NewGroupPolicyObjectRestrictedGroupGetParamsWithContext(ctx context.Context) *GroupPolicyObjectRestrictedGroupGetParams {
	return &GroupPolicyObjectRestrictedGroupGetParams{
		Context: ctx,
	}
}

// NewGroupPolicyObjectRestrictedGroupGetParamsWithHTTPClient creates a new GroupPolicyObjectRestrictedGroupGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewGroupPolicyObjectRestrictedGroupGetParamsWithHTTPClient(client *http.Client) *GroupPolicyObjectRestrictedGroupGetParams {
	return &GroupPolicyObjectRestrictedGroupGetParams{
		HTTPClient: client,
	}
}

/*
GroupPolicyObjectRestrictedGroupGetParams contains all the parameters to send to the API endpoint

	for the group policy object restricted group get operation.

	Typically these are written to a http.Request.
*/
type GroupPolicyObjectRestrictedGroupGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* GroupName.

	   Group name.
	*/
	GroupName string

	/* PolicyIndex.

	   Group policy index.
	*/
	PolicyIndex int64

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the group policy object restricted group get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupPolicyObjectRestrictedGroupGetParams) WithDefaults() *GroupPolicyObjectRestrictedGroupGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the group policy object restricted group get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupPolicyObjectRestrictedGroupGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the group policy object restricted group get params
func (o *GroupPolicyObjectRestrictedGroupGetParams) WithTimeout(timeout time.Duration) *GroupPolicyObjectRestrictedGroupGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the group policy object restricted group get params
func (o *GroupPolicyObjectRestrictedGroupGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the group policy object restricted group get params
func (o *GroupPolicyObjectRestrictedGroupGetParams) WithContext(ctx context.Context) *GroupPolicyObjectRestrictedGroupGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the group policy object restricted group get params
func (o *GroupPolicyObjectRestrictedGroupGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the group policy object restricted group get params
func (o *GroupPolicyObjectRestrictedGroupGetParams) WithHTTPClient(client *http.Client) *GroupPolicyObjectRestrictedGroupGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the group policy object restricted group get params
func (o *GroupPolicyObjectRestrictedGroupGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the group policy object restricted group get params
func (o *GroupPolicyObjectRestrictedGroupGetParams) WithFields(fields []string) *GroupPolicyObjectRestrictedGroupGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the group policy object restricted group get params
func (o *GroupPolicyObjectRestrictedGroupGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithGroupName adds the groupName to the group policy object restricted group get params
func (o *GroupPolicyObjectRestrictedGroupGetParams) WithGroupName(groupName string) *GroupPolicyObjectRestrictedGroupGetParams {
	o.SetGroupName(groupName)
	return o
}

// SetGroupName adds the groupName to the group policy object restricted group get params
func (o *GroupPolicyObjectRestrictedGroupGetParams) SetGroupName(groupName string) {
	o.GroupName = groupName
}

// WithPolicyIndex adds the policyIndex to the group policy object restricted group get params
func (o *GroupPolicyObjectRestrictedGroupGetParams) WithPolicyIndex(policyIndex int64) *GroupPolicyObjectRestrictedGroupGetParams {
	o.SetPolicyIndex(policyIndex)
	return o
}

// SetPolicyIndex adds the policyIndex to the group policy object restricted group get params
func (o *GroupPolicyObjectRestrictedGroupGetParams) SetPolicyIndex(policyIndex int64) {
	o.PolicyIndex = policyIndex
}

// WithSvmUUID adds the svmUUID to the group policy object restricted group get params
func (o *GroupPolicyObjectRestrictedGroupGetParams) WithSvmUUID(svmUUID string) *GroupPolicyObjectRestrictedGroupGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the group policy object restricted group get params
func (o *GroupPolicyObjectRestrictedGroupGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *GroupPolicyObjectRestrictedGroupGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param group_name
	if err := r.SetPathParam("group_name", o.GroupName); err != nil {
		return err
	}

	// path param policy_index
	if err := r.SetPathParam("policy_index", swag.FormatInt64(o.PolicyIndex)); err != nil {
		return err
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGroupPolicyObjectRestrictedGroupGet binds the parameter fields
func (o *GroupPolicyObjectRestrictedGroupGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
